/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.model.transfer;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityType;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.IFormView;
import kd.bos.login.utils.ErrorCodeUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.FileNameUtils;
import kd.bos.zip.ZipFile;
import kd.epm.epbs.business.bd.model.ModelSyncHelper;
import kd.epm.epbs.business.paramsetting.ParamSettingServiceHelper;
import kd.fi.bcm.business.dimension.util.ModelDataClearUtils;
import kd.fi.bcm.business.serviceHelper.ICVersionServiceHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.util.ThirdPartyDataCenterUtil;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.config.ConfigEnum;
import kd.fi.bcm.common.json.JacksonUtils;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.PeriodUtils;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.common.util.ZipFileUtil;
import kd.fi.bcm.computing.util.BatchProcessHelper;
import kd.fi.bcm.formplugin.model.transfer.ImportAfterUpgradeHelper;
import kd.fi.bcm.formplugin.model.transfer.ModelImportParam;
import kd.fi.bcm.formplugin.model.transfer.ModelTransferHelper;
import kd.fi.bcm.formplugin.model.transfer.ModelTransferParam;
import kd.fi.bcm.formplugin.model.transfer.ModelTransferProgress;
import kd.fi.bcm.formplugin.model.transfer.core.DynamicObjWrap;
import kd.fi.bcm.formplugin.model.transfer.core.EntityName;
import kd.fi.bcm.formplugin.model.transfer.core.EntityPropertyParseHelper;
import kd.fi.bcm.formplugin.model.transfer.core.ModelCheckInfo;
import kd.fi.bcm.formplugin.model.transfer.core.ModelTransferServiceHelper;
import kd.fi.bcm.formplugin.model.transfer.core.ModelTransferType;
import kd.fi.bcm.formplugin.model.transfer.core.PKExchanger;
import kd.fi.bcm.formplugin.model.transfer.core.TransferContext;
import kd.fi.bcm.formplugin.model.transfer.core.TransferMsgUtils;
import kd.fi.bcm.formplugin.model.transfer.core.TransferSerializeUtils;
import kd.fi.bcm.formplugin.model.transfer.core.service.IModelTransferService;
import kd.fi.bcm.formplugin.model.transfer.core.service.ModelInitHelper;
import kd.fi.bcm.formplugin.model.transfer.core.service.ModelTransferServiceImpl;
import kd.fi.bcm.formplugin.model.transfer.core.service.ModelTransferServiceValidator;
import kd.fi.bcm.spread.common.util.DateTimeUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;

public class ModelTransferProcessService {
    public static final String META_FILE_NAME = "model.meta";
    protected static final WatchLogger LOG = BcmLogFactory.getWatchLogInstance(ModelTransferProcessService.class);
    private static final String OLAP_FILE_SUFFIX = "olap.data";

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Optional<File> transferOnLocal(ModelTransferParam param, IFormView view) {
        long tick = System.currentTimeMillis();
        new ModelTransferProgress(0, ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c...", (String)"ModelTransferProcessService_0", (String)"fi-bcm-formplugin", (Object[])new Object[0])).cache(view);
        String requestSerialId = ModelTransferProcessService.buildRequestSerializeId(param.getSourceModelId(), param.getTransferType());
        LOG.info(String.format("model_transfer_start: %s", requestSerialId));
        DynamicObject logDy = ModelTransferProcessService.createLocalOpLog(param, requestSerialId);
        try {
            block33: {
                File zipDataFile;
                File serializedFilesDir;
                block32: {
                    ModelTransferServiceImpl transferService;
                    TransferContext transferContext;
                    File olapDataFile;
                    block31: {
                        boolean isNeedPackageOlapData;
                        ModelTransferServiceValidator validator = new ModelTransferServiceValidator(param.getTransferType(), param.getTargetModelNumber(), null);
                        ModelCheckInfo checkInfo = validator.validateRepeatVersion();
                        if (!checkInfo.getErrors().isEmpty()) {
                            ModelTransferProcessService.updateTransferLog(logDy.getLong("id"), true, Optional.empty());
                            throw new KDBizException(checkInfo.getErrors().get(0));
                        }
                        TransferContext.Builder transferContextBuilder = new TransferContext.Builder();
                        transferContextBuilder.setModelId(param.getSourceModelId()).setTargetModelShowNumber(param.getTargetModelNumber()).setTargetModelName(param.getTargetModelName()).setTransferSerializeId(requestSerialId).setTransferType(param.getTransferType()).setTransferEntities(param.getTransferEntities()).setIsTransferOLAPData(param.isTransferOLAPData()).setFilterEntityNums(param.getFilterEntityNums()).setDim2Ids(param.getDim2Ids());
                        String sourceCubeName = MemberReader.findModelNumberById((Object)param.getSourceModelId());
                        olapDataFile = new File(FileUtils.getTempDirectory(), String.format("%s_%s.%s", sourceCubeName, requestSerialId, OLAP_FILE_SUFFIX));
                        CountDownLatch _downLatch = new CountDownLatch(param.isTransferOLAPData() ? 1 : 0);
                        if (param.isTransferOLAPData()) {
                            BatchProcessHelper.handleAsync(() -> {
                                try {
                                    long dumpTick = System.currentTimeMillis();
                                    OlapServiceHelper.backupCube((String)sourceCubeName, (File)olapDataFile);
                                    LOG.info("model_transfer_dumping olap data success : " + (System.currentTimeMillis() - dumpTick));
                                }
                                catch (IOException e) {
                                    LOG.error("olap_dump_failed: " + e.getMessage(), (Throwable)e);
                                }
                                finally {
                                    _downLatch.countDown();
                                }
                            });
                        }
                        transferContext = transferContextBuilder.build();
                        transferService = new ModelTransferServiceImpl(transferContext);
                        serializedFilesDir = null;
                        zipDataFile = null;
                        serializedFilesDir = transferService.serializeAllModelData(requestSerialId, view);
                        new ModelTransferProgress(25, ResManager.loadKDString((String)"\u5bfc\u51fa\u5173\u7cfb\u6570\u636e\u5e93\u6210\u529f\u3002", (String)"ModelTransferProcessService_2", (String)"fi-bcm-formplugin", (Object[])new Object[0])).cache(view);
                        try {
                            _downLatch.await();
                        }
                        catch (InterruptedException e) {
                            LOG.error((Throwable)e);
                            throw new KDBizException((Throwable)e, ErrorCodeUtils.getSystemErrorCode((String)e.getMessage()), new Object[0]);
                        }
                        new ModelTransferProgress(50, ResManager.loadKDString((String)"\u5bfc\u51faOLAP\u6570\u636e\u6210\u529f\u3002", (String)"ModelTransferProcessService_1", (String)"fi-bcm-formplugin", (Object[])new Object[0])).cache(view);
                        if (!olapDataFile.exists() && param.isTransferOLAPData()) {
                            throw new KDBizException(TransferMsgUtils.noOlapData());
                        }
                        boolean bl = isNeedPackageOlapData = ModelTransferType.EXPORT == param.getTransferType() || ModelTransferType.REMOTE_COPY == param.getTransferType();
                        if (olapDataFile.exists() && isNeedPackageOlapData) {
                            FileUtils.moveToDirectory((File)olapDataFile, (File)serializedFilesDir, (boolean)false);
                        }
                        if (ModelTransferType.EXPORT != param.getTransferType()) break block31;
                        zipDataFile = ModelTransferProcessService.zipSerializedFilesByPwd(requestSerialId, param.getSecretkey(), serializedFilesDir);
                        new ModelTransferProgress(90, ResManager.loadKDString((String)"\u5bfc\u51fa\u5173\u7cfb\u6570\u636e\u5e93\u6210\u529f\u3002", (String)"ModelTransferProcessService_2", (String)"fi-bcm-formplugin", (Object[])new Object[0])).cache(view);
                        ModelTransferProcessService.updateTransferLog(logDy.getLong("id"), false, Optional.empty());
                        view.getPageCache().put("ModelExportUrl", ModelTransferProcessService.getUrl(zipDataFile));
                        new ModelTransferProgress(100, ResManager.loadKDString((String)"\u5bfc\u51fa\u5173\u7cfb\u6570\u636e\u5e93\u6210\u529f\u3002", (String)"ModelTransferProcessService_2", (String)"fi-bcm-formplugin", (Object[])new Object[0])).cache(view);
                        Optional<File> optional = Optional.of(zipDataFile);
                        {
                            catch (Throwable throwable) {
                                try {
                                    if (Objects.nonNull(serializedFilesDir)) {
                                        FileUtils.deleteDirectory((File)serializedFilesDir);
                                    }
                                    if (zipDataFile == null || !zipDataFile.exists()) throw throwable;
                                    FileUtils.forceDelete((File)zipDataFile);
                                    throw throwable;
                                }
                                catch (IOException e) {
                                    String zipPath = zipDataFile != null && zipDataFile.exists() ? zipDataFile.getAbsolutePath() : "";
                                    LOG.error("failed to delete data file serializedFilesDir: " + serializedFilesDir.getAbsolutePath() + "---zipDataFile\uff1a" + zipPath + " on " + e.getMessage(), (Throwable)e);
                                }
                                throw throwable;
                            }
                        }
                        try {
                            if (Objects.nonNull(serializedFilesDir)) {
                                FileUtils.deleteDirectory((File)serializedFilesDir);
                            }
                            if (zipDataFile == null || !zipDataFile.exists()) return optional;
                            FileUtils.forceDelete((File)zipDataFile);
                            return optional;
                        }
                        catch (IOException e) {
                            String zipPath = zipDataFile != null && zipDataFile.exists() ? zipDataFile.getAbsolutePath() : "";
                            LOG.error("failed to delete data file serializedFilesDir: " + serializedFilesDir.getAbsolutePath() + "---zipDataFile\uff1a" + zipPath + " on " + e.getMessage(), (Throwable)e);
                        }
                        return optional;
                    }
                    if (ModelTransferType.LOCAL_COPY != param.getTransferType()) break block32;
                    ModelTransferProcessService.importModelDataByBatch(transferService, serializedFilesDir, false, view);
                    DynamicObject newModel = QueryServiceHelper.queryOne((String)"bcm_model", (String)"id,reporttype", (QFilter[])new QFilter("shownumber", "=", (Object)transferContext.getTargetModelShowNumber()).toArray());
                    ModelInitHelper.initModelFunctionPermission(newModel, false);
                    new ModelTransferProgress(80, ResManager.loadKDString((String)"\u5bfc\u5165\u4f53\u7cfb\u5173\u7cfb\u5e93\u6570\u636e\u6210\u529f\u3002", (String)"ModelTransferProcessService_3", (String)"fi-bcm-formplugin", (Object[])new Object[0])).cache(view);
                    transferService.importModelOLAPData(transferContext, Optional.ofNullable(olapDataFile.exists() ? olapDataFile : null));
                    new ModelTransferProgress(99, ResManager.loadKDString((String)"\u5bfc\u5165\u4f53\u7cfbOLAP\u6570\u636e\u6210\u529f\u3002", (String)"ModelTransferProcessService_4", (String)"fi-bcm-formplugin", (Object[])new Object[0])).cache(view);
                    ModelTransferProcessService.updateTransferLog(logDy.getLong("id"), false, Optional.empty());
                    new ModelTransferProgress(100, ResManager.loadKDString((String)"\u590d\u5236\u5b8c\u6210", (String)"ModelTransferProcessService_5", (String)"fi-bcm-formplugin", (Object[])new Object[0])).cache(view);
                    Optional<File> e = Optional.empty();
                    try {
                        if (Objects.nonNull(serializedFilesDir)) {
                            FileUtils.deleteDirectory((File)serializedFilesDir);
                        }
                        if (zipDataFile == null || !zipDataFile.exists()) return e;
                        FileUtils.forceDelete((File)zipDataFile);
                        return e;
                    }
                    catch (IOException e2) {
                        String zipPath = zipDataFile != null && zipDataFile.exists() ? zipDataFile.getAbsolutePath() : "";
                        LOG.error("failed to delete data file serializedFilesDir: " + serializedFilesDir.getAbsolutePath() + "---zipDataFile\uff1a" + zipPath + " on " + e2.getMessage(), (Throwable)e2);
                    }
                    return e;
                }
                if (ModelTransferType.REMOTE_COPY != param.getTransferType()) break block33;
                String remoteLoginToken = ModelTransferHelper.getLoginToken(param.getRemoteSiteUrl(), param.getRemoteAccountId(), param.getRemoteLoginUserMobile(), param.getPassword(), param.getAppId(), ThirdPartyDataCenterUtil.decrypterPwd((String)param.getAppPwd()));
                zipDataFile = ModelTransferProcessService.zipSerializedFiles(requestSerialId, param.getSecretkey(), serializedFilesDir);
                String remoteFileId = ModelTransferHelper.uploadFileToRemoteApp(param.getRemoteSiteUrl(), remoteLoginToken, zipDataFile, false);
                new ModelTransferProgress(60, ResManager.loadKDString((String)"\u4e0a\u4f20\u6570\u636e\u6587\u4ef6\u5230\u76ee\u6807\u670d\u52a1\u5668\u6210\u529f\u3002", (String)"ModelTransferProcessService_6", (String)"fi-bcm-formplugin", (Object[])new Object[0])).cache(view);
                ModelImportParam importParam = new ModelImportParam();
                importParam.setTargetModelNumber(param.getTargetModelNumber());
                importParam.setTargetModelName(param.getTargetModelName());
                importParam.setDataURL(remoteFileId);
                importParam.setRequestSerializeID(requestSerialId);
                importParam.setSourceServiceVersion(String.valueOf(ModelTransferServiceHelper.getCurrentServiceVersion()));
                importParam.setIsForceMetaConsistent(param.getIsForceMetaConsistent());
                ModelTransferHelper.executeRemoteImportModel(param.getRemoteSiteUrl(), importParam, remoteLoginToken);
                new ModelTransferProgress(99, ResManager.loadKDString((String)"\u8fdc\u7a0b\u5bfc\u5165\u4f53\u7cfb\u6570\u636e\u6210\u529f\u3002", (String)"ModelTransferProcessService_7", (String)"fi-bcm-formplugin", (Object[])new Object[0])).cache(view);
                ModelTransferProcessService.updateTransferLog(logDy.getLong("id"), false, Optional.empty());
                new ModelTransferProgress(100, ResManager.loadKDString((String)"\u8fc1\u79fb\u5b8c\u6210\u3002", (String)"ModelTransferProcessService_16", (String)"fi-bcm-formplugin", (Object[])new Object[0])).cache(view);
                Optional<File> optional = Optional.empty();
                try {
                    if (Objects.nonNull(serializedFilesDir)) {
                        FileUtils.deleteDirectory((File)serializedFilesDir);
                    }
                    if (zipDataFile == null || !zipDataFile.exists()) return optional;
                    FileUtils.forceDelete((File)zipDataFile);
                    return optional;
                }
                catch (IOException e) {
                    String zipPath = zipDataFile != null && zipDataFile.exists() ? zipDataFile.getAbsolutePath() : "";
                    LOG.error("failed to delete data file serializedFilesDir: " + serializedFilesDir.getAbsolutePath() + "---zipDataFile\uff1a" + zipPath + " on " + e.getMessage(), (Throwable)e);
                }
                return optional;
            }
            try {
                throw new NotImplementedException((Object)((Object)param.getTransferType()) + " does not implement. ");
            }
            catch (Exception e) {
                new ModelTransferProgress(-1, e.getMessage()).cache(view);
                LOG.error("model_transfer_error:" + e.getMessage(), (Throwable)e);
                ModelTransferProcessService.updateTransferLog(logDy.getLong("id"), false, Optional.of(e));
                String targetModelNumber = param.getTargetModelNumber();
                if (ModelTransferType.REMOTE_COPY == param.getTransferType() || !StringUtils.isNotEmpty((CharSequence)targetModelNumber)) throw new KDBizException((Throwable)e, ErrorCodeUtils.getSystemErrorCode((String)TransferMsgUtils.systemError(e.getMessage())), new Object[0]);
                ModelTransferProcessService.clearSavedDirtyData(targetModelNumber);
                throw new KDBizException((Throwable)e, ErrorCodeUtils.getSystemErrorCode((String)TransferMsgUtils.systemError(e.getMessage())), new Object[0]);
            }
        }
        finally {
            LOG.info("model_transfer cost time: " + (System.currentTimeMillis() - tick));
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void transferOnRemote(ModelImportParam param, IFormView view) {
        block26: {
            block25: {
                block27: {
                    block24: {
                        new ModelTransferProgress(0, ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c...", (String)"ModelTransferProcessService_0", (String)"fi-bcm-formplugin", (Object[])new Object[0])).cache(view);
                        targetModelNumber = param.getTargetModelNumber();
                        dataURL = param.getDataURL();
                        transferType = ModelTransferType.IMPORT;
                        if (StringUtils.isNotEmpty((CharSequence)param.getRequestSerializeID())) {
                            dateTag = DateTimeUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss");
                            param.setRequestSerializeID(String.format("%s-%s-%s", new Object[]{transferType, targetModelNumber.substring(0, Math.min(20, targetModelNumber.length())), dateTag}));
                        }
                        requestSerialId = param.getRequestSerializeID();
                        logDy = ModelTransferProcessService.createRemoteOpLog(param, requestSerialId, transferType);
                        unzipDir = null;
                        localZipFile = null;
                        new ModelTransferProgress(10, ResManager.loadKDString((String)"\u5143\u6570\u636e\u7248\u672c\u6821\u9a8c\u5b8c\u6210\u3002", (String)"ModelTransferProcessService_10", (String)"fi-bcm-formplugin", (Object[])new Object[0])).cache(view);
                        localZipFile = new File(dataURL).exists() != false ? new File(dataURL) : ModelTransferHelper.downloadFile(dataURL);
                        unzipDir = new File(FileUtils.getTempDirectory(), String.format("model_transfer_unzip_%s", new Object[]{requestSerialId}));
                        zipFile = new ZipFile(localZipFile.getCanonicalPath());
                        if (!zipFile.isEncrypted()) ** GOTO lbl34
                        cypher = param.getCypher();
                        msg = ZipFileUtil.unzipByPwd((String)unzipDir.getCanonicalPath(), (ZipFile)zipFile, (String)cypher);
                        if (!StringUtils.isNotEmpty((CharSequence)msg)) break block24;
                        new ModelTransferProgress(-1, msg).cache(view);
                        try {
                            if (Objects.nonNull(unzipDir)) {
                                FileUtils.deleteDirectory((File)unzipDir);
                            }
                            if (Objects.nonNull(localZipFile)) {
                                FileUtils.forceDelete((File)localZipFile);
                            }
                        }
                        catch (IOException e) {
                            ModelTransferProcessService.LOG.error("failed to delete data file unzipDir: " + unzipDir.getAbsolutePath() + "---localZipFile\uff1a" + localZipFile.getAbsolutePath() + " on " + e.getMessage(), (Throwable)e);
                        }
                        return;
                    }
                    break block27;
lbl34:
                    // 1 sources

                    ZipFileUtil.unzipOfApa((String)localZipFile.getCanonicalPath(), (String)unzipDir.getCanonicalPath());
                }
                new ModelTransferProgress(20, ResManager.loadKDString((String)"\u89e3\u538b\u538b\u7f29\u6587\u4ef6\u6210\u529f\u3002", (String)"ModelTransferProcessService_8", (String)"fi-bcm-formplugin", (Object[])new Object[0])).cache(view);
                olapSource = new HashMap<String, Long>();
                if (param.getDataSourceId() != null) {
                    sourceId = param.getDataSourceId();
                    olapSource.put("olapsource", sourceId);
                }
                isTransferOLAPData = ArrayUtils.isNotEmpty((Object[])(olapDataFile = unzipDir.listFiles((FilenameFilter)LambdaMetafactory.metafactory(null, null, null, (Ljava/io/File;Ljava/lang/String;)Z, lambda$transferOnRemote$1(java.io.File java.lang.String ), (Ljava/io/File;Ljava/lang/String;)Z)()))) != false ? Boolean.TRUE : Boolean.FALSE;
                transferContext = new TransferContext.Builder().setTransferType(ModelTransferType.IMPORT).setTransferSerializeId(requestSerialId).setTargetModelShowNumber(param.getTargetModelNumber()).setTargetModelName(param.getTargetModelName()).setIsTransferOLAPData(isTransferOLAPData).setParam(olapSource).build();
                transferService = new ModelTransferServiceImpl(transferContext);
                ModelTransferProcessService.importModelDataByBatch(transferService, unzipDir, param.getIsForceMetaConsistent(), view);
                if (view == null || !Objects.nonNull(progressData = ModelTransferProgress.fromCache(view)) || (percent = progressData.getPercent()) != -1) break block25;
                try {
                    if (Objects.nonNull(unzipDir)) {
                        FileUtils.deleteDirectory((File)unzipDir);
                    }
                    if (Objects.nonNull(localZipFile)) {
                        FileUtils.forceDelete((File)localZipFile);
                    }
                }
                catch (IOException e) {
                    ModelTransferProcessService.LOG.error("failed to delete data file unzipDir: " + unzipDir.getAbsolutePath() + "---localZipFile\uff1a" + localZipFile.getAbsolutePath() + " on " + e.getMessage(), (Throwable)e);
                }
                return;
            }
            new ModelTransferProgress(70, ResManager.loadKDString((String)"\u5bfc\u5165\u4f53\u7cfb\u5173\u7cfb\u5e93\u6570\u636e\u6210\u529f\u3002", (String)"ModelTransferProcessService_3", (String)"fi-bcm-formplugin", (Object[])new Object[0])).cache(view);
            newModel = QueryServiceHelper.queryOne((String)"bcm_model", (String)"id,reporttype", (QFilter[])new QFilter("shownumber", "=", (Object)transferContext.getTargetModelShowNumber()).toArray());
            newModelId = newModel.getLong("id");
            ModelInitHelper.initModelFunctionPermission(newModel, param.getUnitTestFlag());
            new ModelTransferProgress(72, ResManager.loadKDString((String)"\u521d\u59cb\u5316\u4f53\u7cfb\u7ba1\u7406\u5458\u529f\u80fd\u6743\u9650\u6210\u529f\u3002", (String)"ModelTransferProcessService_9", (String)"fi-bcm-formplugin", (Object[])new Object[0])).cache(view);
            transferService.importModelOLAPData(transferContext, Optional.ofNullable(ArrayUtils.isNotEmpty((Object[])olapDataFile) != false ? olapDataFile[0] : null));
            new ModelTransferProgress(90, ResManager.loadKDString((String)"\u5bfc\u5165\u4f53\u7cfbOLAP\u6570\u636e\u6210\u529f\u3002", (String)"ModelTransferProcessService_4", (String)"fi-bcm-formplugin", (Object[])new Object[0])).cache(view);
            ModelTransferProcessService.updateTransferLog(logDy.getLong("id"), false, Optional.empty());
            files = unzipDir.listFiles((FilenameFilter)LambdaMetafactory.metafactory(null, null, null, (Ljava/io/File;Ljava/lang/String;)Z, lambda$transferOnRemote$2(java.io.File java.lang.String ), (Ljava/io/File;Ljava/lang/String;)Z)());
            ModelTransferProcessService.afterImport(newModelId, files == null || files.length == 0);
            ModelTransferProcessService.LOG.info("model_transfer_import end");
            new ModelTransferProgress(100, ResManager.loadKDString((String)"\u5bfc\u5165\u5b8c\u6210", (String)"ModelTransferProcessService_17", (String)"fi-bcm-formplugin", (Object[])new Object[0])).cache(view);
            try {
                if (Objects.nonNull(unzipDir)) {
                    FileUtils.deleteDirectory((File)unzipDir);
                }
                if (Objects.nonNull(localZipFile)) {
                    FileUtils.forceDelete((File)localZipFile);
                }
                break block26;
            }
            catch (IOException e) {
                ModelTransferProcessService.LOG.error("failed to delete data file unzipDir: " + unzipDir.getAbsolutePath() + "---localZipFile\uff1a" + localZipFile.getAbsolutePath() + " on " + e.getMessage(), (Throwable)e);
            }
            break block26;
            catch (Throwable e) {
                try {
                    ModelTransferProcessService.updateTransferLog(logDy.getLong("id"), false, Optional.of(e));
                    errorMsg = ThrowableHelper.toString((Throwable)e);
                    new ModelTransferProgress(-1, errorMsg).cache(view);
                    ModelTransferProcessService.LOG.error("model_transfer_import_error:" + errorMsg);
                    BatchProcessHelper.handleAsync((Runnable)(Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$transferOnRemote$3(kd.fi.bcm.formplugin.model.transfer.ModelImportParam ), ()V)((ModelImportParam)param));
                    throw new KDBizException(e, ErrorCodeUtils.getSystemErrorCode((String)TransferMsgUtils.systemError(errorMsg)), new Object[0]);
                }
                catch (Throwable var19_23) {
                    try {
                        if (Objects.nonNull(unzipDir)) {
                            FileUtils.deleteDirectory(unzipDir);
                        }
                        if (Objects.nonNull(localZipFile)) {
                            FileUtils.forceDelete(localZipFile);
                        }
                    }
                    catch (IOException e) {
                        ModelTransferProcessService.LOG.error("failed to delete data file unzipDir: " + unzipDir.getAbsolutePath() + "---localZipFile\uff1a" + localZipFile.getAbsolutePath() + " on " + e.getMessage(), (Throwable)e);
                    }
                    throw var19_23;
                }
            }
        }
    }

    private static void clearSavedDirtyData(String modelNumber) {
        DynamicObject newModel = QueryServiceHelper.queryOne((String)"bcm_model", (String)"id,number", (QFilter[])new QFilter("shownumber", "=", (Object)modelNumber).toArray());
        if (newModel != null) {
            Object[] ids = new Object[]{newModel.getLong("id")};
            ModelDataClearUtils.clearModels((Object[])ids);
            String number = newModel.getString("number");
            if (OlapServiceHelper.isExistCube((String)number)) {
                OlapServiceHelper.dropCubeSchemes((String)number);
            }
            ModelSyncHelper.deleteEpbsModel((Collection)Lists.newArrayList((Object[])new Long[]{newModel.getLong("id")}));
        }
    }

    private static void importModelDataByBatch(IModelTransferService transferService, File filePath, boolean force, IFormView view) {
        Set<String> missEntityNames;
        File metaFile = new File(filePath, META_FILE_NAME);
        Map<EntityName, List<String>> entityNameGroup = TransferSerializeUtils.buildEntityNameFromMetaFile(metaFile);
        if (force && !(missEntityNames = ModelTransferProcessService.checkMetaPropExists(entityNameGroup)).isEmpty()) {
            new ModelTransferProgress(-1, TransferMsgUtils.missingEntityNames(missEntityNames)).cache(view);
            return;
        }
        ArrayList fileList = Lists.newArrayList((Object[])filePath.listFiles((_dir, name) -> name.endsWith(".csv")));
        Map<EntityName, Set<String>> entityPkMap = TransferSerializeUtils.batchExtractPkFromFile(fileList);
        new ModelTransferProgress(25, "").cache(view);
        PKExchanger pkExchanger = transferService.buildPkExchanger(entityPkMap);
        entityPkMap.clear();
        new ModelTransferProgress(30, "").cache(view);
        Set entityNames = entityNameGroup.keySet().stream().map(x -> x.getMainEntityName()).collect(Collectors.toSet());
        LinkedList<String> metaFileList = new LinkedList<String>(entityNames);
        ModelTransferProcessService.modifyMetaOrder(metaFileList);
        int percent = 35;
        new ModelTransferProgress(percent, "").cache(view);
        HashMap fileMap = new HashMap(128);
        fileList.forEach(x -> {
            String fileName = x.getName().substring(0, x.getName().lastIndexOf("."));
            EntityName entityName = EntityName.parseFrom(fileName);
            fileMap.computeIfAbsent(entityName.getMainEntityName(), f -> new ArrayList(16)).add(x);
        });
        for (int i = 0; i < metaFileList.size(); ++i) {
            String entityName = (String)metaFileList.get(i);
            LOG.info("batch import model current entity:" + entityName + " current:" + (i + 1) + "/" + metaFileList.size());
            List files = (List)fileMap.get(entityName);
            if (CollectionUtils.isNotEmpty((Collection)files)) {
                ModelTransferProcessService.batchImportModel(files, false, transferService, pkExchanger);
            }
            if (i % (metaFileList.size() / 35) != 0 || percent >= 70) continue;
            new ModelTransferProgress(percent++, "").cache(view);
        }
    }

    private static void modifyMetaOrder(List<String> mainEntityNameList) {
        mainEntityNameList.remove("bcm_model");
        mainEntityNameList.add(0, "bcm_model");
        if (mainEntityNameList.contains("bcm_reportentity")) {
            mainEntityNameList.remove("bcm_reportentity");
            mainEntityNameList.add("bcm_reportentity");
        }
        mainEntityNameList.remove("bcm_dimension");
        mainEntityNameList.add(1, "bcm_dimension");
    }

    private static Set<String> checkMetaPropExists(Map<EntityName, List<String>> entityNamePropGroup) {
        HashSet<String> invalidEntityNames = new HashSet<String>(8);
        block0: for (Map.Entry<EntityName, List<String>> entry : entityNamePropGroup.entrySet()) {
            EntityName entityName = entry.getKey();
            if (!EntityPropertyParseHelper.isExist(entityName)) {
                invalidEntityNames.add(entityName.getMainEntityName());
                continue;
            }
            EntityType entityType = TransferSerializeUtils.getEntityTypeByEntityName(entityName);
            for (String prop : entry.getValue()) {
                if (entityType.getProperties().containsKey((Object)prop)) continue;
                LOG.info(String.format("model_transfer_missing_entity_prop: %s on %s", prop, entityName));
                invalidEntityNames.add(entityName.getMainEntityName());
                continue block0;
            }
        }
        return invalidEntityNames;
    }

    private static void updateTransferLog(long logId, boolean isCancel, Optional<Throwable> e) {
        DynamicObject logExistDy = BusinessDataServiceHelper.loadSingle((Object)logId, (String)"bcm_transfermodel_log", (String)"actionstatus,errmsg,costtime,createtime");
        if (!isCancel && !e.isPresent()) {
            logExistDy.set("actionstatus", (Object)2);
        } else if (isCancel) {
            logExistDy.set("actionstatus", (Object)0);
        } else if (e.isPresent()) {
            logExistDy.set("actionstatus", (Object)3);
        }
        if (e.isPresent()) {
            String errMsg = ModelTransferHelper.buildExceptionMsg(e.get(), 20, true);
            logExistDy.set("errmsg", (Object)errMsg.substring(0, Math.min(errMsg.length(), 2000)));
        }
        logExistDy.set("costtime", (Object)(System.currentTimeMillis() - logExistDy.getDate("createtime").getTime()));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{logExistDy});
    }

    private static File zipSerializedFiles(String requestSerialId, String secretkey, File dataFileDir) {
        File zipFile = new File(FileUtils.getTempDirectory(), String.format("model_%s[%s][V%s].zip", requestSerialId, RequestContext.get().getAccountId(), TransferSerializeUtils.getVersionOfConstellation()));
        ZipFileUtil.zip((String)dataFileDir.getPath(), (String)zipFile.getAbsolutePath());
        LOG.info(String.format("model_transfer: %s build data file: %s", requestSerialId, zipFile.getPath()));
        try {
            FileUtils.deleteDirectory((File)dataFileDir);
        }
        catch (IOException e) {
            LOG.error("failed to delete data file dir: " + dataFileDir.getAbsolutePath() + " on " + e.getMessage(), (Throwable)e);
        }
        return zipFile;
    }

    private static File zipSerializedFilesByPwd(String requestSerialId, String secretkey, File dataFileDir) {
        File zipFile = new File(FileUtils.getTempDirectory(), String.format("model_%s[%s][V%s].zip", requestSerialId, RequestContext.get().getAccountId(), TransferSerializeUtils.getVersionOfConstellation()));
        zipFile = ZipFileUtil.zipByPwd((String)dataFileDir.getPath(), (String)zipFile.getAbsolutePath(), (String)secretkey);
        LOG.info(String.format("model_transfer: %s build data file: %s", requestSerialId, zipFile.getPath()));
        try {
            FileUtils.deleteDirectory((File)dataFileDir);
        }
        catch (IOException e) {
            LOG.error("failed to delete data file dir: " + dataFileDir.getAbsolutePath() + " on " + e.getMessage(), (Throwable)e);
        }
        return zipFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void batchImportModel(List<File> files, boolean force, IModelTransferService service, PKExchanger pkExchanger) {
        try {
            files.sort(Comparator.comparing(File::getName).reversed());
            HashMap<EntityName, List<DynamicObjWrap>> entityMap = new HashMap<EntityName, List<DynamicObjWrap>>(16);
            for (File file : files) {
                entityMap.putAll(TransferSerializeUtils.createDynamicFromFile(file, force));
            }
            service.importModel(entityMap, pkExchanger);
            entityMap.clear();
        }
        finally {
            files.forEach(x -> {
                try {
                    FileUtils.forceDeleteOnExit((File)x);
                }
                catch (IOException e) {
                    LOG.error("delete file failed: " + x.getAbsolutePath() + " on :" + e.getMessage(), (Throwable)e);
                }
            });
        }
    }

    private static String buildRequestSerializeId(long sourceModelId, ModelTransferType transferType) {
        QFilter qf = new QFilter("id", "=", (Object)sourceModelId);
        DynamicObject modelDy = QueryServiceHelper.queryOne((String)"bcm_model", (String)"shownumber", (QFilter[])qf.toArray());
        String dateTag = DateTimeUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss");
        String modelNumber = modelDy.getString("shownumber");
        return String.format("%s-%s-%s", transferType.name().toLowerCase(Locale.ENGLISH), modelNumber.substring(0, Math.min(20, modelNumber.length())), dateTag);
    }

    private static DynamicObject createLocalOpLog(ModelTransferParam param, String requestSerialId) {
        DynamicObject logDy = BusinessDataServiceHelper.newDynamicObject((String)"bcm_transfermodel_log");
        logDy.set("billno", (Object)requestSerialId);
        logDy.set("sourcemodel_id", (Object)param.getSourceModelId());
        logDy.set("requestparam", (Object)JacksonUtils.toJson((Object)param));
        logDy.set("actiontype", (Object)param.getTransferType().getCode());
        logDy.set("targetmodelshownum", (Object)param.getTargetModelNumber());
        logDy.set("targetmodelname", (Object)param.getTargetModelName());
        logDy.set("actionstatus", (Object)1);
        logDy.set("includedata", (Object)param.isTransferOLAPData());
        logDy.set("createtime", (Object)new Date());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{logDy});
        return logDy;
    }

    private static DynamicObject createRemoteOpLog(ModelImportParam param, String requestSerialId, ModelTransferType transferType) {
        DynamicObject logDy = BusinessDataServiceHelper.newDynamicObject((String)"bcm_transfermodel_log");
        logDy.set("billno", (Object)requestSerialId);
        logDy.set("sourcemodel_id", (Object)0L);
        logDy.set("requestparam", (Object)JacksonUtils.toJson((Object)param));
        logDy.set("actiontype", (Object)transferType.getCode());
        logDy.set("targetmodelshownum", (Object)param.getTargetModelNumber());
        logDy.set("targetmodelname", (Object)param.getTargetModelName());
        logDy.set("actionstatus", (Object)1);
        logDy.set("includedata", null);
        logDy.set("createtime", (Object)new Date());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{logDy});
        return logDy;
    }

    private static String getUrl(File file) throws Exception {
        String url = "";
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            FileService service = FileServiceFactory.getAttachmentFileService();
            RequestContext rc = RequestContext.getOrCreate();
            String tempFilePath = FileNameUtils.getExportFileName((String)rc.getTenantId(), (String)rc.getAccountId(), (String)"cm", (String)UUID.randomUUID().toString(), (String)file.getName());
            url = service.upload(new FileItem(file.getName(), tempFilePath, (InputStream)fileInputStream));
        }
        return url;
    }

    private static boolean checkAppTypeOfModel(Map<EntityName, List<DynamicObjWrap>> entityGroupData, String appId) {
        List<DynamicObjWrap> dynamicObjWraps = entityGroupData.get(new EntityName("bcm_model"));
        String reporttype = dynamicObjWraps.get(0).getValue().getString("reporttype");
        String appNum = ApplicationTypeEnum.getEnumByIndex((String)reporttype).getAppnum();
        return appId.equals(appNum);
    }

    private static void afterImport(long newModelId, boolean isOldParamModel) {
        ModelTransferProcessService.setPeriodLastperiodValue(newModelId);
        ImportAfterUpgradeHelper.upgradeAfterImportModel(newModelId, isOldParamModel);
        if (ParamSettingServiceHelper.getBoolean((long)newModelId, (String)ConfigEnum.CM060.getNumber())) {
            ICVersionServiceHelper.batchSynchroMemberSlowEvolving((long)newModelId);
        }
    }

    private static void setPeriodLastperiodValue(long newModelId) {
        QFilter qf = new QFilter("model", "=", (Object)newModelId).and(new QFilter("number", "like", (Object)"M_M%"));
        DynamicObject[] periodMems = BusinessDataServiceHelper.load((String)"bcm_periodmembertree", (String)"id, number, isadjust, lastperiod, relatednumber", (QFilter[])qf.toArray());
        if (periodMems == null || periodMems.length == 0) {
            return;
        }
        Arrays.asList(periodMems).forEach(x -> {
            String lastperiod = x.getString("lastperiod");
            if (StringUtils.isEmpty((CharSequence)lastperiod)) {
                String number = x.getString("number");
                if (PeriodUtils.SPECIAL_MONTH_PERIOD.contains(number)) {
                    x.set("relatednumber", (Object)"M_M12");
                    x.set("isadjust", (Object)"1");
                } else if (!number.equals("M_M01") && PeriodUtils.STANDARD_MONTH_PERIOD.contains(number)) {
                    int index = PeriodUtils.STANDARD_MONTH_PERIOD.indexOf(number);
                    x.set("lastperiod", PeriodUtils.STANDARD_MONTH_PERIOD.get(index - 1));
                }
            }
        });
        SaveServiceHelper.update((DynamicObject[])periodMems);
    }

    private static /* synthetic */ void lambda$transferOnRemote$3(ModelImportParam param) {
        ModelTransferProcessService.clearSavedDirtyData(param.getTargetModelNumber());
    }

    private static /* synthetic */ boolean lambda$transferOnRemote$2(File _dir, String name) {
        return "epbs_preset_param.csv".equals(name);
    }

    private static /* synthetic */ boolean lambda$transferOnRemote$1(File _dir, String name) {
        return name.endsWith(OLAP_FILE_SUFFIX);
    }
}

