/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.model.transfer;

import java.util.Objects;
import java.util.function.Function;
import kd.bos.form.IFormView;
import kd.bos.util.StringUtils;
import kd.fi.bcm.common.json.JacksonUtils;

public class ModelTransferProgress {
    public static final String PROGRESS_CACHE_ID = "model_transfer_progress";
    private static Function<IFormView, String> buildCacheKey = v -> PROGRESS_CACHE_ID + v.getPageId();
    private int percent;
    private String message;

    public ModelTransferProgress() {
    }

    public ModelTransferProgress(int percent, String message) {
        this.percent = percent;
        this.message = message;
    }

    public static ModelTransferProgress fromCache(IFormView view) {
        String s = view.getPageCache().get(buildCacheKey.apply(view));
        if (StringUtils.isNotEmpty((String)s)) {
            return (ModelTransferProgress)JacksonUtils.fromJson((String)s, ModelTransferProgress.class);
        }
        return null;
    }

    public int getPercent() {
        return this.percent;
    }

    public void setPercent(int percent) {
        this.percent = percent;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void cache(IFormView view) {
        if (Objects.nonNull(view)) {
            view.getPageCache().put(buildCacheKey.apply(view), JacksonUtils.toJson((Object)this));
        }
    }
}

