/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.model.transfer;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.bill.AbstractBillWebApiPlugin;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.bcm.common.json.JacksonUtils;
import kd.fi.bcm.formplugin.model.transfer.ModelImportParam;
import kd.fi.bcm.formplugin.model.transfer.ModelTransferHelper;
import kd.fi.bcm.formplugin.model.transfer.ModelTransferProcessService;
import kd.fi.bcm.formplugin.model.transfer.core.ModelCheckInfo;
import kd.fi.bcm.formplugin.model.transfer.core.ModelTransferServiceHelper;
import kd.fi.bcm.formplugin.model.transfer.core.ModelTransferType;
import kd.fi.bcm.formplugin.model.transfer.core.service.ModelTransferServiceValidator;
import org.apache.commons.lang3.StringUtils;

public class ModelTransferServerPlugin
extends AbstractBillWebApiPlugin {
    private static final Log LOG = LogFactory.getLog(ModelTransferServerPlugin.class);

    public ApiResult doCustomService(Map<String, Object> params) {
        LOG.info("model_transfer_service:" + JacksonUtils.toJson(params));
        Optional<String> paraValidator = this.validateParam(params);
        if (paraValidator.isPresent()) {
            return ApiResult.fail((String)paraValidator.get(), (String)"000001");
        }
        Double sourceServiceVersion = StringUtils.isEmpty((CharSequence)String.valueOf(ModelTransferServiceHelper.getCurrentServiceVersion())) ? null : Double.valueOf(ModelTransferServiceHelper.getCurrentServiceVersion());
        ModelTransferServiceValidator validator = new ModelTransferServiceValidator(ModelTransferType.IMPORT, (String)params.get("modelNumber"), sourceServiceVersion);
        ModelCheckInfo checkInfo = validator.validate();
        LOG.info("model_transfer_import_validate end");
        if (!checkInfo.getErrors().isEmpty()) {
            return ApiResult.fail((String)checkInfo.getErrors().get(0), (String)"000002");
        }
        ModelImportParam importParam = new ModelImportParam();
        importParam.setTargetModelNumber((String)params.get("modelNumber"));
        importParam.setTargetModelName((String)params.get("modelName"));
        importParam.setSourceServiceVersion((String)params.get("sourceServiceVersion"));
        importParam.setDataURL((String)params.get("dataFileId"));
        importParam.setRequestSerializeID((String)params.get("requestSerializeID"));
        importParam.setIsForceMetaConsistent(false);
        importParam.setUnitTestFlag(false);
        try {
            ModelTransferProcessService.transferOnRemote(importParam, null);
            return new ApiResult();
        }
        catch (KDBizException e) {
            String errMsg = ModelTransferHelper.buildExceptionMsg(e, 20, true);
            LOG.error("model_transfer_service failed:" + e.getMessage(), (Throwable)e);
            return ApiResult.fail((String)errMsg, (String)"000200");
        }
        catch (Exception e) {
            String errMsg = ModelTransferHelper.buildExceptionMsg(e, 20, true);
            LOG.error("model_transfer_service failed:" + e.getMessage(), (Throwable)e);
            return ApiResult.fail((String)errMsg, (String)"999999");
        }
    }

    private Optional<String> validateParam(Map<String, Object> params) {
        if (Objects.isNull(params.get("modelNumber"))) {
            return Optional.of("param modelNumber is required.");
        }
        if (Objects.isNull(params.get("modelName"))) {
            return Optional.of("param modelName is required.");
        }
        if (Objects.isNull(params.get("sourceServiceVersion"))) {
            return Optional.of("param sourceServiceVersion is required.");
        }
        if (Objects.isNull(params.get("dataFileId"))) {
            return Optional.of("param dataFileId is required.");
        }
        if (Objects.isNull(params.get("requestSerializeID"))) {
            return Optional.of("param requestSerializeID is required.");
        }
        return Optional.empty();
    }
}

