/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.model.transfer.core;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.computing.util.BatchProcessHelper;
import kd.fi.bcm.formplugin.model.transfer.core.EntityName;
import kd.fi.bcm.formplugin.model.transfer.core.EntityPropertyParseHelper;
import kd.fi.bcm.formplugin.model.transfer.core.IModelOutputComponent;
import kd.fi.bcm.formplugin.model.transfer.core.TransferComponent;
import kd.fi.bcm.formplugin.model.transfer.core.TransferContext;
import org.apache.commons.collections4.CollectionUtils;

public abstract class AbstractModelOutComponent
implements IModelOutputComponent {
    protected static final Log LOG = LogFactory.getLog(AbstractModelOutComponent.class);
    protected static final List<String> bigEntity = Collections.unmodifiableList(Arrays.asList("bcm_reportentity_search", "bcm_reportlistentity"));
    protected final TransferContext context;
    protected final EntityType rootEntityType;
    protected static final List<String> nonModelEntity = Arrays.asList("bcm_aggshieldruledis", "bcm_extmodelfield", "bcm_extmodeldim", "bcm_extenddata", "bcm_extenddata_bus", "bcm_invsheetacclayout", "bcm_flowtask", "bcm_extenddata_inv", "bcm_rateplanscenes");
    protected static final List<String> filterRpts = Lists.newArrayList((Object[])new String[]{"bcm_rptadjust", "bcm_rptadjustdata"});
    protected static final List<String> filterChks = Lists.newArrayList((Object[])new String[]{"bcm_checkrecord", "bcm_checkrecordsum"});

    protected AbstractModelOutComponent(TransferContext context) {
        this.context = context;
        TransferComponent componentInfo = this.getClass().getAnnotation(TransferComponent.class);
        if (Objects.isNull(componentInfo)) {
            throw new IllegalStateException(String.format("class: %s not annotated with %s.", this.getClass(), TransferComponent.class));
        }
        this.rootEntityType = EntityMetadataCache.getDataEntityType((String)componentInfo.entityNumber());
    }

    @Override
    public Map<EntityName, Set<Object>> parseExportEntityRecords(Set<Object> filterPks) {
        LinkedList<EntityPkParseTask> parseTaskQueue = new LinkedList<EntityPkParseTask>();
        Map<EntityName, Set<Object>> basicEntityPks = this.fetchBasicEntityPks();
        Map<EntityName, Set<Object>> extraEntityPks = this.fillExtraEntityPks(filterPks, basicEntityPks);
        basicEntityPks.putAll(extraEntityPks);
        basicEntityPks.entrySet().stream().filter(x -> !((Set)x.getValue()).isEmpty()).forEach(x -> parseTaskQueue.add(new EntityPkParseTask((EntityName)x.getKey(), (Set)x.getValue(), null)));
        HashMap<EntityName, Set<Object>> processedPks = new HashMap<EntityName, Set<Object>>(8);
        while (!parseTaskQueue.isEmpty()) {
            EntityPkParseTask curTask = (EntityPkParseTask)parseTaskQueue.poll();
            curTask.reduce((Set)processedPks.get(curTask.getEntityName()));
            if (curTask.isBlank()) continue;
            if (!curTask.isBillEntry()) {
                List<EntityPkParseTask> entryTasks = this.spawnEntryTasks(curTask);
                entryTasks.forEach(x -> LOG.info("model_transfer_spawn_entry_task:" + x.toString()));
                parseTaskQueue.addAll(entryTasks);
            }
            if (!processedPks.containsKey(curTask.getEntityName())) {
                processedPks.put(curTask.getEntityName(), curTask.getPks());
                continue;
            }
            ((Set)processedPks.get(curTask.getEntityName())).addAll(curTask.getPks());
        }
        return processedPks;
    }

    private List<EntityPkParseTask> spawnEntryTasks(EntityPkParseTask entityPkParseTask) {
        String mainEntityName = entityPkParseTask.getEntityName().getMainEntityName();
        if (entityPkParseTask.isBlank() || !mainEntityName.startsWith("bcm_") && !mainEntityName.startsWith("epbs_")) {
            return Collections.EMPTY_LIST;
        }
        Map subEntrys = EntityMetadataCache.getDataEntityType((String)mainEntityName).getAllEntities();
        return subEntrys.entrySet().stream().filter(x -> !mainEntityName.equals(x.getKey())).map(x -> new EntityPkParseTask(new EntityName(mainEntityName, (String)x.getKey()), entityPkParseTask.getPks(), entityPkParseTask)).collect(Collectors.toList());
    }

    protected Map<EntityName, Set<Object>> fetchBasicEntityPks() {
        HashMap<EntityName, Set<Object>> entityPksMap = new HashMap<EntityName, Set<Object>>(16);
        List<String> relativeMainEntities = this.listRelativeMainEntityNames();
        relativeMainEntities.forEach(e -> {
            LOG.info("fetchBasicEntityPks method current entity: {}", e);
            entityPksMap.put(new EntityName((String)e), this.quickLoadAllPksWithModelFilter((String)e));
        });
        return entityPksMap;
    }

    @Deprecated
    protected Map<EntityName, Set<Object>> fetchSourceData(Set<Object> filterPks) {
        return Collections.emptyMap();
    }

    protected Map<EntityName, Set<Object>> fillExtraEntityPks(Set<Object> filterPks, Map<EntityName, Set<Object>> basicEntityPks) {
        return Collections.EMPTY_MAP;
    }

    protected Set<Object> quickLoadAllPksWithModelFilter(String entityName) {
        if (EntityPropertyParseHelper.isExist(entityName)) {
            boolean hasModelProp = EntityMetadataCache.getDataEntityType((String)entityName).getProperties().containsKey((Object)"model");
            boolean isShieldruledis = nonModelEntity.contains(entityName);
            if (!hasModelProp && !isShieldruledis) {
                throw new KDBizException(String.format("%s does not has model filter.", entityName));
            }
            QFilter dataFilter = new QFilter("model.id", "=", (Object)this.context.getModelId());
            this.setFiltersOfBigTable(dataFilter, entityName);
            ISimpleProperty pkProp = EntityMetadataCache.getDataEntityType((String)entityName).getPrimaryKey();
            Set<Object> result = Collections.synchronizedSet(new HashSet());
            if (this.context.getTransferEntities() != null && this.context.getTransferEntities().containsKey(entityName)) {
                Set<Long> filterIds = this.context.getTransferEntities().get(entityName);
                if (CollectionUtils.isNotEmpty(filterIds)) {
                    result.addAll(filterIds);
                } else {
                    DataSet rows = QueryServiceHelper.queryDataSet((String)"bcm", (String)entityName, (String)pkProp.getName(), (QFilter[])dataFilter.toArray(), null);
                    while (rows.hasNext()) {
                        result.add(rows.next().getLong(pkProp.getName()));
                    }
                }
            } else if ("bcm_aggshieldruledis".equals(entityName)) {
                DynamicObjectCollection shieldRules = this.getAllshieldrule(dataFilter);
                ArrayList<Long> ruleList = new ArrayList<Long>();
                if (shieldRules != null && !shieldRules.isEmpty()) {
                    for (DynamicObject dyo : shieldRules) {
                        ruleList.add(dyo.getLong(pkProp.getName()));
                    }
                }
                if (!ruleList.isEmpty()) {
                    QFilter memberFilter = new QFilter("rule", "in", ruleList);
                    DataSet rows = QueryServiceHelper.queryDataSet((String)"bcm", (String)entityName, (String)pkProp.getName(), (QFilter[])memberFilter.toArray(), null);
                    while (rows.hasNext()) {
                        result.add(rows.next().getLong(pkProp.getName()));
                    }
                }
            } else if (!nonModelEntity.contains(entityName)) {
                DataSet rows = QueryServiceHelper.queryDataSet((String)"bcm", (String)entityName, (String)pkProp.getName(), (QFilter[])dataFilter.toArray(), null);
                while (rows.hasNext()) {
                    result.add(rows.next().getLong(pkProp.getName()));
                }
            }
            return result;
        }
        return Collections.EMPTY_SET;
    }

    protected void setFiltersOfBigTable(QFilter dataFilter, String entityName) {
        Map<String, Set<Long>> dim2Ids = this.context.getDim2Ids();
        if (filterRpts.contains(entityName) || filterChks.contains(entityName)) {
            for (Map.Entry<String, Set<Long>> next : dim2Ids.entrySet()) {
                String dim = next.getKey();
                Set<Long> ids = next.getValue();
                if ("scene".equals(dim)) {
                    if (filterRpts.contains(entityName) && ids.size() > 0) {
                        dataFilter.and("scenario", "in", ids);
                    } else if (ids.size() > 0) {
                        dataFilter.and("scene", "in", ids);
                    }
                }
                if ("year".equals(dim) && ids.size() > 0) {
                    dataFilter.and("year", "in", ids);
                }
                if (!"period".equals(dim) || ids.size() <= 0) continue;
                dataFilter.and("period", "in", ids);
            }
        }
    }

    protected Set<Object> quickLoadAllPks(String entityName, String filterProp, Set<Object> filterPropIds) {
        if (EntityPropertyParseHelper.isExist(entityName)) {
            Set<Object> result = Collections.synchronizedSet(new HashSet(filterPropIds.size()));
            ISimpleProperty pkProp = EntityMetadataCache.getDataEntityType((String)entityName).getPrimaryKey();
            BatchProcessHelper.batchConsume(new ArrayList<Object>(filterPropIds), (int)100000, ids -> {
                QFilter idFilter = new QFilter(filterProp, "in", ids);
                DataSet rows = QueryServiceHelper.queryDataSet((String)"bcm", (String)entityName, (String)pkProp.getName(), (QFilter[])idFilter.toArray(), null);
                while (rows.hasNext()) {
                    result.add(rows.next().getLong(pkProp.getName()));
                }
            });
            return result;
        }
        return Collections.EMPTY_SET;
    }

    protected Set<Object> quickLoadAllPksOfBatch(String entityName, String filterProp, Set<Object> filterPropIds) {
        if (EntityPropertyParseHelper.isExist(entityName)) {
            Set<Object> result = Collections.synchronizedSet(new HashSet(filterPropIds.size()));
            ISimpleProperty pkProp = EntityMetadataCache.getDataEntityType((String)entityName).getPrimaryKey();
            BatchProcessHelper.batchConsume(new ArrayList<Object>(filterPropIds), (int)100000, ids -> {
                QFilter idFilter = new QFilter(filterProp, "in", ids);
                DataSet rows = QueryServiceHelper.queryDataSet((String)"bcm", (String)entityName, (String)pkProp.getName(), (QFilter[])idFilter.toArray(), null);
                while (rows.hasNext()) {
                    result.add(rows.next().getLong(pkProp.getName()));
                }
            });
            return result;
        }
        return Collections.EMPTY_SET;
    }

    private DynamicObjectCollection getAllshieldrule(QFilter filter) {
        QFilter[] filters = new QFilter[]{filter};
        return QueryServiceHelper.query((String)this.getClass().getName(), (String)"bcm_aggshieldrule", (String)"id", (QFilter[])filters, (String)"");
    }

    private static class EntityPkParseTask {
        protected final EntityName entityName;
        protected final List<EntityPkParseTask> taskTraces = new ArrayList<EntityPkParseTask>(8);
        protected Set<Object> pks;

        public EntityPkParseTask(EntityName entityName, Set<Object> pks, EntityPkParseTask parentTask) {
            if (Objects.isNull(entityName)) {
                throw new IllegalArgumentException();
            }
            this.entityName = entityName;
            this.pks = pks;
            if (Objects.nonNull(parentTask)) {
                this.taskTraces.add(parentTask);
                this.taskTraces.addAll(parentTask.taskTraces);
            }
            LOG.info("model_transfer spawn task with trace: " + this.toStringWithTrace());
        }

        public EntityName getEntityName() {
            return this.entityName;
        }

        public boolean isBillEntry() {
            return this.entityName.isBillEntry();
        }

        public Set<Object> getPks() {
            return this.pks;
        }

        public void reduce(Set<Object> processedPKs) {
            this.pks.removeIf(x -> x == null || "0".equals(x.toString()));
            if (CollectionUtils.isNotEmpty(processedPKs)) {
                this.pks.removeAll(processedPKs);
            }
        }

        public String toString() {
            String idString = "";
            if (CollectionUtils.isNotEmpty(this.pks)) {
                if (this.pks.size() > 5) {
                    ArrayList<Object> list = new ArrayList<Object>(this.pks);
                    idString = list.subList(0, 5).stream().map(Object::toString).collect(Collectors.joining(",")) + "...";
                } else {
                    idString = this.pks.stream().map(Object::toString).collect(Collectors.joining(","));
                }
            }
            return String.format("EntityPkParseTask{entityName='%s', pks=%s}", this.entityName, idString);
        }

        public final String toStringWithTrace() {
            String idString = this.pks.stream().map(Object::toString).collect(Collectors.joining(","));
            return String.format("EntityPkParseTask{entityName='%s', pks=%s, traces:[%s]}", this.entityName, idString, this.taskTraces.stream().map(x -> String.format("{entityName='%s', pks=%s}", x.entityName, x.pks)).collect(Collectors.joining(",")));
        }

        public boolean isBlank() {
            return CollectionUtils.isEmpty(this.pks);
        }
    }
}

