/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.model.transfer.core;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import kd.fi.bcm.formplugin.model.transfer.core.EntityPropertyParseHelper;

public class EntityGroup {
    public static final BiMap<String, String> ENTITY_REPLACER_LIST = HashBiMap.create();
    protected static final Set<String> BLOCK_LIST = ImmutableSet.copyOf((Collection)ENTITY_REPLACER_LIST.values());

    public static String getEntityReplacer(String entityName) {
        return (String)ENTITY_REPLACER_LIST.inverse().getOrDefault((Object)entityName, (Object)entityName);
    }

    public static boolean isSalveEntity(String entityName) {
        String replacer = EntityGroup.getEntityReplacer(entityName);
        return !entityName.equals(replacer);
    }

    static {
        if (EntityPropertyParseHelper.isExist("bcm_adjustcatalog")) {
            ENTITY_REPLACER_LIST.put((Object)"bcm_adjustcatalog", (Object)"bcm_templatecatalog");
        }
        if (EntityPropertyParseHelper.isExist("bcm_adjustbalanceset")) {
            ENTITY_REPLACER_LIST.put((Object)"bcm_adjustbalanceset", (Object)"bcm_configsetting");
        }
        if (EntityPropertyParseHelper.isExist("bcm_invelimtemplate")) {
            ENTITY_REPLACER_LIST.put((Object)"bcm_invelimtemplate", (Object)"bcm_invelimtemplatebase");
        }
    }
}

