/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.model.transfer.core;

import java.util.Objects;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.SubEntryType;
import kd.fi.bcm.fel.common.StringUtils;

public final class EntityName {
    private final String mainEntityName;
    private final String entryName;

    public EntityName(String mainEntityName) {
        if (StringUtils.isEmpty((CharSequence)mainEntityName)) {
            throw new IllegalArgumentException("entity name must be not null. ");
        }
        this.mainEntityName = mainEntityName;
        this.entryName = "";
    }

    public EntityName(String mainEntityName, String entryName) {
        if (StringUtils.isEmpty((CharSequence)mainEntityName)) {
            throw new IllegalArgumentException("entity name must be not null. ");
        }
        if (StringUtils.isEmpty((CharSequence)entryName)) {
            throw new IllegalArgumentException("entry name must be not null. ");
        }
        this.mainEntityName = mainEntityName;
        this.entryName = entryName;
    }

    public static EntityName parseFrom(String fileName) {
        if (StringUtils.isEmpty((CharSequence)fileName)) {
            throw new IllegalArgumentException();
        }
        String[] parts = fileName.split("\\$");
        if (parts.length > 2) {
            throw new IllegalArgumentException("invalid entityName string:" + fileName);
        }
        if (parts.length == 1) {
            return new EntityName(fileName);
        }
        return new EntityName(parts[0], parts[1]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() == o.getClass()) {
            EntityName that = (EntityName)o;
            return Objects.equals(this.toString(), that.toString());
        }
        return false;
    }

    public int hashCode() {
        return this.buildIdentifier().hashCode();
    }

    public String buildIdentifier() {
        if (StringUtils.isEmpty((CharSequence)this.entryName)) {
            return this.mainEntityName;
        }
        return String.format("%s$%s", this.mainEntityName, this.entryName);
    }

    public boolean isBillEntry() {
        return StringUtils.isNotEmpty((CharSequence)this.entryName);
    }

    public String toString() {
        return this.buildIdentifier();
    }

    public EntityName getParentEntityName() {
        if (!this.isBillEntry()) {
            throw new IllegalStateException("current entity is bill:" + this.toString() + ", no parent.");
        }
        DynamicObjectType entryType = (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)this.mainEntityName).getAllEntities().get(this.entryName);
        if (entryType instanceof SubEntryType) {
            IDataEntityType parentEntryType = ((SubEntryType)entryType).getParent();
            return new EntityName(this.mainEntityName, parentEntryType.getName());
        }
        return new EntityName(this.mainEntityName);
    }

    public String getMainEntityName() {
        return this.mainEntityName;
    }

    public String getEntryName() {
        return this.entryName;
    }
}

