/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.model.transfer.core;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.KDBizException;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.model.transfer.core.EntityName;

public class EntityPropertyParseHelper {
    private EntityPropertyParseHelper() {
    }

    public static List<String> listExportProps(DynamicObjectType dynamicObjectType) {
        return dynamicObjectType.getProperties().stream().filter(x -> (x instanceof ISimpleProperty || x instanceof MulBasedataProp) && !x.isDbIgnore()).sorted(Comparator.comparingInt(IDataEntityProperty::getOrdinal)).map(IMetadata::getName).collect(Collectors.toList());
    }

    public static List<String> listExportProps(String entityName) {
        return EntityPropertyParseHelper.listExportProps((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityName));
    }

    public static String buildExportedPropsForSelect(String entityName) {
        return String.join((CharSequence)",", EntityPropertyParseHelper.listExportProps(entityName));
    }

    public static List<String> listEntryExportProps(String mainEntityName, String entryName) {
        boolean expression;
        boolean bl = expression = StringUtils.isNotEmpty((CharSequence)mainEntityName) && StringUtils.isNotEmpty((CharSequence)entryName);
        if (!expression) {
            throw new IllegalArgumentException();
        }
        EntityType entryEntityType = (EntityType)EntityMetadataCache.getDataEntityType((String)mainEntityName).getAllEntities().get(entryName);
        if (Objects.isNull(entryEntityType)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u672a\u5728\u5b9e\u4f53\u201c%1$s\u201d\u4e2d\u627e\u5230\u5206\u5f55\u201c%2$s\u201d\u3002", (String)"EntityPropertyParseHelper_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), mainEntityName, entryName));
        }
        return EntityPropertyParseHelper.listExportProps((DynamicObjectType)entryEntityType);
    }

    public static String buildEntryExportedPropsForSelect(String mainEntityName, String entryName) {
        return EntityPropertyParseHelper.listEntryExportProps(mainEntityName, entryName).stream().map(x -> String.format("%s.%s", entryName, x)).collect(Collectors.joining(","));
    }

    public static Map<String, IDataEntityProperty> getReferComplexPropMap(DynamicObjectType dynamicObjectType) {
        return dynamicObjectType.getProperties().stream().filter(IComplexProperty.class::isInstance).collect(Collectors.toMap(x -> ((IComplexProperty)x).getRefIdPropName(), x -> x));
    }

    public static boolean isExist(String entityName) {
        try {
            EntityMetadataCache.getDataEntityType((String)entityName);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isExist(EntityName entityName) {
        if (!EntityPropertyParseHelper.isExist(entityName.getMainEntityName())) {
            return false;
        }
        return !StringUtils.isNotEmpty((CharSequence)entityName.getEntryName()) || EntityMetadataCache.getDataEntityType((String)entityName.getMainEntityName()).getAllEntities().containsKey(entityName.getEntryName());
    }
}

