/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.model.transfer.core;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.bcm.formplugin.model.transfer.core.EntityGroup;
import kd.fi.bcm.formplugin.model.transfer.core.EntityName;
import kd.fi.bcm.formplugin.model.transfer.core.RecordLocator;

public class PKExchanger {
    private static final Log LOG = LogFactory.getLog(PKExchanger.class);
    private static final Set<EntityName> whiteEntityNames = new HashSet<EntityName>(Arrays.asList(new EntityName("bcm_entitymember"), new EntityName("bcm_accountmember"), new EntityName("bcm_scenemember"), new EntityName("bcm_fymember"), new EntityName("bcm_periodmember"), new EntityName("bcm_processmember"), new EntityName("bcm_currencymember"), new EntityName("bcm_audittrialmember"), new EntityName("bcm_changetypemember"), new EntityName("bcm_intercompanymember"), new EntityName("bcm_rulemember"), new EntityName("bcm_eb_versionmember"), new EntityName("bcm_datasortmember"), new EntityName("bcm_rulemembertree"), new EntityName("bcm_userdefinedmember"), new EntityName("bcm_audittrialmember")));
    private boolean isForcePKExchangerValidate = Boolean.parseBoolean(System.getProperty("fi.bcm.modeltransfer.enablepkvalidate", "false"));
    private Map<EntityName, BiMap<String, String>> entityPkMap = new HashMap<EntityName, BiMap<String, String>>(128);
    private BiMap<String, String> globalPKMap = HashBiMap.create();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(EntityName entityName, Map<String, String> oldNewPkMap) {
        PKExchanger pKExchanger = this;
        synchronized (pKExchanger) {
            this.entityPkMap.computeIfAbsent(entityName, k -> HashBiMap.create()).putAll(oldNewPkMap);
            this.globalPKMap.putAll(oldNewPkMap);
        }
    }

    public Object getNewPK(RecordLocator sourceRecordLocator, Optional<EntityName> entityRestricted, String oldPK, boolean isForceNotNull) {
        boolean isNewPkIneffective;
        if (StringUtils.isEmpty((CharSequence)oldPK) || oldPK.equals("0")) {
            return oldPK;
        }
        Object newPk = 0;
        if (entityRestricted.isPresent()) {
            BiMap<String, String> dataMap;
            String mainEntityName = entityRestricted.get().getMainEntityName();
            if (EntityGroup.isSalveEntity(mainEntityName)) {
                String replacer = EntityGroup.getEntityReplacer(mainEntityName);
                entityRestricted = entityRestricted.get().isBillEntry() ? Optional.of(new EntityName(replacer, entityRestricted.get().getEntryName())) : Optional.of(new EntityName(replacer));
            }
            if (Objects.nonNull(dataMap = this.entityPkMap.get(entityRestricted.get()))) {
                newPk = dataMap.get((Object)oldPK);
            }
        } else {
            newPk = this.globalPKMap.get((Object)oldPK);
        }
        boolean bl = isNewPkIneffective = Objects.isNull(newPk) || StringUtils.isEmpty((CharSequence)newPk.toString()) || "0".equals(newPk.toString());
        if (isNewPkIneffective && this.isForcePKExchangerValidate && entityRestricted.isPresent() && !whiteEntityNames.contains(entityRestricted.get())) {
            throw new IllegalStateException(String.format(ResManager.loadKDString((String)"\u4e3b\u952e\u4ea4\u6362\u903b\u8f91\u9519\u8bef\uff0c\u8bb0\u5f55 \u201c%1$s \u201d\u4e0d\u5b58\u5728\u65e7\u4e3b\u952e\u201c%2$s\u201d\u5bf9\u5e94\u7684\u65b0\u4e3b\u952e\u3002", (String)"PKExchanger_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), sourceRecordLocator, oldPK));
        }
        return newPk;
    }

    public String getOldPK(Optional<EntityName> entityRestricted, String newPK, boolean isForceNotNull) {
        String oldPK = null;
        if (entityRestricted.isPresent()) {
            BiMap<String, String> dataMap = this.entityPkMap.get(entityRestricted.get());
            if (Objects.nonNull(dataMap)) {
                oldPK = (String)dataMap.inverse().get((Object)newPK);
            }
        } else {
            oldPK = (String)this.globalPKMap.inverse().get((Object)newPK);
        }
        if (Objects.isNull(oldPK) && isForceNotNull) {
            throw new IllegalStateException(String.format(ResManager.loadKDString((String)"\u4e3b\u952e\u4ea4\u6362\u903b\u8f91\u9519\u8bef\uff0c\u4e0d\u5b58\u5728\u65b0\u4e3b\u952e[%1$s] %2$s \u5bf9\u5e94\u7684\u65e7\u4e3b\u952e\u3002", (String)"PKExchanger_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), entityRestricted, newPK));
        }
        return oldPK;
    }

    public Map<EntityName, BiMap<String, String>> getEntityPkMap() {
        return this.entityPkMap;
    }
}

