/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.model.transfer.core;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.exception.KDBizException;
import kd.bos.lang.Lang;
import kd.bos.login.utils.ErrorCodeUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.service.VersionService;
import kd.bos.portal.service.bo.Version;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.common.json.JacksonUtils;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.NumericConstant;
import kd.fi.bcm.computing.util.BatchProcessHelper;
import kd.fi.bcm.formplugin.model.transfer.core.DynamicObjWrap;
import kd.fi.bcm.formplugin.model.transfer.core.EntityGroup;
import kd.fi.bcm.formplugin.model.transfer.core.EntityName;
import kd.fi.bcm.formplugin.model.transfer.core.EntityPropertyParseHelper;
import kd.fi.bcm.formplugin.model.transfer.core.EntityRepeat;
import kd.fi.bcm.formplugin.model.transfer.core.TransferMsgUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang3.StringUtils;

public class TransferSerializeUtils {
    public static final String COLUMN_ENTRY_PARENT_ID = "_entryparent";
    private static final WatchLogger LOG = BcmLogFactory.getWatchLogInstance(TransferSerializeUtils.class);
    private static final String ENCODE = "UTF-8";
    private static final String GBK = "GBK";
    private static final String COLUMN_DELIMITER = "||";
    private static final String COLUMN_DELIMITER_REGEX = "\\|\\|";
    private static final String FDATA = "data";
    private static final String FSPREAD_JSON = "spreadjson";
    private static final List<String> ADJ_SPE_OLD_FIELDS = Lists.newArrayList((Object[])new String[]{"account_id", "audittrail_id", "changetype_id", "datasort_id", "multigaap_id", "dim1_id", "dim2_id", "dim3_id", "dim4_id", "dim5_id", "dim6_id"});
    private static final List<String> ADJ_SPE_NEW_FIELDS = Lists.newArrayList((Object[])new String[]{"accountdyn_id", "audittraildyn_id", "changetypedyn_id", "datasortdyn_id", "multigaapdyn_id", "dim1dyn_id", "dim2dyn_id", "dim3dyn_id", "dim4dyn_id", "dim5dyn_id", "dim6dyn_id"});

    private TransferSerializeUtils() {
    }

    public static void singleSerializeToFile(File outDirectory, EntityName entityName, Object[] pks, boolean flag, long modelId) {
        String fileName = entityName.buildIdentifier();
        File targetFile = new File(outDirectory, String.format("%s.csv", fileName));
        ArrayList<String> lines = new ArrayList<String>(256);
        List<String> columnNames = TransferSerializeUtils.buildFileHeader(entityName, flag);
        lines.add(String.join((CharSequence)COLUMN_DELIMITER, columnNames));
        TransferSerializeUtils.pullDataAndWrite(entityName, pks, lines, targetFile, modelId);
    }

    public static Map<EntityName, Set<String>> batchExtractPkFromFile(List<File> entityFiles) {
        HashMap<EntityName, Set<String>> entityPkMap = new HashMap<EntityName, Set<String>>(entityFiles.size());
        for (File csvFile : entityFiles) {
            String fileName = csvFile.getName().substring(0, csvFile.getName().lastIndexOf("."));
            LOG.info("batchExtractPkFromFile file name:" + fileName);
            EntityName entityName = EntityName.parseFrom(fileName);
            if (!EntityPropertyParseHelper.isExist(entityName) || EntityGroup.isSalveEntity(entityName.getMainEntityName())) continue;
            try {
                LineIterator iterator = FileUtils.lineIterator((File)csvFile, (String)ENCODE);
                String headline = iterator.nextLine();
                HashSet<String> pkSets = new HashSet<String>(128);
                Object[] propNames = headline.split(COLUMN_DELIMITER_REGEX);
                String pkPropName = EntityMetadataCache.getDataEntityType((String)entityName.getMainEntityName()).getPrimaryKey().getName();
                int pkIndex = Lists.newArrayList((Object[])propNames).indexOf(pkPropName);
                if (pkIndex < 0) {
                    throw new IllegalStateException(ResManager.loadKDString((String)"\u903b\u8f91\u5f02\u5e38", (String)"TransferSerializeUtils_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
                while (iterator.hasNext()) {
                    String dataLine = iterator.nextLine();
                    String[] propValues = ((List)JacksonUtils.fromJson((String)dataLine, (TypeReference)new TypeReference<List<String>>(){})).toArray(new String[0]);
                    pkSets.add(propValues[pkIndex]);
                }
                entityName = EntityRepeat.getRealEntityName(entityName);
                entityPkMap.put(entityName, pkSets);
            }
            catch (IOException e) {
                throw new KDBizException((Throwable)e, ErrorCodeUtils.getSystemErrorCode((String)String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u8bfb\u53d6\u6570\u636e\u6587\u4ef6\u5931\u8d25\u3002", (String)"TransferSerializeUtils_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), csvFile.getAbsolutePath())), new Object[0]);
            }
        }
        return entityPkMap;
    }

    public static Map<EntityName, List<DynamicObjWrap>> createDynamicFromFile(File entityFile, boolean force) {
        String fileName = entityFile.getName().substring(0, entityFile.getName().lastIndexOf("."));
        EntityName entityName = EntityName.parseFrom(fileName);
        HashMap<EntityName, List<DynamicObjWrap>> maps = new HashMap<EntityName, List<DynamicObjWrap>>(16);
        if (EntityPropertyParseHelper.isExist(entityName)) {
            if (EntityGroup.isSalveEntity(entityName.getMainEntityName())) {
                maps.put(entityName, Collections.emptyList());
                return maps;
            }
            try {
                LineIterator iterator = FileUtils.lineIterator((File)entityFile, (String)ENCODE);
                ArrayList<DynamicObjWrap> objWraps = new ArrayList<DynamicObjWrap>(128);
                String headline = iterator.nextLine();
                if (StringUtils.isEmpty((CharSequence)headline)) {
                    throw new IllegalArgumentException("param headline is null");
                }
                int lineIndex = 1;
                MainEntityType dynamicObjectType = EntityMetadataCache.getDataEntityType((String)entityName.getMainEntityName());
                if (entityName.isBillEntry()) {
                    dynamicObjectType = (DynamicObjectType)dynamicObjectType.getAllEntities().get(entityName.getEntryName());
                }
                List<String> propNames = Arrays.asList(headline.split(COLUMN_DELIMITER_REGEX));
                List<String> newFields = TransferSerializeUtils.setDefaultOfNewField(entityName, propNames, (DynamicObjectType)dynamicObjectType);
                while (iterator.hasNext()) {
                    String dataLine = iterator.nextLine();
                    objWraps.add(TransferSerializeUtils.deserialize(entityName, propNames, dataLine, lineIndex++, force, (DynamicObjectType)dynamicObjectType, newFields));
                }
                entityName = EntityRepeat.getRealEntityName(entityName);
                maps.put(entityName, objWraps);
                return maps;
            }
            catch (IOException e) {
                throw new KDBizException((Throwable)e, ErrorCodeUtils.getSystemErrorCode((String)String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u8bfb\u53d6\u6570\u636e\u6587\u4ef6\u5931\u8d25\u3002", (String)"TransferSerializeUtils_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), entityFile.getAbsolutePath())), new Object[0]);
            }
        }
        if (force) {
            throw new KDBizException(TransferMsgUtils.missingEntityNames(Collections.singletonList(entityName.getMainEntityName())));
        }
        return maps;
    }

    public static void pullDataAndWrite(EntityName entityName, Object[] pks, List<String> lines, File targetFile, long modelId) {
        String apiSign;
        LOG.info(String.format("model_transfer_pulldata entity: %s pk size: %s lines\uff1a%s", entityName, pks.length, lines.size()));
        String mainEntityName = entityName.getMainEntityName();
        String entryName = entityName.getEntryName();
        Integer pageSize = entryName.equals("bcm_templatetree") ? NumericConstant.FIFTY : NumericConstant.TEN_THOUSAND;
        boolean isBill = entityName.isBillEntry();
        String metaStar = mainEntityName.substring(0, mainEntityName.indexOf("_"));
        String string = apiSign = metaStar.equals("epbs") ? "epm" : metaStar;
        if (!isBill) {
            String selectFields = EntityPropertyParseHelper.buildExportedPropsForSelect(mainEntityName);
            String selectFilterFields = entityName.getMainEntityName().equals("bcm_reportentity") ? TransferSerializeUtils.replaceCols(selectFields) : selectFields;
            String pkField = EntityMetadataCache.getDataEntityType((String)mainEntityName).getPrimaryKey().getName();
            BatchProcessHelper.batchConsume(Arrays.asList(pks), (int)pageSize, temp -> {
                QFilter qf = new QFilter(pkField, "in", temp);
                String[] fields = selectFilterFields.split(",");
                HashSet<String> mulFields = new HashSet<String>(10);
                HashSet<String> langFields = new HashSet<String>(10);
                ArrayList<DynamicObject> dys = new ArrayList<DynamicObject>(256);
                HashSet<Long> dyIds = new HashSet<Long>(256);
                DataSet rows = QueryServiceHelper.queryDataSet((String)apiSign, (String)mainEntityName, (String)selectFilterFields, (QFilter[])qf.toArray(), null);
                while (rows.hasNext()) {
                    Row row = rows.next();
                    DynamicObject dy = BusinessDataServiceHelper.newDynamicObject((String)mainEntityName);
                    DynamicObjectType dyType = dy.getDynamicObjectType();
                    for (String field : fields) {
                        if (dyType.getProperty(field) instanceof MulBasedataProp) {
                            mulFields.add(field);
                            continue;
                        }
                        if (dyType.getProperty(field) instanceof MuliLangTextProp) {
                            langFields.add(field);
                            dy.set(field, row.get(field));
                            continue;
                        }
                        dy.set(field, row.get(field));
                    }
                    if (dyIds.contains(dy.getLong(pkField))) continue;
                    dyIds.add(dy.getLong(pkField));
                    dys.add(dy);
                }
                if (dys.size() > 0) {
                    TransferSerializeUtils.setMulBaseAndLangValues(mulFields, langFields, dys, apiSign);
                    lines.addAll(dys.stream().map(e -> TransferSerializeUtils.serialize(e, isBill)).collect(Collectors.toList()));
                    TransferSerializeUtils.writeDataToFile(targetFile, lines);
                    lines.clear();
                    dys.clear();
                }
            });
        } else {
            DynamicObjectType entryType = (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)mainEntityName).getAllEntities().get(entryName);
            String entrySelectProps = EntityPropertyParseHelper.buildEntryExportedPropsForSelect(mainEntityName, entryName);
            String billPkField = EntityMetadataCache.getDataEntityType((String)mainEntityName).getPrimaryKey().getName();
            if (entryType instanceof SubEntryType) {
                IDataEntityType parentEntryType = entryType.getParent();
                DynamicObject[] taskEntities = BusinessDataServiceHelper.load((String)mainEntityName, (String)entrySelectProps, (QFilter[])new QFilter(billPkField, "in", (Object)pks).toArray());
                List datas = Arrays.stream(taskEntities).flatMap(x -> x.getDynamicObjectCollection(parentEntryType.getName()).stream().flatMap(y -> y.getDynamicObjectCollection(entryType.getName()).stream())).collect(Collectors.toList());
                lines.addAll(datas.stream().map(e -> TransferSerializeUtils.serialize(e, entityName.isBillEntry())).collect(Collectors.toList()));
                TransferSerializeUtils.writeDataToFile(targetFile, lines);
            } else {
                DynamicObjectType dynamicObjectType = BusinessDataServiceHelper.newDynamicObject((String)mainEntityName).getDynamicObjectCollection(entryName).getDynamicObjectType();
                String tableName = dynamicObjectType.getAlias();
                if (StringUtils.isEmpty((CharSequence)tableName)) {
                    return;
                }
                DataEntityPropertyCollection properties = dynamicObjectType.getProperties();
                StringBuilder sb = new StringBuilder(10);
                HashSet mulBaseField = new HashSet(6);
                HashSet mulTextField = new HashSet(6);
                HashMap name2Alias = new HashMap(16);
                properties.forEach(x -> {
                    String alias = x.getAlias();
                    if (StringUtils.isNotEmpty((CharSequence)alias)) {
                        if (x instanceof MulBasedataProp) {
                            mulBaseField.add(x.getName());
                        } else {
                            sb.append(x.getAlias());
                            sb.append(",");
                        }
                        if (x instanceof MuliLangTextProp) {
                            mulTextField.add(x.getName());
                        }
                        name2Alias.put(x.getName(), x.getAlias());
                    }
                });
                String pdIdAlias = dynamicObjectType.getParent().getPrimaryKey().getAlias();
                String pdIdName = dynamicObjectType.getParent().getPrimaryKey().getName();
                BatchProcessHelper.batchConsume(Arrays.asList(pks), (int)pageSize, temp -> {
                    StringBuilder sbIds = new StringBuilder(100);
                    for (Object pk : temp) {
                        sbIds.append(pk);
                        sbIds.append(",");
                    }
                    sbIds.replace(sbIds.length() - 1, sbIds.length(), "");
                    String sql = "select " + sb + pdIdAlias + " from " + tableName + " where " + pdIdAlias + " in (" + sbIds + ")";
                    if (tableName.equals("t_epbs_param_set")) {
                        sql = sql + " and fmodelid = " + modelId;
                    }
                    DataSet rows = DB.queryDataSet((String)"export_model_entryname", (DBRoute)DBRoute.of((String)apiSign), (String)sql);
                    ArrayList<DynamicObject> entryDys = new ArrayList<DynamicObject>(10);
                    while (rows.hasNext()) {
                        DynamicObject entryDy = (DynamicObject)dynamicObjectType.createInstance();
                        Row row = rows.next();
                        name2Alias.forEach((x, y) -> {
                            if (!(dynamicObjectType.getProperty(x) instanceof MulBasedataProp)) {
                                entryDy.set(x, row.get(y));
                            }
                        });
                        DynamicObject parDy = BusinessDataServiceHelper.newDynamicObject((String)mainEntityName);
                        parDy.set(pdIdName, (Object)row.getLong(pdIdAlias));
                        entryDy.setParent((Object)parDy);
                        entryDys.add(entryDy);
                    }
                    if (entryDys.size() > 0) {
                        TransferSerializeUtils.setMulBaseAndLangValues(mulBaseField, mulTextField, entryDys, apiSign);
                        lines.addAll(entryDys.stream().map(e -> TransferSerializeUtils.serialize(e, isBill)).collect(Collectors.toList()));
                        TransferSerializeUtils.writeDataToFile(targetFile, lines);
                        lines.clear();
                        entryDys.clear();
                    }
                });
            }
        }
    }

    private static void setMulBaseAndLangValues(Set<String> mulFields, Set<String> langFields, List<DynamicObject> dys, String apiSign) {
        if (mulFields.size() > 0 || langFields.size() > 0) {
            DynamicObjectType dynamicObjectType = dys.get(0).getDynamicObjectType();
            Set ids = dys.stream().map(x -> x.getPkValue()).collect(Collectors.toSet());
            List filterIds = ids.stream().filter(x -> x != null && (Long)x != 0L).collect(Collectors.toList());
            if (mulFields.size() > 0) {
                try {
                    DynamicObject ormDy = dys.get(0);
                    for (String mulField : mulFields) {
                        String baseEntityId = ((MulBasedataDynamicObjectCollection)ormDy.get(mulField)).getDynamicObjectType().getAlias();
                        LOG.info("setMulBaseAndLangValues\uff1aentityname=" + dynamicObjectType.getName() + ";tablename=" + baseEntityId + ";mulField=" + mulField);
                        StringBuilder sb = new StringBuilder(10);
                        if (filterIds.size() == 0) continue;
                        for (int i = 0; i < filterIds.size(); ++i) {
                            sb.append(filterIds.get(i));
                            if (i == filterIds.size() - 1) continue;
                            sb.append(",");
                        }
                        String alias = dynamicObjectType.getPrimaryKey().getAlias();
                        String sql = "select fbasedataid, " + alias + " from " + baseEntityId + " where " + alias + " in (" + sb + ")";
                        DataSet mulRows = DB.queryDataSet((String)"export_model_mainentityname", (DBRoute)DBRoute.of((String)apiSign), (String)sql);
                        HashMap<Long, List> id2MulIds = new HashMap<Long, List>(10);
                        while (mulRows.hasNext()) {
                            Row mulRow = mulRows.next();
                            List basedataIds = id2MulIds.computeIfAbsent(mulRow.getLong(alias), k -> new ArrayList(10));
                            basedataIds.add(mulRow.getLong("fbasedataid"));
                        }
                        for (DynamicObject dynamicObject : dys) {
                            dynamicObject.set(mulField, (Object)StringUtils.join((Iterable)((Iterable)id2MulIds.get(dynamicObject.getPkValue())), (String)","));
                        }
                    }
                }
                catch (Exception e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
            }
            if (langFields.size() > 0) {
                String baseEntityId = dynamicObjectType.getAlias() + "_l";
                StringBuilder sb = new StringBuilder(10);
                if (filterIds.size() != 0) {
                    for (int i = 0; i < filterIds.size(); ++i) {
                        sb.append(filterIds.get(i));
                        if (i == filterIds.size() - 1) continue;
                        sb.append(",");
                    }
                    StringBuilder sbFiled = new StringBuilder(10);
                    HashMap<String, String> sing2Filed = new HashMap<String, String>(8);
                    for (String langField : langFields) {
                        LOG.info("setMulBaseAndLangValues\uff1aentityname=" + dynamicObjectType.getName() + ";tablename=" + baseEntityId + ";langField=" + langField);
                        String alias = dynamicObjectType.getProperty(langField).getAlias();
                        sbFiled.append(alias);
                        sbFiled.append(",");
                        sing2Filed.put(langField, alias);
                    }
                    String pkId = dynamicObjectType.getPrimaryKey().getAlias();
                    String sql = "select " + sbFiled + pkId + ", flocaleid from " + baseEntityId + " where " + pkId + " in (" + sb + ")";
                    DataSet mulRows = DB.queryDataSet((String)"export_model_mainentityname", (DBRoute)DBRoute.of((String)apiSign), (String)sql);
                    HashBasedTable id2Map = HashBasedTable.create();
                    while (mulRows.hasNext()) {
                        Row mulRow = mulRows.next();
                        for (String langField : langFields) {
                            HashMap<String, String> map = (HashMap<String, String>)id2Map.get((Object)mulRow.getLong(pkId), (Object)langField);
                            if (map == null) {
                                map = new HashMap<String, String>(3);
                            }
                            map.put(mulRow.getString("flocaleid"), mulRow.getString((String)sing2Filed.get(langField)));
                            id2Map.put((Object)mulRow.getLong(pkId), (Object)langField, map);
                        }
                    }
                    if (id2Map.size() == 0) {
                        return;
                    }
                    for (DynamicObject dy : dys) {
                        for (String langField : langFields) {
                            Map map = (Map)id2Map.get(dy.getPkValue(), (Object)langField);
                            if (map == null) continue;
                            ILocaleString localeString = dy.getLocaleString(langField);
                            for (Map.Entry entry : map.entrySet()) {
                                localeString.setItem((String)entry.getKey(), entry.getValue());
                            }
                        }
                    }
                }
            }
        }
    }

    public static void generateModelMetaFile(Collection<EntityName> entityNames, File file) {
        List lines = entityNames.stream().map(x -> String.format("%s:%s", x.buildIdentifier(), String.join((CharSequence)",", TransferSerializeUtils.listExportProps(x)))).collect(Collectors.toList());
        try {
            FileUtils.writeLines((File)file, (String)ENCODE, lines);
        }
        catch (IOException e) {
            throw new KDBizException((Throwable)e, ErrorCodeUtils.getSystemErrorCode((String)e.getMessage()), new Object[0]);
        }
    }

    public static Map<EntityName, List<String>> buildEntityNameFromMetaFile(File file) {
        try {
            LineIterator iterator = FileUtils.lineIterator((File)file, (String)ENCODE);
            HashMap<EntityName, List<String>> result = new HashMap<EntityName, List<String>>(8);
            while (iterator.hasNext()) {
                String line = iterator.nextLine();
                String[] parts = line.split(":");
                EntityName entityName = EntityName.parseFrom(parts[0]);
                List<String> props = Arrays.asList(StringUtils.split((String)parts[1], (String)","));
                result.put(entityName, props);
            }
            return result;
        }
        catch (IOException e) {
            throw new KDBizException((Throwable)e, ErrorCodeUtils.getSystemErrorCode((String)e.getMessage()), new Object[0]);
        }
    }

    public static List<String> listExportProps(EntityName entityName) {
        boolean isBill;
        String mainEntityName = entityName.getMainEntityName();
        String entryName = entityName.getEntryName();
        boolean bl = isBill = !entityName.isBillEntry();
        if (isBill) {
            return EntityPropertyParseHelper.listExportProps(mainEntityName);
        }
        EntityType entryEntityType = (EntityType)EntityMetadataCache.getDataEntityType((String)mainEntityName).getAllEntities().get(entryName);
        return EntityPropertyParseHelper.listExportProps((DynamicObjectType)entryEntityType);
    }

    public static EntityType getEntityTypeByEntityName(EntityName entityName) {
        boolean isBill;
        String mainEntityName = entityName.getMainEntityName();
        String entryName = entityName.getEntryName();
        boolean bl = isBill = !entityName.isBillEntry();
        if (isBill) {
            return EntityMetadataCache.getDataEntityType((String)mainEntityName);
        }
        return (EntityType)EntityMetadataCache.getDataEntityType((String)mainEntityName).getAllEntities().get(entryName);
    }

    public static List<String> serialize(List<DynamicObject> billOrEntryList, EntityName entityName, boolean flag) {
        boolean isBill = !entityName.isBillEntry();
        ArrayList<String> lines = new ArrayList<String>(10);
        List<String> columnNames = null;
        if (isBill) {
            columnNames = EntityPropertyParseHelper.listExportProps(entityName.getMainEntityName());
        } else {
            EntityType entryEntityType = (EntityType)EntityMetadataCache.getDataEntityType((String)entityName.getMainEntityName()).getAllEntities().get(entityName.getEntryName());
            columnNames = EntityPropertyParseHelper.listExportProps((DynamicObjectType)entryEntityType);
            columnNames.add(COLUMN_ENTRY_PARENT_ID);
        }
        if (flag && entityName.getMainEntityName().equals("bcm_reportentity")) {
            columnNames = columnNames.stream().filter(x -> !x.equals(FDATA) && !x.equals(FSPREAD_JSON)).collect(Collectors.toList());
        }
        lines.add(String.join((CharSequence)COLUMN_DELIMITER, columnNames));
        if (CollectionUtils.isNotEmpty(billOrEntryList)) {
            lines.addAll(billOrEntryList.stream().map(e -> TransferSerializeUtils.serialize(e, entityName.isBillEntry())).collect(Collectors.toList()));
        }
        return lines;
    }

    private static List<String> buildFileHeader(EntityName entityName, boolean flag) {
        boolean isBill = !entityName.isBillEntry();
        List<String> columnNames = null;
        if (isBill) {
            columnNames = EntityPropertyParseHelper.listExportProps(entityName.getMainEntityName());
        } else {
            EntityType entryEntityType = (EntityType)EntityMetadataCache.getDataEntityType((String)entityName.getMainEntityName()).getAllEntities().get(entityName.getEntryName());
            columnNames = EntityPropertyParseHelper.listExportProps((DynamicObjectType)entryEntityType);
            columnNames.add(COLUMN_ENTRY_PARENT_ID);
        }
        if (flag && entityName.getMainEntityName().equals("bcm_reportentity")) {
            columnNames = columnNames.stream().filter(x -> !x.equals(FDATA) && !x.equals(FSPREAD_JSON)).collect(Collectors.toList());
        }
        return columnNames;
    }

    public static List<String> serialize(DynamicObject entity, String entryName) {
        if (Objects.isNull(entity)) {
            throw new IllegalArgumentException("param entity is null");
        }
        if (entity == null) {
            throw new KDBizException("param entity is null");
        }
        if (entryName == null || entryName.length() == 0) {
            return Collections.singletonList(TransferSerializeUtils.serialize(entity, false));
        }
        if (Objects.isNull(entity.getDynamicObjectType().getProperty(entryName))) {
            throw new IllegalArgumentException(entity.getDynamicObjectType().getName() + " does not include entry: " + entryName);
        }
        return entity.getDynamicObjectCollection(entryName).stream().map(x -> TransferSerializeUtils.serialize(x, true)).collect(Collectors.toList());
    }

    private static String serialize(DynamicObject billEntity, boolean isEntry) {
        Object entryParent;
        if (Objects.isNull(billEntity)) {
            throw new IllegalArgumentException("param billEntity is null");
        }
        if (billEntity == null) {
            throw new KDBizException("param billEntity is null");
        }
        List<String> fields = EntityPropertyParseHelper.listExportProps(billEntity.getDynamicObjectType());
        if ("bcm_reportentity".equals(billEntity.getDynamicObjectType().getName()) && (fields.contains(FDATA) || fields.contains(FSPREAD_JSON))) {
            fields.remove(FDATA);
            fields.remove(FSPREAD_JSON);
        }
        List propVals = fields.stream().map(p -> {
            Object propValue = billEntity.get(p);
            if (Objects.isNull(propValue)) {
                return "";
            }
            if (propValue instanceof String) {
                return (String)propValue;
            }
            if (propValue instanceof DynamicObjectCollection) {
                Preconditions.checkState((boolean)(billEntity.getDynamicObjectType().getProperty(p) instanceof MulBasedataProp));
                return ((DynamicObjectCollection)propValue).stream().map(x -> x.getString("fbasedataid_id")).collect(Collectors.joining(","));
            }
            return JacksonUtils.toJson((Object)propValue);
        }).collect(Collectors.toList());
        if (isEntry && Objects.nonNull(entryParent = billEntity.getParent())) {
            DynamicObject parent = (DynamicObject)entryParent;
            propVals.add(parent.getPkValue().toString());
        }
        return JacksonUtils.toJson(propVals);
    }

    public static DynamicObjWrap deserialize(EntityName entityName, List<String> propNames, String dataLine, int lineIndex, boolean force, DynamicObjectType dynamicObjectType, List<String> addedFields) {
        DynamicProperty entityProp;
        if (StringUtils.isEmpty((CharSequence)dataLine)) {
            throw new IllegalArgumentException("param dataLine is null");
        }
        String[] propValues = ((List)JacksonUtils.fromJson((String)dataLine, (TypeReference)new TypeReference<List<String>>(){})).toArray(new String[0]);
        if (propNames.size() != propValues.length) {
            throw new IllegalStateException(String.format("On %s, header column size is inconsistent with data column size: [header] %s [data] %s on line:%s.", entityName, propNames, dataLine, lineIndex));
        }
        boolean flag = entityName.getMainEntityName().equals("bcm_adjsetting") && "entryentity".equals(entityName.getEntryName());
        DynamicObject dynamicObject = new DynamicObject(dynamicObjectType);
        DynamicObjWrap result = new DynamicObjWrap(dynamicObject);
        for (int j = 0; j < propNames.size(); ++j) {
            if (StringUtils.isEmpty((CharSequence)propValues[j]) || "null".equals(propValues[j])) continue;
            String propName = propNames.get(j);
            if (entityName.getMainEntityName().equals("bcm_rptadjust") && (FDATA.equals(propName) || FSPREAD_JSON.equals(propName)) || entityName.getMainEntityName().equals("bcm_rptadjustdata") && ("ruleexpr".equals(propName) || "calculatecontent".equals(propName))) continue;
            if (COLUMN_ENTRY_PARENT_ID.equals(propName)) {
                result.setParentPk(propValues[j]);
                continue;
            }
            if (flag && ADJ_SPE_OLD_FIELDS.contains(propName)) {
                dynamicObject.set(ADJ_SPE_NEW_FIELDS.get(ADJ_SPE_OLD_FIELDS.indexOf(propName)), JacksonUtils.fromJson((String)propValues[j], Long.TYPE));
                continue;
            }
            entityProp = dynamicObjectType.getProperty(propName);
            if (Objects.isNull(entityProp)) {
                if (!force) continue;
                throw new KDBizException(TransferMsgUtils.missingEntityProp(entityName.toString(), propName));
            }
            try {
                if (entityProp instanceof MulBasedataProp) {
                    if (!StringUtils.isNotEmpty((CharSequence)propValues[j])) continue;
                    List<String> basedataIds = Arrays.asList(propValues[j].split(","));
                    result.addMultiPropEntry((MulBasedataProp)entityProp, basedataIds);
                    continue;
                }
                Class propertyType = entityProp.getPropertyType();
                if (String.class == propertyType) {
                    dynamicObject.set(propNames.get(j), (Object)propValues[j]);
                    continue;
                }
                if (ILocaleString.class == propertyType) {
                    LocaleString localeString;
                    try {
                        localeString = (LocaleString)JacksonUtils.fromJson((String)propValues[j], LocaleString.class);
                    }
                    catch (KDBizException e) {
                        localeString = (LocaleString)JacksonUtils.fromJson((String)JSON.toJSONString((Object)new LocaleString(propValues[j])), LocaleString.class);
                    }
                    if (localeString.getItem(Lang.zh_CN.name()) == null && localeString.getItem(Lang.zh_TW.getLangTag()) == null && localeString.getItem(Lang.en_US.getLangTag()) == null && localeString.getItem("GLang") != null) {
                        localeString.setItem(Lang.zh_CN.name(), localeString.getItem("GLang"));
                    }
                    dynamicObject.set(propNames.get(j), (Object)localeString);
                    continue;
                }
                dynamicObject.set(propNames.get(j), JacksonUtils.fromJson((String)propValues[j], (Class)propertyType));
                continue;
            }
            catch (Exception e) {
                LOG.error(String.format("deserialize_data_failed, cur prop: %s, value: %s, entity - %s, headerLine - %s, dataLine - %s, msg: %s", propName, propValues[j], entityName, propNames.toString(), dataLine, e.getMessage()), (Throwable)e);
                throw new KDBizException((Throwable)e, ErrorCodeUtils.getSystemErrorCode((String)e.getMessage()), new Object[0]);
            }
        }
        if (flag) {
            addedFields.removeAll(ADJ_SPE_NEW_FIELDS);
        }
        if (addedFields.size() > 0) {
            for (String addField : addedFields) {
                entityProp = dynamicObjectType.getProperty(addField);
                if (entityProp == null || entityProp.getAlias() == null || !(entityProp instanceof FieldProp)) continue;
                dynamicObject.set(addField, ((FieldProp)entityProp).getDefValue());
            }
        }
        return result;
    }

    private static List<String> setDefaultOfNewField(EntityName entityName, List<String> propNames, DynamicObjectType dynamicObjectType) {
        String mainEntityName = entityName.getMainEntityName();
        String entryName = entityName.getEntryName();
        String selectFields = "";
        boolean flag = entityName.isBillEntry();
        selectFields = flag ? EntityPropertyParseHelper.buildEntryExportedPropsForSelect(mainEntityName, entryName) : EntityPropertyParseHelper.buildExportedPropsForSelect(mainEntityName);
        ArrayList<Object> newFields = new ArrayList<Object>(10);
        if (StringUtils.isNotEmpty((CharSequence)selectFields)) {
            String[] targetFields = selectFields.split(",");
            if (flag) {
                for (String targetField : targetFields) {
                    if (targetField.contains(".")) {
                        newFields.add(targetField.substring(targetField.indexOf(".") + 1));
                        continue;
                    }
                    newFields.add(targetField);
                }
            } else {
                Collections.addAll(newFields, targetFields);
            }
        }
        ArrayList<String> addedFileds = new ArrayList<String>(10);
        for (String string : newFields) {
            if (propNames.contains(string)) continue;
            addedFileds.add(string);
        }
        return addedFileds;
    }

    private static String replaceCols(String selectFields) {
        if (selectFields.contains(",data")) {
            selectFields = selectFields.replace(",data", "");
        }
        if (selectFields.contains(",spreadjson")) {
            selectFields = selectFields.replace(",spreadjson", "");
        }
        return selectFields;
    }

    public static String getVersionOfConstellation() {
        List versions = VersionService.getVersionInfos();
        for (Version version : versions) {
            if (!version.getProductNumber().startsWith("constellation_")) continue;
            return version.getVersion();
        }
        return "";
    }

    public static void writeDataToFile(File targetFile, List<String> lines) {
        try {
            FileUtils.writeLines((File)targetFile, (String)ENCODE, lines, (boolean)true);
        }
        catch (IOException ex) {
            LOG.error("Failed to write file:" + ex.getMessage(), (Throwable)ex);
            throw new KDBizException((Throwable)ex, ErrorCodeUtils.getSystemErrorCode((String)ex.getMessage()), new Object[0]);
        }
    }

    public static void writeDataToFileWithGBK(File targetFile, List<String> lines) {
        try {
            FileUtils.writeLines((File)targetFile, (String)GBK, lines, (boolean)true);
        }
        catch (IOException ex) {
            LOG.error("Failed to write file:" + ex.getMessage(), (Throwable)ex);
            throw new KDBizException((Throwable)ex, ErrorCodeUtils.getSystemErrorCode((String)ex.getMessage()), new Object[0]);
        }
    }
}

