/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.model.transfer.core.components.input;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.Consumer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.entity.property.ModifyDateProp;
import kd.fi.bcm.formplugin.model.transfer.core.DynamicObjWrap;
import kd.fi.bcm.formplugin.model.transfer.core.EntityName;
import kd.fi.bcm.formplugin.model.transfer.core.PKExchanger;
import kd.fi.bcm.formplugin.model.transfer.core.RecordLocator;
import kd.fi.bcm.formplugin.model.transfer.core.TransferComponent;
import kd.fi.bcm.formplugin.model.transfer.core.TransferContext;
import kd.fi.bcm.formplugin.model.transfer.core.components.input.CommonBillInputComponent;
import org.apache.commons.lang3.StringUtils;

@TransferComponent(entityNumber="bcm_analysishelper")
public class AnalysiShelperInputComponent
extends CommonBillInputComponent {
    public AnalysiShelperInputComponent(TransferContext transferContext, EntityName entityName, PKExchanger pkExchanger, List<DynamicObjWrap> billOrEntries) {
        super(transferContext, entityName, pkExchanger, billOrEntries);
    }

    @Override
    public void updateEntityReferPK() {
        super.updateEntityReferPK();
        if (this.entityName.isBillEntry() && "anaysisdimrange".equals(this.entityName.getEntryName())) {
            this.iteratorBatchProcess((Consumer<DynamicObject>)((Consumer)row -> {
                Object newPK;
                long dimrangevalue = row.getLong("dimrangevalue");
                String dimentity = row.getString("dimentity");
                if (StringUtils.isNotEmpty((CharSequence)dimentity) && (newPK = this.pkExchanger.getNewPK(new RecordLocator(this.entityName, "anaysisdim", dimrangevalue), Optional.of(new EntityName(dimentity)), String.valueOf(dimrangevalue), true)) != null && StringUtils.isNotEmpty((CharSequence)newPK.toString()) && Long.parseLong(newPK.toString()) != 0L) {
                    row.set("dimrangevalue", newPK);
                }
            }));
        } else {
            this.iteratorBatchProcess((Consumer<DynamicObject>)((Consumer)row -> {
                String anaysisdim = row.getString("anaysisdim");
                if (StringUtils.isNotEmpty((CharSequence)anaysisdim) && anaysisdim.contains("/")) {
                    String[] dimInfo = anaysisdim.split("/");
                    String dimId = dimInfo[0];
                    String memberTable = dimInfo[1];
                    Object newPK = this.pkExchanger.getNewPK(new RecordLocator(this.entityName, "anaysisdim", dimId), Optional.of(new EntityName("bcm_dimension")), dimId, true);
                    if (newPK != null && StringUtils.isNotEmpty((CharSequence)newPK.toString()) && Long.parseLong(newPK.toString()) != 0L) {
                        row.set("anaysisdim", (Object)(newPK + "/" + memberTable));
                    }
                }
            }));
        }
    }

    @Override
    public void updateEntityNonPKProps() {
        List simpleProps = this.entityType.getProperties().stream().filter(x -> x instanceof ISimpleProperty && !x.isDbIgnore()).map(x -> (ISimpleProperty)x).collect(Collectors.toList());
        List dateProps = simpleProps.stream().filter(x -> x instanceof ModifyDateProp).collect(Collectors.toList());
        this.iteratorBatchProcess((Consumer<DynamicObject>)((Consumer)entity -> dateProps.forEach(dp -> entity.set((IDataEntityProperty)dp, (Object)entity.getDate("createtime")))));
    }
}

