/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.model.transfer.core.components.input;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Consumer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.model.transfer.core.DynamicObjWrap;
import kd.fi.bcm.formplugin.model.transfer.core.EntityName;
import kd.fi.bcm.formplugin.model.transfer.core.PKExchanger;
import kd.fi.bcm.formplugin.model.transfer.core.RecordLocator;
import kd.fi.bcm.formplugin.model.transfer.core.TransferComponent;
import kd.fi.bcm.formplugin.model.transfer.core.TransferContext;
import kd.fi.bcm.formplugin.model.transfer.core.components.input.CommonBillInputComponent;

@TransferComponent(entityNumber="bcm_analyticssoluentry")
public class AnalyticsSolutionInputComponent
extends CommonBillInputComponent {
    private static final Set<String> invalidBasedataProps = new HashSet<String>(Arrays.asList("orderindex", "roworderindex", "colorderindex"));

    public AnalyticsSolutionInputComponent(TransferContext transferContext, EntityName entityName, PKExchanger pkExchanger, List<DynamicObjWrap> billOrEntries) {
        super(transferContext, entityName, pkExchanger, billOrEntries);
    }

    @Override
    public void updateEntityReferPK() {
        super.updateEntityReferPK();
        long currUserId = RequestContext.get().getCurrUserId();
        if ("rowdim".equals(this.entityName.getEntryName())) {
            this.iteratorBatchProcess((Consumer<DynamicObject>)((Consumer)x -> x.set("rowmenberid", (Object)this.replaceNewIds(x.getString("rowmenberid"), "rowmenberid", x.getLong("id")))));
        } else if ("coldim".equals(this.entityName.getEntryName())) {
            this.iteratorBatchProcess((Consumer<DynamicObject>)((Consumer)x -> x.set("columnmenberid", (Object)this.replaceNewIds(x.getString("columnmenberid"), "columnmenberid", x.getLong("id")))));
        } else if ("pagedim".equals(this.entityName.getEntryName())) {
            this.iteratorBatchProcess((Consumer<DynamicObject>)((Consumer)x -> x.set("menberid", (Object)this.replaceNewIds(x.getString("menberid"), "menberid", x.getLong("id")))));
        } else if (!this.entityName.isBillEntry()) {
            this.iteratorBatchProcess((Consumer<DynamicObject>)((Consumer)x -> {
                x.set("createuserid", (Object)currUserId);
                x.set("updateuserid", (Object)currUserId);
            }));
        }
    }

    @Override
    protected boolean updateEntityReferPK(EntityName curEntityName, DynamicObject dynamicObject, String dyOriginPk, String referIdPropName, IDataEntityProperty basedataProp, String propEntityName) {
        return invalidBasedataProps.contains(basedataProp.getName());
    }

    private String replaceNewIds(String memberIdStr, String processProp, Long pk) {
        if (StringUtils.isEmpty((CharSequence)memberIdStr)) {
            return memberIdStr;
        }
        String[] items = memberIdStr.split(",");
        for (int j = 0; j < items.length; ++j) {
            String[] temMem = items[j].split(";");
            if (temMem.length <= 0) continue;
            boolean isCustom = temMem.length >= 3;
            String memberId = temMem[0];
            Object newMemberId = this.pkExchanger.getNewPK(new RecordLocator(this.entityName, processProp, pk), Optional.empty(), memberId, true);
            if (newMemberId != null) {
                items[j] = items[j].replace(memberId, newMemberId.toString());
            }
            if (!isCustom || !DimEntityNumEnum.ENTITY.getEntityNum().equals(this.entityName.getMainEntityName()) || temMem.length != 4) continue;
            String clsId = temMem[3];
            Object newclsId = this.pkExchanger.getNewPK(new RecordLocator(this.entityName, processProp, pk), Optional.of(new EntityName("bcm_cslscheme")), clsId, true);
            if (newclsId == null) continue;
            items[j] = items[j].replace(clsId, newclsId.toString());
        }
        return String.join((CharSequence)",", Arrays.asList(items));
    }
}

