/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.model.transfer.core.components.input;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.Consumer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.model.transfer.core.DynamicObjWrap;
import kd.fi.bcm.formplugin.model.transfer.core.EntityName;
import kd.fi.bcm.formplugin.model.transfer.core.PKExchanger;
import kd.fi.bcm.formplugin.model.transfer.core.RecordLocator;
import kd.fi.bcm.formplugin.model.transfer.core.TransferComponent;
import kd.fi.bcm.formplugin.model.transfer.core.TransferContext;
import kd.fi.bcm.formplugin.model.transfer.core.components.input.CommonBillInputComponent;

@TransferComponent(entityNumber="bcm_auth_info")
public class AuthInfoInputComponent
extends CommonBillInputComponent {
    public AuthInfoInputComponent(TransferContext transferContext, EntityName entityName, PKExchanger pkExchanger, List<DynamicObjWrap> billOrEntries) {
        super(transferContext, entityName, pkExchanger, billOrEntries);
    }

    @Override
    public void updateEntityNonPKProps() {
        super.updateEntityNonPKProps();
        Set levelProps = this.entityType.getProperties().stream().filter(x -> x instanceof ISimpleProperty && !x.isDbIgnore() && x.getName().startsWith("level")).collect(Collectors.toSet());
        if (!this.entityName.isBillEntry()) {
            this.iteratorBatchProcess((Consumer<DynamicObject>)((Consumer)bill -> {
                String originPk = this.pkExchanger.getOldPK(Optional.of(this.entityName), bill.getPkValue().toString(), true);
                RecordLocator recordLocator = new RecordLocator(this.entityName, "id", originPk);
                levelProps.forEach(levelProp -> {
                    String originLevelId = bill.getString(levelProp);
                    if (StringUtils.isEmpty((CharSequence)originLevelId) || "0".equals(originLevelId)) {
                        return;
                    }
                    Object newPropValue = this.pkExchanger.getNewPK(recordLocator, Optional.of(new EntityName("bcm_flowstep")), originLevelId, true);
                    bill.set(levelProp, this.defaultIdConverter.apply(newPropValue));
                });
            }));
        }
    }
}

