/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.model.transfer.core.components.input;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.Consumer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkFormulaServiceHelper;
import kd.fi.bcm.business.script.CommonFormulaModel;
import kd.fi.bcm.business.script.XdmExpressionGenerator;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.formplugin.model.transfer.core.DynamicObjWrap;
import kd.fi.bcm.formplugin.model.transfer.core.EntityName;
import kd.fi.bcm.formplugin.model.transfer.core.PKExchanger;
import kd.fi.bcm.formplugin.model.transfer.core.RecordLocator;
import kd.fi.bcm.formplugin.model.transfer.core.TransferComponent;
import kd.fi.bcm.formplugin.model.transfer.core.TransferContext;
import kd.fi.bcm.formplugin.model.transfer.core.components.input.CommonBillInputComponent;
import org.apache.commons.collections.CollectionUtils;

@TransferComponent(entityNumber="bcm_chkformulasetting")
public class CHKFormulaInputComponent
extends CommonBillInputComponent {
    public CHKFormulaInputComponent(TransferContext transferContext, EntityName entityName, PKExchanger pkExchanger, List<DynamicObjWrap> billOrEntries) {
        super(transferContext, entityName, pkExchanger, billOrEntries);
    }

    @Override
    public void updateEntityReferPK() {
        super.updateEntityReferPK();
        if ("memberrange".equals(this.entityName.getEntryName())) {
            this.iteratorBatchProcess((Consumer<DynamicObject>)((Consumer)x -> x.set("memberid", this.pkExchanger.getNewPK(new RecordLocator(this.entityName, "id", x.getPkValue()), Optional.empty(), x.getString("memberId"), true))));
        }
    }

    @Override
    public void updateEntityNonPKProps() {
        super.updateEntityNonPKProps();
        if (!this.entityName.isBillEntry()) {
            this.iteratorBatchProcess((Consumer<DynamicObject>)((Consumer)x -> {
                String newFormula;
                if (ChkFormulaServiceHelper.hasXdmFormula((String)x.getString("leftformula"))) {
                    String leftFormula = x.getString("leftformula");
                    newFormula = this.transferId(leftFormula);
                    x.set("leftformula", (Object)newFormula);
                    x.set("lformulatemp", (Object)newFormula);
                }
                if (ChkFormulaServiceHelper.hasXdmFormula((String)x.getString("rightformula"))) {
                    String rightFormula = x.getString("rightformula");
                    newFormula = this.transferId(rightFormula);
                    x.set("rightformula", (Object)newFormula);
                    x.set("rformulatemp", (Object)newFormula);
                }
            }));
        }
    }

    private String transferId(String originalFormula) {
        List xList = ChkFormulaServiceHelper.getXList((String)originalFormula);
        String newFormula = originalFormula;
        if (!xList.isEmpty()) {
            for (String f : xList) {
                CommonFormulaModel xdmFormulaBuilder = ChkFormulaServiceHelper.parseXdmFormulaModel((String)f);
                List extendMdFieldValue = (List)xdmFormulaBuilder.getCondition("extendsmdfieldvalue");
                if (!CollectionUtils.isNotEmpty((Collection)extendMdFieldValue)) continue;
                ArrayList<Tuple> newExMDFieldValue = new ArrayList<Tuple>(extendMdFieldValue.size());
                for (Tuple tuple : extendMdFieldValue) {
                    if (tuple.p3 != null) {
                        String dimNumber = tuple.p1.toString().replace("mdfieldpanel", "");
                        EntityName memberEntityName = new EntityName(DimEntityNumEnum.getEntieyNumByNumber((String)dimNumber));
                        EntityName customPropEntityName = new EntityName("bcm_definedpropertyvalue");
                        JSONArray jsonArray = JSONArray.parseArray((String)tuple.p3.toString());
                        for (Object o : jsonArray) {
                            Object id;
                            Object oldPK;
                            JSONObject json = (JSONObject)o;
                            if (json.get((Object)"pid") != null && !"".equals(json.get((Object)"pid").toString())) {
                                oldPK = json.get((Object)"pid");
                                id = this.pkExchanger.getNewPK(new RecordLocator(customPropEntityName, "id", oldPK), Optional.empty(), oldPK.toString(), true);
                                json.put("pid", id);
                                continue;
                            }
                            oldPK = json.get((Object)"id");
                            id = this.pkExchanger.getNewPK(new RecordLocator(memberEntityName, "id", oldPK), Optional.empty(), oldPK.toString(), true);
                            json.put("id", id);
                        }
                        Tuple newTuple = Tuple.create((Object)tuple.p1.toString(), (Object)tuple.p2.toString(), (Object)jsonArray.toString());
                        newExMDFieldValue.add(newTuple);
                        continue;
                    }
                    newExMDFieldValue.add(tuple);
                }
                xdmFormulaBuilder.addCondition("extendsmdfieldvalue", newExMDFieldValue);
                String newF = XdmExpressionGenerator.generateFormulaFunction((CommonFormulaModel)xdmFormulaBuilder);
                newFormula = originalFormula.replace(f, newF);
            }
        }
        return newFormula;
    }
}

