/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.model.transfer.core.components.input;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.Consumer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.model.transfer.core.DynamicObjWrap;
import kd.fi.bcm.formplugin.model.transfer.core.EntityName;
import kd.fi.bcm.formplugin.model.transfer.core.PKExchanger;
import kd.fi.bcm.formplugin.model.transfer.core.RecordLocator;
import kd.fi.bcm.formplugin.model.transfer.core.TransferComponent;
import kd.fi.bcm.formplugin.model.transfer.core.TransferContext;
import kd.fi.bcm.formplugin.model.transfer.core.components.input.CommonBillInputComponent;

@TransferComponent(entityNumber="bcm_carrymap")
public class CarryMapInputComponent
extends CommonBillInputComponent {
    public CarryMapInputComponent(TransferContext transferContext, EntityName entityName, PKExchanger pkExchanger, List<DynamicObjWrap> billOrEntries) {
        super(transferContext, entityName, pkExchanger, billOrEntries);
    }

    @Override
    public void updateEntityNonPKProps() {
        super.updateEntityNonPKProps();
        if (this.entityName.isBillEntry() && "specialentry".equals(this.entityName.getEntryName())) {
            ISimpleProperty pkProperty = this.entityType.getPrimaryKey();
            IDataEntityProperty accountScopeProperty = (IDataEntityProperty)this.entityType.getProperties().get((Object)"accountscope");
            IDataEntityProperty dimensionScopeProperty = (IDataEntityProperty)this.entityType.getProperties().get((Object)"dimensionscope");
            this.iteratorBatchProcess((Consumer<DynamicObject>)((Consumer)entity -> {
                RecordLocator recordLocator;
                String originPk;
                String accountScopeStr = entity.getString(accountScopeProperty);
                String dimensionScopeStr = entity.getString(dimensionScopeProperty);
                Object newPk = entity.get((IDataEntityProperty)pkProperty);
                if (StringUtils.isNotEmpty((CharSequence)accountScopeStr)) {
                    originPk = this.pkExchanger.getOldPK(Optional.of(this.entityName), newPk.toString(), true);
                    recordLocator = new RecordLocator(this.entityName, "accountscope", originPk);
                    List list = (List)SerializationUtils.fromJsonString((String)accountScopeStr, List.class);
                    for (Map map : list) {
                        String oldMemberId = (String)map.get("id");
                        Object newMemberId = this.pkExchanger.getNewPK(recordLocator, Optional.empty(), oldMemberId, true);
                        if (newMemberId == null) continue;
                        accountScopeStr = accountScopeStr.replace(oldMemberId, newMemberId.toString());
                    }
                    entity.set(accountScopeProperty, (Object)accountScopeStr);
                }
                if (StringUtils.isNotEmpty((CharSequence)dimensionScopeStr)) {
                    originPk = this.pkExchanger.getOldPK(Optional.of(this.entityName), newPk.toString(), true);
                    recordLocator = new RecordLocator(this.entityName, "dimensionscope", originPk);
                    Map map = (Map)SerializationUtils.fromJsonString((String)dimensionScopeStr, Map.class);
                    for (Map.Entry entry : map.entrySet()) {
                        for (Map inMap : (List)entry.getValue()) {
                            String oldMemberId = (String)inMap.get("id");
                            Object newMemberId = this.pkExchanger.getNewPK(recordLocator, Optional.empty(), oldMemberId, true);
                            if (newMemberId == null) continue;
                            dimensionScopeStr = dimensionScopeStr.replace(oldMemberId, newMemberId.toString());
                        }
                    }
                    entity.set(dimensionScopeProperty, (Object)dimensionScopeStr);
                }
            }));
        }
    }
}

