/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.model.transfer.core.components.input;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.Consumer;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.CreateDateProp;
import kd.bos.entity.property.CreaterProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.ModifierProp;
import kd.bos.entity.property.ModifyDateProp;
import kd.bos.entity.property.UserProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.enums.dimension.SystemVarsEnum;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.computing.util.BatchProcessHelper;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.model.transfer.core.DynamicObjWrap;
import kd.fi.bcm.formplugin.model.transfer.core.EntityName;
import kd.fi.bcm.formplugin.model.transfer.core.EntityPropertyParseHelper;
import kd.fi.bcm.formplugin.model.transfer.core.ModelTransferType;
import kd.fi.bcm.formplugin.model.transfer.core.PKExchanger;
import kd.fi.bcm.formplugin.model.transfer.core.RecordLocator;
import kd.fi.bcm.formplugin.model.transfer.core.TransferContext;

public class CommonBillInputComponent {
    private static final Log LOG = LogFactory.getLog(CommonBillInputComponent.class);
    protected final TransferContext transferContext;
    protected final EntityName entityName;
    protected final PKExchanger pkExchanger;
    protected final List<DynamicObjWrap> billOrEntries;
    protected DynamicObjectType entityType;
    protected Function<Object, Object> defaultIdConverter = x -> Objects.isNull(x) || StringUtils.isEmpty((CharSequence)x.toString()) ? Integer.valueOf(0) : x;

    public CommonBillInputComponent(TransferContext transferContext, EntityName entityName, PKExchanger pkExchanger, List<DynamicObjWrap> billOrEntries) {
        this.transferContext = transferContext;
        this.entityName = entityName;
        this.pkExchanger = pkExchanger;
        this.billOrEntries = billOrEntries;
        this.entityType = EntityMetadataCache.getDataEntityType((String)entityName.getMainEntityName());
        if (entityName.isBillEntry()) {
            this.entityType = (DynamicObjectType)((MainEntityType)this.entityType).getAllEntities().get(entityName.getEntryName());
        }
    }

    public int getSaveOrder() {
        return 0;
    }

    public Map<String, String> exchangePk(Set<String> oldPks) {
        if (CollectionUtils.isEmpty(oldPks)) {
            return Collections.emptyMap();
        }
        ISimpleProperty pkProperty = this.entityType.getPrimaryKey();
        Class pkPropType = pkProperty.getPropertyType();
        List<String> newPks = pkPropType.isPrimitive() || pkPropType == Long.class ? Arrays.stream(GlobalIdUtil.genGlobalLongIds((int)oldPks.size())).boxed().collect(Collectors.toList()) : Arrays.asList(GlobalIdUtil.genStringIds((int)oldPks.size()));
        HashMap<String, String> oldNewPkMap = new HashMap<String, String>(oldPks.size());
        Object[] oldPkData = new ArrayList<String>(oldPks).toArray(new Object[oldPks.size()]);
        for (int i = 0; i < oldPkData.length; ++i) {
            Object oldPk = oldPkData[i];
            String newPk = newPks.get(i);
            oldNewPkMap.put(oldPk.toString(), newPk.toString());
        }
        this.addDimVarPair(oldNewPkMap);
        return oldNewPkMap;
    }

    private void addDimVarPair(Map<String, String> oldNewPkMap) {
        Set dimSigns = Arrays.stream(SysDimensionEnum.values()).map(x -> x.getMemberTreemodel()).collect(Collectors.toSet());
        if (!this.entityName.isBillEntry() && dimSigns.contains(this.entityName.getMainEntityName())) {
            Map<String, String> dimVarId2Id = Arrays.stream(SystemVarsEnum.values()).map(x -> x.getId()).collect(Collectors.toMap(k -> k, v -> v, (k, v) -> k));
            oldNewPkMap.putAll(dimVarId2Id);
        }
    }

    public void updatePk() {
        ISimpleProperty pkProperty = this.entityType.getPrimaryKey();
        this.iteratorBatchProcess((Consumer<DynamicObject>)((Consumer)e -> {
            Object oldPk = e.get((IDataEntityProperty)pkProperty);
            Object newPk = this.pkExchanger.getNewPK(new RecordLocator(this.entityName, pkProperty.getName(), oldPk), Optional.of(this.entityName), oldPk.toString(), true);
            e.set((IDataEntityProperty)pkProperty, newPk);
        }));
    }

    public void updateEntityReferPK() {
        Map<String, IDataEntityProperty> referPropMap = EntityPropertyParseHelper.getReferComplexPropMap(this.entityType);
        DynamicObjectType currentEntityType = this.billOrEntries.get(0).getValue().getDynamicObjectType();
        ISimpleProperty pkProp = currentEntityType.getPrimaryKey();
        Set<String> exchangeSimpleProps = currentEntityType.getProperties().stream().map(x -> x.getName()).collect(Collectors.toSet());
        exchangeSimpleProps.retainAll(referPropMap.keySet());
        this.addExtraFields(exchangeSimpleProps);
        long curUserId = RequestContext.get().getCurrUserId();
        this.iteratorBatchProcess((Consumer<DynamicObject>)((Consumer)x -> {
            Object newPk = x.get((IDataEntityProperty)pkProp);
            String originPk = this.pkExchanger.getOldPK(Optional.of(this.entityName), newPk.toString(), true);
            for (String referIdProp : exchangeSimpleProps) {
                String propEntityName;
                IDataEntityProperty basedataProp;
                boolean isProcessed;
                Object oldPk = x.get(referIdProp);
                if (Objects.isNull(oldPk) || oldPk instanceof Long && (Long)oldPk == 0L || oldPk instanceof String && StringUtils.isEmpty((CharSequence)oldPk.toString()) || (isProcessed = this.updateEntityReferPK(this.entityName, (DynamicObject)x, originPk, referIdProp, basedataProp = this.getDataEntityProperty(referIdProp, referPropMap), propEntityName = this.getEntityName((DynamicObject)x, referIdProp, basedataProp)))) continue;
                if (!propEntityName.startsWith("bcm_") && !propEntityName.startsWith("epbs_")) {
                    if (basedataProp instanceof UserProp) {
                        if (basedataProp instanceof CreaterProp || basedataProp instanceof ModifierProp) {
                            x.set(referIdProp, (Object)curUserId);
                            continue;
                        }
                        if (this.transferContext.getTransferType() == ModelTransferType.LOCAL_COPY) continue;
                        x.set(referIdProp, (Object)curUserId);
                        continue;
                    }
                    if ("bos_org".equals(propEntityName) && (Long)oldPk == 100000L || !"bos_user".equals(propEntityName) || this.transferContext.getTransferType() == ModelTransferType.LOCAL_COPY) continue;
                    x.set(referIdProp, (Object)curUserId);
                    continue;
                }
                if ("bcm_guidemenu".equals(this.entityName.getMainEntityName()) && "menu_id".equals(referIdProp)) continue;
                if (propEntityName.startsWith("epbs_") && referIdProp.equals("model_id")) {
                    x.set(referIdProp, this.pkExchanger.getNewPK(new RecordLocator(this.entityName, referIdProp, x.get(referIdProp).toString()), Optional.of(new EntityName("bcm_model")), x.get(referIdProp).toString(), true));
                    continue;
                }
                Object newPK = this.pkExchanger.getNewPK(new RecordLocator(this.entityName, referIdProp, originPk), Optional.of(new EntityName(propEntityName)), x.get(referIdProp).toString(), true);
                if (propEntityName.equals("bcm_dimension") && (Objects.isNull(newPK) || StringUtils.isEmpty((CharSequence)newPK.toString()) || "0".equals(newPK.toString()))) {
                    x.set(referIdProp, this.pkExchanger.getNewPK(new RecordLocator(this.entityName, referIdProp, originPk), Optional.of(new EntityName("bcm_dimension_ext")), x.get(referIdProp).toString(), true));
                    continue;
                }
                x.set(referIdProp, this.pkExchanger.getNewPK(new RecordLocator(this.entityName, referIdProp, originPk), Optional.of(new EntityName(propEntityName)), x.get(referIdProp).toString(), true));
            }
        }));
    }

    protected boolean updateEntityReferPK(EntityName curEntityName, DynamicObject dynamicObject, String dyOriginPk, String referIdPropName, IDataEntityProperty basedataProp, String propEntityName) {
        return false;
    }

    public void updateEntityNonPKProps() {
        List simpleProps = this.entityType.getProperties().stream().filter(x -> x instanceof ISimpleProperty && !x.isDbIgnore()).map(x -> (ISimpleProperty)x).collect(Collectors.toList());
        List dateProps = simpleProps.stream().filter(x -> x instanceof CreateDateProp || x instanceof ModifyDateProp).collect(Collectors.toList());
        this.iteratorBatchProcess((Consumer<DynamicObject>)((Consumer)entity -> dateProps.forEach(dp -> entity.set((IDataEntityProperty)dp, (Object)new Date()))));
    }

    protected boolean isRequireSave() {
        return true;
    }

    public void saveData() {
        if (this.isRequireSave() && !this.billOrEntries.isEmpty()) {
            OperateOption op = OperateOption.create();
            op.setVariableValue("updateModifyDate", "false");
            DynamicObjectType objectType = this.billOrEntries.get(0).getValue().getDynamicObjectType();
            BatchProcessHelper.batchConsume(this.billOrEntries, (int)2000, list -> {
                Object[] savedDys = (DynamicObject[])list.stream().map(x -> x.getValue()).toArray(DynamicObject[]::new);
                try {
                    BusinessDataWriter.save((IDataEntityType)objectType, (Object[])savedDys, (OperateOption)op);
                }
                catch (Exception e) {
                    LOG.error("model_transfer_save_failed on " + objectType.getName() + " on " + e.getMessage(), (Throwable)e);
                    throw e;
                }
            });
        }
    }

    protected void iteratorBatchProcess(Consumer<DynamicObject> updateFieldFunc) {
        this.billOrEntries.stream().map(x -> x.getValue()).forEach(x -> updateFieldFunc.accept(x));
    }

    protected void replaceMemberIdProp(DynamicObject dynamicObject, String memberIdPropName) {
        ISimpleProperty pkProperty = this.entityType.getPrimaryKey();
        IDataEntityProperty memberIdProp = (IDataEntityProperty)this.entityType.getProperties().get((Object)memberIdPropName);
        Object newPk = dynamicObject.get((IDataEntityProperty)pkProperty);
        String originPk = this.pkExchanger.getOldPK(Optional.of(this.entityName), newPk.toString(), true);
        String memberIdValue = dynamicObject.getString(memberIdProp);
        if (StringUtils.isEmpty((CharSequence)memberIdValue) || memberIdValue.equals("0") || memberIdValue.equals("-1")) {
            return;
        }
        RecordLocator recordLocator = new RecordLocator(this.entityName, pkProperty.getName(), originPk);
        Object newMemberIdValue = this.pkExchanger.getNewPK(recordLocator, Optional.empty(), memberIdValue, true);
        dynamicObject.set(memberIdProp, this.defaultIdConverter.apply(newMemberIdValue));
    }

    protected void replaceMemberIdProp2(DynamicObject dynamicObject, String memberIdPropName, String dimField, String dpropertyFiled) {
        ISimpleProperty pkProperty = this.entityType.getPrimaryKey();
        IDataEntityProperty memberIdProp = (IDataEntityProperty)this.entityType.getProperties().get((Object)memberIdPropName);
        Object newPk = dynamicObject.get((IDataEntityProperty)pkProperty);
        String memberIdValue = dynamicObject.getString(memberIdProp);
        if (StringUtils.isEmpty((CharSequence)memberIdValue) || memberIdValue.equals("0") || memberIdValue.equals("-1")) {
            return;
        }
        long filterdimension = dynamicObject.getLong(dimField);
        QFilter qf = new QFilter("id", "=", (Object)filterdimension);
        Map dimMap = BusinessDataServiceHelper.loadFromCache((String)"bcm_dimension", (String)"id, membermodel", (QFilter[])qf.toArray());
        long filtermemproperty_id = 0L;
        if (kd.bos.util.StringUtils.isNotEmpty((String)dpropertyFiled)) {
            filtermemproperty_id = dynamicObject.getLong(dpropertyFiled);
        }
        Object newMemId = 0L;
        EntityName entityName = null;
        if (dimMap.size() != 0) {
            if (filtermemproperty_id != 0L) {
                entityName = new EntityName("bcm_definedpropertyvalue");
            } else {
                String membermodel = ((DynamicObject)dimMap.values().iterator().next()).getString("membermodel");
                entityName = new EntityName(membermodel);
            }
            RecordLocator recordLocator = new RecordLocator(entityName, pkProperty.getName(), newPk);
            newMemId = this.pkExchanger.getNewPK(recordLocator, Optional.of(entityName), memberIdValue, false);
        }
        dynamicObject.set(memberIdProp, this.defaultIdConverter.apply(newMemId));
    }

    public TransferContext getTransferContext() {
        return this.transferContext;
    }

    public EntityName getEntityName() {
        return this.entityName;
    }

    public PKExchanger getPkExchanger() {
        return this.pkExchanger;
    }

    public List<DynamicObjWrap> getBillOrEntries() {
        return this.billOrEntries;
    }

    public DynamicObjectType getEntityType() {
        return this.entityType;
    }

    protected IDataEntityProperty getDataEntityProperty(String referIdProp, Map<String, IDataEntityProperty> referPropMap) {
        return referPropMap.get(referIdProp);
    }

    protected String getEntityName(DynamicObject dynamicObject, String referIdProp, IDataEntityProperty basedataProp) {
        if (basedataProp instanceof ItemClassProp) {
            return dynamicObject.getString(((ItemClassProp)basedataProp).getTypePropName());
        }
        return ((BasedataProp)basedataProp).getBaseEntityId();
    }

    protected void addExtraFields(Set<String> exchangeSimpleProps) {
    }
}

