/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.model.transfer.core.components.input;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Consumer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.CreaterProp;
import kd.bos.entity.property.ModifierProp;
import kd.bos.entity.property.UserProp;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.model.transfer.core.DynamicObjWrap;
import kd.fi.bcm.formplugin.model.transfer.core.EntityName;
import kd.fi.bcm.formplugin.model.transfer.core.EntityPropertyParseHelper;
import kd.fi.bcm.formplugin.model.transfer.core.ModelTransferType;
import kd.fi.bcm.formplugin.model.transfer.core.PKExchanger;
import kd.fi.bcm.formplugin.model.transfer.core.RecordLocator;
import kd.fi.bcm.formplugin.model.transfer.core.TransferComponent;
import kd.fi.bcm.formplugin.model.transfer.core.TransferContext;
import kd.fi.bcm.formplugin.model.transfer.core.components.input.CommonBillInputComponent;

@TransferComponent(entityNumber="bcm_defaultvalue")
public class DefaultValueInputComponent
extends CommonBillInputComponent {
    private static final String DEFAULTVALUEID = "defaultvalueid";

    public DefaultValueInputComponent(TransferContext transferContext, EntityName entityName, PKExchanger pkExchanger, List<DynamicObjWrap> billOrEntries) {
        super(transferContext, entityName, pkExchanger, billOrEntries);
    }

    @Override
    public void updateEntityReferPK() {
        Map<String, IDataEntityProperty> referPropMap = EntityPropertyParseHelper.getReferComplexPropMap(this.entityType);
        DynamicObjectType currentEntityType = ((DynamicObjWrap)this.billOrEntries.get(0)).getValue().getDynamicObjectType();
        ISimpleProperty pkProp = currentEntityType.getPrimaryKey();
        Set exchangeSimpleProps = currentEntityType.getProperties().stream().map(x -> x.getName()).collect(Collectors.toSet());
        exchangeSimpleProps.retainAll(referPropMap.keySet());
        exchangeSimpleProps.add(DEFAULTVALUEID);
        long curUserId = Long.parseLong(RequestContext.get().getUserId());
        this.iteratorBatchProcess((Consumer<DynamicObject>)((Consumer)x -> {
            Object newPk = x.get((IDataEntityProperty)pkProp);
            String originPk = this.pkExchanger.getOldPK(Optional.of(this.entityName), newPk.toString(), true);
            for (String referIdProp : exchangeSimpleProps) {
                boolean isProccessed;
                Object oldPk = x.get(referIdProp);
                if (Objects.isNull(oldPk) || oldPk instanceof Long && (Long)oldPk == 0L || oldPk instanceof String && StringUtils.isEmpty((CharSequence)oldPk.toString())) continue;
                BasedataProp basedataProp = null;
                String propEntityName = null;
                if (DEFAULTVALUEID.equals(referIdProp)) {
                    basedataProp = new BasedataProp();
                    propEntityName = SysDimensionEnum.getMemberTreemodelByNumber((String)x.getString("dimension"));
                } else {
                    basedataProp = (IDataEntityProperty)referPropMap.get(referIdProp);
                    propEntityName = basedataProp.getBaseEntityId();
                }
                if (isProccessed = this.updateEntityReferPK(this.entityName, (DynamicObject)x, originPk, referIdProp, (IDataEntityProperty)basedataProp, propEntityName)) continue;
                if (!propEntityName.startsWith("bcm_")) {
                    if (basedataProp instanceof UserProp) {
                        if (basedataProp instanceof CreaterProp || basedataProp instanceof ModifierProp) {
                            x.set(referIdProp, (Object)curUserId);
                            continue;
                        }
                        if (this.transferContext.getTransferType() == ModelTransferType.LOCAL_COPY) continue;
                        x.set(referIdProp, (Object)curUserId);
                        continue;
                    }
                    if ("bos_org".equals(propEntityName) && (Long)oldPk == 100000L || !"bos_user".equals(propEntityName) || this.transferContext.getTransferType() == ModelTransferType.LOCAL_COPY) continue;
                    x.set(referIdProp, (Object)curUserId);
                    continue;
                }
                x.set(referIdProp, this.pkExchanger.getNewPK(new RecordLocator(this.entityName, referIdProp, originPk), Optional.of(new EntityName(propEntityName)), x.get(referIdProp).toString(), true));
            }
        }));
    }

    private String getDefaultValueId(String dimension) {
        String entityName = "";
        switch (dimension) {
            case "Entity": {
                entityName = "bcm_entitymembertree";
                break;
            }
            case "Account": {
                entityName = "bcm_accountmembertree";
                break;
            }
            case "Scenario": {
                entityName = "bcm_scenemembertree";
                break;
            }
            case "Year": {
                entityName = "bcm_fymembertree";
                break;
            }
            case "Period": {
                entityName = "bcm_periodmembertree";
                break;
            }
            case "Process": {
                entityName = "bcm_processmembertree";
                break;
            }
            case "Currency": {
                entityName = "bcm_currencymembertree";
                break;
            }
            case "AuditTrail": {
                entityName = "bcm_audittrialmembertree";
                break;
            }
            case "ChangeType": {
                entityName = "bcm_changetypemembertree";
                break;
            }
            case "InternalCompany": {
                entityName = "bcm_icmembertree";
                break;
            }
            case "MultiGAAP": {
                entityName = "bcm_rulemembertree";
                break;
            }
            case "DataSort": {
                entityName = "bcm_datasortmembertree";
                break;
            }
            default: {
                entityName = "bcm_userdefinedmembertree";
            }
        }
        return entityName;
    }
}

