/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.model.transfer.core.components.input;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Consumer;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.epbs.common.enums.CloudTypeEnum;
import kd.epm.epbs.common.util.GlobalIdUtil;
import kd.fi.bcm.formplugin.model.transfer.core.DynamicObjWrap;
import kd.fi.bcm.formplugin.model.transfer.core.EntityName;
import kd.fi.bcm.formplugin.model.transfer.core.PKExchanger;
import kd.fi.bcm.formplugin.model.transfer.core.RecordLocator;
import kd.fi.bcm.formplugin.model.transfer.core.TransferComponent;
import kd.fi.bcm.formplugin.model.transfer.core.TransferContext;
import kd.fi.bcm.formplugin.model.transfer.core.components.input.CommonBillInputComponent;
import org.apache.commons.lang3.StringUtils;

@TransferComponent(entityNumber="epbs_preset_param")
public class EpbsPreParamInputComponent
extends CommonBillInputComponent {
    private static final Log LOG = LogFactory.getLog(EpbsPreParamInputComponent.class);

    public EpbsPreParamInputComponent(TransferContext transferContext, EntityName entityName, PKExchanger pkExchanger, List<DynamicObjWrap> billOrEntries) {
        super(transferContext, entityName, pkExchanger, billOrEntries);
    }

    @Override
    public void updateEntityReferPK() {
        super.updateEntityReferPK();
        if ("entryentity".equals(this.entityName.getEntryName())) {
            this.iteratorBatchProcess((Consumer<DynamicObject>)((Consumer)x -> {
                String params = x.getString("params");
                if (StringUtils.isNotEmpty((CharSequence)params)) {
                    JSONObject jsonObject = null;
                    try {
                        jsonObject = JSON.parseObject((String)params);
                    }
                    catch (Exception e) {
                        return;
                    }
                    if (jsonObject != null) {
                        this.replaceOrgAndUserId(jsonObject);
                        this.replaceSceneIds(jsonObject);
                        x.set("params", (Object)jsonObject.toJSONString());
                    }
                }
            }));
        }
    }

    private void replaceSceneIds(JSONObject jsonObject) {
        JSONArray scenarios = jsonObject.getJSONArray("scenario");
        if (scenarios != null && scenarios.size() > 0) {
            for (int i = 0; i < scenarios.size(); ++i) {
                String sceneId = String.valueOf(scenarios.get(i));
                Object newId = this.pkExchanger.getNewPK(new RecordLocator(this.entityName, "params", sceneId), Optional.of(new EntityName("bcm_scenemembertree")), sceneId, Boolean.FALSE);
                if (newId == null) continue;
                scenarios.set(i, (Object)Long.parseLong(newId.toString()));
            }
        }
    }

    private void replaceOrgAndUserId(JSONObject jsonObject) {
        JSONArray entryentity = jsonObject.getJSONArray("entryentity");
        long curUserId = RequestContext.get().getCurrUserId();
        Date date = new Date();
        if (entryentity != null && entryentity.size() > 0) {
            entryentity.forEach(ele -> {
                Long userId;
                String idStr;
                Object newId;
                JSONObject entryJson = (JSONObject)ele;
                String basedatatype = entryJson.getString("basedatatype");
                Long id = entryJson.getLong("entity");
                if (StringUtils.isNotEmpty((CharSequence)basedatatype) && id != 0L && (newId = this.pkExchanger.getNewPK(new RecordLocator(this.entityName, "params", idStr = String.valueOf(id)), Optional.of(new EntityName(basedatatype)), idStr, Boolean.FALSE)) != null) {
                    entryJson.put("entity", newId);
                }
                if ((userId = entryJson.getLong("userId")) != null && userId != 0L) {
                    entryJson.put("userId", (Object)curUserId);
                }
                if (entryJson.get((Object)"modifyTime") != null) {
                    entryJson.put("modifyTime", (Object)date);
                }
            });
        }
    }

    @Override
    public void saveData() {
        if (this.isRequireSave() && !this.billOrEntries.isEmpty()) {
            OperateOption op = OperateOption.create();
            op.setVariableValue("updateModifyDate", Boolean.TRUE.toString());
            DynamicObjectType objectType = ((DynamicObjWrap)this.billOrEntries.get(0)).getValue().getDynamicObjectType();
            Set nums = this.billOrEntries.stream().map(x -> x.getValue().getString("number")).collect(Collectors.toSet());
            DynamicObjectCollection results = QueryServiceHelper.query((String)"epbs_preset_param", (String)"id, number", (QFilter[])new QFilter[]{new QFilter("number", "in", nums)});
            Set dataNums = results.stream().map(x -> x.getString("number")).collect(Collectors.toSet());
            List<DynamicObject> upDys = this.billOrEntries.stream().map(x -> x.getValue()).filter(x -> dataNums.contains(x.getString("number"))).collect(Collectors.toList());
            List<DynamicObject> inDys = this.billOrEntries.stream().map(x -> x.getValue()).filter(x -> !dataNums.contains(x.getString("number"))).collect(Collectors.toList());
            try {
                if (upDys.size() > 0) {
                    this.updateData(upDys);
                }
                if (inDys.size() > 0) {
                    SaveServiceHelper.save((DynamicObject[])inDys.toArray(new DynamicObject[0]));
                }
            }
            catch (Exception e) {
                LOG.error("model_transfer_save_failed on " + objectType.getName() + " on " + e.getMessage(), (Throwable)e);
                throw e;
            }
        }
    }

    private void updateData(List<DynamicObject> upDys) {
        upDys.forEach(ele -> {
            long id = ele.getLong("id");
            ele.set("id", (Object)this.pkExchanger.getOldPK(Optional.of(new EntityName("epbs_preset_param")), String.valueOf(id), true));
        });
        String sql = "INSERT INTO t_epbs_param_set(fid, fentryid, fseq, fmodelid, fparams,fmodifierid, fmodifytime) VALUES (?, ?, 0, ?, ?, ?, ?);";
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(upDys.size());
        long[] entryIds = GlobalIdUtil.genGlobalLongIds((int)upDys.size());
        for (int i = 0; i < upDys.size(); ++i) {
            DynamicObject dy = upDys.get(i);
            DynamicObject entryDy = (DynamicObject)dy.getDynamicObjectCollection("entryentity").get(0);
            Object[] param = new Object[]{dy.getLong("id"), entryIds[i], entryDy.getLong("model_id"), entryDy.getString("params"), entryDy.getLong("modifier_id"), entryDy.getDate("modifytime")};
            paramsList.add(param);
        }
        DB.executeBatch((DBRoute)new DBRoute(CloudTypeEnum.EPM.name()), (String)sql, paramsList);
    }
}

