/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.model.transfer.core.components.input;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.Consumer;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.model.transfer.core.DynamicObjWrap;
import kd.fi.bcm.formplugin.model.transfer.core.EntityName;
import kd.fi.bcm.formplugin.model.transfer.core.EntityPropertyParseHelper;
import kd.fi.bcm.formplugin.model.transfer.core.PKExchanger;
import kd.fi.bcm.formplugin.model.transfer.core.RecordLocator;
import kd.fi.bcm.formplugin.model.transfer.core.TransferComponent;
import kd.fi.bcm.formplugin.model.transfer.core.TransferContext;
import kd.fi.bcm.formplugin.model.transfer.core.components.input.CommonBillInputComponent;

@TransferComponent(entityNumber="bcm_guidemenu")
public class GuideMenuInputComponent
extends CommonBillInputComponent {
    private static final EntityName _guideMenuPermEntity = new EntityName("bcm_guidemenuperm");
    private static final EntityName _guideMenuEntity = new EntityName("bcm_guidemenu");

    public GuideMenuInputComponent(TransferContext transferContext, EntityName entityName, PKExchanger pkExchanger, List<DynamicObjWrap> billOrEntries) {
        super(transferContext, entityName, pkExchanger, billOrEntries);
    }

    @Override
    public int getSaveOrder() {
        return 1000;
    }

    @Override
    public void updateEntityReferPK() {
        super.updateEntityReferPK();
        this.iteratorBatchProcess((Consumer<DynamicObject>)((Consumer)x -> {
            String classification;
            if (!this.entityName.isBillEntry() && null != (classification = x.getString("classification")) && !"-1".equals(classification)) {
                x.set("classification", this.pkExchanger.getNewPK(new RecordLocator(this.entityName, "classification", ""), Optional.of(new EntityName("bcm_templatecatalog")), x.get("classification").toString(), true));
            }
        }));
    }

    @Override
    public void saveData() {
        if (this.billOrEntries.isEmpty()) {
            return;
        }
        if (!this.entityName.isBillEntry()) {
            ArrayList ids = new ArrayList(16);
            List<DynamicObject> refershDys = this.billOrEntries.stream().map(x -> {
                String originGuidMenuPk = this.pkExchanger.getOldPK(Optional.of(_guideMenuEntity), x.getValue().getPkValue().toString(), true);
                RecordLocator recordLocator = new RecordLocator(_guideMenuEntity, "id", originGuidMenuPk);
                Object guideMenuPermNewId = this.pkExchanger.getNewPK(recordLocator, Optional.of(_guideMenuPermEntity), originGuidMenuPk, false);
                if (Objects.isNull(guideMenuPermNewId) || StringUtils.isEmpty((CharSequence)guideMenuPermNewId.toString())) {
                    return x.getValue();
                }
                DynamicObjectType menuGuidType = x.getValue().getDynamicObjectType();
                DynamicObject cachedMenuDy = x.getValue();
                cachedMenuDy.set("id", guideMenuPermNewId);
                ids.add(guideMenuPermNewId);
                for (String prop : EntityPropertyParseHelper.listExportProps(menuGuidType)) {
                    Object propValue;
                    if (prop == menuGuidType.getPrimaryKey().getName() || !Objects.nonNull(propValue = x.getValue().get(prop)) || !"parent_id".equals(prop) || "0".equals(propValue.toString())) continue;
                    String _parentGuideMenuPk = propValue.toString();
                    String _originParentGuidMenuPk = this.pkExchanger.getOldPK(Optional.of(_guideMenuEntity), _parentGuideMenuPk, true);
                    RecordLocator curRecordLocator = new RecordLocator(_guideMenuEntity, "parent_id", originGuidMenuPk);
                    Object _parentGuideMenuNewId = this.pkExchanger.getNewPK(curRecordLocator, Optional.of(_guideMenuPermEntity), _originParentGuidMenuPk, false);
                    if (Objects.nonNull(_parentGuideMenuNewId) && StringUtils.isNotEmpty((CharSequence)_parentGuideMenuNewId.toString())) {
                        cachedMenuDy.set("parent_id", _parentGuideMenuNewId);
                        continue;
                    }
                    cachedMenuDy.set("parent_id", propValue);
                }
                return cachedMenuDy;
            }).collect(Collectors.toList());
            DeleteServiceHelper.delete((IDataEntityType)((DynamicObject)refershDys.get(0)).getDynamicObjectType(), (Object[])ids.toArray());
            OperateOption op = OperateOption.create();
            op.setVariableValue("updateModifyDate", "false");
            BusinessDataWriter.save((IDataEntityType)((DynamicObject)refershDys.get(0)).getDynamicObjectType(), (Object[])refershDys.toArray(new DynamicObject[0]), (OperateOption)op);
        }
    }
}

