/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.model.transfer.core.components.input;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Consumer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.CreaterProp;
import kd.bos.entity.property.ModifierProp;
import kd.bos.entity.property.UserProp;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.model.transfer.core.DynamicObjWrap;
import kd.fi.bcm.formplugin.model.transfer.core.EntityName;
import kd.fi.bcm.formplugin.model.transfer.core.EntityPropertyParseHelper;
import kd.fi.bcm.formplugin.model.transfer.core.ModelTransferType;
import kd.fi.bcm.formplugin.model.transfer.core.PKExchanger;
import kd.fi.bcm.formplugin.model.transfer.core.RecordLocator;
import kd.fi.bcm.formplugin.model.transfer.core.TransferComponent;
import kd.fi.bcm.formplugin.model.transfer.core.TransferContext;
import kd.fi.bcm.formplugin.model.transfer.core.components.input.CommonBillInputComponent;

@TransferComponent(entityNumber="bcm_invsheetttplentrys")
public class InvSheetTtplEntrysInputComponnent
extends CommonBillInputComponent {
    private static final String RULE_EXPR = "ruleexpr";
    private static final String RULE_EXPR_DEPT = "ruleexprdept";

    public InvSheetTtplEntrysInputComponnent(TransferContext transferContext, EntityName entityName, PKExchanger pkExchanger, List<DynamicObjWrap> billOrEntries) {
        super(transferContext, entityName, pkExchanger, billOrEntries);
    }

    @Override
    public void updateEntityReferPK() {
        Map<String, IDataEntityProperty> referPropMap = EntityPropertyParseHelper.getReferComplexPropMap(this.entityType);
        DynamicObjectType currentEntityType = ((DynamicObjWrap)this.billOrEntries.get(0)).getValue().getDynamicObjectType();
        ISimpleProperty pkProp = currentEntityType.getPrimaryKey();
        Set exchangeSimpleProps = currentEntityType.getProperties().stream().map(x -> x.getName()).collect(Collectors.toSet());
        exchangeSimpleProps.retainAll(referPropMap.keySet());
        if (this.entityName.getEntryName().equals("invelimtplentry")) {
            exchangeSimpleProps.add(RULE_EXPR);
            exchangeSimpleProps.add(RULE_EXPR_DEPT);
        }
        long curUserId = Long.parseLong(RequestContext.get().getUserId());
        this.iteratorBatchProcess((Consumer<DynamicObject>)((Consumer)x -> {
            Object newPk = x.get((IDataEntityProperty)pkProp);
            String originPk = this.pkExchanger.getOldPK(Optional.of(this.entityName), newPk.toString(), true);
            for (String referIdProp : exchangeSimpleProps) {
                Object oldPk = x.get(referIdProp);
                if (Objects.isNull(oldPk) || oldPk instanceof Long && (Long)oldPk == 0L || oldPk instanceof String && StringUtils.isEmpty((CharSequence)oldPk.toString())) continue;
                String propEntityName = null;
                if (!RULE_EXPR.equals(referIdProp) && !RULE_EXPR_DEPT.equals(referIdProp)) {
                    IDataEntityProperty basedataProp = (IDataEntityProperty)referPropMap.get(referIdProp);
                    propEntityName = ((BasedataProp)basedataProp).getBaseEntityId();
                    if (!propEntityName.startsWith("bcm_")) {
                        if (basedataProp instanceof UserProp) {
                            if (basedataProp instanceof CreaterProp || basedataProp instanceof ModifierProp) {
                                x.set(referIdProp, (Object)curUserId);
                                continue;
                            }
                            if (this.transferContext.getTransferType() == ModelTransferType.LOCAL_COPY) continue;
                            x.set(referIdProp, (Object)curUserId);
                            continue;
                        }
                        if ("bos_org".equals(propEntityName) && (Long)oldPk == 100000L || !"bos_user".equals(propEntityName) || this.transferContext.getTransferType() == ModelTransferType.LOCAL_COPY) continue;
                        x.set(referIdProp, (Object)curUserId);
                        continue;
                    }
                    if ("bcm_guidemenu".equals(this.entityName.getMainEntityName()) && "menu_id".equals(referIdProp)) continue;
                    x.set(referIdProp, this.pkExchanger.getNewPK(new RecordLocator(this.entityName, referIdProp, originPk), Optional.of(new EntityName(propEntityName)), x.get(referIdProp).toString(), true));
                    continue;
                }
                if ("bn".equals(x.getString(referIdProp))) continue;
                propEntityName = "bcm_structofextend";
                x.set(referIdProp, this.pkExchanger.getNewPK(new RecordLocator(this.entityName, referIdProp, originPk), Optional.of(new EntityName(propEntityName)), x.get(referIdProp).toString(), true));
            }
        }));
    }
}

