/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.model.transfer.core.components.input;

import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.Consumer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.model.transfer.core.DynamicObjWrap;
import kd.fi.bcm.formplugin.model.transfer.core.EntityName;
import kd.fi.bcm.formplugin.model.transfer.core.PKExchanger;
import kd.fi.bcm.formplugin.model.transfer.core.RecordLocator;
import kd.fi.bcm.formplugin.model.transfer.core.TransferComponent;
import kd.fi.bcm.formplugin.model.transfer.core.TransferContext;
import kd.fi.bcm.formplugin.model.transfer.core.components.input.CommonBillInputComponent;

@TransferComponent(entityNumber="bcm_invchangestatus")
public class InvchangeStatusInputComponent
extends CommonBillInputComponent {
    public InvchangeStatusInputComponent(TransferContext transferContext, EntityName entityName, PKExchanger pkExchanger, List<DynamicObjWrap> billOrEntries) {
        super(transferContext, entityName, pkExchanger, billOrEntries);
    }

    @Override
    public void updateEntityNonPKProps() {
        super.updateEntityNonPKProps();
        ISimpleProperty pkProperty = this.entityType.getPrimaryKey();
        if (!this.entityName.isBillEntry()) {
            this.iteratorBatchProcess((Consumer<DynamicObject>)((Consumer)x -> {
                Object newPk = x.get((IDataEntityProperty)pkProperty);
                String originPk = this.pkExchanger.getOldPK(Optional.of(this.entityName), newPk.toString(), true);
                RecordLocator recordLocator = new RecordLocator(this.entityName, "id", originPk);
                if (this.entityType.getProperties().containsKey((Object)"modelid")) {
                    this.replaceProp((DynamicObject)x, recordLocator, "modelid", "bcm_model");
                }
                if (this.entityType.getProperties().containsKey((Object)"scenarioid")) {
                    this.replaceProp((DynamicObject)x, recordLocator, "scenarioid", "bcm_scenemembertree");
                }
                if (this.entityType.getProperties().containsKey((Object)"fyid")) {
                    this.replaceProp((DynamicObject)x, recordLocator, "fyid", "bcm_fymembertree");
                }
                if (this.entityType.getProperties().containsKey((Object)"periodid")) {
                    this.replaceProp((DynamicObject)x, recordLocator, "periodid", "bcm_periodmembertree");
                }
            }));
        }
    }

    private void replaceProp(DynamicObject dy, RecordLocator recordLocator, String propName, String entityEntityNumber) {
        String originPropValue = dy.getString(propName);
        if (StringUtils.isEmpty((CharSequence)originPropValue) || "0".equals(originPropValue)) {
            return;
        }
        Object newPropValue = this.pkExchanger.getNewPK(recordLocator, Optional.of(new EntityName(entityEntityNumber)), originPropValue, true);
        dy.set(propName, newPropValue);
    }
}

