/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.model.transfer.core.components.input;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Consumer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.CreaterProp;
import kd.bos.entity.property.ModifierProp;
import kd.bos.entity.property.UserProp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.model.transfer.core.DynamicObjWrap;
import kd.fi.bcm.formplugin.model.transfer.core.EntityName;
import kd.fi.bcm.formplugin.model.transfer.core.EntityPropertyParseHelper;
import kd.fi.bcm.formplugin.model.transfer.core.ModelTransferType;
import kd.fi.bcm.formplugin.model.transfer.core.PKExchanger;
import kd.fi.bcm.formplugin.model.transfer.core.RecordLocator;
import kd.fi.bcm.formplugin.model.transfer.core.TransferComponent;
import kd.fi.bcm.formplugin.model.transfer.core.TransferContext;
import kd.fi.bcm.formplugin.model.transfer.core.components.input.CommonBillInputComponent;
import kd.fi.bcm.spread.domain.view.JsonSerializerUtil;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.model.UserObject;

@TransferComponent(entityNumber="bcm_papertemplate")
public class PapertemplateInputComponent
extends CommonBillInputComponent {
    private WatchLogger log = BcmLogFactory.getWatchLogInstance(PapertemplateInputComponent.class);
    private static final String COMMENBID = "commembid";
    private static final String MEMBER_ID = "memberid";
    private static final String PROPERTY_ID = "propertyid";
    private static final String FIXVALUE_ID = "fixvalueid";
    private static final String CVT_BEFORE_CURRENCY = "cvtbeforecurrency";

    public PapertemplateInputComponent(TransferContext transferContext, EntityName entityName, PKExchanger pkExchanger, List<DynamicObjWrap> billOrEntries) {
        super(transferContext, entityName, pkExchanger, billOrEntries);
    }

    @Override
    public void updateEntityReferPK() {
        String shownumber;
        QFilter qf;
        DynamicObjectCollection dims;
        Map<String, IDataEntityProperty> referPropMap = EntityPropertyParseHelper.getReferComplexPropMap(this.entityType);
        DynamicObjectType currentEntityType = ((DynamicObjWrap)this.billOrEntries.get(0)).getValue().getDynamicObjectType();
        ISimpleProperty pkProp = currentEntityType.getPrimaryKey();
        Set exchangeSimpleProps = currentEntityType.getProperties().stream().map(x -> x.getName()).collect(Collectors.toSet());
        exchangeSimpleProps.retainAll(referPropMap.keySet());
        if ("commembentry".equals(this.entityType.getName())) {
            exchangeSimpleProps.add(COMMENBID);
        }
        if ("dimscope".equals(this.entityType.getName())) {
            exchangeSimpleProps.add(MEMBER_ID);
            exchangeSimpleProps.add(PROPERTY_ID);
            exchangeSimpleProps.add(FIXVALUE_ID);
        }
        if ("bcm_papertemplate".equals(this.entityType.getName())) {
            exchangeSimpleProps.add(CVT_BEFORE_CURRENCY);
        }
        if (CollectionUtils.isEmpty((Collection)(dims = QueryServiceHelper.query((String)"bcm_dimension", (String)"id, membermodel", (QFilter[])(qf = new QFilter("model.shownumber", "=", (Object)(shownumber = this.transferContext.getTargetModelShowNumber()))).toArray())))) {
            return;
        }
        Map<Long, String> dimMap = dims.stream().collect(Collectors.toMap(x -> x.getLong("id"), y -> y.getString("membermodel"), (v1, v2) -> v1));
        long curUserId = Long.parseLong(RequestContext.get().getUserId());
        this.iteratorBatchProcess((Consumer<DynamicObject>)((Consumer)x -> {
            Object newPk = x.get((IDataEntityProperty)pkProp);
            String originPk = this.pkExchanger.getOldPK(Optional.of(this.entityName), newPk.toString(), true);
            for (String referIdProp : exchangeSimpleProps) {
                boolean isProccessed;
                Object oldPk = x.get(referIdProp);
                if (Objects.isNull(oldPk) || oldPk instanceof Long && (Long)oldPk == 0L || oldPk instanceof String && StringUtils.isEmpty((CharSequence)oldPk.toString())) continue;
                BasedataProp basedataProp = null;
                String propEntityName = null;
                if (COMMENBID.equals(referIdProp)) {
                    basedataProp = new BasedataProp();
                    propEntityName = x.getString("comentitysign");
                } else if (MEMBER_ID.equals(referIdProp) || FIXVALUE_ID.equals(referIdProp)) {
                    long dimension = x.getLong("dimension_id");
                    if (dimension != 0L) {
                        propEntityName = (String)dimMap.get(dimension);
                        if (StringUtils.isEmpty((CharSequence)propEntityName)) {
                            Object newPK = this.pkExchanger.getNewPK(new RecordLocator(this.entityName, referIdProp, originPk), Optional.of(new EntityName("bcm_dimension")), x.get(referIdProp).toString(), false);
                            propEntityName = (String)dimMap.get(newPK);
                        }
                    } else {
                        basedataProp = new BasedataProp();
                        propEntityName = "bcm_enumvalue";
                    }
                } else if (PROPERTY_ID.equals(referIdProp)) {
                    basedataProp = new BasedataProp();
                    propEntityName = "bcm_definedpropertyvalue";
                } else if (CVT_BEFORE_CURRENCY.equalsIgnoreCase(referIdProp)) {
                    basedataProp = new BasedataProp();
                    propEntityName = "bcm_currencymembertree";
                } else {
                    basedataProp = (IDataEntityProperty)referPropMap.get(referIdProp);
                    propEntityName = basedataProp.getBaseEntityId();
                }
                if (isProccessed = this.updateEntityReferPK(this.entityName, (DynamicObject)x, originPk, referIdProp, (IDataEntityProperty)basedataProp, propEntityName)) continue;
                if (!propEntityName.startsWith("bcm_")) {
                    if (basedataProp instanceof UserProp) {
                        if (basedataProp instanceof CreaterProp || basedataProp instanceof ModifierProp) {
                            x.set(referIdProp, (Object)curUserId);
                            continue;
                        }
                        if (this.transferContext.getTransferType() == ModelTransferType.LOCAL_COPY) continue;
                        x.set(referIdProp, (Object)curUserId);
                        continue;
                    }
                    if ("bos_org".equals(propEntityName) && (Long)oldPk == 100000L || !"bos_user".equals(propEntityName) || this.transferContext.getTransferType() == ModelTransferType.LOCAL_COPY) continue;
                    x.set(referIdProp, (Object)curUserId);
                    continue;
                }
                if ("bcm_guidemenu".equals(this.entityName.getMainEntityName()) && "menu_id".equals(referIdProp)) continue;
                Object newPK = this.pkExchanger.getNewPK(new RecordLocator(this.entityName, referIdProp, originPk), Optional.of(new EntityName(propEntityName)), x.get(referIdProp).toString(), true);
                if (propEntityName.equals("bcm_dimension") && (Objects.isNull(newPK) || StringUtils.isEmpty((CharSequence)newPK.toString()) || "0".equals(newPK.toString()))) {
                    x.set(referIdProp, this.pkExchanger.getNewPK(new RecordLocator(this.entityName, referIdProp, originPk), Optional.of(new EntityName("bcm_dimension_ext")), x.get(referIdProp).toString(), true));
                    continue;
                }
                x.set(referIdProp, this.pkExchanger.getNewPK(new RecordLocator(this.entityName, referIdProp, originPk), Optional.of(new EntityName(propEntityName)), x.get(referIdProp).toString(), true));
            }
        }));
    }

    @Override
    public void updateEntityNonPKProps() {
        super.updateEntityNonPKProps();
        if (!this.entityName.isBillEntry()) {
            ISimpleProperty pkProperty = this.entityType.getPrimaryKey();
            this.iteratorBatchProcess((Consumer<DynamicObject>)((Consumer)x -> {
                if (StringUtils.isNotEmpty((CharSequence)x.getString("data"))) {
                    SpreadManager spreadManager = JsonSerializerUtil.toSpreadManager((String)x.getString("data"));
                    this.transSpreadManagerId(pkProperty, (DynamicObject)x, spreadManager);
                    x.set("data", (Object)JsonSerializerUtil.toJson((SpreadManager)spreadManager));
                }
            }));
        }
    }

    private void transSpreadManagerId(ISimpleProperty pkProperty, DynamicObject x, SpreadManager spreadManager) {
        Object newPk = x.get((IDataEntityProperty)pkProperty);
        String originPk = this.pkExchanger.getOldPK(Optional.of(this.entityName), newPk.toString(), true);
        RecordLocator recordLocator = new RecordLocator(this.entityName, pkProperty.getName(), originPk);
        if (spreadManager.getBook() != null) {
            spreadManager.getBook().getSheet(0).getTable().forEach(table -> table.forEach(cell -> {
                EntityName entityName;
                Object scopeIdValue;
                UserObject userObject;
                Object membid;
                if (cell != null && (membid = (userObject = cell.getUserObject()).get((Object)"membid")) != null && (Long)membid != 0L && (scopeIdValue = this.pkExchanger.getNewPK(recordLocator, Optional.of(entityName = new EntityName((String)userObject.get((Object)"entitysign"))), String.valueOf(membid), true)) != null) {
                    userObject.put((Object)"membid", (Object)Long.parseLong(scopeIdValue.toString()));
                }
            }));
        }
    }
}

