/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.model.transfer.core.components.input;

import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.Consumer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.common.enums.RptAdjustStatusEnum;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.model.transfer.core.DynamicObjWrap;
import kd.fi.bcm.formplugin.model.transfer.core.EntityName;
import kd.fi.bcm.formplugin.model.transfer.core.PKExchanger;
import kd.fi.bcm.formplugin.model.transfer.core.RecordLocator;
import kd.fi.bcm.formplugin.model.transfer.core.TransferComponent;
import kd.fi.bcm.formplugin.model.transfer.core.TransferContext;
import kd.fi.bcm.formplugin.model.transfer.core.components.input.CommonBillInputComponent;

@TransferComponent(entityNumber="bcm_rptadjust")
public class RptAdjustInputComponent
extends CommonBillInputComponent {
    public RptAdjustInputComponent(TransferContext transferContext, EntityName entityName, PKExchanger pkExchanger, List<DynamicObjWrap> billOrEntries) {
        super(transferContext, entityName, pkExchanger, billOrEntries);
    }

    @Override
    protected boolean updateEntityReferPK(EntityName curEntityName, DynamicObject dynamicObject, String dyOriginPk, String referIdPropName, IDataEntityProperty basedataProp, String propEntityName) {
        if ("bcm_templatecatalog".contains(basedataProp.getName())) {
            String oldTempateCatalogId = dynamicObject.getString(referIdPropName);
            Object newTemplateCatId = this.pkExchanger.getNewPK(new RecordLocator(this.entityName, "id", dyOriginPk), Optional.of(new EntityName(propEntityName)), oldTempateCatalogId, false);
            if (Objects.nonNull(newTemplateCatId) && StringUtils.isNotEmpty((CharSequence)newTemplateCatId.toString())) {
                dynamicObject.set(referIdPropName, newTemplateCatId);
            }
            return true;
        }
        return false;
    }

    @Override
    public void updateEntityNonPKProps() {
        if (!this.entityName.isBillEntry()) {
            this.iteratorBatchProcess((Consumer<DynamicObject>)((Consumer)x -> {
                x.set("spreadjson", null);
                x.set("data", null);
                Object checkrecord = x.get("checkrecord");
                if (!Objects.isNull(checkrecord)) {
                    EntityName entityName = new EntityName("bcm_checkrecord");
                    Object newPk = this.pkExchanger.getNewPK(new RecordLocator(entityName, "id", checkrecord), Optional.of(entityName), checkrecord.toString(), true);
                    if (newPk == null) {
                        entityName = new EntityName("bcm_invelimtemplate");
                        newPk = this.pkExchanger.getNewPK(new RecordLocator(entityName, "id", checkrecord), Optional.of(entityName), checkrecord.toString(), true);
                    }
                    x.set("checkrecord", newPk);
                }
                if (!this.getTransferContext().isTransferOLAPData() && RptAdjustStatusEnum.AUDIT.status().equals(x.getString("status"))) {
                    x.set("status", (Object)RptAdjustStatusEnum.TEMPSAVE.status());
                }
            }));
        } else {
            super.updateEntityNonPKProps();
            if (this.entityName.getEntryName().equals("commembentry")) {
                Set collect = this.getBillOrEntries().stream().filter(x -> !Objects.isNull(x.getValue().get("comdimension_id")) && 0L != x.getValue().getLong("comdimension_id")).map(x -> x.getValue().getLong("comdimension_id")).collect(Collectors.toSet());
                QFilter qf = new QFilter("id", "in", collect);
                DynamicObjectCollection results = QueryServiceHelper.query((String)"bcm_dimension", (String)"id,membermodel", (QFilter[])qf.toArray());
                HashMap<Long, String> idToTab = new HashMap<Long, String>(16);
                for (DynamicObject dy : results) {
                    idToTab.put(dy.getLong("id"), dy.getString("membermodel"));
                }
                this.iteratorBatchProcess((Consumer<DynamicObject>)((Consumer)x -> {
                    ISimpleProperty pkProperty = this.entityType.getPrimaryKey();
                    IDataEntityProperty memberIdProp = (IDataEntityProperty)this.entityType.getProperties().get((Object)"commembid");
                    Object newPk = x.get((IDataEntityProperty)pkProperty);
                    String originPk = this.pkExchanger.getOldPK(Optional.of(this.entityName), newPk.toString(), true);
                    String memberIdValue = x.getString(memberIdProp);
                    if (StringUtils.isEmpty((CharSequence)memberIdValue) || memberIdValue.equals("0") || memberIdValue.equals("-1")) {
                        return;
                    }
                    String comentitysign = (String)idToTab.get(x.getLong("comdimension_id"));
                    if (StringUtils.isEmpty((CharSequence)comentitysign)) {
                        return;
                    }
                    RecordLocator recordLocator = new RecordLocator(this.entityName, pkProperty.getName(), originPk);
                    Object newMemberIdValue = this.pkExchanger.getNewPK(recordLocator, Optional.of(new EntityName(comentitysign)), memberIdValue, true);
                    x.set(memberIdProp, this.defaultIdConverter.apply(newMemberIdValue));
                }));
            } else if (this.entityName.getEntryName().equals("spreadmembentry")) {
                this.iteratorBatchProcess((Consumer<DynamicObject>)((Consumer)x -> this.replaceMemberIdProp((DynamicObject)x, "spreadmembid")));
            }
        }
    }
}

