/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.model.transfer.core.components.input;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.Consumer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.util.StringUtils;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.model.transfer.core.DynamicObjWrap;
import kd.fi.bcm.formplugin.model.transfer.core.EntityName;
import kd.fi.bcm.formplugin.model.transfer.core.PKExchanger;
import kd.fi.bcm.formplugin.model.transfer.core.RecordLocator;
import kd.fi.bcm.formplugin.model.transfer.core.TransferComponent;
import kd.fi.bcm.formplugin.model.transfer.core.TransferContext;
import kd.fi.bcm.formplugin.model.transfer.core.components.input.CommonBillInputComponent;
import kd.fi.bcm.spread.domain.view.JsonSerializerUtil;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInnerLineInfo;
import kd.fi.bcm.spread.domain.view.builder.extend.ExtendInfo;
import kd.fi.bcm.spread.domain.view.builder.extend.FloatDimInfo;
import kd.fi.bcm.spread.model.IDimMember;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

@TransferComponent(entityNumber="bcm_templateentity")
public class TemplateEntityInputComponent
extends CommonBillInputComponent {
    public TemplateEntityInputComponent(TransferContext transferContext, EntityName entityName, PKExchanger pkExchanger, List<DynamicObjWrap> billOrEntries) {
        super(transferContext, entityName, pkExchanger, billOrEntries);
    }

    @Override
    public void updateEntityNonPKProps() {
        if (!this.entityName.isBillEntry()) {
            Set allGroupIds = this.billOrEntries.stream().map(x -> x.getValue().getLong("group")).filter(x -> x > 0L).collect(Collectors.toSet());
            Map<Long, Long> oldNewGroupIdMap = allGroupIds.stream().collect(Collectors.toMap(x -> x, x -> GlobalIdUtil.genGlobalLongId()));
            this.iteratorBatchProcess((Consumer<DynamicObject>)((Consumer)x -> {
                long oldGroupId = x.getLong("group");
                if (oldGroupId > 0L) {
                    x.set("group", oldNewGroupIdMap.get(oldGroupId));
                }
            }));
            ISimpleProperty pkProperty = this.entityType.getPrimaryKey();
            this.iteratorBatchProcess((Consumer<DynamicObject>)((Consumer)x -> {
                SpreadManager spreadManager = JsonSerializerUtil.toSpreadManager((String)x.getString("data"));
                this.transSpreadManagerId(pkProperty, (DynamicObject)x, spreadManager);
                x.set("data", (Object)JsonSerializerUtil.toJson((SpreadManager)spreadManager));
                if (StringUtils.isNotEmpty((String)x.getString("rptdata"))) {
                    SpreadManager rptdata = JsonSerializerUtil.toSpreadManager((String)x.getString("rptdata"));
                    this.transSpreadManagerId(pkProperty, (DynamicObject)x, rptdata);
                    x.set("rptdata", (Object)JsonSerializerUtil.toJson((SpreadManager)rptdata));
                }
            }));
        } else if (this.entityName.getEntryName().equals("viewpointmembentry")) {
            this.iteratorBatchProcess((Consumer<DynamicObject>)((Consumer)x -> this.replaceMemberIdProp((DynamicObject)x, "viewmembid")));
        } else if (this.entityName.getEntryName().equals("pagemembentry")) {
            this.iteratorBatchProcess((Consumer<DynamicObject>)((Consumer)x -> this.replaceMemberIdProp((DynamicObject)x, "pagemembid")));
        } else if (this.entityName.getEntryName().equals("colmembdetail")) {
            this.iteratorBatchProcess((Consumer<DynamicObject>)((Consumer)x -> this.replaceMemberIdProp((DynamicObject)x, "colmembid")));
        } else if (this.entityName.getEntryName().equals("rowmembdetail")) {
            this.iteratorBatchProcess((Consumer<DynamicObject>)((Consumer)x -> this.replaceMemberIdProp((DynamicObject)x, "rowmembid")));
        } else if (this.entityName.getEntryName().equals("filtermembentry")) {
            this.iteratorBatchProcess((Consumer<DynamicObject>)((Consumer)x -> this.replaceMemberIdProp2((DynamicObject)x, "filtermembid", "filterdimension_id", "filtermemproperty_id")));
        }
    }

    private void transSpreadManagerId(ISimpleProperty pkProperty, DynamicObject x, SpreadManager spreadManager) {
        Object newPk = x.get((IDataEntityProperty)pkProperty);
        String originPk = this.pkExchanger.getOldPK(Optional.of(this.entityName), newPk.toString(), true);
        RecordLocator recordLocator = new RecordLocator(this.entityName, pkProperty.getName(), originPk);
        spreadManager.getAreaManager().getPostionInfoSet().forEach(positionInfo -> {
            ExtendInfo extendInfo = positionInfo.getExtendInfo();
            if (extendInfo != null && extendInfo.getFloatdims() != null) {
                extendInfo.getFloatdims().forEach(floatDimInfo -> this.replaceIdForMembSetting(floatDimInfo, recordLocator));
            }
            this.replaceIdForEnumMemRange(extendInfo, recordLocator);
            positionInfo.getBasePoints().forEach(basePointInfo -> basePointInfo.getBasePointInnerLineInfo().forEach(inner -> this.replaceIdForMembSetting(inner, recordLocator)));
        });
    }

    private void replaceIdForEnumMemRange(ExtendInfo extendInfo, RecordLocator recordLocator) {
        Map enumValueRangeMap;
        if (extendInfo != null && MapUtils.isNotEmpty((Map)(enumValueRangeMap = extendInfo.getEnumValueRangeMap()))) {
            Iterator iterator = enumValueRangeMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry next = iterator.next();
                String k = (String)next.getKey();
                List v = (List)enumValueRangeMap.get(k);
                ArrayList values = new ArrayList(16);
                if (CollectionUtils.isNotEmpty((Collection)v)) {
                    v.forEach(p -> {
                        Object newId = this.pkExchanger.getNewPK(recordLocator, Optional.of(new EntityName("bcm_enumvalue")), p.p1 + "", true);
                        if (newId != null) {
                            values.add(Pair.onePair((Object)LongUtil.toLong((Object)newId), (Object)p.p2));
                        }
                    });
                }
                if (CollectionUtils.isNotEmpty(values)) {
                    enumValueRangeMap.put(k, values);
                    continue;
                }
                iterator.remove();
            }
            extendInfo.setEnumValueRangeMap(enumValueRangeMap);
        }
    }

    private void replaceIdForMembSetting(Object obj, RecordLocator recordLocator) {
        EntityName inMemberEntityName;
        Object fixMemId;
        List dynaMembScopeInfos = new ArrayList(16);
        IDimMember member = null;
        if (obj instanceof FloatDimInfo) {
            if (((FloatDimInfo)obj).isFixMember()) {
                member = ((FloatDimInfo)obj).getMember();
            } else {
                dynaMembScopeInfos = ((FloatDimInfo)obj).getDynaMembScopes();
            }
        } else if (obj instanceof BasePointInnerLineInfo) {
            dynaMembScopeInfos = ((BasePointInnerLineInfo)obj).getDynaMembScopes();
            member = ((BasePointInnerLineInfo)obj).getMemberAddOf(false);
        }
        dynaMembScopeInfos.forEach(scope -> {
            EntityName inMemberEntityName = null;
            inMemberEntityName = scope.isCustom() ? new EntityName("bcm_definedpropertyvalue") : new EntityName(DimEntityNumEnum.getEntieyNumByNumber((String)scope.getMember().getDimension().getNumber()));
            Object scopeIdValue = this.pkExchanger.getNewPK(recordLocator, Optional.of(inMemberEntityName), String.valueOf(scope.getMember().getId()), true);
            if (scopeIdValue != null) {
                scope.getMember().setId(Long.parseLong(scopeIdValue.toString()));
            }
        });
        if (member != null && (fixMemId = this.pkExchanger.getNewPK(recordLocator, Optional.of(inMemberEntityName = new EntityName(DimEntityNumEnum.getEntieyNumByNumber((String)member.getDimension().getNumber()))), String.valueOf(member.getId()), true)) != null) {
            member.setId(Long.parseLong(fixMemId.toString()));
        }
    }
}

