/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.model.transfer.core.service;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.epbs.business.bd.model.ModelSyncHelper;
import kd.fi.bcm.business.dimension.helper.DynamicComputingServiceHelper;
import kd.fi.bcm.business.permission.BcmFunPermissionHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.util.QFBuilder;

public class ModelInitHelper {
    public static void initOLAPBase(long modelId) {
        QFilter qf = new QFilter("id", "=", (Object)modelId);
        DynamicObject modelDy = QueryServiceHelper.queryOne((String)"bcm_model", (String)"number, name, shownumber,issourcemeasure,islockmeasure,datasource.id", (QFilter[])qf.toArray());
        String cube = modelDy.getString("number");
        OlapServiceHelper.createCubeSchemes((DynamicObject)modelDy);
        DynamicObjectCollection dimensions = QueryServiceHelper.query((String)"bcm_dimension", (String)"id,number,shortnumber,membermodel", (QFilter[])new QFilter("model.id", "=", (Object)modelId).toArray());
        dimensions.stream().forEach(dim -> {
            QFBuilder qfBuilder = new QFBuilder();
            qfBuilder.add("model.id", "=", (Object)modelId);
            qfBuilder.add("dimension.id", "=", (Object)dim.getLong("id"));
            qfBuilder.add("storagetype", "!=", (Object)StorageTypeEnum.SHARE.index);
            String dimEntityName = dim.getString("membermodel");
            DynamicObjectCollection members = QueryServiceHelper.query((String)dimEntityName, (String)"number,aggoprt,parent,parent.number", (QFilter[])qfBuilder.toArray());
            if (members.size() > 0) {
                List tupleList = members.stream().map(x -> Tuple.create((Object)x.getString("number"), (Object)x.getInt("aggoprt"), (Object)(x.getLong("parent") == 0L ? "" : x.getString("parent.number")))).collect(Collectors.toList());
                if (ConfigServiceHelper.getGlobalBoolParam((String)"isFilterDimNumber")) {
                    tupleList = tupleList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<Tuple>(Comparator.comparing(p -> (String)p.p1))), ArrayList::new));
                }
                OlapServiceHelper.batchCreateDimensionSchemes((String)cube, (String)dim.getString("number"), (String)dim.getString("shortnumber"), (List)tupleList);
            }
        });
        OlapServiceHelper.syncDimensionShortNumber2Cube((String)cube);
        ModelInitHelper.sycnOrgs(cube, modelId);
        DynamicComputingServiceHelper.updateModel((long)modelId, (String)cube);
    }

    private static void sycnOrgs(String modelCube, long modelId) {
        QFilter modelFilter = new QFilter("model", "=", (Object)modelId);
        QFilter statusFilter = new QFilter("status", "!=", (Object)"A");
        QFilter parentFilter = QFilter.isNotNull((String)"parent").and(new QFilter("parent", "!=", (Object)0L));
        QFilter[] filters = new QFilter[]{modelFilter, statusFilter, parentFilter};
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"number,aggoprt,parent.number,storagetype", (QFilter[])filters);
        HashSet<String> parntChildNums = new HashSet<String>(10);
        for (DynamicObject dyn : query) {
            String number = dyn.getString("number");
            String pNumber = dyn.getString("parent.number");
            parntChildNums.add(pNumber + "_" + number);
        }
        OlapServiceHelper.batchCreateDimensionMembers((String)modelCube, (String)"Entity", (String[])parntChildNums.toArray(new String[0]));
    }

    public static void initModelFunctionPermission(DynamicObject model, boolean flag) {
        long modelId = model.getLong("id");
        DynamicObject perm = BusinessDataServiceHelper.newDynamicObject((String)"bcm_modelperm");
        perm.set("model", (Object)modelId);
        DynamicObject entry = perm.getDynamicObjectCollection("modelpermentry").addNew();
        if (!flag) {
            long currUserId = RequestContext.get().getCurrUserId();
            perm.set("creator", (Object)currUserId);
            perm.set("modifier", (Object)currUserId);
            QFilter qf = new QFilter("id", "=", (Object)currUserId);
            perm.set("username", BusinessDataServiceHelper.loadSingle((String)"bos_user", (String)"name", (QFilter[])qf.toArray()).get("name"));
            entry.set("eusers", (Object)currUserId);
        } else {
            QFilter qFilter = new QFilter("phone", "=", (Object)"17299999999");
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bos_user", (String)"id, name", (QFilter[])new QFilter[]{qFilter});
            perm.set("creator", (Object)dynamicObject.get("id").toString());
            perm.set("modifier", (Object)dynamicObject.get("id").toString());
            perm.set("username", (Object)dynamicObject.get("name").toString());
            entry.set("eusers", (Object)dynamicObject.get("id").toString());
        }
        perm.set("createtime", (Object)TimeServiceHelper.now());
        perm.set("modifytime", (Object)TimeServiceHelper.now());
        entry.set("etype", (Object)"bos_user");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{perm});
        BcmFunPermissionHelper.addRootPermByUser((String)String.valueOf(modelId), (String)RequestContext.get().getUserId());
        ModelSyncHelper.saveEpbsModel((Long)modelId, (String)model.getString("reporttype"));
    }
}

