/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.model.transfer.core.service;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.login.utils.ErrorCodeUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.computing.util.BatchProcessHelper;
import kd.fi.bcm.formplugin.model.transfer.ModelTransferProgress;
import kd.fi.bcm.formplugin.model.transfer.core.DynamicObjWrap;
import kd.fi.bcm.formplugin.model.transfer.core.EntityName;
import kd.fi.bcm.formplugin.model.transfer.core.EntityPropertyParseHelper;
import kd.fi.bcm.formplugin.model.transfer.core.IModelOutputComponent;
import kd.fi.bcm.formplugin.model.transfer.core.PKExchanger;
import kd.fi.bcm.formplugin.model.transfer.core.RecordLocator;
import kd.fi.bcm.formplugin.model.transfer.core.TransferComponent;
import kd.fi.bcm.formplugin.model.transfer.core.TransferContext;
import kd.fi.bcm.formplugin.model.transfer.core.TransferSerializeUtils;
import kd.fi.bcm.formplugin.model.transfer.core.TransferServiceVersionInfo;
import kd.fi.bcm.formplugin.model.transfer.core.components.input.AdjsettingInputComponent;
import kd.fi.bcm.formplugin.model.transfer.core.components.input.AnalysiShelperInputComponent;
import kd.fi.bcm.formplugin.model.transfer.core.components.input.AnalyticsSchemeInputComponent;
import kd.fi.bcm.formplugin.model.transfer.core.components.input.AnalyticsSolutionInputComponent;
import kd.fi.bcm.formplugin.model.transfer.core.components.input.AnnualAccountInputComponent;
import kd.fi.bcm.formplugin.model.transfer.core.components.input.AuthInfoInputComponent;
import kd.fi.bcm.formplugin.model.transfer.core.components.input.BizRuleAllProcessInputComponent;
import kd.fi.bcm.formplugin.model.transfer.core.components.input.BizRuleScopeInputComponent;
import kd.fi.bcm.formplugin.model.transfer.core.components.input.CHKFormulaInputComponent;
import kd.fi.bcm.formplugin.model.transfer.core.components.input.CarryMapInputComponent;
import kd.fi.bcm.formplugin.model.transfer.core.components.input.CheckRecordInputComponent;
import kd.fi.bcm.formplugin.model.transfer.core.components.input.CheckRecordLinkInputComponent;
import kd.fi.bcm.formplugin.model.transfer.core.components.input.CheckRecordSumInputComponent;
import kd.fi.bcm.formplugin.model.transfer.core.components.input.CheckTemplateInputComponent;
import kd.fi.bcm.formplugin.model.transfer.core.components.input.CommonBillInputComponent;
import kd.fi.bcm.formplugin.model.transfer.core.components.input.ConvertDiffentityInputComponent;
import kd.fi.bcm.formplugin.model.transfer.core.components.input.CurrencyInputComponent;
import kd.fi.bcm.formplugin.model.transfer.core.components.input.CustomProValueInputComponent;
import kd.fi.bcm.formplugin.model.transfer.core.components.input.DefaultValueInputComponent;
import kd.fi.bcm.formplugin.model.transfer.core.components.input.DimensionAccountInComponent;
import kd.fi.bcm.formplugin.model.transfer.core.components.input.DimensionMapInputComponent;
import kd.fi.bcm.formplugin.model.transfer.core.components.input.EntityMemTreeInputComponent;
import kd.fi.bcm.formplugin.model.transfer.core.components.input.EntryCvtCurrencyInputComponent;
import kd.fi.bcm.formplugin.model.transfer.core.components.input.EnumItemInputComponent;
import kd.fi.bcm.formplugin.model.transfer.core.components.input.EpbsPreParamInputComponent;
import kd.fi.bcm.formplugin.model.transfer.core.components.input.ExchangeRateInComponent;
import kd.fi.bcm.formplugin.model.transfer.core.components.input.ExtModelDimInputComponent;
import kd.fi.bcm.formplugin.model.transfer.core.components.input.ExtModelFieldInputComponent;
import kd.fi.bcm.formplugin.model.transfer.core.components.input.ExtendDataBusInputComponnet;
import kd.fi.bcm.formplugin.model.transfer.core.components.input.ExtendDataInputComponent;
import kd.fi.bcm.formplugin.model.transfer.core.components.input.ExtendDataInvInputComponent;
import kd.fi.bcm.formplugin.model.transfer.core.components.input.ExtendDimInputComponent;
import kd.fi.bcm.formplugin.model.transfer.core.components.input.FlowTaskInputComponent;
import kd.fi.bcm.formplugin.model.transfer.core.components.input.GuideMenuInputComponent;
import kd.fi.bcm.formplugin.model.transfer.core.components.input.InvSheetTtplEntrysInputComponnent;
import kd.fi.bcm.formplugin.model.transfer.core.components.input.InvchangeStatusInputComponent;
import kd.fi.bcm.formplugin.model.transfer.core.components.input.InvchangecaseInputComponent;
import kd.fi.bcm.formplugin.model.transfer.core.components.input.LinkAdjustMapInputComponent;
import kd.fi.bcm.formplugin.model.transfer.core.components.input.LinkageUserDefinedComponent;
import kd.fi.bcm.formplugin.model.transfer.core.components.input.MemberListInputComponent;
import kd.fi.bcm.formplugin.model.transfer.core.components.input.MemberPermInputComponent;
import kd.fi.bcm.formplugin.model.transfer.core.components.input.ModelInputComponent;
import kd.fi.bcm.formplugin.model.transfer.core.components.input.OlapDataSourceInputComponent;
import kd.fi.bcm.formplugin.model.transfer.core.components.input.PageSelectInputComponent;
import kd.fi.bcm.formplugin.model.transfer.core.components.input.PapertemplateInputComponent;
import kd.fi.bcm.formplugin.model.transfer.core.components.input.PermClassEntityInputComponent;
import kd.fi.bcm.formplugin.model.transfer.core.components.input.RateCvtDiffInputComponent;
import kd.fi.bcm.formplugin.model.transfer.core.components.input.RateCvtSetInputComponent;
import kd.fi.bcm.formplugin.model.transfer.core.components.input.ReportDataCustSetingInputComponent;
import kd.fi.bcm.formplugin.model.transfer.core.components.input.ReportEntityInputComponent;
import kd.fi.bcm.formplugin.model.transfer.core.components.input.RptAdjustDataInputComponent;
import kd.fi.bcm.formplugin.model.transfer.core.components.input.RptAdjustInputComponent;
import kd.fi.bcm.formplugin.model.transfer.core.components.input.RptAdjustQueryPlanInputComponent;
import kd.fi.bcm.formplugin.model.transfer.core.components.input.RptAdjustShareInputComponent;
import kd.fi.bcm.formplugin.model.transfer.core.components.input.ShieldRuleInputComponent;
import kd.fi.bcm.formplugin.model.transfer.core.components.input.SpecialRateInputComponent;
import kd.fi.bcm.formplugin.model.transfer.core.components.input.TemplateEntityInputComponent;
import kd.fi.bcm.formplugin.model.transfer.core.components.output.AnalysisHelperOutComponent;
import kd.fi.bcm.formplugin.model.transfer.core.components.output.BizruleOutComponent;
import kd.fi.bcm.formplugin.model.transfer.core.components.output.CHKFormulaOutComponent;
import kd.fi.bcm.formplugin.model.transfer.core.components.output.CheckrecordOutComponent;
import kd.fi.bcm.formplugin.model.transfer.core.components.output.ConvertDiffOutComponent;
import kd.fi.bcm.formplugin.model.transfer.core.components.output.ConvertSettingOutComponent;
import kd.fi.bcm.formplugin.model.transfer.core.components.output.DataPermOutComponent;
import kd.fi.bcm.formplugin.model.transfer.core.components.output.DimensionOutComponent;
import kd.fi.bcm.formplugin.model.transfer.core.components.output.ExchangeOutComponent;
import kd.fi.bcm.formplugin.model.transfer.core.components.output.ExtendsOutComponent;
import kd.fi.bcm.formplugin.model.transfer.core.components.output.FlowStepSettingOutComponent;
import kd.fi.bcm.formplugin.model.transfer.core.components.output.GuideMenuOutComponent;
import kd.fi.bcm.formplugin.model.transfer.core.components.output.InvelimtemplateOutComponent;
import kd.fi.bcm.formplugin.model.transfer.core.components.output.InvestigateOutComponent;
import kd.fi.bcm.formplugin.model.transfer.core.components.output.LinkageMappingOutComponent;
import kd.fi.bcm.formplugin.model.transfer.core.components.output.MemberPermOutComponent;
import kd.fi.bcm.formplugin.model.transfer.core.components.output.MergeControlOutComponent;
import kd.fi.bcm.formplugin.model.transfer.core.components.output.OtherSettingOutComponents;
import kd.fi.bcm.formplugin.model.transfer.core.components.output.PaperTemplateOutComponent;
import kd.fi.bcm.formplugin.model.transfer.core.components.output.RptadjustOutComponent;
import kd.fi.bcm.formplugin.model.transfer.core.components.output.SystemConfigsOutComponent;
import kd.fi.bcm.formplugin.model.transfer.core.components.output.TaskSettingOutComponent;
import kd.fi.bcm.formplugin.model.transfer.core.components.output.TemplateOutComponent;
import kd.fi.bcm.formplugin.model.transfer.core.service.IModelTransferService;
import kd.fi.bcm.formplugin.model.transfer.core.service.ModelInitHelper;
import org.apache.commons.io.FileUtils;

@TransferServiceVersionInfo(version=1.0)
public class ModelTransferServiceImpl
implements IModelTransferService {
    protected static final Set<Class<? extends IModelOutputComponent>> OUT_COMPONENTS = new HashSet<Class>(Arrays.asList(DimensionOutComponent.class, RptadjustOutComponent.class, CHKFormulaOutComponent.class, ConvertDiffOutComponent.class, FlowStepSettingOutComponent.class, SystemConfigsOutComponent.class, BizruleOutComponent.class, CheckrecordOutComponent.class, InvelimtemplateOutComponent.class, TemplateOutComponent.class, InvestigateOutComponent.class, ExchangeOutComponent.class, MemberPermOutComponent.class, DataPermOutComponent.class, OtherSettingOutComponents.class, LinkageMappingOutComponent.class, ConvertSettingOutComponent.class, GuideMenuOutComponent.class, TaskSettingOutComponent.class, ExtendsOutComponent.class, PaperTemplateOutComponent.class, MergeControlOutComponent.class, AnalysisHelperOutComponent.class));
    protected static final Set<Class<? extends CommonBillInputComponent>> IN_COMPONENTS = new HashSet<Class>(Arrays.asList(ModelInputComponent.class, DimensionAccountInComponent.class, OlapDataSourceInputComponent.class, AnalyticsSolutionInputComponent.class, MemberPermInputComponent.class, CurrencyInputComponent.class, EnumItemInputComponent.class, ShieldRuleInputComponent.class, PermClassEntityInputComponent.class, TemplateEntityInputComponent.class, LinkageUserDefinedComponent.class, ConvertDiffentityInputComponent.class, EntryCvtCurrencyInputComponent.class, RateCvtDiffInputComponent.class, RateCvtSetInputComponent.class, RptAdjustDataInputComponent.class, RptAdjustInputComponent.class, SpecialRateInputComponent.class, AnnualAccountInputComponent.class, PageSelectInputComponent.class, BizRuleAllProcessInputComponent.class, BizRuleScopeInputComponent.class, ReportDataCustSetingInputComponent.class, CheckTemplateInputComponent.class, InvchangeStatusInputComponent.class, GuideMenuInputComponent.class, ReportEntityInputComponent.class, MemberListInputComponent.class, RptAdjustQueryPlanInputComponent.class, AuthInfoInputComponent.class, RptAdjustShareInputComponent.class, CHKFormulaInputComponent.class, ExchangeRateInComponent.class, ExtModelFieldInputComponent.class, ExtModelDimInputComponent.class, ExtendDataInputComponent.class, ExtendDataBusInputComponnet.class, ExtendDataInvInputComponent.class, InvSheetTtplEntrysInputComponnent.class, DefaultValueInputComponent.class, PapertemplateInputComponent.class, EntityMemTreeInputComponent.class, AdjsettingInputComponent.class, InvchangecaseInputComponent.class, CarryMapInputComponent.class, FlowTaskInputComponent.class, LinkAdjustMapInputComponent.class, CheckRecordInputComponent.class, CheckRecordLinkInputComponent.class, CheckRecordSumInputComponent.class, DimensionMapInputComponent.class, AnalysiShelperInputComponent.class, CustomProValueInputComponent.class, ExtendDimInputComponent.class, EpbsPreParamInputComponent.class, AnalyticsSchemeInputComponent.class));
    protected static final Set<String> IN_ENTITIES_BD_LIST = new HashSet<String>(Collections.singletonList("bd_currency"));
    protected static final Set<String> IN_ENTITIES_IGNORE_LIST = new HashSet<String>(Arrays.asList(new String[0]));
    private static final WatchLogger LOG = BcmLogFactory.getWatchLogInstance(ModelTransferServiceImpl.class);
    protected TransferContext transferContext;

    public ModelTransferServiceImpl(TransferContext transferContext) {
        this.transferContext = transferContext;
    }

    private Map<EntityName, Set<Object>> parseModelData(long modelId) {
        if (modelId <= 0L) {
            throw new IllegalArgumentException();
        }
        Map<EntityName, Set<Object>> entityNameIdMap = Collections.synchronizedMap(new HashMap(10));
        Set effectiveOutComponents = OUT_COMPONENTS.stream().filter(c -> {
            TransferComponent componentInfo = c.getAnnotation(TransferComponent.class);
            if (Objects.isNull(componentInfo)) {
                throw new KDBizException(String.format("class: %s requires @TransferComponent annotation.", c.getName()));
            }
            if (!EntityPropertyParseHelper.isExist(componentInfo.entityNumber())) {
                return false;
            }
            boolean isEffective = CollectionUtils.isEmpty(this.transferContext.getTransferEntities()) || !componentInfo.isOptional() || this.transferContext.getTransferEntities().containsKey(componentInfo.entityNumber());
            return isEffective && (this.transferContext.isTransferOLAPData() || !componentInfo.isOnlyForData());
        }).collect(Collectors.toSet());
        LOG.info(String.format("model_transfer: %s effective output components: %s", this.transferContext.getTransferSerializeId(), effectiveOutComponents.stream().map(Class::getName).collect(Collectors.toList())));
        for (Class componentClazz : effectiveOutComponents) {
            IModelOutputComponent component = this.createOutComponentInstance(componentClazz, this.transferContext);
            TransferComponent componentInfo = componentClazz.getAnnotation(TransferComponent.class);
            Set<Long> filterIds = null;
            if (!CollectionUtils.isEmpty(this.transferContext.getTransferEntities()) && this.transferContext.getTransferEntities().containsKey(componentInfo.entityNumber())) {
                filterIds = this.transferContext.getTransferEntities().getOrDefault(componentInfo.entityNumber(), Collections.EMPTY_SET);
            }
            LOG.info(String.format("model_transfer: effectiveOutComponents: current component: %s", component));
            Map<EntityName, Set<Object>> subResult = component.parseExportEntityRecords(filterIds);
            for (Map.Entry<EntityName, Set<Object>> entry : subResult.entrySet()) {
                if (Objects.isNull(entityNameIdMap.get(entry.getKey()))) {
                    entityNameIdMap.put(entry.getKey(), new HashSet(10));
                }
                entityNameIdMap.get(entry.getKey()).addAll((Collection<Object>)entry.getValue());
            }
        }
        return entityNameIdMap;
    }

    @Override
    public File serializeAllModelData(String requestSerialId, IFormView view) {
        File tempDir = FileUtils.getTempDirectory();
        File genDataDir = new File(tempDir, String.format("model_transfer_gen_%s", requestSerialId));
        try {
            FileUtils.forceMkdir((File)genDataDir);
        }
        catch (IOException e) {
            throw new KDBizException((Throwable)e, ErrorCodeUtils.getSystemErrorCode((String)String.format(ResManager.loadKDString((String)"\u521b\u5efa\u89e3\u538b\u76ee\u5f55\u5931\u8d25:\u201c%s\u201d\u3002", (String)"ModelTransferServiceImpl_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), genDataDir.getAbsolutePath())), new Object[0]);
        }
        Map<EntityName, Set<Object>> modelDataIndex = this.parseModelData(this.transferContext.getModelId());
        this.checkEntityNum(modelDataIndex);
        new ModelTransferProgress(10, ResManager.loadKDString((String)"\u83b7\u53d6\u6240\u6709\u5b9e\u4f53\u4e3b\u952e\u5b8c\u6210\u3002", (String)"ModelTransferProcessService_15", (String)"fi-bcm-formplugin", (Object[])new Object[0])).cache(view);
        for (Map.Entry<EntityName, Set<Object>> entry : modelDataIndex.entrySet()) {
            LOG.info(String.format("model_transfer_serialize_file start: %s time %s", entry.getKey(), System.currentTimeMillis()));
            long sTick = System.currentTimeMillis();
            TransferSerializeUtils.singleSerializeToFile(genDataDir, entry.getKey(), entry.getValue().toArray(new Object[0]), true, this.transferContext.getModelId());
            LOG.info(String.format("model_transfer_serialize_file success: %s cost %s", entry.getKey(), System.currentTimeMillis() - sTick));
        }
        File metaFile = new File(genDataDir, "model.meta");
        TransferSerializeUtils.generateModelMetaFile(modelDataIndex.keySet(), metaFile);
        return genDataDir;
    }

    private IModelOutputComponent createOutComponentInstance(Class<? extends IModelOutputComponent> clazz, TransferContext context) {
        try {
            Constructor<? extends IModelOutputComponent> constructor = clazz.getConstructor(TransferContext.class);
            try {
                return constructor.newInstance(context);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new IllegalArgumentException(e);
            }
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
    }

    private CommonBillInputComponent createInComponentInstance(Class<? extends CommonBillInputComponent> clazz, TransferContext context, EntityName entityName, PKExchanger pkExchanger, List<DynamicObjWrap> billOrEntries) {
        try {
            Constructor<? extends CommonBillInputComponent> constructor = clazz.getConstructor(TransferContext.class, EntityName.class, PKExchanger.class, List.class);
            try {
                return constructor.newInstance(context, entityName, pkExchanger, billOrEntries);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new IllegalArgumentException(e);
            }
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public PKExchanger buildPkExchanger(Map<EntityName, Set<String>> entityPkMap) {
        PKExchanger pkExchanger = new PKExchanger();
        List<CommonBillInputComponent> inComInstances = this.getBindInputComponents(entityPkMap.keySet(), null, null);
        for (CommonBillInputComponent component : inComInstances) {
            EntityName entityName = component.getEntityName();
            pkExchanger.putAll(entityName, component.exchangePk(entityPkMap.get(entityName)));
        }
        return pkExchanger;
    }

    @Override
    public void importModel(Map<EntityName, List<DynamicObjWrap>> transferData, PKExchanger pkExchanger) {
        List<CommonBillInputComponent> inComInstances = this.getBindInputComponents(transferData.keySet(), pkExchanger, transferData).stream().filter(x -> !CollectionUtils.isEmpty(x.getBillOrEntries())).collect(Collectors.toList());
        BatchProcessHelper.handle(inComInstances, x -> {
            x.updatePk();
            return null;
        }, (Integer)600);
        BatchProcessHelper.handle(inComInstances, x -> {
            x.updateEntityReferPK();
            x.updateEntityNonPKProps();
            return null;
        }, (Integer)600);
        Map<String, DynamicObject> allObj = inComInstances.stream().flatMap(x -> x.getBillOrEntries().stream()).collect(Collectors.toMap(x -> x.getValue().getPkValue().toString(), DynamicObjWrap::getValue));
        inComInstances.stream().filter(x -> x.getEntityName().isBillEntry()).forEach(x -> {
            for (DynamicObjWrap billOrEntry : x.getBillOrEntries()) {
                String oldParentPk = billOrEntry.getParentPk();
                RecordLocator recordLocator = new RecordLocator(x.getEntityName(), "_entryparent", oldParentPk);
                Object newParentPk = pkExchanger.getNewPK(recordLocator, Optional.of(x.getEntityName().getParentEntityName()), oldParentPk, true);
                DynamicObject parentDy = (DynamicObject)allObj.get(newParentPk.toString());
                if (parentDy == null) {
                    LOG.error(String.format("the parent was not found : %s", oldParentPk));
                    continue;
                }
                parentDy.getDynamicObjectCollection(x.getEntityName().getEntryName()).add((Object)billOrEntry.getValue());
            }
        });
        inComInstances.forEach(x -> {
            if (!CollectionUtils.isEmpty(x.getBillOrEntries())) {
                for (DynamicObjWrap billOrEntry : x.getBillOrEntries()) {
                    for (Map.Entry<MulBasedataProp, List<String>> entry : billOrEntry.getMulBasedataIds().entrySet()) {
                        MulBasedataProp prop = entry.getKey();
                        List<String> oldPks = entry.getValue();
                        String referBasedataType = prop.getComplexType().getName();
                        RecordLocator recordLocator = new RecordLocator(x.getEntityName(), prop.getName(), billOrEntry.getValue().getPkValue());
                        List newPks = oldPks.stream().map(z -> pkExchanger.getNewPK(recordLocator, Optional.of(new EntityName(referBasedataType)), (String)z, true)).collect(Collectors.toList());
                        IDataEntityType itemType = prop.getItemType();
                        for (Object newPk : newPks) {
                            DynamicObject item = (DynamicObject)itemType.createInstance();
                            long pkId = GlobalIdUtil.genGlobalLongId();
                            item.set("pkid", (Object)pkId);
                            item.set("fbasedataid_id", newPk);
                            billOrEntry.getValue().getDynamicObjectCollection((IDataEntityProperty)prop).add((Object)item);
                        }
                    }
                }
            }
        });
        try {
            inComInstances.stream().filter(x -> !x.getEntityName().isBillEntry()).sorted(Comparator.comparingInt(CommonBillInputComponent::getSaveOrder)).forEach(CommonBillInputComponent::saveData);
        }
        catch (Throwable e) {
            LOG.error("model_transfer save data, error:" + e.getMessage(), e);
            throw new KDBizException(e, ErrorCodeUtils.getSystemErrorCode((String)("Failed to save data: " + e.getMessage())), new Object[0]);
        }
    }

    @Override
    public void importModelOLAPData(TransferContext context, Optional<File> olapDataFile) {
        DynamicObject targetModelDy = QueryServiceHelper.queryOne((String)"bcm_model", (String)"id,number,shownumber,name,datasource.id datasource_id,islockmeasure", (QFilter[])new QFilter("shownumber", "=", (Object)context.getTargetModelShowNumber()).toArray());
        String targetCubeName = targetModelDy.getString("number");
        if (targetModelDy.getBoolean("islockmeasure")) {
            ConfigServiceHelper.lockCM034((Long)targetModelDy.getLong("id"));
        }
        if (olapDataFile.isPresent()) {
            Preconditions.checkState((boolean)olapDataFile.get().exists());
            long datasourceId = targetModelDy.getLong("datasource_id");
            OlapServiceHelper.restoreCubeFromFile((String)targetCubeName, (long)datasourceId, (File)olapDataFile.get());
            String modelName = targetModelDy.getString("name");
            OlapServiceHelper.updateCubeCaption((String)targetCubeName, (String)modelName, (String)context.getTargetModelShowNumber());
            LOG.info(String.format("model_transfer restore cube %s on datasource %s success.", targetCubeName, datasourceId));
        } else {
            ModelInitHelper.initOLAPBase(targetModelDy.getLong("id"));
        }
    }

    @Override
    public TransferContext getContext() {
        return this.transferContext;
    }

    private List<CommonBillInputComponent> getBindInputComponents(Set<EntityName> entityNames, PKExchanger exchanger, Map<EntityName, List<DynamicObjWrap>> transferData) {
        HashMap mainEntityComMap = new HashMap(entityNames.size());
        IN_COMPONENTS.stream().forEach(c -> {
            TransferComponent componentInfo = c.getAnnotation(TransferComponent.class);
            if (Objects.isNull(componentInfo)) {
                throw new KDBizException(String.format("class: %s requires @TransferComponent annotation.", c.getName()));
            }
            String mainEntityNumber = componentInfo.entityNumber();
            Class comClass = (Class)mainEntityComMap.get(mainEntityNumber);
            if (comClass != null) {
                throw new KDBizException(String.format("Both classes %s and %s is driver by the same entity number.", c.getName(), comClass.getName()));
            }
            mainEntityComMap.put(mainEntityNumber, c);
        });
        return entityNames.stream().filter(entityName -> {
            String mainEntityName = entityName.getMainEntityName();
            if (!(mainEntityName.startsWith("bcm_") || mainEntityName.startsWith("epbs_") || IN_ENTITIES_BD_LIST.contains(mainEntityName))) {
                LOG.info(String.format("model_transfer - Ignore main entity data %s for not starting with 'bcm' prefix. ", mainEntityName));
                return false;
            }
            if (IN_ENTITIES_IGNORE_LIST.contains(mainEntityName)) {
                LOG.info(String.format("model_transfer - Ignore main entity data %s for hit ignore list. ", mainEntityName));
                return false;
            }
            if (!EntityPropertyParseHelper.isExist(entityName.getMainEntityName())) {
                LOG.info(String.format("model_transfer - Ignore main entity data %s for metadata is not exist. ", entityName.getMainEntityName()));
                return false;
            }
            return true;
        }).map(entityName -> {
            Class<CommonBillInputComponent> inComClazz = mainEntityComMap.getOrDefault(entityName.getMainEntityName(), CommonBillInputComponent.class);
            LOG.info(String.format("model_transfer - select input component type: %s on entity: %s", inComClazz, entityName));
            List billOrEntrys = Collections.EMPTY_LIST;
            if (Objects.nonNull(transferData)) {
                billOrEntrys = transferData.getOrDefault(entityName, Collections.EMPTY_LIST);
            }
            return this.createInComponentInstance((Class<? extends CommonBillInputComponent>)inComClazz, this.transferContext, (EntityName)entityName, exchanger, billOrEntrys);
        }).collect(Collectors.toList());
    }

    protected void checkEntityNum(Map<EntityName, Set<Object>> modelDataIndex) {
        String filterEntityNums = this.transferContext.getFilterEntityNums();
        if (StringUtils.isNotEmpty((String)filterEntityNums)) {
            List<String> entityNums = Arrays.asList(filterEntityNums.split(","));
            Iterator<EntityName> iterator = modelDataIndex.keySet().iterator();
            while (iterator.hasNext()) {
                EntityName entry = iterator.next();
                if (!entityNums.contains(entry.getMainEntityName())) continue;
                iterator.remove();
            }
            if (entityNums.contains("bcm_extenddata_bus")) {
                modelDataIndex.remove(new EntityName("bcm_intrreportentity"));
            }
        }
    }
}

