/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.model.transfer.core.service;

import java.math.BigDecimal;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.formplugin.model.transfer.core.ModelCheckInfo;
import kd.fi.bcm.formplugin.model.transfer.core.ModelTransferServiceHelper;
import kd.fi.bcm.formplugin.model.transfer.core.ModelTransferType;
import kd.fi.bcm.formplugin.model.transfer.core.TransferMsgUtils;
import org.apache.commons.lang3.StringUtils;

public class ModelTransferServiceValidator {
    private ModelTransferType transferType;
    private String modelShowNumber;
    private Double sourceServiceVersion;

    public ModelTransferServiceValidator(ModelTransferType transferType, String modelShowNumber, Double sourceServiceVersion) {
        if (Objects.isNull((Object)transferType)) {
            throw new IllegalArgumentException("param transferType is empty");
        }
        if (ModelTransferType.EXPORT != transferType && StringUtils.isEmpty((CharSequence)modelShowNumber)) {
            throw new IllegalArgumentException("param modelShowNumber is empty");
        }
        this.transferType = transferType;
        this.modelShowNumber = modelShowNumber;
        this.sourceServiceVersion = sourceServiceVersion;
    }

    public ModelCheckInfo validate() {
        DynamicObject modelDy;
        ModelCheckInfo checkInfo = new ModelCheckInfo();
        if ((ModelTransferType.LOCAL_COPY == this.transferType || ModelTransferType.IMPORT == this.transferType) && StringUtils.isNotEmpty((CharSequence)this.modelShowNumber) && Objects.nonNull(modelDy = QueryServiceHelper.queryOne((String)"bcm_model", (String)"id", (QFilter[])new QFilter("shownumber", "=", (Object)this.modelShowNumber).toArray()))) {
            checkInfo.getErrors().add(TransferMsgUtils.existModel(this.modelShowNumber));
        }
        if (Objects.nonNull(this.sourceServiceVersion)) {
            double targetServiceVersion = ModelTransferServiceHelper.getCurrentServiceVersion();
            if (BigDecimal.valueOf(this.sourceServiceVersion).intValue() != BigDecimal.valueOf(targetServiceVersion).intValue()) {
                checkInfo.getErrors().add(TransferMsgUtils.versionGap(this.sourceServiceVersion, targetServiceVersion));
            }
        }
        return checkInfo;
    }

    public ModelCheckInfo validateRepeatModel() {
        DynamicObject modelDy;
        ModelCheckInfo checkInfo = new ModelCheckInfo();
        if ((ModelTransferType.LOCAL_COPY == this.transferType || ModelTransferType.IMPORT == this.transferType) && StringUtils.isNotEmpty((CharSequence)this.modelShowNumber) && Objects.nonNull(modelDy = QueryServiceHelper.queryOne((String)"bcm_model", (String)"id", (QFilter[])new QFilter("shownumber", "=", (Object)this.modelShowNumber).toArray()))) {
            checkInfo.getErrors().add(TransferMsgUtils.existModel(this.modelShowNumber));
        }
        return checkInfo;
    }

    public ModelCheckInfo validateRepeatVersion() {
        ModelCheckInfo checkInfo = new ModelCheckInfo();
        if (Objects.nonNull(this.sourceServiceVersion)) {
            double targetServiceVersion = ModelTransferServiceHelper.getCurrentServiceVersion();
            if (BigDecimal.valueOf(this.sourceServiceVersion).intValue() != BigDecimal.valueOf(targetServiceVersion).intValue()) {
                checkInfo.getErrors().add(TransferMsgUtils.versionGap(this.sourceServiceVersion, targetServiceVersion));
            }
        }
        return checkInfo;
    }
}

