/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.module;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.serviceHelper.UserSelectServiceHelper;
import kd.fi.bcm.business.tree.AbstractTreeNode;
import kd.fi.bcm.business.tree.ITreeNode;
import kd.fi.bcm.business.tree.TreeBuilder;
import kd.fi.bcm.business.tree.TreeModel;
import kd.fi.bcm.business.tree.dimension.OrgTreeNode;
import kd.fi.bcm.common.MessageConstant;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.guidemenu.GuidePageUtils;
import kd.fi.bcm.formplugin.pageinteraction.CommandParam;
import kd.fi.bcm.formplugin.pageinteraction.InteractivePage;
import kd.fi.bcm.formplugin.pageinteraction.SubPage;
import kd.fi.bcm.formplugin.util.SearchUtil;
import kd.fi.bcm.spread.common.util.StringUtil;

public class OrgTreePlugin
extends AbstractBaseFormPlugin
implements SubPage,
TreeNodeClickListener {
    private static final String TREE_VIEW_ORG = "treeview_org";
    private static final String CACHE_TREE_MODEL = "cache_treemodel";
    private static final String CACHE_TREE_NODE = "cache_treenode";
    private static final String CACHE_SHOW_ORG_TYPE = "cache_showorgtype";
    private static final String SELECT_ORGS = "selectorgs";
    private static final String CTL_SHOW_ORG_TYPE = "showorgtype";
    private static final String ALL_SUBORDINATE = "allsubordinate";
    private static final String SEARCH_BOFORE = "searchbefore";
    private static final String SEARCH_NEXT = "searchnext";

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String showType = (String)this.getModel().getValue(CTL_SHOW_ORG_TYPE);
        this.getPageCache().put(CACHE_SHOW_ORG_TYPE, showType != null ? showType : "4");
        String allsubordinate = (String)this.getFormCustomParam(ALL_SUBORDINATE);
        if (StringUtils.isNotEmpty((String)allsubordinate) && "hide".equals(allsubordinate)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{ALL_SUBORDINATE});
        }
        this.refreshTree();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView orgTreeView = (TreeView)this.getControl(TREE_VIEW_ORG);
        orgTreeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        IFormView view = this.getView();
        IPageCache pageCache = this.getPageCache();
        Search sl = (Search)this.getControl("entitysearchap");
        sl.addEnterListener(p0 -> {
            if (p0.getText() != null && !"".equals(p0.getText())) {
                SearchUtil.searchMember(p0.getText().toLowerCase(Locale.ENGLISH).trim(), view, pageCache, orgTreeView, CACHE_TREE_NODE);
            } else {
                this.getPageCache().put("resultlist", null);
                this.getView().showTipNotification(MessageConstant.getMEMBER_NOINPUT());
            }
        });
        this.addClickListeners(SEARCH_BOFORE, SEARCH_NEXT);
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        if (evt.getSource() instanceof TreeView) {
            String selectId = (String)evt.getNodeId();
            UserSelectServiceHelper.setEntity((Long)this.getUserId(), (Long)this.getModelId(), (Object)selectId);
            this.getPageCache().put("focusnodeid", selectId);
            TreeView t = (TreeView)evt.getSource();
            CommandParam com = new CommandParam("bcm_orgtree", null, "treeNodeClick", this.getView().getPageId(), t.getKey(), evt);
            com.setModule(true);
            this.sendMsg(this.getView(), com);
        }
    }

    private void refreshTree() {
        AbstractTreeNode<Object> root = this.buildTreeCache();
        if (root != null) {
            this.initTree(root);
        }
    }

    private AbstractTreeNode<Object> buildTreeCache() {
        DynamicObjectCollection rootNodecollection = this.getTreeListORM();
        if (rootNodecollection != null && !rootNodecollection.isEmpty()) {
            String showType = this.getPageCache().get(CACHE_SHOW_ORG_TYPE);
            OrgTreeNode root = TreeBuilder.getOrgCslTree((DynamicObjectCollection)rootNodecollection, (String)showType, (boolean)false);
            if ((root = (OrgTreeNode)TreeBuilder.setOpen((ITreeNode)root)) != null) {
                root.SetIsOpened(true);
                TreeModel treemodel = new TreeModel((ITreeNode)root);
                treemodel.ache2page(this.getPageCache(), CACHE_TREE_MODEL);
            }
            return root;
        }
        TreeView tree = (TreeView)this.getControl(TREE_VIEW_ORG);
        tree.deleteAllNodes();
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u4efb\u4f55\u7ec4\u7ec7\u6210\u5458\u6743\u9650\u3002", (String)"OrgTreePlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        return null;
    }

    private DynamicObjectCollection getTreeListORM() {
        DynamicObjectCollection doc = this.getOrgDynamicObjectCollection(this.getModelId());
        this.delOrgMenberPerm(doc, this.getModelId());
        return doc;
    }

    public void refreshTree(Long modelId, Long cslid, Long fyid, Long peid) {
        this.getView().getFormShowParameter().setCustomParam("KEY_MODEL_ID", (Object)modelId);
        OrgTreePlugin.setOrgModuleFilterParam(this.getView().getFormShowParameter(), cslid, fyid, peid);
        this.getView().cacheFormShowParameter();
        this.refreshTree();
    }

    private void initTree(AbstractTreeNode<Object> root) {
        TreeView tree = (TreeView)this.getControl(TREE_VIEW_ORG);
        tree.setRootVisible(false);
        if (root != null) {
            TreeModel treemodel = new TreeModel(root);
            TreeNode treeNode = treemodel.buildEntryTree(tree);
            if (root.getChildren() == null) {
                return;
            }
            TreeNode selectnode = this.findCacheNode(root);
            tree.focusNode(selectnode);
            tree.addTreeNodeClickListener((TreeNodeClickListener)this);
            tree.treeNodeClick(selectnode.getParentid(), selectnode.getId());
            this.expandAllSelected((TreeModel<AbstractTreeNode<Object>>)treemodel, tree);
            treemodel.ache2page(this.getPageCache(), CACHE_TREE_MODEL);
            this.getPageCache().put(CACHE_TREE_NODE, SerializationUtils.toJsonString((Object)treeNode));
        }
    }

    private void expandAllSelected(TreeModel<AbstractTreeNode<Object>> treemodel, TreeView treeView) {
        List selects = (List)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(SELECT_ORGS));
        OrgTreeNode root = (OrgTreeNode)treemodel.getRoot();
        for (String nodeid : selects) {
            OrgTreeNode node = (OrgTreeNode)treemodel.searchByNodeId(nodeid);
            if (node == null || node.getId() == null || node.getId().equals(root.getId())) continue;
            String parentid = node.getParent().getId();
            while (!parentid.equals(root.getId())) {
                treeView.expand(parentid);
                node = (OrgTreeNode)node.getParent();
                parentid = node.getParent().getId();
            }
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (SEARCH_BOFORE.equals(key) || SEARCH_NEXT.equals(key)) {
            String[] btns = new String[]{SEARCH_BOFORE, SEARCH_NEXT};
            SearchUtil.getLeftOrRight(this.getPageCache(), this.getView(), key, (TreeView)this.getControl(TREE_VIEW_ORG), btns, CACHE_TREE_NODE);
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        super.propertyChanged(e);
        switch (e.getProperty().getName()) {
            case "allsubordinate": {
                CommandParam com = new CommandParam("bcm_orgtree", null, "propertyChanged", this.getView().getPageId(), ALL_SUBORDINATE, e);
                com.setModule(true);
                this.sendMsg(this.getView(), com);
                break;
            }
            case "showorgtype": {
                String showType = (String)this.getModel().getValue(CTL_SHOW_ORG_TYPE);
                this.getPageCache().put(CACHE_SHOW_ORG_TYPE, showType);
                this.refreshTree();
                break;
            }
        }
    }

    private TreeNode findCacheNode(AbstractTreeNode<Object> root) {
        String selectnode = this.getPageCache().get("focusnodeid");
        if (StringUtil.isEmptyString((String)selectnode)) {
            selectnode = GuidePageUtils.getUserSelectOrg(this.getView(), this.getUserId(), this.getModelId(), false, false);
        }
        if (this.getPageCache().get(SELECT_ORGS) != null) {
            List selects = (List)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(SELECT_ORGS));
            selectnode = (String)selects.get(selects.size() - 1);
        } else {
            ArrayList<String> selectnodes = new ArrayList<String>();
            selectnodes.add(selectnode);
            this.getPageCache().put(SELECT_ORGS, ObjectSerialUtil.toByteSerialized(selectnodes));
        }
        if (selectnode == null || selectnode.equals(root.getId())) {
            return new TreeNode("0", root.getId(), root.getName());
        }
        LinkedList<AbstractTreeNode<Object>> queue = new LinkedList<AbstractTreeNode<Object>>();
        queue.add(root);
        while (!queue.isEmpty()) {
            ITreeNode node = (ITreeNode)queue.poll();
            if (node.getId().equals(selectnode)) {
                return new TreeNode(node.getParent().getId(), node.getId(), "");
            }
            List children = node.getChildren();
            if (children.isEmpty()) continue;
            queue.addAll(children);
        }
        return new TreeNode("0", root.getId(), root.getName());
    }

    public static void setOrgModuleFilterParam(FormShowParameter formShowParameter, Long cslid, Long fyid, Long peid) {
        if (cslid != null) {
            formShowParameter.setCustomParam("cslscheme", (Object)("bcm_cslscheme&" + cslid));
        }
        if (fyid != null) {
            formShowParameter.setCustomParam("year", (Object)("bcm_fymembertree&" + fyid));
        }
        if (peid != null) {
            formShowParameter.setCustomParam("period", (Object)("bcm_periodmembertree&" + peid));
        }
    }

    public static void refreshTree(InteractivePage plugin, IFormView view, Long modelId, Long cslid, Long fyid, Long peid) {
        if (cslid == null) {
            cslid = 0L;
        }
        if (fyid == null) {
            fyid = 0L;
        }
        if (peid == null) {
            peid = 0L;
        }
        CommandParam com = new CommandParam(null, "bcm_orgtree", "refreshTree", modelId, cslid, fyid, peid);
        com.setReFlect(true);
        plugin.sendMsg(view, com);
    }
}

