/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.module;

import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.orm.query.QFilter;
import kd.fi.bcm.business.tree.AbstractTreeNode;
import kd.fi.bcm.business.tree.ITreeNode;
import kd.fi.bcm.business.tree.TreeModel;
import kd.fi.bcm.business.tree.report.TemplateTreeNode;
import kd.fi.bcm.common.MessageConstant;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.pageinteraction.CommandParam;
import kd.fi.bcm.formplugin.pageinteraction.SubPage;
import kd.fi.bcm.formplugin.tree.chk.ChkTreeBuilder;
import kd.fi.bcm.formplugin.util.SearchUtil;

public class TemplateTreePlugin
extends AbstractBaseFormPlugin
implements SubPage,
TreeNodeClickListener {
    private static final String TREEVIEW_TEMPLATE = "treeview_template";
    private static final String SEARCH_BOFORE = "searchbefore";
    private static final String SEARCH_NEXT = "searchnext";

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initLeftTree();
    }

    private TreeModel<AbstractTreeNode<Object>> initLeftTree() {
        TemplateTreeNode root;
        if (this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID") == null) {
            return null;
        }
        String showType = (String)this.getModel().getValue("showtmptype");
        String temFilter = (String)this.getView().getFormShowParameter().getCustomParam("customTemFilter");
        if (temFilter != null) {
            QFilter qFilter = (QFilter)ObjectSerialUtil.deSerializedBytes((String)temFilter);
            root = ChkTreeBuilder.getTempTree(this.getModelId(), showType, qFilter, false);
        } else {
            root = ChkTreeBuilder.getTempTree(this.getModelId(), showType, false);
        }
        TreeView tree = (TreeView)this.getView().getControl(TREEVIEW_TEMPLATE);
        TreeModel treemodel = new TreeModel((ITreeNode)root);
        TreeNode realroot = treemodel.buildEntryTree(tree);
        this.getPageCache().put(TREEVIEW_TEMPLATE, SerializationUtils.toJsonString((Object)realroot));
        TreeNode focusNode = this.getFocusNode((ITreeNode<Object>)root);
        tree.focusNode(focusNode);
        tree.treeNodeClick(focusNode.getParentid(), focusNode.getId());
        TreeNodeEvent evt = new TreeNodeEvent((Object)tree, (Object)focusNode.getParentid(), (Object)focusNode.getId());
        this.treeNodeClick(evt);
        return treemodel;
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        final IFormView view = this.getView();
        final IPageCache pageCache = this.getPageCache();
        final TreeView modelTreeView = (TreeView)this.getControl(TREEVIEW_TEMPLATE);
        modelTreeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addClickListeners(SEARCH_BOFORE, SEARCH_NEXT);
        Search sl = (Search)this.getControl("entitysearchap");
        sl.addEnterListener(new SearchEnterListener(){

            public void search(SearchEnterEvent p0) {
                if (p0.getText() != null && !"".equals(p0.getText())) {
                    SearchUtil.searchMember(p0.getText().toLowerCase(Locale.ENGLISH).trim(), view, pageCache, modelTreeView, TemplateTreePlugin.TREEVIEW_TEMPLATE);
                } else {
                    TemplateTreePlugin.this.getPageCache().put("resultlist", null);
                    TemplateTreePlugin.this.getView().showTipNotification(MessageConstant.getMEMBER_NOINPUT());
                }
            }
        });
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (SEARCH_BOFORE.equals(key) || SEARCH_NEXT.equals(key)) {
            String[] btns = new String[]{SEARCH_BOFORE, SEARCH_NEXT};
            SearchUtil.getLeftOrRight(this.getPageCache(), this.getView(), key, (TreeView)this.getControl(TREEVIEW_TEMPLATE), btns, TREEVIEW_TEMPLATE);
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        if (evt.getSource() instanceof TreeView) {
            TreeView t = (TreeView)evt.getSource();
            CommandParam com = new CommandParam("bcm_templatetree", null, "treeNodeClick", this.getView().getPageId(), t.getKey(), evt);
            com.setModule(true);
            this.sendMsg(this.getView(), com);
        }
    }

    private TreeNode getFocusNode(ITreeNode<Object> root) {
        String templateId = (String)this.getFormCustomParam("templateId");
        ITreeNode<Object> focusNode = this.findNodeInTree(root, templateId);
        if (focusNode != null) {
            return new TreeNode(focusNode.getParent().getId(), focusNode.getId(), focusNode.getName());
        }
        return new TreeNode("0", root.getId(), root.getName());
    }

    private ITreeNode<Object> findNodeInTree(ITreeNode<Object> currentNode, String templateId) {
        if (StringUtils.isEmpty((CharSequence)templateId)) {
            return null;
        }
        if (templateId.equals(currentNode.getId())) {
            return currentNode;
        }
        List children = currentNode.getChildren();
        if (CollectionUtil.isEmpty((Collection)children)) {
            return null;
        }
        return children.stream().map(child -> this.findNodeInTree((ITreeNode<Object>)child, templateId)).filter(Objects::nonNull).findFirst().orElseGet(() -> null);
    }
}

