/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.olap;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.trace.util.TraceIdUtil;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.page.model.Area;
import kd.fi.bcm.business.page.model.BaseEditElement;
import kd.fi.bcm.business.page.model.Element;
import kd.fi.bcm.business.page.model.Page;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.util.TransMemberUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.olap.OlapOpTraceUtil;
import kd.fi.bcm.formplugin.olap.OlapTraceResult;
import kd.fi.bcm.formplugin.olap.TransactionTraceInfo;
import kd.fi.bcm.formplugin.pageinteraction.DynamicPage;
import kd.fi.bcm.spread.common.util.DateTimeUtils;

public class OlapOpTracePlugin
extends AbstractBaseFormPlugin
implements DynamicPage,
HyperLinkClickListener {
    private static final String CTL_ENTRYENTITY = "entryentity";
    private static final String NEXTTOKEN = "nextToken";
    private static final String DEADLINETIME = "deadlinetime";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("btn_more", "btn_query");
        EntryGrid grid = (EntryGrid)this.getControl(CTL_ENTRYENTITY);
        grid.addHyperClickListener((HyperLinkClickListener)this);
        Page page = this.getPage(this.getView());
        if (page != null) {
            this.iteratorEle(page, element -> {
                BasedataEdit bs = (BasedataEdit)this.getControl(element.getSign());
                bs.addBeforeF7SelectListener(b7 -> {
                    long dimid;
                    QFilter qf = new QFilter("model", "=", (Object)this.getModelId());
                    if ("bcm_userdefinedmembertree".equals(((BaseEditElement)element).getEntity())) {
                        dimid = MemberReader.getDimensionIdByNum((long)this.getModelId(), (String)((BaseEditElement)element).getNumber());
                        qf.and(new QFilter("dimension", "=", (Object)dimid));
                    }
                    if ("bcm_entitymembertree".equals(((BaseEditElement)element).getEntity())) {
                        dimid = MemberReader.getDimensionIdByNum((long)this.getModelId(), (String)((BaseEditElement)element).getNumber());
                        QFilter filter = PermissionServiceImpl.getInstance((Long)this.getModelId()).getReadOrWritePermFilter(Long.valueOf(dimid), "bcm_entitymembertree", "id");
                        qf.and(filter);
                    }
                    b7.getCustomQFilters().add(qf);
                });
            });
        }
    }

    private void iteratorEle(Page page, Consumer<Element> consumer) {
        page.getAreaList().forEach(area -> area.getElementListList().forEach(consumer));
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getPageCache().put("KEY_MODEL_ID", (String)this.getFormCustomParam("modelid"));
        this.getPageCache().put("KEY_MODEL_NUMBER", (String)this.getFormCustomParam("cube"));
        Map dimDyoMap = MemberReader.getDimDyoByModelId((long)this.getModelId());
        Page page = new Page();
        Area area = new Area("comb");
        dimDyoMap.forEach((num, dim) -> {
            BaseEditElement bs = new BaseEditElement(dim.getString("name"), num.toLowerCase(), DimEntityNumEnum.getEntieyNumByNumber((String)num));
            bs.setNumber(num);
            area.addElement((Element)bs);
        });
        page.addArea(area);
        this.setPage(this.getView(), page);
        page.updatePage(this.getView());
        Map<String, String> values = this.getCombFromView();
        this.iteratorEle(page, element -> {
            String number = ((BaseEditElement)element).getNumber();
            long id = MemberReader.findMemberByNumber((String)this.getModelNumber(), (String)number, (String)((String)values.get(number))).getId();
            this.getModel().setValue(element.getSign(), (Object)id);
        });
        this.getModel().setValue(DEADLINETIME, (Object)OlapOpTraceUtil.getDefaultTime());
        this.loadTraceMsg("");
    }

    private void loadTraceMsg(String nextToken) {
        OlapTraceResult res = OlapOpTraceUtil.queryTransactionTraceInfo(this.getModelNumber(), this.getComb(), this.getDateString(), nextToken);
        if (res.getError() != null) {
            if (res.getError().contains("FuntionManager_200")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5347\u7ea7\u591a\u7ef4\u5e93\u52308.8.4\u4ee5\u4e0a\uff0c\u624d\u652f\u6301\u8ffd\u6eaf\u529f\u80fd\u3002", (String)"OlapOpTracePlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showTipNotification(res.getError());
            }
        } else if (!res.getInfoList().isEmpty()) {
            int index = this.getModel().getEntryRowCount(CTL_ENTRYENTITY);
            this.getModel().batchCreateNewEntryRow(CTL_ENTRYENTITY, res.getInfoList().size());
            for (TransactionTraceInfo tti : res.getInfoList()) {
                this.getModel().setValue("username", (Object)tti.getUsername(), index);
                this.getModel().setValue("opdate", (Object)tti.getTime(), index);
                this.getModel().setValue("value", tti.getValue(), index);
                this.getModel().setValue("traceid", (Object)(tti.getTraceId() != null ? TraceIdUtil.idToHex((long)tti.getTraceId()) : ""), index);
                this.getModel().setValue("transactionid", (Object)tti.getTransactionId(), index);
                ++index;
            }
            this.getPageCache().put(NEXTTOKEN, res.getNextToken());
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String opkey = ((Control)evt.getSource()).getKey();
        if ("btn_more".equals(opkey)) {
            String nextToken = this.getPageCache().get(NEXTTOKEN);
            if (StringUtils.isNotEmpty((String)nextToken)) {
                this.loadTraceMsg(nextToken);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5168\u90e8\u52a0\u8f7d\u5b8c\u6210\u3002", (String)"OlapOpTracePlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        } else if ("btn_query".equals(opkey)) {
            this.getModel().deleteEntryData(CTL_ENTRYENTITY);
            this.loadTraceMsg("");
        }
    }

    private String getDateString() {
        Object time = this.getValue(DEADLINETIME);
        if (time != null) {
            return DateTimeUtils.format((Date)((Date)time));
        }
        return "";
    }

    private Map<String, String> getComb() {
        HashMap<String, String> membermap = new HashMap<String, String>();
        Page page = this.getPage(this.getView());
        AtomicLong org = new AtomicLong();
        if (page != null) {
            this.iteratorEle(page, element -> {
                Object obj = this.getModel().getValue(element.getSign());
                if (obj == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b8c\u6574\u7ef4\u5ea6\u3002", (String)"OlapOpTracePlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
                String value = ((DynamicObject)obj).getString("number");
                membermap.put(((BaseEditElement)element).getNumber(), value);
                if (DimTypesEnum.ENTITY.getNumber().equals(((BaseEditElement)element).getNumber())) {
                    org.set(((DynamicObject)this.getModel().getValue(element.getSign())).getLong("id"));
                }
            });
        }
        try {
            Pair p = TransMemberUtil.transOrgAndCurbyOrgId((long)this.getModelId(), (long)org.get(), (String)((String)membermap.get(DimTypesEnum.PROCESS.getNumber())), (String)((String)membermap.get(DimTypesEnum.CURRENCY.getNumber())), (long)0L, (long)0L);
            membermap.put(DimTypesEnum.CURRENCY.getNumber(), (String)p.p2);
            membermap.put(DimTypesEnum.ENTITY.getNumber(), (String)p.p1);
            for (Map.Entry m : membermap.entrySet()) {
                IDNumberTreeNode member = MemberReader.findMemberByNumber((String)this.getModelNumber(), (String)((String)m.getKey()), (String)((String)m.getValue()));
                if (StorageTypeEnum.DYNAMIC != member.getStorageType()) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u52a8\u6001\u8ba1\u7b97\u6210\u5458\u8bf7\u4f7f\u7528\u76f8\u5173\u56e0\u5b50\u67e5\u8be2\uff0c\u5426\u5219\u65e0\u6cd5\u7cbe\u51c6\u8ffd\u8e2a\u52a8\u6001\u8ba1\u7b97\u6570\u636e\u3002", (String)"OlapOpTracePlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                break;
            }
        }
        catch (Exception p) {
            // empty catch block
        }
        String bpnum = (String)membermap.get(DimTypesEnum.PROCESS.getNumber());
        membermap.put(DimTypesEnum.PROCESS.getNumber(), TransMemberUtil.toNEProcess((String)bpnum));
        return membermap;
    }

    private Map<String, String> getCombFromView() {
        Map map = (Map)this.getFormCustomParam("comb");
        return (Map)this.getFormCustomParam("comb");
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        super.hyperLinkClick(arg0);
        String col = arg0.getFieldName();
        String value = (String)this.getModel().getValue(col, arg0.getRowIndex());
        FormShowParameter formparam = new FormShowParameter();
        formparam.setFormId("bcm_traceolapmsg");
        formparam.setParentPageId(this.getView().getPageId());
        formparam.getOpenStyle().setShowType(ShowType.Modal);
        formparam.setCustomParam("cube", (Object)this.getModelNumber());
        formparam.setCustomParam(col, (Object)value);
        formparam.setCustomParam("modelid", (Object)String.valueOf(this.getModelId()));
        if ("traceid".equals(col)) {
            formparam.setCaption(ResManager.loadKDString((String)"\u64cd\u4f5c\u65e5\u5fd7", (String)"OlapOpTracePlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        } else if ("transactionid".equals(col)) {
            formparam.setCaption(ResManager.loadKDString((String)"\u591a\u7ef4\u6307\u4ee4", (String)"OlapOpTracePlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        this.getView().showForm(formparam);
    }
}

