/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.olap;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logorm.LogORM;
import kd.bos.olap.common.PropertyBag;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.olap.dataSources.FunctionCommandInfo;
import kd.bos.olap.dataSources.OlapCommand;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.trace.util.TraceIdUtil;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.common.trace.OlapComTraceUtil;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.formplugin.olap.OlapTraceResult;
import kd.fi.bcm.formplugin.olap.TransactionTraceInfo;

public class OlapOpTraceUtil {
    public static Date getDefaultTime() {
        Date nowDate = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(nowDate);
        calendar.set(6, calendar.get(6) - 10);
        nowDate = calendar.getTime();
        return nowDate;
    }

    public static String queryDetailByTraceid(long modelid, String traceid) {
        String rmsg;
        String olaptraceid = String.valueOf(TraceIdUtil.hexToId((String)traceid));
        long uniqueid = OlapComTraceUtil.subUniqueidFromOlap((String)olaptraceid);
        LogORM logORM = LogORM.create();
        QFilter qFilter = new QFilter("uniqueid", "=", (Object)uniqueid);
        DynamicObjectCollection doc = logORM.query("bcm_traceoplog", "opname,opdesc,detail,opdate,traceid", new QFilter[]{qFilter}, 100, 0);
        StringBuilder sb = new StringBuilder();
        if (doc != null && !doc.isEmpty()) {
            for (DynamicObject obj : doc) {
                sb.append(ResManager.loadKDString((String)"\u64cd\u4f5c\u540d\u79f0\uff1a", (String)"OlapOpTraceUtil_1", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append(obj.getString("opname")).append("\n");
                sb.append(ResManager.loadKDString((String)"\u4e0a\u673a\u64cd\u4f5c\u65f6\u95f4\uff1a", (String)"OlapOpTraceUtil_4", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append(obj.getString("opdate")).append("\n");
                sb.append("traceid:").append(obj.getString("traceid")).append("\n");
                sb.append(ResManager.loadKDString((String)"\u64cd\u4f5c\u63cf\u8ff0\uff1a", (String)"OlapOpTraceUtil_2", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append(obj.getString("opdesc")).append("\n");
                sb.append(ResManager.loadKDString((String)"\u64cd\u4f5c\u7ec6\u8282\uff1a", (String)"OlapOpTraceUtil_3", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append(obj.getString("detail")).append("\n");
            }
        }
        if ((rmsg = OlapOpTraceUtil.queryRule(modelid, OlapComTraceUtil.subRuleIdFromOlap((String)olaptraceid))) != null) {
            sb.append(ResManager.loadKDString((String)"\u6267\u884c\u7684\u89c4\u5219\u7f16\u7801\uff1a", (String)"OlapOpTraceUtil_5", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append(rmsg);
        }
        return sb.toString();
    }

    public static String queryRule(long modelid, String rid) {
        if ("00000000".equals(rid)) {
            return null;
        }
        QFilter qf = new QFilter("model", "=", (Object)modelid);
        DynamicObjectCollection bizs = QueryServiceHelper.query((String)"bcm_bizruleentity", (String)"id,number", (QFilter[])new QFilter[]{qf});
        ArrayList nums = new ArrayList();
        if (bizs != null) {
            bizs.forEach(biz -> {
                String id = biz.getString("id");
                if (rid.equals(OlapComTraceUtil.subRuleId((String)id))) {
                    nums.add(biz.getString("number"));
                }
            });
        }
        return Joiner.on((String)",").join(nums);
    }

    public static String queryRule(long modelid, Collection ids) {
        QFilter qf = new QFilter("model", "=", (Object)modelid);
        qf.and("id", "in", (Object)ids);
        DynamicObjectCollection bizs = QueryServiceHelper.query((String)"bcm_bizruleentity", (String)"id,number", (QFilter[])new QFilter[]{qf});
        List nums = bizs.stream().map(e -> e.getString("number")).collect(Collectors.toList());
        return Joiner.on((String)",").join(nums);
    }

    public static String queryTransactionCommandInfo(String cube, String transactionId) {
        OlapConnection olapConn = OlapServiceHelper.getOlapConnection((String)cube);
        PropertyBag bag = new PropertyBag();
        bag.set("transactionIds", "[" + transactionId + "]");
        OlapCommand olapCommand = new OlapCommand(olapConn, (CommandInfo)new FunctionCommandInfo("queryTransactionCommandInfo", bag));
        PropertyBag result = olapCommand.executeFunction();
        String commands = result.get("commands");
        System.out.println("\u8fd4\u56de\u7684\u7ed3\u679c\uff1a" + commands);
        ObjectMapper mapper = new ObjectMapper();
        JavaType javaType = mapper.getTypeFactory().constructParametricType(ArrayList.class, new Class[]{String.class});
        List commandList = new ArrayList();
        try {
            commandList = (List)mapper.readValue(commands, javaType);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return commandList.isEmpty() ? "" : (String)commandList.get(0);
    }

    public static OlapTraceResult queryTransactionTraceInfo(String cube, Map<String, String> comb, String deadlineTime, String nextToken, int top) {
        try {
            PropertyBag bag = new PropertyBag();
            bag.set("cellKey", JSONObject.toJSON(comb).toString());
            bag.set("deadlineTime", deadlineTime);
            bag.set("limit", String.valueOf(top));
            bag.set("nextToken", nextToken);
            bag.set("measureName", "FMONEY");
            OlapCommand olapCommand = new OlapCommand(OlapServiceHelper.getOlapConnection((String)cube), (CommandInfo)new FunctionCommandInfo("queryTransactionTraceInfo", bag));
            PropertyBag result = olapCommand.executeFunction();
            String rows = result.get("history");
            ObjectMapper mapper = new ObjectMapper();
            JavaType javaType = mapper.getTypeFactory().constructParametricType(ArrayList.class, new Class[]{TransactionTraceInfo.class});
            List<TransactionTraceInfo> infoList = new ArrayList<TransactionTraceInfo>();
            try {
                infoList = (List)mapper.readValue(rows, javaType);
            }
            catch (JsonProcessingException e) {
                e.printStackTrace();
            }
            OlapOpTraceUtil.fillTracemsg(infoList);
            nextToken = result.get("nextToken");
            OlapTraceResult otc = new OlapTraceResult();
            otc.setInfoList(infoList);
            otc.setNextToken(nextToken);
            return otc;
        }
        catch (Exception e) {
            OlapTraceResult otc = new OlapTraceResult();
            otc.setError(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)10));
            return otc;
        }
    }

    public static OlapTraceResult queryTransactionTraceInfo(String cube, Map<String, String> comb, String deadlineTime, String nextToken) {
        return OlapOpTraceUtil.queryTransactionTraceInfo(cube, comb, deadlineTime, nextToken, 10);
    }

    private static void fillTracemsg(List<TransactionTraceInfo> tis) {
        HashMap tidtounid = new HashMap();
        tis.forEach(t -> {
            if (t.getTraceId() != null) {
                long uid = OlapComTraceUtil.subUniqueidFromOlap((String)t.getTraceId().toString());
                tidtounid.put(t.getTraceId(), uid);
            }
        });
        LogORM logORM = LogORM.create();
        QFilter qFilter = new QFilter("uniqueid", "in", tidtounid.values());
        DynamicObjectCollection doc = logORM.query("bcm_traceoplog", "uniqueid,username", new QFilter[]{qFilter}, 100, 0);
        HashMap<Long, String> usermap = new HashMap<Long, String>();
        if (doc != null && !doc.isEmpty()) {
            for (DynamicObject obj : doc) {
                long uid = obj.getLong("uniqueid");
                String username = obj.getString("username");
                usermap.put(uid, username);
            }
            for (TransactionTraceInfo tti : tis) {
                tti.setUsername((String)usermap.get(tidtounid.get(tti.getTraceId())));
            }
        }
    }
}

