/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.pageinteraction;

import kd.bos.cache.ThreadCache;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.fi.bcm.business.page.model.Page;
import kd.fi.bcm.common.util.ObjectSerialUtil;

public interface DynamicPage {
    default public Page getPage(IFormView curview) {
        return (Page)ThreadCache.get((Object)(curview.getPageId() + "page"), () -> {
            if (this.getPageCache(curview) == null) {
                return null;
            }
            String cac = this.getPageCache(curview).get("page");
            if (cac != null) {
                return (Page)ObjectSerialUtil.deSerializedBytes((String)cac);
            }
            return null;
        });
    }

    default public void setPage(IFormView curview, Page page) {
        this.setPage(curview, page, false);
    }

    default public void setPage(IFormView curview, Page page, boolean isaddElement) {
        if (this.getPageCache(curview) == null) {
            return;
        }
        if (isaddElement) {
            curview.getModel().getDataEntity(true);
        }
        page.getAreaList().forEach(a -> a.getElementListList().forEach(e -> e.check(curview)));
        ThreadCache.put((Object)(curview.getPageId() + "page"), (Object)page);
        this.getPageCache(curview).put("page", ObjectSerialUtil.toByteSerialized((Object)page));
    }

    default public IPageCache getPageCache(IFormView curview) {
        FormViewPluginProxy curproxy = (FormViewPluginProxy)curview.getService(FormViewPluginProxy.class);
        IPageCache pageCache = null;
        for (IFormPlugin pl : curproxy.getPlugIns()) {
            if (!AbstractFormPlugin.class.isAssignableFrom(pl.getClass())) continue;
            pageCache = ((AbstractFormPlugin)AbstractFormPlugin.class.cast(pl)).getPageCache();
        }
        if (pageCache == null) {
            return null;
        }
        return pageCache;
    }

    default public boolean needCache() {
        return true;
    }
}

