/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.papertemplate;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.papertemplate.PaperTemplateService;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.TemplateCatalogEnum;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.spread.common.util.DateTimeUtils;

public class PaperTemplateEditVersionPlugin
extends AbstractFormPlugin {
    private static final String btn_ok = "btn_ok";
    private static final String btn_createandopen = "btn_createandopen";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IFormView view = this.getView();
        FormShowParameter formShowParameter = view.getFormShowParameter();
        String style = (String)formShowParameter.getCustomParam("style");
        Long group = (Long)formShowParameter.getCustomParam("group");
        Long model = (Long)formShowParameter.getCustomParam("model");
        if ("new".equals(style)) {
            DynamicObjectCollection query = QueryServiceHelper.query((String)this.getTemplateEntity(), (String)"id, versionnumber, group, effectivedate, expiringdate", (QFilter[])QFilter.of((String)"group = ? and model = ?", (Object[])new Object[]{group, model}).toArray(), (String)"versionnumber desc", (int)1);
            if (query.size() > 0) {
                DynamicObject template = (DynamicObject)query.get(0);
                IDataModel dataModel = this.getModel();
                dataModel.setValue("versionnum", (Object)String.format("V%.1f", Float.valueOf(template.getLong("versionnumber") + 1L)));
                Date effectiveDate = template.getDate("expiringdate");
                if (effectiveDate == null) {
                    effectiveDate = new Date();
                } else {
                    Calendar cal = Calendar.getInstance();
                    cal.setTimeInMillis(effectiveDate.getTime() + 86400000L);
                    effectiveDate = cal.getTime();
                }
                dataModel.setValue("effectivedate", (Object)effectiveDate);
                view.setVisible(Boolean.valueOf(false), new String[]{btn_ok});
            }
        } else {
            Long pkId = (Long)formShowParameter.getCustomParam("pkId");
            DynamicObject query = QueryServiceHelper.queryOne((String)this.getTemplateEntity(), (String)"id, versionnumber, group, effectivedate, expiringdate, versiondescription", (QFilter[])QFilter.of((String)"id = ? and model = ?", (Object[])new Object[]{pkId, model}).toArray());
            if (query != null) {
                IDataModel dataModel = this.getModel();
                dataModel.setValue("versionnum", (Object)String.format("V%.1f", Float.valueOf(query.getLong("versionnumber"))));
                Date effectiveDate = query.getDate("effectivedate");
                dataModel.setValue("effectivedate", (Object)effectiveDate);
                Date expiringdate = query.getDate("expiringdate");
                dataModel.setValue("expiringdate", (Object)expiringdate);
                String versiondescription = query.getString("versiondescription");
                dataModel.setValue("versiondescription", (Object)versiondescription);
                view.setVisible(Boolean.valueOf(false), new String[]{btn_createandopen});
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "btn_ok": {
                if (!this.validateRetionality()) break;
                this.saveTemplateInfo();
                break;
            }
            case "btn_createandopen": {
                if (!this.validateRetionality()) break;
                this.copyAndReturnData();
            }
        }
    }

    private void copyAndReturnData() {
        IFormView view = this.getView();
        FormShowParameter formShowParameter = view.getFormShowParameter();
        Long group = (Long)formShowParameter.getCustomParam("group");
        Long model = (Long)formShowParameter.getCustomParam("model");
        QFilter fgroup = new QFilter("group ", "=", (Object)group);
        QFilter fmodel = new QFilter("model ", "=", formShowParameter.getCustomParam("model"));
        DynamicObjectCollection query = QueryServiceHelper.query((String)this.getTemplateEntity(), (String)"id, versionnumber, group, model, effectivescope, templatetype", (QFilter[])new QFilter[]{fgroup, fmodel}, (String)"versionnumber desc", (int)1);
        if (query.size() > 0) {
            IDataModel dataModel = this.getModel();
            String versionNumber = (String)dataModel.getValue("versionnum");
            Double versionNum = Double.valueOf(versionNumber.substring(1));
            if (!QueryServiceHelper.exists((String)this.getTemplateEntity(), (QFilter[])QFilter.of((String)"group = ? and versionnumber = ? and model = ?", (Object[])new Object[]{group, versionNum, model}).toArray())) {
                DynamicObject template = (DynamicObject)query.get(0);
                template = BusinessDataServiceHelper.loadSingle((Object)template.getLong("id"), (String)this.getTemplateEntity());
                CloneUtils cloneUtil = new CloneUtils(true, true);
                ArrayListMultimap multiMap = ArrayListMultimap.create();
                DynamicObject genGlobalLongId = this.copyBaseInfo(dataModel, versionNum, template, cloneUtil, (Multimap<String, DynamicObject>)multiMap);
                QFilter filter1 = new QFilter("model", "=", (Object)template.getDynamicObject("model").getLong("id"));
                QFilter filter2 = new QFilter("template", "=", (Object)template.getLong("id"));
                QFilter[] filters = new QFilter[]{filter1, filter2};
                this.copyInvSheetTemplateEntry(cloneUtil, (Multimap<String, DynamicObject>)multiMap, genGlobalLongId, template);
                this.copyInvSheetAccLayout(cloneUtil, (Multimap<String, DynamicObject>)multiMap, genGlobalLongId, template);
                this.copyUserDefFormula(cloneUtil, (Multimap<String, DynamicObject>)multiMap, genGlobalLongId, filters);
                this.copyDistributeRecord(cloneUtil, (Multimap<String, DynamicObject>)multiMap, genGlobalLongId, filters);
                this.copyBeginPeriodDims(cloneUtil, (Multimap<String, DynamicObject>)multiMap, genGlobalLongId, filters);
                if (TemplateCatalogEnum.INNERTRADE.getTemplatetype().equals(PaperTemplateService.getTemplateTypeByLongnumber((String)template.getString("templatecatalog.longnumber")))) {
                    this.copyAdjsetting(cloneUtil, (Multimap<String, DynamicObject>)multiMap, genGlobalLongId, template.getDynamicObject("model").getLong("id"), template.getLong("id"));
                }
                this.saveData((Multimap<String, DynamicObject>)multiMap);
                view.returnDataToParent((Object)genGlobalLongId.getLong("id"));
                view.close();
            } else {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7248\u672c\u5df2\u88ab\u521b\u5efa\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"TplVersionEditPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void saveData(Multimap<String, DynamicObject> multiMap) {
        this.executeWithTX(handle -> multiMap.asMap().forEach((k, v) -> SaveServiceHelper.save((DynamicObject[])v.toArray(new DynamicObject[0]))));
    }

    private void copyAdjsetting(CloneUtils cloneUtil, Multimap<String, DynamicObject> multiMap, DynamicObject genGlobalLongId, long model, long template) {
        DynamicObject[] load;
        QFilter filter2;
        QFilter filter1 = new QFilter("model", "=", (Object)model);
        QFilter[] filters = new QFilter[]{filter1, filter2 = new QFilter("templateid", "=", (Object)template)};
        DynamicObjectCollection tempCollection = QueryServiceHelper.query((String)"bcm_adjsetting", (String)"id", (QFilter[])filters);
        if (tempCollection.size() > 0 && (load = BusinessDataServiceHelper.load((Object[])tempCollection.stream().map(v -> v.get("id")).toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bcm_adjsetting"))) != null && load.length > 0) {
            Stream.of(load).forEach(c -> {
                DynamicObject temp = (DynamicObject)cloneUtil.clone(c.getDataEntityType(), c);
                temp.set("templateid", (Object)genGlobalLongId.getLong("id"));
                multiMap.put((Object)"bcm_adjsetting", (Object)temp);
            });
        }
    }

    public void copyBeginPeriodDims(CloneUtils cloneUtil, Multimap<String, DynamicObject> multiMap, DynamicObject genGlobalLongId, QFilter[] filters) {
        DynamicObject[] load;
        DynamicObjectCollection tempCollection = QueryServiceHelper.query((String)"bcm_beginperioddims", (String)"id", (QFilter[])filters);
        if (tempCollection.size() > 0 && (load = BusinessDataServiceHelper.load((Object[])tempCollection.stream().map(v -> v.get("id")).toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bcm_beginperioddims"))) != null && load.length > 0) {
            Stream.of(load).forEach(c -> {
                DynamicObject temp = (DynamicObject)cloneUtil.clone(c.getDataEntityType(), c);
                temp.set("template", (Object)genGlobalLongId);
                multiMap.put((Object)"bcm_beginperioddims", (Object)temp);
            });
        }
    }

    public void copyDistributeRecord(CloneUtils cloneUtil, Multimap<String, DynamicObject> multiMap, DynamicObject genGlobalLongId, QFilter[] filters) {
        DynamicObject[] load;
        DynamicObjectCollection tempCollection = QueryServiceHelper.query((String)this.getTemplateAssignEntity(), (String)"id", (QFilter[])filters);
        if (tempCollection.size() > 0 && (load = BusinessDataServiceHelper.load((Object[])tempCollection.stream().map(v -> v.get("id")).toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bcm_templateassignrecord"))) != null && load.length > 0) {
            Stream.of(load).forEach(c -> {
                DynamicObject temp = (DynamicObject)cloneUtil.clone(c.getDataEntityType(), c);
                temp.set("template", (Object)genGlobalLongId);
                multiMap.put((Object)this.getTemplateAssignEntity(), (Object)temp);
            });
        }
    }

    private void copyInvSheetAccLayout(CloneUtils cloneUtil, Multimap<String, DynamicObject> multiMap, DynamicObject newTemplate, DynamicObject oldTemplate) {
        this.doCopy(cloneUtil, multiMap, newTemplate, oldTemplate.getLong("id"), new CopyEntity("bcm_invsheetacclayout", "id", "template"), qfBuilder -> qfBuilder);
    }

    private void copyInvSheetTemplateEntry(CloneUtils cloneUtil, Multimap<String, DynamicObject> multiMap, DynamicObject newTemplate, DynamicObject oldTemplate) {
        this.doCopy(cloneUtil, multiMap, newTemplate, oldTemplate.getLong("id"), new CopyEntity("bcm_invsheetttplentrys", "id", "sheettemplate"), qfBuilder -> qfBuilder.and("model", "=", (Object)oldTemplate.getDynamicObject("model").getLong("id")));
    }

    private void doCopy(CloneUtils cloneUtil, Multimap<String, DynamicObject> multiMap, DynamicObject newTemplate, long oldTemplateId, CopyEntity copyEntity, UnaryOperator<QFBuilder> function) {
        DynamicObject[] load;
        QFBuilder qfBuilder = (QFBuilder)function.apply(new QFBuilder(copyEntity.templateFieldName, "=", (Object)oldTemplateId));
        DynamicObjectCollection tempCollection = QueryServiceHelper.query((String)copyEntity.entityName, (String)copyEntity.id, (QFilter[])qfBuilder.toArray());
        if (!tempCollection.isEmpty() && (load = BusinessDataServiceHelper.load((Object[])tempCollection.stream().map(v -> v.get(copyEntity.id)).toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)copyEntity.entityName))) != null && load.length > 0) {
            Stream.of(load).forEach(c -> {
                DynamicObject temp = (DynamicObject)cloneUtil.clone(c.getDataEntityType(), c);
                temp.set(copyEntity.templateFieldName, (Object)newTemplate);
                multiMap.put((Object)copyEntity.entityName, (Object)temp);
            });
        }
    }

    public void copyUserDefFormula(CloneUtils cloneUtil, Multimap<String, DynamicObject> multiMap, DynamicObject genGlobalLongId, QFilter[] filters) {
        DynamicObject[] load;
        DynamicObjectCollection tempCollection = QueryServiceHelper.query((String)"bcm_userdefcvtformula", (String)"id", (QFilter[])filters);
        if (tempCollection.size() > 0 && (load = BusinessDataServiceHelper.load((Object[])tempCollection.stream().map(v -> v.get("id")).toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bcm_userdefcvtformula"))) != null && load.length > 0) {
            Stream.of(load).forEach(c -> {
                DynamicObject temp = (DynamicObject)cloneUtil.clone(c.getDataEntityType(), c);
                temp.set("template", (Object)genGlobalLongId);
                multiMap.put((Object)"bcm_userdefcvtformula", (Object)temp);
            });
        }
    }

    public DynamicObject copyBaseInfo(IDataModel dataModel, Double versionNum, DynamicObject template, CloneUtils cloneUtil, Multimap<String, DynamicObject> multiMap) {
        DynamicObject newTemplate = (DynamicObject)cloneUtil.clone(template.getDataEntityType(), (Object)template);
        newTemplate.set("effective", null);
        Date effectiveDate = (Date)dataModel.getValue("effectivedate");
        newTemplate.set("effectivedate", (Object)effectiveDate);
        newTemplate.set("effectivescope", (Object)template.getString("effectivescope"));
        newTemplate.set("expiringdate", dataModel.getValue("expiringdate"));
        newTemplate.set("versiondescription", dataModel.getValue("versiondescription"));
        newTemplate.set("versionnumber", (Object)versionNum);
        newTemplate.set("status", (Object)"0");
        LocalDateTime localDateTime = LocalDateTime.now();
        Date now = Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
        RequestContext requestContext = RequestContext.get();
        newTemplate.set("creator", (Object)requestContext.getUserId());
        newTemplate.set("createtime", (Object)now);
        newTemplate.set("modifier", (Object)requestContext.getUserId());
        newTemplate.set("modifytime", (Object)now);
        long genGlobalLongId = GlobalIdUtil.genGlobalLongId();
        newTemplate.set("id", (Object)genGlobalLongId);
        multiMap.put((Object)this.getTemplateEntity(), (Object)newTemplate);
        if (template.getDate("expiringdate") == null) {
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(effectiveDate.getTime() - 86400000L);
            effectiveDate = cal.getTime();
            template.set("expiringdate", (Object)effectiveDate);
            multiMap.put((Object)this.getTemplateEntity(), (Object)template);
        }
        return newTemplate;
    }

    private void executeWithTX(Consumer<TXHandle> consumer) {
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                consumer.accept(txHandle);
            }
            catch (Exception e) {
                txHandle.markRollback();
                throw new KDException(new ErrorCode("TXException", e.getMessage()), new Object[0]);
            }
        }
        catch (Exception e) {
            throw new KDException(new ErrorCode("TXException", e.getMessage()), new Object[0]);
        }
    }

    private void saveTemplateInfo() {
        ArrayList waitSave;
        IFormView view = this.getView();
        FormShowParameter formShowParameter = view.getFormShowParameter();
        Long pkId = (Long)formShowParameter.getCustomParam("pkId");
        String selectProperties = "id, number, name, versionnumber, group, effectivedate, expiringdate, versiondescription,model, modifier, modifytime";
        DynamicObject template = BusinessDataServiceHelper.loadSingle((String)this.getTemplateEntity(), (String)selectProperties, (QFilter[])QFilter.of((String)"id = ?", (Object[])new Object[]{pkId}).toArray());
        if (template != null) {
            IDataModel dataModel = this.getModel();
            Date effectiveDate = (Date)dataModel.getValue("effectivedate");
            template.set("effectivedate", (Object)effectiveDate);
            template.set("expiringdate", dataModel.getValue("expiringdate"));
            template.set("versiondescription", dataModel.getValue("versiondescription"));
            Pair<DynamicObject, DynamicObject> versionPair = this.getVersionPair(template.getLong("group"), template.getLong("id"), template.getLong("model.id"));
            DynamicObject frontVersion = (DynamicObject)versionPair.p1;
            waitSave = Lists.newArrayListWithCapacity((int)2);
            waitSave.add(template);
            if (frontVersion != null && frontVersion.getDate("expiringdate") == null) {
                frontVersion = BusinessDataServiceHelper.loadSingle((Object)frontVersion.getLong("id"), (String)this.getTemplateEntity(), (String)selectProperties);
                Calendar cal = Calendar.getInstance();
                cal.setTimeInMillis(effectiveDate.getTime() - 86400000L);
                frontVersion.set("expiringdate", (Object)cal.getTime());
                waitSave.add(frontVersion);
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u6a21\u677f\u5df2\u4e0d\u5b58\u5728\u3002", (String)"TplVersionEditPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        SaveServiceHelper.save((DynamicObject[])waitSave.toArray(new DynamicObject[0]));
        view.getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u4fee\u6539\u6210\u529f\u3002", (String)"TplVersionEditPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        view.close();
        OperationLogUtil.writeOperationLog((String)ResManager.loadKDString((String)"\u4fee\u6539\u7248\u672c\u4fe1\u606f", (String)"PaperTemplateEditVersionPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), (String)String.format(ResManager.loadKDString((String)"%1$s %2$s %3$s\uff0c\u7248\u672c\u4fe1\u606f\u4fee\u6539\u6210\u529f", (String)"PaperTemplateEditVersionPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), template.getString("number"), template.getString("name"), template.getString("versionnumber")), (Long)template.getLong("model.id"), (String)this.getTemplateEntity());
    }

    private boolean validateRetionality() {
        IDataModel model = this.getModel();
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        Date effectiveDate = (Date)model.getValue("effectivedate");
        if (effectiveDate == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u751f\u6548\u65e5\u671f\u3002", (String)"TplVersionEditPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        Date expiringDate = (Date)model.getValue("expiringdate");
        if (expiringDate != null && format.format(expiringDate).compareTo(format.format(effectiveDate)) < 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5931\u6548\u65e5\u671f\u5fc5\u987b\u665a\u4e8e\u751f\u6548\u65e5\u671f\u3002", (String)"TplVersionEditPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObject frontVersion = null;
        DynamicObject behindVersion = null;
        IFormView view = this.getView();
        FormShowParameter formShowParameter = view.getFormShowParameter();
        String style = (String)formShowParameter.getCustomParam("style");
        QFilter modelqf = new QFilter("1", "=", (Object)1);
        Long modelId = 0L;
        if (LongUtil.isvalidLong((Object)formShowParameter.getCustomParam("model"))) {
            modelId = (Long)formShowParameter.getCustomParam("model");
            modelqf.and("model", "=", formShowParameter.getCustomParam("model"));
        }
        if ("new".equals(style)) {
            Long group = (Long)formShowParameter.getCustomParam("group");
            DynamicObjectCollection query = QueryServiceHelper.query((String)this.getTemplateEntity(), (String)"id,model,versionnumber, group, effectivedate, expiringdate,templatecatalog.longnumber", (QFilter[])new QFilter[]{QFilter.of((String)"group = ?", (Object[])new Object[]{group}), modelqf}, (String)"versionnumber desc", (int)1);
            if (query.size() > 0) {
                frontVersion = (DynamicObject)query.get(0);
            }
        } else {
            Long pkId = (Long)formShowParameter.getCustomParam("pkId");
            DynamicObject tempGroup = QueryServiceHelper.queryOne((String)this.getTemplateEntity(), (String)"id, group", (QFilter[])new QFilter[]{QFilter.of((String)"id = ?", (Object[])new Object[]{pkId}), modelqf});
            if (tempGroup != null) {
                Pair<DynamicObject, DynamicObject> versionPair = this.getVersionPair(tempGroup.getLong("group"), pkId, modelId);
                frontVersion = (DynamicObject)versionPair.p1;
                behindVersion = (DynamicObject)versionPair.p2;
            }
        }
        if (behindVersion != null && expiringDate == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u540e\u4e00\u7248\u672c\uff0c\u5931\u6548\u65e5\u671f\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"TplVersionEditPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        Date frontDate = null;
        Date behindDate = null;
        if (frontVersion != null && (frontDate = frontVersion.getDate("expiringdate")) == null) {
            frontDate = frontVersion.getDate("effectivedate");
        }
        if (behindVersion != null) {
            behindDate = behindVersion.getDate("effectivedate");
        }
        if (frontDate != null && format.format(effectiveDate).compareTo(format.format(frontDate)) <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u5fc5\u987b\u665a\u4e8e\u4e0a\u4e00\u7248\u672c\u7684\u751f\u6548/\u5931\u6548\u65e5\u671f\u3002", (String)"TplVersionEditPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (behindDate != null && expiringDate != null && format.format(expiringDate).compareTo(format.format(behindDate)) >= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5931\u6548\u65e5\u671f\u5fc5\u987b\u65e9\u4e8e\u540e\u4e00\u7248\u672c\u7684\u751f\u6548\u65e5\u671f\u3002", (String)"TplVersionEditPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (frontVersion != null) {
            if (!TemplateCatalogEnum.INNERTRADE.getTemplatetype().equals(PaperTemplateService.getTemplateTypeByLongnumber((String)frontVersion.getString("templatecatalog.longnumber")))) {
                return true;
            }
            QFilter filter1 = new QFilter("model", "in", (Object)frontVersion.getLong("model"));
            QFilter filter2 = new QFilter("papertemplate.id", "in", (Object)frontVersion.getLong("id"));
            QFilter[] filters = new QFilter[]{filter1, filter2};
            DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"bcm_intrreportentity", (String)"id,year.number,year.name,period.number,period.expdate", (QFilter[])filters, (String)"year.number desc,period.number desc");
            if (dynamicObjectCollection != null && dynamicObjectCollection.size() > 0) {
                String period = ((DynamicObject)dynamicObjectCollection.get(0)).getString("period.expdate");
                String year = ((DynamicObject)dynamicObjectCollection.get(0)).getString("year.name");
                Date recordExpDate = null;
                try {
                    recordExpDate = DateTimeUtils.parseStrDate((String)(year + period));
                }
                catch (ParseException e) {
                    recordExpDate = null;
                }
                if (recordExpDate != null && format.format(effectiveDate).compareTo(format.format(recordExpDate)) <= 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u5fc5\u987b\u665a\u4e8e\u4e0a\u4e00\u7248\u672c\u5b58\u5728\u7f16\u5236\u8bb0\u5f55\u7684\u6700\u665a\u8d22\u5e74\u671f\u95f4\u3002", (String)"PaperTemplateEditVersionPlugin_01", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return false;
                }
            }
        }
        return true;
    }

    private Pair<DynamicObject, DynamicObject> getVersionPair(long groupId, Long pkId, Long modelId) {
        Pair result = Pair.onePair(null, null);
        QFilter modelqf = new QFilter("1", "=", (Object)1);
        if (LongUtil.isvalidLong((Object)modelId)) {
            modelqf.and("model", "=", (Object)modelId);
        }
        DynamicObjectCollection query = QueryServiceHelper.query((String)this.getTemplateEntity(), (String)"id,model, versionnumber, group, effectivedate, expiringdate,templatecatalog.longnumber", (QFilter[])new QFilter[]{QFilter.of((String)"group = ?", (Object[])new Object[]{groupId}), modelqf}, (String)"versionnumber desc");
        int index = 0;
        if (query.size() > 0) {
            for (int i = 0; i < query.size(); ++i) {
                DynamicObject temp = (DynamicObject)query.get(i);
                if (temp.getLong("id") != pkId.longValue()) continue;
                index = i;
                break;
            }
        }
        if (index - 1 >= 0) {
            result = Pair.onePair((Object)result.p1, (Object)query.get(index - 1));
        }
        if (index + 1 < query.size()) {
            result = Pair.onePair((Object)query.get(index + 1), (Object)result.p2);
        }
        return result;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public String getTemplateEntity() {
        return "bcm_papertemplate";
    }

    public String getTemplateAssignEntity() {
        return "bcm_templateassignrecord";
    }

    static class CopyEntity {
        private String entityName;
        private String id;
        private String templateFieldName;

        public CopyEntity(String entityName, String id, String templateFieldName) {
            this.entityName = entityName;
            this.id = id;
            this.templateFieldName = templateFieldName;
        }
    }
}

