/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.papertemplate;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.property.ComboProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.DecimalListColumn;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.mvc.form.FormView;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.adjust.operation.AdjustOperationContext;
import kd.fi.bcm.business.adjust.util.AdjustBusinessTypeUtil;
import kd.fi.bcm.business.adjust.util.AdjustTemplateHelper;
import kd.fi.bcm.business.adjust.validator.AdjustValidatorExecute;
import kd.fi.bcm.business.adjust.validator.IValidator;
import kd.fi.bcm.business.adjust.validator.TemplateModelValidator.CommonCheckDimMemberPermValidator;
import kd.fi.bcm.business.adjust.validator.TemplateModelValidator.CommonCheckPaperTmplValidator;
import kd.fi.bcm.business.export.ExportUtil;
import kd.fi.bcm.business.innertrade.report.IntrTmplImportExportHelper;
import kd.fi.bcm.business.invest.helper.InvElimPaperHelper;
import kd.fi.bcm.business.invest.helper.InvTmplImportExportHelper;
import kd.fi.bcm.business.mergecontrol.MergeControlHelper;
import kd.fi.bcm.business.papertemplate.CommonPaperTemplateModel;
import kd.fi.bcm.business.papertemplate.PaperTemplateHelper;
import kd.fi.bcm.business.papertemplate.PaperTemplateService;
import kd.fi.bcm.business.papertemplate.filterchain.AbstractPaperFilter;
import kd.fi.bcm.business.papertemplate.filterchain.PaperTmplChainFilter;
import kd.fi.bcm.business.papertemplate.filterchain.filter.SceneFilter;
import kd.fi.bcm.business.permission.permclass.PermClassCache;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.scheme.SchemeContext;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.BusinessTypeEnum;
import kd.fi.bcm.common.enums.MultiLangEnumBridge;
import kd.fi.bcm.common.enums.Permission.DataTypeEnum;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.enums.TemplateCatalogEnum;
import kd.fi.bcm.common.enums.TemplateCatalogTypeEnum;
import kd.fi.bcm.common.enums.adjust.AdjustTemplateControlEnum;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.enums.papertemplate.PaperTemplateTypeEnum;
import kd.fi.bcm.common.enums.status.ResultStatusEnum;
import kd.fi.bcm.common.model.ResultBox;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.papertemplate.PaperTemplateScenarioSettingConstant;
import kd.fi.bcm.common.papertemplate.PaperTemplateSceneSettingHelper;
import kd.fi.bcm.common.util.DynUtils;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.formplugin.adjust.model.AdjustSpreadToolModel;
import kd.fi.bcm.formplugin.common.IRefreshList;
import kd.fi.bcm.formplugin.importhelper.AbsCommonImport;
import kd.fi.bcm.formplugin.template.AbstractTemplateTreePlugin;
import kd.fi.bcm.formplugin.util.AdjustModelUtil;
import kd.fi.bcm.formplugin.util.UserSelectUtil;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.model.UserObject;
import org.apache.commons.lang.StringUtils;

public class PaperTemplateListPlugin
extends AbstractTemplateTreePlugin
implements IRefreshList {
    private static final String CTL_TOOLBARAP = "toolbarap";
    private static final String ITEM_ADD = "btn_addtemplate";
    private static final String ITEM_COPY = "btn_copy";
    private static final String ITEM_DEL = "btn_deltemplate";
    private static final String ITEM_ENABLE = "btn_enable";
    private static final String ITEM_DISABLE = "btn_disable";
    private static final String ITEM_VERSION = "btn_version";
    private static final String ITEM_ASSIGN = "btn_assign";
    private static final String ITEM_SHOWHISTORY = "btn_showhistory";
    private static final String ITEM_HIDEHISTORY = "btn_hidehistory";
    private static final String ITEM_REFRESH = "btn_refresh";
    private static final String ITEM_EXECUTEORDER = "btn_executeorder";
    private static final String ITEM_CLOSE = "close";
    private static final String IS_HIDEHISTORY = "isHideHistory";
    private static final String BTN_DELETE = "btn_delete";
    private static final String CTL_TEMPLATE_CATALOG = "templatecatalog";
    private static final String CTRL_TREE_CHECKBOX = "treecheckbox";
    private static final String CTL_BILLSTAP = "billlistap";
    protected static final String FOCUS_NODE_ID = "focusnodeid";
    private static final String CTL_MODEL = "model";
    private static final String CTL_SCENARIO = "scenario";
    private static final String KEY_NOPERMTMPL = "nopermtmpl";
    private static final String KEY_READONLYTMPL = "readonlytmpl";
    private static final String KEY_ADMINUSERBOL = "adminUserBol";
    public static final String BTN_EXPORT = "btn_invstexport";
    public static final String BTN_INTRORDER = "btn_introrder";
    public static final String BTN_IMPORT = "btn_invstimport";
    public static final String IMPORTTEMPLATE = "importtemplate";
    public static final String BTN_FETCHORDER = "btn_fetchorder";
    public static final String BTN_MOVETEMPLATE = "btn_movetemplate";
    public static final String ADJ_IMPORT_CALL_BACK = "ADJ_IMPORT_CALL_BACK";
    private static Set<String> dimKeys = Sets.newHashSet((Object[])new String[]{"scenario"});
    protected static final String[] btnAuth = new String[]{"btn_addtemplate", "btn_deltemplate", "btn_enable", "btn_disable", "btn_version", "btn_assign", "btn_copy", "btn_executeorder", "btn_movetemplate"};
    protected static final String[] btnAuth2 = new String[]{"btn_deltemplate", "btn_enable", "btn_disable", "btn_version", "btn_assign", "btn_executeorder", "btn_movetemplate"};
    protected static final String[] treebtnAuth = new String[]{"btn_addnew", "btn_delete", "btn_modify", "btn_up", "btn_down"};
    private static final String selectFields = "id,creator,createtime,model,versionnumber,seq,effectivedate,expiringdate,number,templatecatalog,permclass,scenario,status,name,spreadtype,invrelationtype,relacslscheme,data,spreadjson,count,group,versiondescription,extdimid,process,effective";
    private static String ORDERBY_STR = "number asc,sequence asc";
    private static final String iscategoryReadOnly = "iscategoryReadOnly";
    protected static final String readOnly = "readOnly";
    protected static final String categoryReadOnly = "categoryReadOnly";
    protected static final String tree_list = "treelist";
    protected static final String read = "read";
    private static Set<String> fixhead = Sets.newHashSet((Object[])new String[]{TemplateCatalogEnum.INNERTRADE.getNumber(), TemplateCatalogEnum.INVELIM.getNumber(), TemplateCatalogEnum.PRTADJUST.getNumber()});
    public static final String TMPL_SCENE_CACHE = "tmpl_scene_cache";
    private static Set<String> BUSINESSTYPEGROUP1 = Sets.newHashSet((Object[])new String[]{BusinessTypeEnum.ADJUSTOFFSETLEVEL.getName(), BusinessTypeEnum.OFFSETEICA.getName(), BusinessTypeEnum.OFFSETEIT.getName(), BusinessTypeEnum.OFFSETEOE.getName(), BusinessTypeEnum.OFFSETECF.getName(), BusinessTypeEnum.OFFSETEOther.getName()});
    private static Set<String> BUSINESSTYPEGROUP2 = Sets.newHashSet((Object[])new String[]{BusinessTypeEnum.ADJUSTSELFLEVEL.getName(), BusinessTypeEnum.OFFSETSELFLEVEL.getName()});
    private static Set<String> BUSINESSTYPEGROUP3 = Sets.newHashSet((Object[])new String[]{BusinessTypeEnum.RADJ.getName(), BusinessTypeEnum.EADJ.getName()});
    private static final Set<String> IGNORE_DIM = Sets.newHashSet((Object[])new String[]{"Entity", "Scenario", "Year", "Period"});

    @Override
    public void initialize() {
        super.initialize();
        HashMap<String, SingleF7TypeEnum> map = new HashMap<String, SingleF7TypeEnum>(16);
        map.put(CTL_SCENARIO, SingleF7TypeEnum.LEAF);
        super.initSingleMemberF7(map);
    }

    @Override
    protected void initTree() {
        PaperTemplateService.initPresetCatalog((String)this.getPageCache().get("KEY_MODEL_ID"));
        super.initTree();
    }

    @Override
    protected void addListeners() {
        super.addListeners();
        TreeView view = (TreeView)this.getControl(CTL_TEMPLATE_CATALOG);
        this.addItemClickListeners(CTL_TOOLBARAP);
        BillList billList = (BillList)this.getView().getControl(CTL_BILLSTAP);
        billList.setBillFormId("bcm_papertemplate");
        billList.addSetFilterListener(this::setFilter);
        billList.addHyperClickListener(e -> {
            BillList list = (BillList)e.getSource();
            ListSelectedRow currentRow = list.getSelectedRows().get(0);
            DynamicObject template = BusinessDataReader.loadSingle((Object)list.getFocusRowPkId(), (DynamicObjectType)list.getEntityType());
            String catalogId = template.getDynamicObject(CTL_TEMPLATE_CATALOG).getString("id");
            if ("number".equals(e.getFieldName())) {
                List onlyRead;
                long templateId = template.getLong("id");
                String readOnly = this.getPageCache().get(readOnly);
                if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)this.getPageCache().get(read))) {
                    this.getPageCache().remove(read);
                }
                if (null != readOnly && (onlyRead = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(readOnly), List.class)).contains(templateId)) {
                    this.getPageCache().put(read, "true");
                }
                if (PaperTemplateService.isTemplateType((String)catalogId, (String)TemplateCatalogEnum.INVELIM.getNumber())) {
                    this.openInvSheetTemplateEdit(TemplateModel.genTemplateModelBy((DynamicObject)template));
                } else {
                    this.openPaperTemplateEdit((Long)list.getFocusRowPkId(), template.getString("name"), template.getBigDecimal("versionnumber"));
                }
                this.writeOperationLog(OpItemEnum.LOOKUP.getName(), currentRow.getNumber(), currentRow.getName(), ResultStatusEnum.SUCCESS.getName());
            }
        });
        billList.addPagerClickListener(pagerClickEvent -> {
            if (this.validator()) {
                return;
            }
            this.refrushBillList();
        });
        billList.addListRowClickListener(new ListRowClickListener(){

            public void listRowClick(ListRowClickEvent evt) {
                PaperTemplateListPlugin.this.initPermCache();
                PaperTemplateListPlugin.this.checkTmpAuth(evt);
            }
        });
        billList.addCreateListColumnsListener(e -> {
            if (PaperTemplateService.isTemplateType((String)this.getPageCache().get(FOCUS_NODE_ID), (String)TemplateCatalogEnum.PRTADJUST.getNumber())) {
                e.getListColumns().removeIf(a -> "versionnumber".equals(a.getListFieldKey()) || "effectiveperiods".equals(a.getListFieldKey()) || "effectivedate".equals(a.getListFieldKey()) || "expiringdate".equals(a.getListFieldKey()) || "usage".equals(a.getListFieldKey()));
                AdjustTemplateControlEnum.getListColumn().forEach(a -> e.getListColumns().add(3, a));
            }
            if (PaperTemplateService.isTemplateType((String)this.getPageCache().get(FOCUS_NODE_ID), (String)TemplateCatalogEnum.INVELIM.getNumber())) {
                e.getListColumns().removeIf(a -> "usage".equals(a.getListFieldKey()));
                DecimalListColumn listColumn = new DecimalListColumn();
                listColumn.setKey("count");
                listColumn.setCaption(new LocaleString(new MultiLangEnumBridge("\u5206\u5f55\u6570\u91cf", "PaperTemplateListPlugin_1", "fi-bcm-formplugin").loadKDString()));
                listColumn.setFieldName("count");
                listColumn.setListFieldKey("count");
                listColumn.setVisible(11);
                listColumn.setZeroShow(true);
                DecimalListColumn executeorderColumn = new DecimalListColumn();
                executeorderColumn.setKey("executeorder");
                executeorderColumn.setCaption(new LocaleString(AdjustTemplateControlEnum.EXECUTEORDER.getName()));
                executeorderColumn.setFieldName("executeorder");
                executeorderColumn.setListFieldKey("executeorder");
                executeorderColumn.setVisible(11);
                executeorderColumn.setZeroShow(false);
                DecimalListColumn processColumn = new DecimalListColumn();
                processColumn.setKey("process");
                processColumn.setCaption(new LocaleString(ResManager.loadKDString((String)"\u8fc7\u7a0b", (String)"PaperTemplateListPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
                processColumn.setFieldName("process");
                processColumn.setListFieldKey("process.number");
                processColumn.setVisible(11);
                List listColumns = e.getListColumns();
                listColumns.add(listColumns.size(), listColumn);
                listColumns.add(3, executeorderColumn);
                listColumns.add(4, processColumn);
            }
        });
        billList.addPackageDataListener(e -> {
            if (ColumnDesc.class.isAssignableFrom(e.getSource().getClass())) {
                String key = ((ColumnDesc)e.getSource()).getKey();
                if ("executeorder".equals(key)) {
                    BigDecimal bigDecimal = e.getRowData().getBigDecimal(key);
                    if (bigDecimal != null && bigDecimal.compareTo(new BigDecimal("99999")) != 0 && bigDecimal.compareTo(BigDecimal.ZERO) != 0) {
                        DecimalFormat decimalFormat = new DecimalFormat("#,###.##");
                        e.setFormatValue((Object)decimalFormat.format(bigDecimal));
                    } else {
                        e.setFormatValue((Object)"");
                    }
                }
                if ("scenarioset".equals(key)) {
                    PaperTemplateTypeEnum type = this.getPaperTemplateTypeEnum(this.getPageCache().get(FOCUS_NODE_ID));
                    Map tmplScene = PaperTemplateHelper.findTmplScene4Setting((long)this.getModelId(), (PaperTemplateTypeEnum)type, (long)e.getRowData().getLong("group"));
                    e.setFormatValue(tmplScene.get("name"));
                }
            }
        });
        billList.addCreateListDataProviderListener(e -> e.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public void setListFields(List<ListField> listFields) {
                for (ListField listField : listFields) {
                    if (!"bussnesstype".equals(listField.getFieldName())) continue;
                    try {
                        ComboProp comboProp = (ComboProp)listField.getSrcFieldProp();
                        ArrayList<ValueMapItem> comboItems = new ArrayList<ValueMapItem>(16);
                        List<Pair<LocaleString, String>> bussinessType = AdjustModelUtil.getBussinessType(PaperTemplateListPlugin.this.getModelId(), false);
                        for (Pair<LocaleString, String> pair : bussinessType) {
                            comboItems.add(new ValueMapItem(null, (String)pair.p2, (LocaleString)pair.p1));
                        }
                        comboProp.setComboItems(comboItems);
                        listField.setSrcFieldProp((IDataEntityProperty)comboProp);
                    }
                    catch (Exception e) {
                        throw new KDBizException(ThrowableHelper.toString((Exception)e));
                    }
                }
                super.setListFields(listFields);
            }

            public DynamicObjectCollection getData(int arg0, int arg1) {
                DynamicObjectCollection rows = super.getData(arg0, arg1);
                return PaperTemplateListPlugin.this.sortRowData(rows);
            }
        }));
        view.addTreeNodeClickListener(new TreeNodeClickListener(){

            public void treeNodeClick(TreeNodeEvent evt) {
                super.treeNodeClick(evt);
                PaperTemplateListPlugin.this.getPageCache().put(PaperTemplateListPlugin.FOCUS_NODE_ID, evt.getNodeId().toString());
                PaperTemplateListPlugin.this.buttonAuthStatus(LongUtil.toLong((Object)evt.getNodeId().toString()));
                PaperTemplateListPlugin.this.showDifferType(evt.getNodeId().toString());
            }
        });
    }

    private DynamicObjectCollection sortRowData(DynamicObjectCollection rows) {
        List elimProcess = MergeControlHelper.getUnitElimProcesses((long)this.getModelId());
        elimProcess.add(Arrays.asList("RAdj", "ERAdj"));
        if (PaperTemplateService.isTemplateType((String)this.getPageCache().get(FOCUS_NODE_ID), (String)TemplateCatalogEnum.PRTADJUST.getNumber())) {
            ArrayList businessTypeOrder = new ArrayList(16);
            elimProcess.forEach(l -> l.forEach(p -> businessTypeOrder.add(AdjustBusinessTypeUtil.getBusinessTypeByProcess((String)p))));
            rows.sort((o1, o2) -> {
                int v = 0;
                if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)o1.getString("bussnesstype")) || kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)o2.getString("bussnesstype")) || kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)o1.getString("status")) || kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)o2.getString("status")) || kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)o1.getString("executeorder")) || kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)o2.getString("executeorder")) || kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)o1.getString("number")) || kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)o2.getString("number"))) {
                    return v;
                }
                v = BUSINESSTYPEGROUP1.contains(o1.getString("bussnesstype")) && BUSINESSTYPEGROUP1.contains(o2.getString("bussnesstype")) || BUSINESSTYPEGROUP2.contains(o1.getString("bussnesstype")) && BUSINESSTYPEGROUP2.contains(o2.getString("bussnesstype")) || BUSINESSTYPEGROUP3.contains(o1.getString("bussnesstype")) && BUSINESSTYPEGROUP3.contains(o2.getString("bussnesstype")) ? 0 : businessTypeOrder.indexOf(o1.getString("bussnesstype")) - businessTypeOrder.indexOf(o2.getString("bussnesstype"));
                if (v == 0 && (v = o2.getString("status").compareTo(o1.getString("status"))) == 0 && (v = o1.getBigDecimal("executeorder").compareTo(o2.getBigDecimal("executeorder"))) == 0) {
                    v = o1.getString("number").compareTo(o2.getString("number"));
                }
                return v;
            });
        } else if (PaperTemplateService.isTemplateType((String)this.getPageCache().get(FOCUS_NODE_ID), (String)TemplateCatalogEnum.INVELIM.getNumber())) {
            ArrayList processOrder = new ArrayList(16);
            elimProcess.forEach(l -> l.forEach(p -> processOrder.add(p)));
            Comparator<Object> comparator = Comparator.comparing(row -> processOrder.indexOf(((DynamicObject)row).get("process.number"))).thenComparing((r1, r2) -> {
                if (((DynamicObject)r1).getBigDecimal("executeorder").compareTo(BigDecimal.ZERO) == 0) {
                    if (((DynamicObject)r2).getBigDecimal("executeorder").compareTo(BigDecimal.ZERO) == 0) {
                        return 0;
                    }
                    return 1;
                }
                if (((DynamicObject)r2).getBigDecimal("executeorder").compareTo(BigDecimal.ZERO) == 0) {
                    return -1;
                }
                return ((DynamicObject)r1).getBigDecimal("executeorder").compareTo(((DynamicObject)r2).getBigDecimal("executeorder"));
            }).thenComparing(row -> ((DynamicObject)row).getBigDecimal("executeorder"), Comparator.nullsLast(BigDecimal::compareTo)).thenComparing(row -> ((DynamicObject)row).getString("number"));
            rows.sort(comparator);
        }
        return rows;
    }

    @Override
    public void checkPerm(String opkey) {
        switch (opkey) {
            case "btn_addnew": {
                opkey = ITEM_ADD;
                break;
            }
            case "btn_delete": {
                opkey = ITEM_DEL;
                break;
            }
            case "btn_disable": {
                opkey = ITEM_ENABLE;
                break;
            }
        }
        super.checkPerm(opkey);
    }

    @Override
    public String getModelSign() {
        return CTL_MODEL;
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String modelId = UserSelectUtil.getModelIdAfterCreateNewData(this.getView(), CTL_MODEL);
        this.refreshBillByUserSelect(new ArrayList<String>(dimKeys), true);
        this.getModel().setValue(CTL_SCENARIO, (Object)this.getPageCache().get(CTL_SCENARIO));
        PermClassCache.cachePermission((IPageCache)this.getPageCache(), (String)"bcm_papertemplatecatalog", (String)modelId);
        if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)modelId)) {
            this.refrushBillList();
            this.refreshTree();
        }
        this.showDifferType(this.getPageCache().get(FOCUS_NODE_ID));
        this.showBtnhistory(true);
        this.writeMultiLangLog(OpItemEnum.LOOKUP.getOpMultiLangEnumBridge(), new OPDescMultiLangEnumBridge("\u67e5\u770b\u6210\u529f", "PaperTemplateListPlugin_54", "fi-bcm-formplugin"));
    }

    private void buttonAuthStatus(Long focusId) {
        boolean adminUserBol = MemberPermHelper.ifUserHasRootPermByModel((long)Long.parseLong(RequestContext.get().getUserId()), (String)String.valueOf(this.getModelId()));
        if (!adminUserBol) {
            this.getPageCache().remove(iscategoryReadOnly);
            List<Long> readOnlyCatalogIds = this.getTmplPermByType(categoryReadOnly);
            List treeList = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(tree_list), List.class);
            Map<String, String> curTreeNode = this.getCurTreeNode(treeList, focusId.toString());
            if (this.findReadParentNode(treeList, curTreeNode)) {
                readOnlyCatalogIds.add(focusId);
                this.getPageCache().put(categoryReadOnly, SerializationUtils.toJsonString(readOnlyCatalogIds));
            }
            if (readOnlyCatalogIds.contains(focusId)) {
                this.getView().setEnable(Boolean.valueOf(false), btnAuth);
                this.getView().setEnable(Boolean.valueOf(false), treebtnAuth);
                this.getPageCache().put(iscategoryReadOnly, "true");
                return;
            }
        }
        this.getView().setEnable(Boolean.valueOf(true), btnAuth);
        this.getView().setEnable(Boolean.valueOf(true), treebtnAuth);
    }

    private boolean hyperlinkButtonAuth(Long tempId) {
        List<Long> readOnlytemplIds = this.getTmplPermByType(KEY_READONLYTMPL);
        boolean adminUserBol = MemberPermHelper.ifUserHasRootPermByModel((long)Long.parseLong(RequestContext.get().getUserId()), (String)String.valueOf(this.getModelId()));
        return !adminUserBol && (Objects.equals(this.getPageCache().get(iscategoryReadOnly), "true") || readOnlytemplIds.contains(tempId));
    }

    private void initPermCache() {
        boolean adminUserBol = MemberPermHelper.ifUserHasRootPermByModel((long)Long.parseLong(RequestContext.get().getUserId()), (String)String.valueOf(this.getModelId()));
        this.getPageCache().put(KEY_ADMINUSERBOL, Boolean.toString(adminUserBol));
        if (!adminUserBol) {
            ArrayListMultimap tmplPermMap = PermClassEntityHelper.getPermissionMapBatch((String)"bcm_papertemplate", (String)String.valueOf(this.getModelId()), (String)RequestContext.get().getUserId());
            HashMap allTmplPermMap = new HashMap();
            for (String key : tmplPermMap.keySet()) {
                List ids = tmplPermMap.get((Object)key);
                ids.forEach(id -> allTmplPermMap.put(id.toString(), key));
            }
            this.getPageCache().put(KEY_NOPERMTMPL, SerializationUtils.toJsonString(tmplPermMap.get((Object)PermClassEntityHelper.PermClassEnum.NOPERM.getValue()) == null ? new ArrayList() : tmplPermMap.get((Object)PermClassEntityHelper.PermClassEnum.NOPERM.getValue())));
            this.getPageCache().put(KEY_READONLYTMPL, SerializationUtils.toJsonString(tmplPermMap.get((Object)PermClassEntityHelper.PermClassEnum.READONLY.getValue()) == null ? new ArrayList() : tmplPermMap.get((Object)PermClassEntityHelper.PermClassEnum.READONLY.getValue())));
            List onlyReadCatalogPerms = PermClassCache.getPermissionMap((IPageCache)this.getPageCache(), (String)DataTypeEnum.READ.getIndex());
            this.getPageCache().put(categoryReadOnly, SerializationUtils.toJsonString((Object)onlyReadCatalogPerms));
        }
    }

    private void showDifferType(String foucusId) {
        String templateType = PaperTemplateService.getTemplateType((String)foucusId);
        if (TemplateCatalogEnum.PRTADJUST.getTemplatetype().equals(templateType)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{ITEM_VERSION, ITEM_SHOWHISTORY, ITEM_HIDEHISTORY});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{ITEM_COPY, ITEM_EXECUTEORDER});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{ITEM_VERSION});
            String isHidehistory = this.getPageCache().get(IS_HIDEHISTORY);
            boolean isShowHistory = kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)isHidehistory) ? Boolean.parseBoolean(isHidehistory) : true;
            this.getView().setVisible(Boolean.valueOf(isShowHistory), new String[]{ITEM_SHOWHISTORY});
            this.getView().setVisible(Boolean.valueOf(!isShowHistory), new String[]{ITEM_HIDEHISTORY});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{ITEM_COPY, ITEM_EXECUTEORDER});
        }
        if (TemplateCatalogEnum.INNERTRADE.getTemplatetype().equals(templateType)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"btn_intrreportlist", BTN_INTRORDER});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_intrreportlist", BTN_INTRORDER});
        }
        if (TemplateCatalogEnum.INVELIM.getTemplatetype().equals(templateType)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{ITEM_EXECUTEORDER});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_FETCHORDER});
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        if (!this.validator()) {
            return;
        }
        switch (key = evt.getItemKey()) {
            case "btn_addtemplate": {
                this.actionAddNew();
                break;
            }
            case "btn_deltemplate": {
                this.actionDelete();
                break;
            }
            case "btn_enable": 
            case "btn_disable": {
                BillList billList = (BillList)this.getControl(CTL_BILLSTAP);
                ListSelectedRowCollection dys = billList.getSelectedRows();
                if (dys == null || dys.size() == 0) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5177\u4f53\u884c\u3002", (String)"PaperTemplateListPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
                this.actionEnable(Objects.equals(ITEM_ENABLE, key) ? 1 : 0);
                break;
            }
            case "btn_version": {
                this.versionTemplate();
                break;
            }
            case "btn_assign": {
                this.actionAssign();
                break;
            }
            case "btn_showhistory": 
            case "btn_hidehistory": {
                boolean isShowHistory = Objects.equals(ITEM_HIDEHISTORY, key);
                this.showBtnhistory(isShowHistory);
                this.refrushBillList();
                break;
            }
            case "btn_refresh": {
                this.actionRefresh();
                this.refreshTree();
                break;
            }
            case "btn_movetemplate": {
                this.movetemplate();
                break;
            }
            case "btn_intrreportlist": {
                this.showTmplReportView();
                break;
            }
            case "btn_copy": {
                this.checkPerm(ITEM_ADD);
                this.copyTemplate();
                break;
            }
            case "btn_introrder": {
                this.showIntrTemplateOrderView();
                break;
            }
            case "btn_invstexport": {
                this.exportPaperTemplate();
                break;
            }
            case "btn_invstimport": {
                this.showImportView();
                break;
            }
            case "btn_fetchorder": {
                this.openFetchOrderSettingView();
                break;
            }
            case "btn_executeorder": {
                this.openAdjustExecuteOrderSettingView();
                break;
            }
        }
    }

    private void exportPaperTemplate() {
        BillList list = (BillList)this.getView().getControl(CTL_BILLSTAP);
        ListSelectedRowCollection rows = list.getSelectedRows();
        if (CollectionUtils.isEmpty((Collection)rows)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5bfc\u51fa\u7684\u6a21\u677f\u3002", (String)"PaperTemplateListPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        String templateType = PaperTemplateService.getTemplateType((String)this.getPageCache().get(FOCUS_NODE_ID));
        if (TemplateCatalogEnum.PRTADJUST.getTemplatetype().equals(templateType)) {
            this.exportCommonAdjustTemplate(rows);
        } else {
            this.exportIntrOrInvTemplate(rows);
        }
    }

    private void exportCommonAdjustTemplate(ListSelectedRowCollection rows) {
        Object[] ids = rows.stream().map(ListSelectedRow::getPrimaryKeyValue).toArray();
        List fields = MetadataServiceHelper.getDataEntityType((String)"bcm_commadjust_tpl_import").getProperties().stream().map(IMetadata::getName).collect(Collectors.toList());
        Collection dys = BusinessDataServiceHelper.loadFromCache((Object[])ids, (String)"bcm_papertemplate").values();
        fields.removeAll(Arrays.asList("data", "commembentry", "desc", "tmplscenario", "cvtbeforecurrency", "spreadmembentry"));
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(dys.size());
        List<String> debit2CreditList = Arrays.asList("debit", "credit");
        SchemeContext sc = new SchemeContext(this.getModelId());
        Map<Long, List<DynamicObject>> groupSceneMap = PaperTemplateHelper.findTmplScene((long)this.getModelId(), (PaperTemplateTypeEnum)PaperTemplateTypeEnum.PRTADJUST, dys.stream().map(e -> e.getLong("group")).collect(Collectors.toSet())).stream().collect(Collectors.groupingBy(k -> k.getLong("groupid")));
        for (DynamicObject dy : dys) {
            DynamicObject newDy = BusinessDataServiceHelper.newDynamicObject((String)"bcm_commadjust_tpl_import");
            for (String field : fields) {
                newDy.set(field, dy.get(field));
            }
            DynamicObjectCollection spreadmembentryDoc = dy.getDynamicObjectCollection("spreadmembentry");
            spreadmembentryDoc.removeIf(e -> "Entity".equalsIgnoreCase(e.getDynamicObject("spreaddimension").getString("number")));
            newDy.set("spreadmembentry", (Object)spreadmembentryDoc);
            newDy.set("desc", dy.get("description"));
            IDNumberTreeNode currencyNode = MemberReader.findCurrencyMemberById((String)this.getCurModelNumber(), (Long)dy.getLong("cvtbeforecurrency"));
            if (IDNumberTreeNode.NotFoundTreeNode != currencyNode) {
                newDy.set("cvtbeforecurrency", (Object)currencyNode.getNumber());
            }
            boolean ismultiplecurrency = dy.getBoolean("multiplecurrency");
            List<String> spreadmembentry = dy.getDynamicObjectCollection("spreadmembentry").stream().map(e -> e.getString("spreaddimension.number")).collect(Collectors.toList());
            spreadmembentry.remove("Entity");
            SpreadManager spread = (SpreadManager)ObjectSerialUtil.deSerializedBytesAdjust((String)dy.getString("data"));
            AdjustSpreadToolModel spreadModel = new AdjustSpreadToolModel(spread.getBook().getSheet(0), spreadmembentry);
            spreadModel.setTemplate(true);
            HashSet<String> sets = new HashSet<String>(spreadModel.getIndexMap().keySet());
            sets.removeAll(spreadmembentry);
            sets.remove("Entity");
            sets.removeAll(debit2CreditList);
            for (Integer effectRow : spreadModel.getEffectRows()) {
                DynamicObjectCollection datas = newDy.getDynamicObjectCollection("data");
                DynamicObject data = datas.addNew();
                for (String dimNumber : spreadmembentry) {
                    UserObject userObject = spreadModel.getCell((int)effectRow, dimNumber).getUserObject();
                    String entitysign = (String)userObject.get((Object)"entitysign");
                    if (entitysign == null) continue;
                    DynamicObject dimDy = BusinessDataServiceHelper.newDynamicObject((String)entitysign);
                    dimDy.set("name", userObject.get((Object)"membname"));
                    dimDy.set("number", userObject.get((Object)"membnumber"));
                    data.set(sc.getDimensionByNumber(dimNumber).getFieldmapped(), (Object)dimDy);
                }
                for (String other : sets) {
                    data.set(other, spreadModel.getCell((int)effectRow, other).getValue());
                }
                for (String other : debit2CreditList) {
                    Cell cell = spreadModel.getCell((int)effectRow, other);
                    if (cell.hasFormula()) {
                        data.set(ismultiplecurrency ? "cvtbefore" + other : other, (Object)cell.getFormula());
                        continue;
                    }
                    data.set(ismultiplecurrency ? "cvtbefore" + other : other, cell.getValue());
                }
            }
            DynamicObjectCollection commembentry = dy.getDynamicObjectCollection("commembentry");
            DynamicObjectCollection coms = newDy.getDynamicObjectCollection("commembentry");
            commembentry.forEach(e -> {
                if (IGNORE_DIM.contains(e.getString("comdimension.number"))) {
                    return;
                }
                DynamicObject com = coms.addNew();
                com.set("comdimension", e.get("comdimension"));
                IDNumberTreeNode node = MemberReader.findMemberById((long)this.getModelId(), (String)e.getString("comdimension.memberform"), (Long)e.getLong("commembid"));
                if (node != IDNumberTreeNode.NotFoundTreeNode) {
                    com.set("commembnumber", (Object)node.getNumber());
                    com.set("commembname", (Object)node.getName());
                }
            });
            DynamicObjectCollection tmplscenarios = newDy.getDynamicObjectCollection("tmplscenario");
            List<DynamicObject> sceneList = groupSceneMap.get(dy.getLong("group"));
            if (!CollectionUtils.isEmpty(sceneList)) {
                for (DynamicObject scene : sceneList) {
                    DynamicObject newScene = tmplscenarios.addNew();
                    newScene.set(CTL_SCENARIO, (Object)BusinessDataServiceHelper.loadSingle((Object)scene.getLong("scenario.id"), (String)"bcm_scenemembertree"));
                    newScene.set("scope", scene.get("scope"));
                    newScene.set("isexcept", scene.get("isexcept"));
                }
            }
            list.add(newDy);
        }
        try {
            FormView formView = (FormView)this.getView();
            String routeAppId = formView.getFormShowParameter().getServiceAppId();
            DynamicObject[] res = list.toArray(new DynamicObject[0]);
            this.handleDys(res);
            String url = ExportUtil.export((DynamicObject[])res, (String)routeAppId, (String)"bcm_commadjust_tpl_import", format -> {});
            this.downloadFile(url, "bcm_papertemplatelist", "3=3/NUOSE6ZU");
        }
        catch (Exception e2) {
            watchlogger.info(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e2, (int)30));
            throw new KDBizException((Throwable)e2, new ErrorCode(kd.bos.util.StringUtils.getEmpty(), ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u5bfc\u51fa\u6a21\u677f\u662f\u5426\u5b58\u5728\u3002", (String)"PaperTemplateListPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0])), new Object[0]);
        }
    }

    private void exportIntrOrInvTemplate(ListSelectedRowCollection rows) {
        HashSet<Long> tmplIds = new HashSet<Long>(16);
        HashSet<String> numbers = new HashSet<String>(16);
        HashSet<String> names = new HashSet<String>(16);
        for (ListSelectedRow row : rows) {
            tmplIds.add(LongUtil.toLong((Object)row.getPrimaryKeyValue()));
            numbers.add(row.getNumber());
            names.add(row.getName());
        }
        try {
            String templateType = PaperTemplateService.getTemplateType((String)this.getPageCache().get(FOCUS_NODE_ID));
            String url = null;
            if (TemplateCatalogEnum.INNERTRADE.getTemplatetype().equals(templateType)) {
                url = IntrTmplImportExportHelper.exportTmpls((long)this.getModelId(), tmplIds);
            } else if (TemplateCatalogEnum.INVELIM.getTemplatetype().equals(templateType)) {
                url = InvTmplImportExportHelper.exportTmpls((long)this.getModelId(), tmplIds);
            }
            if (StringUtils.isNotBlank((String)url)) {
                this.downloadFile(url, "bcm_papertemplatelist", "3=3/NUOSE6ZU");
                this.writeOperationLog(ResManager.loadKDString((String)"\u5bfc\u51fa", (String)"PaperTemplateListPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", numbers), String.join((CharSequence)",", names), ResManager.loadKDString((String)"\u6210\u529f", (String)"PaperTemplateListPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        }
        catch (IOException e) {
            log.error(String.format("\u62b5\u9500\u5e95\u7a3f[%s]\u5bfc\u51fa\u5931\u8d25\u3002", String.join((CharSequence)",", numbers), e));
            this.writeOperationLog(ResManager.loadKDString((String)"\u5bfc\u51fa", (String)"PaperTemplateListPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", numbers), String.join((CharSequence)",", names), ResManager.loadKDString((String)"\u5931\u8d25", (String)"PaperTemplateListPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private void showImportView() {
        if (this.getModelId() == 0L) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"PaperTemplateListPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        String templateType = PaperTemplateService.getTemplateType((String)this.getPageCache().get(FOCUS_NODE_ID));
        if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)templateType)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5177\u4f53\u7684\u6a21\u677f\u5206\u7c7b\u3002", (String)"PaperTemplateListPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (TemplateCatalogEnum.PRTADJUST.getTemplatetype().equals(templateType)) {
            String plugin = "kd.fi.bcm.formplugin.adjust.importplugin.AdjComTplBatchImportPlugin";
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, ADJ_IMPORT_CALL_BACK);
            String listName = ResManager.loadKDString((String)"\u901a\u7528\u5206\u5f55\u6a21\u677f", (String)"PaperTemplateListPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            ApplicationTypeEnum typeEnum = ApplicationTypeEnum.getApplication((String)this.getBizAppId());
            AbsCommonImport.invokeOperation("bcm_commadjust_tpl_import", plugin, closeCallBack, this.getModelId(), typeEnum, this.getView(), listName);
        } else {
            if (this.getValueId(CTL_SCENARIO) == 0L) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u60c5\u666f\u3002", (String)"PaperTemplateListPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("bcm_invtmplimport");
            showParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
            showParameter.setCustomParam("templateType", (Object)templateType);
            showParameter.setCustomParam(CTL_TEMPLATE_CATALOG, (Object)this.getPageCache().get(FOCUS_NODE_ID));
            showParameter.setCustomParam("KEY_SCENARIO_ID", (Object)this.getValueId(CTL_SCENARIO));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, IMPORTTEMPLATE));
            this.getView().showForm(showParameter);
        }
    }

    @Override
    protected Map<String, Object> getCustomParam2Import() {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("catalog", "hahaha");
        return map;
    }

    private void openFetchOrderSettingView() {
        FormShowParameter param = new FormShowParameter();
        param.setFormId("bcm_datafetchorder");
        param.setStatus(OperationStatus.ADDNEW);
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCustomParam("KEY_MODEL_ID", (Object)this.getPageCache().get("KEY_MODEL_ID"));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "dataFetchOrder");
        param.setCloseCallBack(closeCallBack);
        this.getView().showForm(param);
    }

    private void openAdjustExecuteOrderSettingView() {
        BillList billList = (BillList)this.getView().getControl(CTL_BILLSTAP);
        ListSelectedRowCollection dys = billList.getSelectedRows();
        if (dys == null || dys.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5177\u4f53\u884c\u3002", (String)"PaperTemplateListPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        FormShowParameter param = new FormShowParameter();
        param.setFormId("bcm_adjustpapertemporder");
        param.setStatus(OperationStatus.ADDNEW);
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCustomParam("KEY_MODEL_ID", (Object)this.getValueId(CTL_MODEL));
        param.setCustomParam("KEY_SCENARIO_ID", (Object)this.getValueId(CTL_SCENARIO));
        param.setCustomParam("ids", (Object)dys.getPrimaryKeyValues());
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "closeback_refresh");
        param.setCloseCallBack(closeCallBack);
        this.getView().showForm(param);
    }

    private void showIntrTemplateOrderView() {
        if (!this.checkParams(true)) {
            return;
        }
        FormShowParameter param = new FormShowParameter();
        param.setFormId("bcm_intrtmpl_order");
        param.getOpenStyle().setShowType(ShowType.Modal);
        if (this.getView().getParentView() != null) {
            param.setRootPageId(this.getView().getParentView().getPageId());
        }
        param.setCustomParam("KEY_MODEL_ID", (Object)this.getValueId(CTL_MODEL));
        param.setCustomParam("KEY_SCENARIO_ID", (Object)this.getValueId(CTL_SCENARIO));
        param.setCaption(ResManager.loadKDString((String)"\u5185\u90e8\u4ea4\u6613\u62b5\u9500\u5e95\u7a3f\u6a21\u677f\u6392\u5e8f\uff08\u652f\u6301\u62d6\u62fd\u79fb\u52a8\u6392\u5e8f\uff09", (String)"PaperTemplateListPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "intr_tmpl_order");
        param.setCloseCallBack(closeCallBack);
        this.getView().showForm(param);
    }

    private Long getValueId(String keyName) {
        DynamicObject obj = (DynamicObject)this.getModel().getValue(keyName);
        Long res = 0L;
        if (obj != null) {
            res = obj.getLong("id");
        }
        return res;
    }

    private boolean checkParams(boolean showMsg) {
        Object model = this.getModel().getValue(CTL_MODEL);
        if (model == null) {
            if (showMsg) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c\u4f53\u7cfb\u201d\u3002", (String)"PaperTemplateListPlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            return false;
        }
        return true;
    }

    private void copyTemplate() {
        BillList billList = (BillList)this.getView().getControl(CTL_BILLSTAP);
        ListSelectedRowCollection rows = billList.getSelectedRows();
        if (CollectionUtils.isEmpty((Collection)rows)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u590d\u5236\u7684\u6a21\u677f\u3002", (String)"PaperTemplateListPlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        Object[] ids = rows.getPrimaryKeyValues();
        ResultBox resultBox = PaperTemplateService.copyTemplate((String)this.getPageCache().get(FOCUS_NODE_ID), (Object[])ids);
        if (resultBox.isNotSuccess()) {
            resultBox.getErrorList().stream().forEach(e -> this.getView().showTipNotification(e.getMessage()));
        } else if (resultBox.getData() != null) {
            this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u5df2\u6210\u529f\u590d\u5236%s\u4efd\u6a21\u677f\u3002", (String)"PaperTemplateListPlugin_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ((Map)resultBox.getData()).size()));
            this.actionRefresh();
        }
    }

    private void showTmplReportView() {
        BillList billList = (BillList)this.getControl(CTL_BILLSTAP);
        if (billList.getSelectedRows() == null || billList.getSelectedRows().isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u67e5\u8be2\u7684\u6a21\u677f\u3002", (String)"PaperTemplateListPlugin_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        Set tmplIds = billList.getSelectedRows().stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
        FormShowParameter param = new FormShowParameter();
        param.setFormId("bcm_intrreportrecord");
        param.setParentPageId(this.getView().getParentView() != null ? this.getView().getParentView().getPageId() : this.getView().getPageId());
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.getOpenStyle().setTargetKey("_submaintab_");
        param.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        param.setCustomParam("tmplIds", tmplIds);
        param.setCaption(ResManager.loadKDString((String)"\u5185\u90e8\u4ea4\u6613\u6a21\u677f\u7f16\u5236\u8bb0\u5f55", (String)"PaperTemplateListPlugin_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        this.getView().showForm(param);
    }

    public void actionEdit(CommonPaperTemplateModel template) {
        BillList list = (BillList)this.getControl(CTL_BILLSTAP);
        if (!list.getSelectedRows().isEmpty()) {
            DynamicObject dynamicObject = list.getModel().loadReferenceData((DynamicObjectType)list.getEntityType(), list.getFocusRowPkId());
            String id = dynamicObject.get("id").toString();
            String name = dynamicObject.get("name").toString();
            HashMap<String, String> openParameter = new HashMap<String, String>(16);
            openParameter.put("formId", this.getBillEditForm(this.getPageCache().get(FOCUS_NODE_ID)));
            openParameter.put("pkId", id);
            IFormView mainPageView = this.getView().getMainView();
            IFormView parentView = this.getView().getParentView();
            String pageId = this.getView().getPageId() + id;
            if (mainPageView.getView(pageId) == null) {
                FormShowParameter formShowParameter = FormShowParameter.createFormShowParameter(openParameter);
                formShowParameter.setPageId(pageId);
                formShowParameter.setStatus(OperationStatus.EDIT);
                formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
                formShowParameter.setCustomParam("KEY_SCENARIO_ID", this.getScenarioId());
                formShowParameter.setCustomParam("template_model", (Object)ObjectSerialUtil.toByteSerialized((Object)template));
                formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                formShowParameter.setCaption(String.format(ResManager.loadKDString((String)"\u62b5\u6d88\u6a21\u677f-%s", (String)"PaperTemplateListPlugin_19", (String)"fi-bcm-formplugin", (Object[])new Object[0]), name));
                formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bcm_papertemplateedit"));
                this.getView().showForm(formShowParameter);
            } else {
                IFormView childFormView = mainPageView.getView(pageId);
                childFormView.activate();
                this.getView().sendFormAction(childFormView);
            }
        }
    }

    public void versionTemplate() {
        BillList billList = (BillList)this.getView().getControl(CTL_BILLSTAP);
        ListSelectedRowCollection dys = billList.getSelectedRows();
        if (dys == null || dys.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5177\u4f53\u884c\u3002", (String)"PaperTemplateListPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (dys.size() == 1) {
            Object[] primaryKeyValues = dys.getPrimaryKeyValues();
            DynamicObject tempSimple = QueryServiceHelper.queryOne((String)"bcm_papertemplate", (String)"number, name, group,model", (QFilter[])QFilter.of((String)"id = ?", (Object[])new Object[]{primaryKeyValues[0]}).toArray());
            if (tempSimple != null) {
                ListShowParameter formShowParameter = new ListShowParameter();
                formShowParameter.setFormId("bcm_papertplversionlist");
                formShowParameter.setCustomParam("group", (Object)tempSimple.getLong("group"));
                formShowParameter.setCustomParam(CTL_MODEL, (Object)tempSimple.getLong(CTL_MODEL));
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                String strVersion = ResManager.loadKDString((String)"\u7248\u672c\u5316", (String)"PaperTemplateListPlugin_20", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                formShowParameter.setCaption(String.format(strVersion + "-%s %s ", tempSimple.getString("number"), tempSimple.getString("name")));
                formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ITEM_VERSION));
                this.getView().showForm((FormShowParameter)formShowParameter);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6a21\u677f\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\u3002", (String)"PaperTemplateListPlugin_21", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u9009\u62e9\u4e00\u4e2a\u6a21\u677f\u8fdb\u884c\u7248\u672c\u5316\u64cd\u4f5c\u3002", (String)"PaperTemplateListPlugin_22", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        String nodeId = this.getPageCache().get(FOCUS_NODE_ID);
        if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)nodeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u6a21\u677f\u5206\u7c7b\u6811\u8282\u70b9\u540e\u518d\u64cd\u4f5c\u3002", (String)"PaperTemplateListPlugin_23", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject catalog = QueryServiceHelper.queryOne((String)"bcm_papertemplatecatalog", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)LongUtil.toLong((Object)nodeId))});
        switch (key) {
            case "btn_addnew": {
                if (!Objects.equals("root", catalog.getString("number"))) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4e0d\u652f\u6301\u65b0\u589e\u5206\u7c7b\u3002", (String)"PaperTemplateListPlugin_24", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            case "btn_delete": {
                if (!fixhead.contains(catalog.getString("number")) && !Objects.equals("root", catalog.getString("number"))) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u56fa\u5b9a\u5206\u7c7b\u4e0d\u53ef\u5220\u9664\u3002", (String)"PaperTemplateListPlugin_25", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            case "btn_modify": {
                if (!fixhead.contains(catalog.getString("number")) && !Objects.equals("root", catalog.getString("number"))) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u56fa\u5b9a\u5206\u7c7b\u4e0d\u53ef\u4fee\u6539\u3002", (String)"PaperTemplateListPlugin_26", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        super.click(evt);
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent mbce) {
        String callBackId;
        super.confirmCallBack(mbce);
        switch (callBackId = mbce.getCallBackId()) {
            case "btn_delete": {
                if (!MessageBoxResult.Yes.equals((Object)mbce.getResult())) break;
                BillList billList = (BillList)this.getControl(CTL_BILLSTAP);
                HashSet ids = new HashSet(16);
                billList.getCurrentListAllRowCollection().forEach(e -> ids.add(e.getPrimaryKeyValue()));
                Map<Object, String> collect = QueryServiceHelper.query((String)"bcm_papertemplate", (String)"id,name", (QFilter[])new QFilter("id", "in", ids).toArray()).stream().collect(Collectors.toMap(k -> k.get("id"), v -> v.getString("name")));
                if (ids.size() != collect.size()) {
                    return;
                }
                TreeView tree = (TreeView)this.getControl(CTL_TEMPLATE_CATALOG);
                Map map = tree.getTreeState().getFocusNode();
                String nodeId = (String)map.get("id");
                this.refrushBillList();
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"PaperTemplateListPlugin_27", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "btn_deltemplate": {
                if (!MessageBoxResult.Yes.equals((Object)mbce.getResult())) break;
                BillList billList = (BillList)this.getControl(CTL_BILLSTAP);
                HashSet<Object> ids = new HashSet<Object>(10);
                billList.getSelectedRows().forEach(e -> ids.add(e.getPrimaryKeyValue()));
                this.deleteTmpl(ids, null);
                for (int i = 0; i < billList.getSelectedRows().size(); ++i) {
                    ListSelectedRow listSelectedRow = billList.getSelectedRows().get(i);
                    this.writeOperationLog(OpItemEnum.DELETE.getName(), listSelectedRow.getNumber(), listSelectedRow.getName(), ResultStatusEnum.SUCCESS.getName());
                }
                this.refrushBillList();
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"PaperTemplateListPlugin_27", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    private void deleteTmpl(Set<Object> ids, String nodeId) {
        try (TXHandle tx = TX.required();){
            try {
                Set collect = ids.stream().map(p -> Long.valueOf(p.toString())).collect(Collectors.toSet());
                PaperTemplateHelper.deleteTmplScene((long)this.getModelId(), collect);
                QFilter tmplate = new QFilter(CTL_MODEL, "in", (Object)this.getModelId());
                tmplate.and("template", "in", collect);
                BusinessDataWriter.delete((String)"bcm_templateassignrecord", (QFilter[])new QFilter[]{tmplate});
                QFilter filter = new QFilter("id", "in", collect);
                BusinessDataWriter.delete((String)"bcm_papertemplate", (QFilter[])new QFilter[]{filter});
                if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)nodeId)) {
                    QFilter nodeFilter = new QFilter("id", "=", (Object)LongUtil.toLong((Object)nodeId));
                    BusinessDataWriter.delete((String)this.getTemplateCataLogEntryEntity(), (QFilter[])new QFilter[]{nodeFilter});
                }
                BusinessDataWriter.delete((String)"bcm_invsheetacclayout", (QFilter[])new QFilter[]{new QFilter("template", "in", collect)});
                BusinessDataWriter.delete((String)"bcm_invsheetttplentrys", (QFilter[])new QFilter[]{new QFilter("sheettemplate", "in", collect)});
            }
            catch (Throwable e) {
                tx.markRollback();
                throw new RuntimeException(e);
            }
        }
    }

    private void openPaperTemplateEdit(Map<String, Object> params) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(this.getBillEditForm(this.getPageCache().get(FOCUS_NODE_ID)));
        formShowParameter.setCustomParams(params);
        if (params.get("effectivedata") != null) {
            formShowParameter.setCustomParam("effectivedata", (Object)ObjectSerialUtil.toByteSerialized((Object)params.get("effectivedata")));
        }
        formShowParameter.setCaption(String.format(ResManager.loadKDString((String)"\u7f16\u8f91\u6a21\u677f-%1$s %2$s", (String)"PaperTemplateListPlugin_28", (String)"fi-bcm-formplugin", (Object[])new Object[0]), this.getName(params.get("name")), Objects.isNull(params.get("versionnumber")) ? "" : params.get("versionnumber")));
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setCustomParam("List_entry", (Object)Boolean.TRUE);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "closeback_refresh");
        formShowParameter.setCloseCallBack(closeCallBack);
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            formShowParameter.setParentFormId(parentView.getEntityId());
        }
        this.getView().showForm(formShowParameter);
    }

    public String getName(Object value) {
        if (value instanceof OrmLocaleValue) {
            OrmLocaleValue localValue = (OrmLocaleValue)value;
            return localValue.getLocaleValue();
        }
        return value == null ? "" : value.toString();
    }

    private void openPaperTemplateEdit(Long templateId, String name, BigDecimal versionnumber) {
        IFormView mainPageView = this.getView().getMainView();
        String pageId = this.getView().getPageId() + templateId;
        IFormView parentView = this.getView().getParentView();
        if (mainPageView == null || mainPageView.getView(pageId) == null) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId(this.getBillEditForm(this.getPageCache().get(FOCUS_NODE_ID)));
            formShowParameter.setPageId(pageId);
            formShowParameter.setCustomParam("template_id", (Object)templateId);
            formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getPageCache().get("KEY_MODEL_ID"));
            if (this.hyperlinkButtonAuth(templateId)) {
                formShowParameter.setCustomParam("nopermModify", (Object)"true");
            }
            String version = BigDecimal.ZERO.compareTo(versionnumber) == 0 ? "" : String.format("V%.1f", Float.valueOf(versionnumber.floatValue()));
            formShowParameter.setCustomParam("listPageID", (Object)this.getView().getPageId());
            formShowParameter.setCaption(String.format(ResManager.loadKDString((String)"\u7f16\u8f91\u6a21\u677f-%1$s %2$s", (String)"PaperTemplateListPlugin_28", (String)"fi-bcm-formplugin", (Object[])new Object[0]), name, version));
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            formShowParameter.setCustomParam("List_entry", (Object)Boolean.TRUE);
            formShowParameter.setCustomParam("rank", (Object)this.getPageCache().get("rank"));
            formShowParameter.setCustomParam(read, (Object)this.getPageCache().get(read));
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "closeback_refresh");
            formShowParameter.setCloseCallBack(closeCallBack);
            if (parentView == null) {
                formShowParameter.setParentPageId(this.getView().getPageId());
                this.getView().showForm(formShowParameter);
                return;
            }
            formShowParameter.setParentPageId(parentView.getPageId());
            formShowParameter.setParentFormId(parentView.getEntityId());
            parentView.showForm(formShowParameter);
            this.getView().sendFormAction(parentView);
        } else {
            IFormView childFormView = mainPageView.getView(pageId);
            childFormView.activate();
            this.getView().sendFormAction(childFormView);
        }
    }

    private void actionAddNew() {
        boolean exists;
        String catalogId = this.getPageCache().get(FOCUS_NODE_ID);
        if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)catalogId)) {
            catalogId = "0";
        }
        if (catalogId.equals(this.getPageCache().get("headnodeid")) || catalogId.equals("0")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4e0b\u4e0d\u80fd\u65b0\u589e\u6a21\u677f\u3002", (String)"PaperTemplateListPlugin_29", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getPageCache().put("KEY_SCENARIO_ID", this.getPageCache().get(CTL_SCENARIO));
        FormShowParameter formShowParameter = new FormShowParameter();
        String formId = "bcm_papertemplate";
        if (PaperTemplateService.isTemplateType((String)this.getPageCache().get(FOCUS_NODE_ID), (String)TemplateCatalogEnum.PRTADJUST.getNumber())) {
            formId = "bcm_adjustpapertemplate";
        }
        if (!(exists = QueryServiceHelper.exists((String)"bcm_papertemplatecatalog", (QFilter[])new QFilter("id", "=", (Object)LongUtil.toLong((Object)catalogId)).toArray()))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6a21\u677f\u5206\u7c7b\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u5217\u8868\u3002", (String)"PaperTemplateListPlugin_30", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        formShowParameter.setFormId(formId);
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f", (String)"PaperTemplateListPlugin_31", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        Object scenario = this.getModel().getValue(CTL_SCENARIO);
        if (null != scenario) {
            DynamicObject sceneDyn = (DynamicObject)scenario;
            formShowParameter.setCustomParam("KEY_SCENARIO_ID", (Object)sceneDyn.getLong("id"));
            formShowParameter.setCustomParam("tmplscene", (Object)this.toByteSerialized(this.getDefaultTmplScene(sceneDyn)));
        }
        formShowParameter.setCustomParam(CTL_TEMPLATE_CATALOG, (Object)LongUtil.toLong((Object)catalogId));
        formShowParameter.setCustomParam("isNew", (Object)Boolean.TRUE);
        formShowParameter.setStatus(OperationStatus.ADDNEW);
        formShowParameter.setParentPageId(this.getView().getPageId());
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bcm_papertemplate"));
        this.getView().showForm(formShowParameter);
    }

    private Object getDefaultTmplScene(DynamicObject sceneDyn) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        String name = PaperTemplateSceneSettingHelper.formateDisplay((String)sceneDyn.getString("number"), (String)sceneDyn.getString("name"), (String)String.valueOf(PaperTemplateScenarioSettingConstant.MemRangeEnum.ONLY_SELF.getCode()), (String)String.valueOf(PaperTemplateScenarioSettingConstant.ExceptEnum.APPLICABLE.getCode()));
        result.put("name", name);
        HashMap<String, Object> item = new HashMap<String, Object>(16);
        item.put("id", sceneDyn.getLong("id"));
        item.put("scope", String.valueOf(PaperTemplateScenarioSettingConstant.MemRangeEnum.ONLY_SELF.getCode()));
        item.put("isexcept", String.valueOf(PaperTemplateScenarioSettingConstant.ExceptEnum.APPLICABLE.getCode()));
        result.put("items", Lists.newArrayList((Object[])new Map[]{item}));
        return result;
    }

    private void actionDelete() {
        BillList billList = (BillList)this.getControl(CTL_BILLSTAP);
        if (billList.getSelectedRows() == null || billList.getSelectedRows().isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u6a21\u677f\u3002", (String)"PaperTemplateListPlugin_32", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList ids = new ArrayList(10);
        billList.getSelectedRows().forEach(e -> ids.add(e.getPrimaryKeyValue()));
        List<Long> readOnlyIds = this.getTmplPermByType(KEY_READONLYTMPL);
        AtomicBoolean containReadOnly = new AtomicBoolean(false);
        if (!this.getAdminUserBol().booleanValue() && !CollectionUtils.isEmpty(readOnlyIds)) {
            ids.forEach(id -> {
                if (readOnlyIds.contains(id)) {
                    containReadOnly.set(true);
                    return;
                }
            });
        }
        if (containReadOnly.get()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u6a21\u677f\u5305\u542b\u53ea\u8bfb\u6a21\u677f\uff0c\u4e0d\u53ef\u5220\u9664\u3002", (String)"PaperTemplateListPlugin_33", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter idfilter = new QFilter("id", "in", ids);
        QFilter statusfilter = new QFilter("status", "=", (Object)"1");
        QFilter[] filters = new QFilter[]{idfilter, statusfilter};
        boolean flag = QueryServiceHelper.exists((String)"bcm_papertemplate", (QFilter[])filters);
        if (flag) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u6a21\u677f\u5305\u542b\u5904\u4e8e\u542f\u7528\u72b6\u6001\u4e0b\u7684\u6a21\u677f\uff0c\u4e0d\u53ef\u5220\u9664\u3002", (String)"PaperTemplateListPlugin_34", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter filter = new QFilter("papertemplate", "in", ids);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bcm_intrreportentity", (String)"id,papertemplate.number", (QFilter[])filter.toArray(), null);){
            GroupbyDataSet groupbyDataSet = dataSet.groupBy(new String[]{"papertemplate.number"});
            groupbyDataSet.count("total");
            DataSet newDataSet = groupbyDataSet.finish();
            HashSet<String> numberSet = new HashSet<String>(16);
            if (newDataSet != null) {
                while (newDataSet.hasNext()) {
                    Row dataRow = newDataSet.next();
                    numberSet.add(dataRow.getString("papertemplate.number"));
                }
            }
            if (!numberSet.isEmpty()) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s \u6a21\u677f\u5b58\u5728\u7f16\u5236\u8bb0\u5f55\uff0c\u4e0d\u53ef\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6216\u5148\u6574\u8868\u91cd\u7f6e\u3002", (String)"PaperTemplateListPlugin_35", (String)"fi-bcm-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", numberSet)));
                return;
            }
        }
        if (InvElimPaperHelper.isPaperGenerate(ids)) {
            StringJoiner msg = new StringJoiner("\n");
            InvElimPaperHelper.getElimSheetLocate(ids, (scenario, year, period, org, number) -> msg.add(String.format(ResManager.loadKDString((String)"\u60c5\u666f%1$s\u3001\u8d22\u5e74%2$s\u3001\u671f\u95f4%3$s\u3001\u5408\u5e76\u8282\u70b9%4$s\u3001\u5e95\u7a3f%5$s", (String)"PaperTemplateListPlugin_36", (String)"fi-bcm-formplugin", (Object[])new Object[0]), scenario, year, period, org, number)));
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5b58\u5728\u5e95\u7a3f\u8bb0\u5f55\uff0c\u4e0d\u53ef\u5220\u9664\u3002", (String)"PaperTemplateListPlugin_37", (String)"fi-bcm-formplugin", (Object[])new Object[0]), msg.toString(), MessageBoxOptions.OK, ConfirmTypes.Default, null);
            return;
        }
        long modelId = this.getModelId();
        DynamicObjectCollection assignsTmplColl = QueryServiceHelper.query((String)"bcm_templateassignrecord", (String)"template", (QFilter[])new QFBuilder().add(CTL_MODEL, "=", (Object)modelId).add("template", "in", ids).toArray());
        ArrayList assignsTmpls = new ArrayList(10);
        if (!assignsTmplColl.isEmpty()) {
            assignsTmplColl.forEach(e -> assignsTmpls.add(e.getLong("template")));
            DynamicObjectCollection tmplNamesColl = QueryServiceHelper.query((String)"bcm_papertemplate", (String)"name", (QFilter[])new QFBuilder().add(CTL_MODEL, "=", (Object)modelId).add("id", "in", assignsTmpls).toArray());
            StringBuilder tmplnames = new StringBuilder();
            for (DynamicObject name : tmplNamesColl) {
                tmplnames.append(name.get("name").toString()).append(' ');
            }
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5176\u4e2d\u6a21\u677f %s\u5df2\u5206\u914d\uff0c\u786e\u8ba4\u662f\u5426\u5220\u9664\uff1f", (String)"PaperTemplateListPlugin_38", (String)"fi-bcm-formplugin", (Object[])new Object[0]), tmplnames.toString()), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(ITEM_DEL, (IFormPlugin)this));
        } else {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u662f\u5426\u5220\u9664\uff1f", (String)"PaperTemplateListPlugin_39", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(ITEM_DEL, (IFormPlugin)this));
        }
    }

    private void actionAssign() {
        Object[] rows;
        String catelogId = this.getPageCache().get(FOCUS_NODE_ID);
        if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)catelogId)) {
            catelogId = "0";
        }
        FormShowParameter param = new FormShowParameter();
        String formId = "bcm_templateassign";
        if (PaperTemplateService.isTemplateType((String)this.getPageCache().get(FOCUS_NODE_ID), (String)TemplateCatalogEnum.PRTADJUST.getNumber())) {
            formId = "bcm_adjusttemplateassign";
        }
        param.setFormId(formId);
        String pageId = null == this.getView().getParentView() ? this.getView().getPageId() : this.getView().getParentView().getPageId();
        param.setRootPageId(pageId);
        String[] businessRoot = this.getBusinessRootCatalog();
        param.setPageId(pageId + businessRoot[0] + this.getScenarioId());
        param.setStatus(OperationStatus.ADDNEW);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.getOpenStyle().setTargetKey("_submaintab_");
        param.setCustomParam("KEY_MODEL_ID", (Object)this.getPageCache().get("KEY_MODEL_ID"));
        param.setCustomParam(FOCUS_NODE_ID, (Object)this.getPageCache().get(FOCUS_NODE_ID));
        if (!this.isModelManager(this.getModelId())) {
            param.setCustomParam("noPermCatalogIds", (Object)PermClassCache.getPermissionMap((IPageCache)this.getPageCache(), (String)DataTypeEnum.NO.getIndex()));
        }
        if ((rows = this.getSelectTemplate()) != null && rows.length > 0) {
            param.setCustomParam("rows", (Object)rows);
        }
        if (catelogId.equals(this.getPageCache().get("headnodeid")) || catelogId.equals("0")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4e0b\u4e0d\u80fd\u5206\u914d\u6a21\u677f\u3002", (String)"PaperTemplateListPlugin_40", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        param.setCaption(String.format(ResManager.loadKDString((String)"\u5206\u914d-%s\u6a21\u677f", (String)"PaperTemplateListPlugin_41", (String)"fi-bcm-formplugin", (Object[])new Object[0]), businessRoot[1]));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "closeback_refresh");
        param.setCloseCallBack(closeCallBack);
        this.getView().showForm(param);
    }

    private String[] getBusinessRootCatalog() {
        String focusNodeId = this.getPageCache().get(FOCUS_NODE_ID);
        List treeList = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(tree_list), List.class);
        String[] businessRoot = new String[2];
        this.findBusinessRoot(focusNodeId, treeList, businessRoot);
        return businessRoot;
    }

    private void findBusinessRoot(String focusNodeId, List<Map<String, String>> treeList, String[] b) {
        for (Map<String, String> stringStringMap : treeList) {
            if (!stringStringMap.get("id").equals(focusNodeId)) continue;
            String parentId = stringStringMap.get("parentid");
            if ("0".equals(parentId)) break;
            b[0] = focusNodeId;
            b[1] = stringStringMap.get("name");
            this.findBusinessRoot(parentId, treeList, b);
            break;
        }
    }

    private void checkTmpAuth(ListRowClickEvent evt) {
        boolean modelManager = MemberPermHelper.isModelManager((Long)this.getModelId());
        if (modelManager) {
            this.getView().setEnable(Boolean.valueOf(true), btnAuth);
            return;
        }
        List<Long> readOnlyTmpIds = this.getTmplPermByType(KEY_READONLYTMPL);
        ListSelectedRowCollection rows = evt.getListSelectedRowCollection();
        List treeList = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(tree_list), List.class);
        DynamicObjectCollection templates = QueryServiceHelper.query((String)"bcm_papertemplate", (String)"id,templatecatalog.id", (QFilter[])new QFilter(CTL_MODEL, "=", (Object)this.getModelId()).and(new QFilter("id", "in", (Object)rows.getPrimaryKeyValues())).toArray());
        ArrayListMultimap catalogToTemplate = ArrayListMultimap.create();
        for (DynamicObject dyn : templates) {
            catalogToTemplate.put((Object)dyn.getLong("templatecatalog.id"), (Object)dyn.getLong("id"));
        }
        for (Map.Entry entry : catalogToTemplate.asMap().entrySet()) {
            Long key = (Long)entry.getKey();
            Map<String, String> curTreeNode = this.getCurTreeNode(treeList, key.toString());
            if (!this.findReadParentNode(treeList, curTreeNode)) continue;
            readOnlyTmpIds.addAll((Collection)entry.getValue());
            break;
        }
        this.getPageCache().put(readOnly, SerializationUtils.toJsonString(readOnlyTmpIds));
        if (rows.stream().map(ListSelectedRow::getPrimaryKeyValue).anyMatch(readOnlyTmpIds::contains)) {
            this.getView().setEnable(Boolean.valueOf(false), btnAuth2);
            return;
        }
        String focusNodeId = this.getPageCache().get(FOCUS_NODE_ID);
        if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)focusNodeId)) {
            this.buttonAuthStatus(LongUtil.toLong((Object)focusNodeId));
        }
    }

    private void actionEnable(int i) {
        BillList billList = (BillList)this.getControl(CTL_BILLSTAP);
        ListSelectedRowCollection dys = billList.getSelectedRows();
        String enable = i == 0 ? "0" : "1";
        Map templateStatus = PaperTemplateService.getTemplateStatus((Object[])dys.getPrimaryKeyValues());
        ArrayList primaryKeyValues = new ArrayList(dys.size());
        HashMap numberValues = new HashMap(dys.size());
        HashMap nameValues = new HashMap(dys.size());
        for (Map.Entry entry : templateStatus.entrySet()) {
            if (enable.equals(((DynamicObject)entry.getValue()).getString("status"))) continue;
            primaryKeyValues.add(entry.getKey());
            numberValues.put(entry.getKey(), ((DynamicObject)entry.getValue()).getString("number"));
            nameValues.put(entry.getKey(), ((DynamicObject)entry.getValue()).getString("name"));
        }
        if (i == 1) {
            if (primaryKeyValues.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6a21\u677f\u5df2\u542f\u7528\u3002", (String)"PaperTemplateListPlugin_42", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            boolean isCheckEffectiveDate = !PaperTemplateService.isTemplateType((String)this.getPageCache().get(FOCUS_NODE_ID), (String)TemplateCatalogEnum.PRTADJUST.getNumber());
            HashMap<Long, String> errorMsgResult = new HashMap<Long, String>();
            if (!isCheckEffectiveDate) {
                AdjustOperationContext _ctx = new AdjustOperationContext(Long.valueOf(this.getModelId()));
                List templs = AdjustTemplateHelper.getTemplateListById((Long)_ctx.getModelId(), primaryKeyValues);
                AdjustValidatorExecute validatorExecute = new AdjustValidatorExecute(_ctx);
                validatorExecute.addValidator((IValidator)new CommonCheckPaperTmplValidator());
                validatorExecute.addValidator((IValidator)new CommonCheckDimMemberPermValidator());
                validatorExecute.excute((Object)templs);
                for (OperateErrorInfo errorInfo : validatorExecute.getValidateResult().getAllErrorInfo()) {
                    long pkId2 = LongUtil.toLong((Object)errorInfo.getPkValue());
                    errorMsgResult.put(pkId2, errorInfo.getMessage());
                    primaryKeyValues.remove(pkId2);
                }
            }
            Pair checkRes = PaperTemplateService.updateTemplateStatus((String)"1", (Object[])primaryKeyValues.toArray(), (boolean)isCheckEffectiveDate);
            Set unEffectiveDate = (Set)checkRes.p1;
            Set unTmplScene = (Set)checkRes.p2;
            if (!(unEffectiveDate.isEmpty() && unTmplScene.isEmpty() && errorMsgResult.isEmpty())) {
                StringBuilder message = new StringBuilder();
                if (!unEffectiveDate.isEmpty()) {
                    message.append(ResManager.loadKDString((String)"\u56e0\u751f\u6548\u65e5\u671f\u4e3a\u7a7a\u800c\u542f\u7528\u5931\u8d25\u7684\u6a21\u677f\u5982\u4e0b\uff1a", (String)"PaperTemplateListPlugin_43", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    message.append("\r\n");
                    for (Long item : unEffectiveDate) {
                        message.append(String.format("%s_%s", numberValues.get(item), nameValues.get(item)));
                        message.append("\r\n");
                    }
                }
                if (!unTmplScene.isEmpty()) {
                    message.append(ResManager.loadKDString((String)"\u56e0\u6ca1\u6709\u8bbe\u7f6e\u9002\u7528\u60c5\u666f\u800c\u542f\u7528\u5931\u8d25\u7684\u6a21\u677f\u5982\u4e0b\uff1a", (String)"PaperTemplateListPlugin_44", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    message.append("\r\n");
                    for (Long item : unTmplScene) {
                        message.append(String.format("%s_%s", numberValues.get(item), nameValues.get(item)));
                        message.append("\r\n");
                    }
                }
                if (!errorMsgResult.isEmpty()) {
                    errorMsgResult.forEach((pkId, errorMsg) -> {
                        message.append(String.format(ResManager.loadKDString((String)"%1$s_%2$s\u64cd\u4f5c\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\u4e3a%3$s\u3002", (String)"PaperTemplateListPlugin_45", (String)"fi-bcm-formplugin", (Object[])new Object[0]), numberValues.get(pkId), nameValues.get(pkId), errorMsg));
                        message.append("\r\n");
                    });
                }
                this.getView().showMessage(ResManager.loadKDString((String)"\u90e8\u5206\u6a21\u677f\u542f\u7528\u5931\u8d25\u3002", (String)"PaperTemplateListPlugin_46", (String)"fi-bcm-formplugin", (Object[])new Object[0]), message.toString(), MessageTypes.Default);
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u542f\u7528\u3002", (String)"PaperTemplateListPlugin_47", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            String sucessNumberrs = primaryKeyValues.stream().filter(s -> !unEffectiveDate.contains(s) && !unTmplScene.contains(s) && !errorMsgResult.containsKey(s)).map(numberValues::get).collect(Collectors.joining(","));
            String sucessNames = primaryKeyValues.stream().filter(s -> !unEffectiveDate.contains(s) && !unTmplScene.contains(s) && !errorMsgResult.containsKey(s)).map(nameValues::get).collect(Collectors.joining(","));
            this.writeOperationLog(OpItemEnum.ENABLE.getName(), String.join((CharSequence)",", sucessNumberrs), String.join((CharSequence)",", sucessNames), ResultStatusEnum.SUCCESS.getName());
        } else if (i == 0) {
            if (primaryKeyValues.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6a21\u677f\u5df2\u7981\u7528\u3002", (String)"PaperTemplateListPlugin_48", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            PaperTemplateService.updateTemplateStatus((String)"0", (Object[])primaryKeyValues.toArray(), (boolean)false);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u7981\u7528\u3002", (String)"PaperTemplateListPlugin_49", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            this.writeOperationLog(OpItemEnum.DISABLE.getName(), String.join((CharSequence)",", numberValues.values()), String.join((CharSequence)",", nameValues.values()), ResultStatusEnum.SUCCESS.getName());
        }
        if (PaperTemplateService.isTemplateType((String)this.getPageCache().get(FOCUS_NODE_ID), (String)TemplateCatalogEnum.PRTADJUST.getNumber())) {
            AdjustTemplateHelper.clearDistributeMapFromAllCache((Long)this.getModelId(), (Long)DynUtils.getBaseId((DynamicObject)this.getModel().getDataEntity(), (String)CTL_SCENARIO));
        }
        this.refrushBillList();
    }

    private void actionRefresh() {
        this.refrushBillList();
    }

    protected Map<String, String> getCurTreeNode(List<Map<String, String>> treeList, String nodeId) {
        for (Map<String, String> next : treeList) {
            if (!next.get("id").equals(nodeId)) continue;
            return next;
        }
        return null;
    }

    protected boolean findReadParentNode(List<Map<String, String>> treeList, Map<String, String> node) {
        for (Map<String, String> next : treeList) {
            List permissionMap = PermClassCache.getPermissionMap((IPageCache)this.getPageCache(), (String)DataTypeEnum.READ.getIndex());
            if (permissionMap.contains(Long.parseLong(node.get("id")))) {
                return true;
            }
            if (!node.get("parentid").equals(next.get("id"))) continue;
            if (permissionMap.contains(Long.parseLong(next.get("id")))) {
                return true;
            }
            return this.findReadParentNode(treeList, next);
        }
        return false;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        switch (actionId) {
            case "bcm_papertemplate": {
                if (evt.getReturnData() == null) break;
                Map params = (Map)ObjectSerialUtil.deSerializedBytes((String)evt.getReturnData().toString());
                if (PaperTemplateService.isTemplateType((String)String.valueOf(params.get(CTL_TEMPLATE_CATALOG)), (String)TemplateCatalogEnum.INVELIM.getNumber())) {
                    TemplateModel template = new TemplateModel();
                    template.putAll(params);
                    template.setIsOldTemplate(false);
                    template.put("versionnumber", (Object)BigDecimal.valueOf(1.0));
                    template.put(CTL_MODEL, (Object)this.getModelId());
                    template.put(CTL_SCENARIO, this.getScenarioId());
                    Object sceneMap = template.get(TMPL_SCENE_CACHE);
                    if (sceneMap != null) {
                        template.put(TMPL_SCENE_CACHE, this.deSerializedBytes(sceneMap.toString()));
                    }
                    this.openInvSheetTemplateEdit(template);
                    break;
                }
                params.put("KEY_MODEL_ID", this.getModelId());
                params.put("KEY_SCENARIO_ID", this.getScenarioId());
                this.openPaperTemplateEdit(params);
                break;
            }
            case "btn_version": {
                if (returnData == null) break;
                DynamicObject dyna = BusinessDataServiceHelper.loadSingle((Object)returnData, (String)"bcm_papertemplate", (String)selectFields);
                if (PaperTemplateService.isTemplateType((String)dyna.getDynamicObject(CTL_TEMPLATE_CATALOG).getString("id"), (String)TemplateCatalogEnum.INVELIM.getNumber())) {
                    this.openInvSheetTemplateEdit(TemplateModel.genTemplateModelBy((DynamicObject)dyna));
                } else {
                    this.openPaperTemplateEdit(dyna.getLong("id"), dyna.getString("name"), dyna.getBigDecimal("versionnumber"));
                }
                this.writeOperationLog(OpItemEnum.VERSION.getName(), dyna.getString("number"), dyna.getString("name"), ResultStatusEnum.SUCCESS.getName());
                this.getView().showSuccessNotification(OpItemEnum.VERSION.getName() + ResultStatusEnum.SUCCESS.getName());
                break;
            }
            case "bcm_papertemplateedit": {
                this.refrushBillList();
                break;
            }
            case "refresh": {
                this.refrushBillList();
                break;
            }
            case "bcm_templatemove": {
                if (returnData != null) {
                    BillList billList = (BillList)this.getControl(CTL_BILLSTAP);
                    List collect = billList.getSelectedRows().stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
                    PaperTemplateService.moveTemplateForCatalog((long)this.getModelId(), (long)LongUtil.toLong((Object)returnData), collect);
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u79fb\u52a8\u6210\u529f\u3002", (String)"PaperTemplateListPlugin_50", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
                this.refrushBillList();
                break;
            }
            case "closeback_refresh": {
                this.refrushBillList();
                break;
            }
            case "intr_tmpl_order": {
                boolean isRefresh;
                if (returnData == null || !(isRefresh = ((Boolean)returnData).booleanValue())) break;
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fee\u6539\u6210\u529f\u3002", (String)"PaperTemplateListPlugin_51", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                this.actionRefresh();
                break;
            }
            case "importtemplate": {
                this.refrushBillList();
                break;
            }
            case "ADJ_IMPORT_CALL_BACK": {
                AdjustTemplateHelper.clearAllSceneTemplateCache((Long)this.getModelId(), (String[])new String[0]);
                this.refrushBillList();
            }
        }
    }

    protected QFilter getCatalogqFilter() {
        String nodeid = this.getPageCache().get(FOCUS_NODE_ID);
        if (this.getPageCache().get(FOCUS_NODE_ID) != null) {
            boolean isallchild = Boolean.parseBoolean(this.getModel().getValue(CTRL_TREE_CHECKBOX).toString());
            QFilter qFilter = new QFilter(CTL_TEMPLATE_CATALOG, "=", (Object)LongUtil.toLong((Object)nodeid));
            if (isallchild) {
                List treeList = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(tree_list), List.class);
                ArrayList<String> list = new ArrayList<String>(16);
                this.queryAllChildNodeList(nodeid, treeList, list);
                if (!list.isEmpty()) {
                    qFilter.or(CTL_TEMPLATE_CATALOG, "in", (Object)LongUtil.toLongList(list));
                }
            }
            return this.getTemplateIdsQFilter(qFilter);
        }
        return null;
    }

    protected void movetemplate() {
        DynamicObject[] tempObjs = this.getSelectedTempDynaObjs(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u79fb\u52a8\u7684\u6a21\u677f\u3002", (String)"PaperTemplateListPlugin_52", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        if (tempObjs != null) {
            List treeList;
            String nodeid = this.getPageCache().get(FOCUS_NODE_ID);
            boolean isallchild = Boolean.parseBoolean(this.getModel().getValue(CTRL_TREE_CHECKBOX).toString());
            if (isallchild && (treeList = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(tree_list), List.class)).size() == 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u65b0\u589e\u6a21\u677f\u5206\u7c7b\u3002", (String)"PaperTemplateListPlugin_53", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            String catalogLongNumber = PaperTemplateService.getCatalogPrefixByLongnumber((String)PaperTemplateService.getTemplateLongnumber((String)nodeid));
            DynamicObject secondLevelNode = QueryServiceHelper.queryOne((String)"bcm_papertemplatecatalog", (String)"id", (QFilter[])new QFilter[]{new QFilter(CTL_MODEL, "=", (Object)this.getModelId()).and("longnumber", "=", (Object)catalogLongNumber)});
            QFilter qfilter = this.getCatalogtypeQFilter().and(new QFilter("longnumber", "like", (Object)(catalogLongNumber + ".%")).or("longnumber", "=", (Object)catalogLongNumber));
            String modelkey = this.getPageCache().get("KEY_MODEL_ID");
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("bcm_templatemove");
            showParameter.setCustomParam("KEY_MODEL_ID", (Object)modelkey);
            showParameter.setCustomParam("template_customQfiter", (Object)this.toByteSerialized(qfilter));
            showParameter.setCustomParam("entryentity", (Object)this.getEntryEntity());
            showParameter.setCustomParam("cataLogEntryentity", (Object)this.getTemplateCataLogEntryEntity());
            showParameter.setCustomParam("nodeid", (Object)nodeid);
            if (secondLevelNode != null) {
                showParameter.setCustomParam("rootNodeId", (Object)secondLevelNode.getString("id"));
            }
            showParameter.setCustomParam("pluginName", (Object)this.getPluginName());
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "bcm_templatemove");
            showParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm(showParameter);
        }
    }

    @Override
    public void refreshList() {
        this.refrushBillList();
    }

    @Override
    protected void refrushBillList() {
        BillList billList = (BillList)this.getControl(CTL_BILLSTAP);
        billList.clearSelection();
        billList.setOrderBy(ORDERBY_STR);
        billList.refresh();
        this.initPermCache();
    }

    public void setFilter(SetFilterEvent e) {
        this.getPageCache().remove(readOnly);
        this.getPageCache().remove(read);
        QFilter filter = this.getCatalogqFilter();
        String orderBy = "number asc,versionnumber asc";
        String templateType = PaperTemplateService.getTemplateType((String)this.getPageCache().get(FOCUS_NODE_ID));
        if (TemplateCatalogEnum.INNERTRADE.getTemplatetype().equals(templateType)) {
            orderBy = "sequence asc,number asc,versionnumber asc";
        }
        e.setOrderBy(orderBy);
        boolean modelManager = MemberPermHelper.isModelManager((Long)this.getModelId());
        if (filter == null) {
            e.getQFilters().add(new QFilter("id", "=", (Object)-1));
            return;
        }
        e.getQFilters().add(filter);
        if (!modelManager) {
            ArrayListMultimap map = PermClassEntityHelper.getPermissionMap((String)"bcm_papertemplate", (String)String.valueOf(this.getModelId()), (String)String.valueOf(this.getUserId()));
            List noPermIds = map.get((Object)"1");
            if (!CollectionUtils.isEmpty((Collection)noPermIds)) {
                QFilter qFilter = new QFilter("id", "not in", (Object)noPermIds);
                e.getQFilters().add(qFilter);
            }
            if (map.get((Object)"2") != null) {
                this.getPageCache().put(readOnly, SerializationUtils.toJsonString((Object)map.get((Object)"2")));
            }
        }
        e.getQFilters().add(this.getFilter());
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        if (!this.validator()) {
            return;
        }
        switch (key = e.getProperty().getName()) {
            case "treecheckbox": {
                this.refrushBillList();
                break;
            }
            case "model": {
                String modelId = UserSelectUtil.getF7SelectId(this.getView(), CTL_MODEL);
                if (modelId == null) {
                    this.getModel().setValue(CTL_MODEL, (Object)this.getPageCache().get("KEY_MODEL_ID"));
                } else {
                    if (modelId.equals(this.getPageCache().get("KEY_MODEL_ID"))) {
                        return;
                    }
                    UserSelectUtil.saveUserSelectWhenModelChange(this.getView(), modelId);
                    this.getPageCache().put("KEY_MODEL_ID", modelId);
                }
                String sceneId = UserSelectUtil.getModelIdAfterCreateNewData(this.getView(), CTL_SCENARIO);
                if ("0".equals(sceneId)) {
                    sceneId = null;
                }
                PermClassCache.cachePermission((IPageCache)this.getPageCache(), (String)"bcm_papertemplatecatalog", (String)modelId);
                this.getModel().setValue(CTL_SCENARIO, (Object)sceneId);
                this.refreshTree();
                this.refrushBillList();
                break;
            }
            case "scenario": {
                String modelID = this.getPageCache().get("KEY_MODEL_ID");
                String scenarioId = UserSelectUtil.getF7SelectId(this.getView(), CTL_SCENARIO);
                UserSelectUtil.saveUserSelectWhenModelChange(this.getView(), modelID, scenarioId);
                this.refrushBillList();
                break;
            }
        }
    }

    private void refreshTree() {
        TreeView tree = (TreeView)this.getControl(CTL_TEMPLATE_CATALOG);
        tree.deleteAllNodes();
        this.initTree();
        this.initPermCache();
    }

    private Object getScenarioId() {
        Object scenarioId = null;
        Object scenario = this.getModel().getValue(CTL_SCENARIO);
        if (null != scenario) {
            scenarioId = ((DynamicObject)scenario).get("id");
        }
        if (null == scenarioId) {
            // empty if block
        }
        return scenarioId;
    }

    private QFilter getFilter() {
        String nodeid = this.getPageCache().get(FOCUS_NODE_ID);
        String headnodeid = this.getPageCache().get("headnodeid");
        if (nodeid == null || Objects.equals(nodeid, headnodeid)) {
            return new QFilter("1", "=", (Object)0);
        }
        QFilter qFilter = new QFilter("1", "=", (Object)1);
        QFilter qFilter_model = null;
        PaperTemplateTypeEnum type = this.getPaperTemplateTypeEnum(nodeid);
        long modelId = this.getModelId();
        Long secneId = this.getModel().getValue(CTL_SCENARIO) != null ? LongUtil.toLong((Object)((DynamicObject)this.getModel().getValue(CTL_SCENARIO)).getPkValue()) : null;
        PaperTmplChainFilter filter = new PaperTmplChainFilter(Long.valueOf(modelId), type, true);
        filter.addFilter((AbstractPaperFilter)new SceneFilter(secneId));
        QFilter qFilter_scene = new QFilter("id", "in", (Object)filter.doFilter(null));
        if (this.getModel().getValue(CTL_MODEL) != null) {
            qFilter_model = new QFilter(CTL_MODEL, "=", ((DynamicObject)this.getModel().getValue(CTL_MODEL)).getPkValue());
        }
        if (qFilter_scene != null) {
            qFilter = qFilter.and(qFilter_scene);
        }
        qFilter = qFilter_model == null ? qFilter : qFilter.and(qFilter_model);
        List<Long> noPermCheckTmpIds = this.getTmplPermByType(KEY_NOPERMTMPL);
        if (!this.getAdminUserBol().booleanValue() && !CollectionUtils.isEmpty(noPermCheckTmpIds)) {
            qFilter = qFilter.and("id", "not in", noPermCheckTmpIds);
        }
        return qFilter;
    }

    private PaperTemplateTypeEnum getPaperTemplateTypeEnum(String nodeid) {
        PaperTemplateTypeEnum type = null;
        String templateType = PaperTemplateService.getTemplateType((String)nodeid);
        if (TemplateCatalogEnum.PRTADJUST.getTemplatetype().equals(templateType)) {
            type = PaperTemplateTypeEnum.PRTADJUST;
        } else if (TemplateCatalogEnum.INNERTRADE.getTemplatetype().equals(templateType)) {
            type = PaperTemplateTypeEnum.INNERTRADE;
        } else if (TemplateCatalogEnum.INVELIM.getTemplatetype().equals(templateType)) {
            type = PaperTemplateTypeEnum.INVELIM;
        }
        return type;
    }

    private Boolean getAdminUserBol() {
        return Boolean.parseBoolean(this.getPageCache().get(KEY_ADMINUSERBOL));
    }

    private List<Long> queryAllChildNode(String nodeid, List<Map<String, String>> treeList, List<Long> allnodelist) {
        for (Map<String, String> m : treeList) {
            if (!m.get("parentid").equals(nodeid)) continue;
            allnodelist.add(Long.valueOf(m.get("id")));
            this.queryAllChildNode(m.get("id"), treeList, allnodelist);
        }
        return allnodelist;
    }

    private List<Long> getTmplPermByType(String key) {
        ArrayList<Long> result = new ArrayList<Long>();
        String s = this.getPageCache().get(key);
        if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)s)) {
            List o = (List)SerializationUtils.fromJsonString((String)s, List.class);
            o.forEach(e -> result.add(LongUtil.toLong((Object)e)));
        }
        return result;
    }

    @Override
    protected QFilter getTemplateIdsQFilter(QFilter qFilter) {
        qFilter.and("status", "in", (Object)Lists.newArrayList((Object[])new String[]{"0", "1"}));
        DynamicObjectCollection tmpls = QueryServiceHelper.query((String)"bcm_papertemplate", (String)"id, number, versionnumber", (QFilter[])qFilter.toArray());
        if (this.getPageCache().get(IS_HIDEHISTORY) != null) {
            PaperTemplateService.filterVersionTemplateTree((Collection)tmpls);
            return new QFilter("id", "in", tmpls.stream().map(e -> e.getLong("id")).collect(Collectors.toSet()));
        }
        return new QFilter("id", "in", tmpls.stream().map(e -> e.getLong("id")).collect(Collectors.toSet()));
    }

    private void showBtnhistory(Boolean isShowHistory) {
        this.getView().setVisible(isShowHistory, new String[]{ITEM_SHOWHISTORY});
        this.getView().setVisible(Boolean.valueOf(isShowHistory == false), new String[]{ITEM_HIDEHISTORY});
        if (isShowHistory.booleanValue()) {
            this.getPageCache().put(IS_HIDEHISTORY, "true");
        } else {
            this.getPageCache().remove(IS_HIDEHISTORY);
        }
    }

    private CommonPaperTemplateModel constructTemplateModel(DynamicObject dyna) {
        CommonPaperTemplateModel template = new CommonPaperTemplateModel();
        template.loadDynaObj2Model(dyna);
        return template;
    }

    private Object[] getSelectTemplate() {
        BillList billList = (BillList)this.getView().getControl(CTL_BILLSTAP);
        ListSelectedRowCollection rows = billList.getSelectedRows();
        if (!rows.isEmpty()) {
            if (PaperTemplateService.isTemplateType((String)this.getPageCache().get(FOCUS_NODE_ID), (String)TemplateCatalogEnum.PRTADJUST.getNumber())) {
                return rows.getPrimaryKeyValues();
            }
            DynamicObjectCollection dyns = QueryServiceHelper.query((String)"bcm_papertemplate", (String)"id, group", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)rows.getPrimaryKeyValues())});
            return dyns.stream().map(s -> s.getLong("group")).toArray();
        }
        return new Object[0];
    }

    @Override
    protected String getCatalogType() {
        return TemplateCatalogTypeEnum.PAPERTEMPLATELOG.getType() + "";
    }

    @Override
    protected QFilter getCatalogtypeQFilter() {
        return new QFilter("catalogtype", "=", (Object)Character.valueOf(TemplateCatalogTypeEnum.PAPERTEMPLATELOG.getType()));
    }

    @Override
    protected String getTemplateCataLogEntryEntity() {
        return "bcm_papertemplatecatalog";
    }

    public String getBillEditForm(String focusId) {
        if (PaperTemplateService.isTemplateType((String)focusId, (String)TemplateCatalogEnum.PRTADJUST.getNumber())) {
            return "bcm_adjustpapertempedit";
        }
        if (PaperTemplateService.isTemplateType((String)focusId, (String)TemplateCatalogEnum.INVELIM.getNumber())) {
            return "bcm_invsheettemplateedit";
        }
        return "bcm_papertemplateedit";
    }

    @Override
    protected String getEntryEntity() {
        return "bcm_papertemplate";
    }

    private void openInvSheetTemplateEdit(TemplateModel template) {
        BigDecimal versionNumber;
        String pageId = this.getView().getPageId() + template.getId();
        FormShowParameter formShowParameter = new FormShowParameter();
        if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)((CharSequence)template.get("status")))) {
            formShowParameter.setStatus(OperationStatus.EDIT);
        }
        formShowParameter.setFormId("bcm_invsheettemplateedit");
        formShowParameter.setPageId(pageId);
        if (this.hyperlinkButtonAuth(template.getId())) {
            formShowParameter.setStatus(OperationStatus.VIEW);
        }
        String version = BigDecimal.ZERO.compareTo(versionNumber = (BigDecimal)template.get("versionnumber")) == 0 ? "" : String.format("V%.1f", Float.valueOf(versionNumber.floatValue()));
        formShowParameter.setCaption(String.format(ResManager.loadKDString((String)"\u7f16\u8f91\u6a21\u677f-%1$s %2$s", (String)"PaperTemplateListPlugin_28", (String)"fi-bcm-formplugin", (Object[])new Object[0]), template.get("name"), version));
        formShowParameter.setCustomParam("template_model", (Object)ObjectSerialUtil.toByteSerialized((Object)template));
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.getOpenStyle().setTargetKey("_submaintab_");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "bcm_invsheettemplateedit");
        formShowParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(formShowParameter);
    }
}

