/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.papertemplate;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.fi.bcm.business.util.BCMNumberRule;
import kd.fi.bcm.common.util.MapInitHelper;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;

public class PaperTemplateNumSettingPlugin
extends AbstractBaseListPlugin {
    private static final String CONTROL_TMPL_ENTRY = "tmplentity";
    private static final String BTN_OK = "btnok";

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(BTN_OK);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        List tmpList = null;
        Object tmpListObj = this.getFormCustomParam("tmpList");
        if (tmpListObj != null) {
            tmpList = (List)ObjectSerialUtil.deSerializedBytes((String)tmpListObj.toString());
        }
        this.refreshGrid(tmpList);
    }

    private void refreshGrid(List<Map<String, String>> tmpList) {
        this.getModel().deleteEntryData(CONTROL_TMPL_ENTRY);
        EntryGrid grid = (EntryGrid)this.getControl(CONTROL_TMPL_ENTRY);
        if (tmpList == null || tmpList.isEmpty()) {
            return;
        }
        grid.getModel().batchCreateNewEntryRow(CONTROL_TMPL_ENTRY, tmpList.size());
        int row = 0;
        this.getModel().beginInit();
        for (Map<String, String> item : tmpList) {
            DynamicObject rowObj = this.getModel().getEntryRowEntity(CONTROL_TMPL_ENTRY, row);
            rowObj.set("oldtmpnum", (Object)item.get("oldtmpnum"));
            rowObj.set("version", (Object)item.get("version"));
            rowObj.set("importnum", (Object)item.get("importnum"));
            ++row;
        }
        this.getModel().endInit();
        this.getView().updateView(CONTROL_TMPL_ENTRY);
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Button)evt.getSource()).getKey();
        if (BTN_OK.equals(key)) {
            int row = 1;
            ArrayList<Map> result = new ArrayList<Map>(16);
            for (DynamicObject dyn : this.getModel().getEntryEntity(CONTROL_TMPL_ENTRY)) {
                String importnum = dyn.getString("importnum");
                if (StringUtils.isBlank((CharSequence)importnum)) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u8bf7\u586b\u5165\u201c\u5bfc\u5165\u6a21\u677f\u7f16\u7801\u201d\u3002", (String)"PaperTemplateNumSettingPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), row));
                    return;
                }
                if (importnum.length() >= 45) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u201c\u5bfc\u5165\u6a21\u677f\u7f16\u7801\u201d\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc745\u4e2a\u5b57\u7b26\u3002", (String)"PaperTemplateNumSettingPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), row));
                    return;
                }
                if (!BCMNumberRule.checkNumber((String)importnum)) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u201c\u5bfc\u5165\u6a21\u677f\u7f16\u7801\u201d\u4e0d\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u4ee5\u5916\u7684\u5b57\u7b26\uff0c\u4e0d\u53ef\u4ee5\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u5f00\u5934\uff0c\u5c0f\u6570\u70b9\u4e4b\u95f4\u5fc5\u987b\u6709\u5176\u4ed6\u5b57\u7b26\u3002", (String)"PaperTemplateNumSettingPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), row));
                    return;
                }
                result.add(MapInitHelper.ofMap((Object)"oldtmpnum", (Object)dyn.getString("oldtmpnum"), (Object)"version", (Object)dyn.getString("version"), (Object)"importnum", (Object)importnum));
                ++row;
            }
            this.getView().returnDataToParent(result);
            this.getView().close();
        }
    }
}

