/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.papertemplate;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.ArrayListMultimap;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.RichTextEditor;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.papertemplate.PaperTemplateService;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.util.BCMNumberRule;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.TemplateCatalogEnum;
import kd.fi.bcm.common.enums.TemplateCatalogTypeEnum;
import kd.fi.bcm.common.enums.adjust.AdjustTemplateControlEnum;
import kd.fi.bcm.common.enums.invest.InvCaseProcessEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.util.AdjustModelUtil;
import org.apache.commons.collections.CollectionUtils;

public class PaperTemplatePlugin
extends AbstractBaseFormPlugin {
    public static final String CB_PROCESS_VALUE = "cbProcessValue";
    public static final String TMPL_SCENE_ITEMS = "tmpl_scene_items";
    private static final String ctl_templatecatalog = "templatecatalog";
    private static final String ctl_model = "model";
    private static final String ctl_scenario = "scenario";
    private static final String IS_SHOW_DESCRIPTION = "isshowdescription";
    private static final String IS_ONLY_READ = "isonlyread";
    private static final String OPERATION_CONFIRM = "confirm";
    private static final String CTL_RICH_TEXTEDITOR_AP = "richtexteditorap";
    private static final String ctl_checkbox_descpriton = "isshowdescription";
    public static final String PROCESS = "process";
    public static final String CB_PROCESS = "cb_process";
    private static final String ctr_effectivetext = "effectivetext";
    private static final String ctr_effectivedata = "effectivedata";
    private static final String ctr_effectivecache = "effectivecache";
    private static final String SCENARIOSET = "scenarioset";
    public static final String TMPL_SCENE_CACHE = "tmpl_scene_cache";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit tplcatalog = (BasedataEdit)this.getControl(ctl_templatecatalog);
        tplcatalog.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners("btn_close", "btn_confirm", ctr_effectivetext, SCENARIOSET);
        PermClassEntityHelper.setPermClassFilter((BasedataEdit)((BasedataEdit)this.getControl("permclass")), (Object)this.getModelId());
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String description = (String)this.getView().getFormShowParameter().getCustomParam("description");
        OperationStatus isNew = formShowParameter.getStatus();
        Object tmplscenestr = this.getFormCustomParam("tmplscene");
        if (tmplscenestr != null) {
            this.getPageCache().put(TMPL_SCENE_CACHE, tmplscenestr.toString());
            Map tmplScene = (Map)this.deSerializedBytes(tmplscenestr.toString());
            if (tmplScene != null) {
                this.getModel().setValue(SCENARIOSET, tmplScene.get("name"));
                this.getPageCache().put(TMPL_SCENE_ITEMS, this.toByteSerialized(tmplScene.get("items")));
            }
        }
        this.getPageCache().remove("explain");
        this.buildFromCusParameter();
        if (Objects.equals(this.getFormCustomParam("explain"), "isexplain")) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"baseinfoflex"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"explainflex", "isshowdescription"});
            RichTextEditor rap = (RichTextEditor)this.getControl(CTL_RICH_TEXTEDITOR_AP);
            if (StringUtils.isNotEmpty((CharSequence)description)) {
                String dec = (String)ObjectSerialUtil.deSerializedBytes((String)description);
                rap.setText(dec);
            }
            this.getPageCache().put("explain", "isexplain");
            return;
        }
        if (OperationStatus.ADDNEW.equals((Object)isNew)) {
            this.setValue("versionnumber", new BigDecimal(1));
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"explainflex", "isshowdescription"});
        this.buildTemplateCatalogFilter(this.isAddNewStatus());
        this.getView().setEnable(Boolean.valueOf(!"bcm_papertemplateedit".equals(this.getView().getParentView().getEntityId())), new String[]{"usage"});
        this.initShowEffective();
    }

    private void buildFromCusParameter() {
        Long group;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object name = formShowParameter.getCustomParam("name");
        String number = (String)formShowParameter.getCustomParam("number");
        if (LongUtil.isvalidLong((Object)formShowParameter.getCustomParam("KEY_MODEL_ID"))) {
            Long modelId = (Long)formShowParameter.getCustomParam("KEY_MODEL_ID");
            this.getModel().setValue(ctl_model, (Object)modelId);
            this.getPageCache().put("KEY_MODEL_ID", String.valueOf(modelId));
        }
        if (LongUtil.isvalidLong((Object)formShowParameter.getCustomParam("KEY_SCENARIO_ID"))) {
            Long senarioId = (Long)formShowParameter.getCustomParam("KEY_SCENARIO_ID");
            this.getModel().setValue(ctl_scenario, (Object)senarioId);
            this.getPageCache().put("KEY_SCENARIO_ID", String.valueOf(senarioId));
        }
        String templateType = "";
        if (LongUtil.isvalidLong((Object)formShowParameter.getCustomParam(ctl_templatecatalog))) {
            Long catalogId = (Long)formShowParameter.getCustomParam(ctl_templatecatalog);
            this.getModel().setValue(ctl_templatecatalog, (Object)catalogId);
            templateType = PaperTemplateService.getTemplateType((String)String.valueOf(catalogId));
            this.getView().setVisible(Boolean.valueOf(Objects.equals(templateType, TemplateCatalogEnum.INNERTRADE.getTemplatetype())), new String[]{"usage"});
            if (Objects.equals(templateType, TemplateCatalogEnum.INNERTRADE.getTemplatetype())) {
                String usage = (String)formShowParameter.getCustomParam("usage");
                this.getModel().setValue("usage", (Object)(StringUtils.isEmpty((CharSequence)usage) ? "0" : usage));
            }
            this.showAdjustControl(templateType);
        }
        IDNumberTreeNode processNode = MemberReader.findProcessMemberById((String)this.getCurModelNumber(), (Long)LongUtil.toLong((Object)formShowParameter.getCustomParam(PROCESS)));
        boolean isInvTemp = Objects.equals(templateType, TemplateCatalogEnum.INVELIM.getTemplatetype());
        this.getView().setVisible(Boolean.valueOf(isInvTemp), new String[]{CB_PROCESS});
        if (isInvTemp) {
            List invProcessNumSet = InvCaseProcessEnum.getInvNumber();
            if (processNode != IDNumberTreeNode.NotFoundTreeNode) {
                if (OrgRelaProcessMembPool.isRelaProcess((String)processNode.getNumber())) {
                    invProcessNumSet.retainAll(OrgRelaProcessMembPool.getRelaProcessMembPool());
                } else {
                    invProcessNumSet.removeAll(OrgRelaProcessMembPool.getRelaProcessMembPool());
                }
            }
            this.initProcessCombo(invProcessNumSet);
        }
        if (processNode != IDNumberTreeNode.NotFoundTreeNode) {
            this.setValueOnModel(PROCESS, processNode.getId());
            this.setValueOnModel(CB_PROCESS, InvCaseProcessEnum.getIndex((String)processNode.getNumber()));
        }
        if (LongUtil.isvalidLong((Object)formShowParameter.getCustomParam("permclass"))) {
            Long permclassId = (Long)formShowParameter.getCustomParam("permclass");
            this.getModel().setValue("permclass", (Object)permclassId);
        }
        if (Objects.nonNull(name)) {
            this.setValueOnModel("name", name);
        }
        if (Objects.nonNull(number)) {
            this.setValueOnModel("number", number);
            group = (Long)formShowParameter.getCustomParam("group");
            if (Objects.nonNull(group) && this.checkTemplateHaveMultiVersion(group)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"number"});
            }
        }
        if (LongUtil.isvalidLong((Object)formShowParameter.getCustomParam("id"))) {
            Long id = (Long)formShowParameter.getCustomParam("id");
            this.setValueOnModel("id", id);
        }
        if (LongUtil.isvalidLong((Object)formShowParameter.getCustomParam("group"))) {
            group = (Long)formShowParameter.getCustomParam("group");
            this.setValueOnModel("group", group);
        }
    }

    private Map<String, Object> returnBaseInfoFromDM() {
        String s;
        DynamicObject process;
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        DynamicObject data = this.getModel().getDataEntity();
        params.put("name", data.getString("name"));
        params.put("mutiname", data.get("name"));
        params.put("number", data.getString("number"));
        if (data.getLong("permclass.id") > 0L) {
            params.put("permclass", data.getLong("permclass.id"));
        }
        params.put(ctl_templatecatalog, data.getLong("templatecatalog.id"));
        params.put("usage", data.getString("usage"));
        RichTextEditor rap = (RichTextEditor)this.getControl(CTL_RICH_TEXTEDITOR_AP);
        if (Objects.nonNull(rap) && StringUtils.isNotEmpty((CharSequence)rap.getText())) {
            params.put("description", rap.getText());
        }
        if (Objects.nonNull(process = (DynamicObject)data.get(PROCESS))) {
            params.put(PROCESS, process.getLong("id"));
            params.put(CB_PROCESS, data.getString(CB_PROCESS));
            params.put("processNumber", process.getString("number"));
            params.put("cb_process_value", process.getString("number") + " " + process.getString("name"));
        }
        if (StringUtils.isNotEmpty((CharSequence)(s = this.getPageCache().get(ctr_effectivecache)))) {
            Map effective = (Map)JSON.parseObject((String)s, (TypeReference)new TypeReference<Map<String, Set<Long>>>(){}, (Feature[])new Feature[0]);
            params.put(ctr_effectivedata, effective);
            params.put(ctr_effectivetext, data.getString(ctr_effectivetext));
        }
        params.put(TMPL_SCENE_CACHE, this.getPageCache().get(TMPL_SCENE_CACHE));
        return params;
    }

    private void buildTemplateCatalogFilter(boolean isNew) {
        ArrayListMultimap catalogPerm;
        BasedataEdit templatecatalog = (BasedataEdit)this.getControl(ctl_templatecatalog);
        DynamicObject catalog = (DynamicObject)this.getModel().getValue(ctl_templatecatalog);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(4);
        QFilter filter1 = new QFilter(ctl_model, "=", (Object)this.getModelId());
        QFilter filter2 = TemplateCatalogTypeEnum.getPaperTemplateCatalogFilter();
        qFilters.add(filter1);
        qFilters.add(filter2);
        qFilters.add(new QFilter("longnumber", "like", (Object)(PaperTemplateService.getCatalogPrefixByLongnumber((String)catalog.getString("longnumber")) + "%")));
        boolean adminUserBol = MemberPermHelper.ifUserHasRootPermByModel((long)Long.parseLong(RequestContext.get().getUserId()), (String)String.valueOf(this.getModelId()));
        if (!adminUserBol && !CollectionUtils.isEmpty((Collection)(catalogPerm = PermClassEntityHelper.getPermissionMapBatch((String)"bcm_papertemplatecatalog", (String)String.valueOf(this.getModelId()), (String)String.valueOf(RequestContext.get().getCurrUserId()))).get((Object)PermClassEntityHelper.PermClassEnum.NOPERM.getValue()))) {
            qFilters.add(new QFilter("id", "not in", (Object)catalogPerm.get((Object)PermClassEntityHelper.PermClassEnum.NOPERM.getValue())));
        }
        templatecatalog.setQFilters(qFilters);
    }

    private void showAdjustControl(String templatetype) {
        if (Objects.equals(templatetype, "3")) {
            List inputNumbers = AdjustTemplateControlEnum.getNumbers();
            this.getView().setVisible(Boolean.valueOf(true), inputNumbers.toArray(new String[0]));
            inputNumbers.forEach(e -> ((ComboEdit)this.getControl((String)e)).setMustInput(true));
            List<ComboItem> bussnesstypeinput = AdjustModelUtil.setBusinessType(this.getModel(), (ComboEdit)this.getControl(AdjustTemplateControlEnum.BUSSINESS_TYPE.getNumber()), this.getModelId(), false, true, null, false);
            if (!CollectionUtils.isEmpty(bussnesstypeinput)) {
                this.getModel().setValue(AdjustTemplateControlEnum.BUSSINESS_TYPE.getNumber(), (Object)bussnesstypeinput.get(0).getValue());
            }
        } else {
            this.getView().setVisible(Boolean.valueOf(false), AdjustTemplateControlEnum.getNumbers().toArray(new String[0]));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operation;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (operation = afterDoOperationEventArgs.getOperateKey()) {
            case "confirm": {
                if (!this.getModel().getDataChanged()) break;
                Map<String, Object> templatemodel = this.returnBaseInfoFromDM();
                this.returnDataToParent(templatemodel);
            }
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (ctr_effectivetext.equals(key)) {
            this.openExpiredDateF7(ctr_effectivetext);
        }
        if (SCENARIOSET.equals(key)) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("bcm_templatemutiscenceset");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCustomParam(ctl_model, (Object)this.getModelId());
            formShowParameter.setCustomParam("selecteditems", (Object)this.getPageCache().get(TMPL_SCENE_ITEMS));
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
            this.getView().showForm(formShowParameter);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        RichTextEditor rap;
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        String number = (String)this.getValueOnModel("number");
        Long catalogId = (Long)this.getFormCustomParam(ctl_templatecatalog);
        String templateType = PaperTemplateService.getTemplateType((String)String.valueOf(catalogId));
        if ((TemplateCatalogEnum.INNERTRADE.getTemplatetype().equals(templateType) || TemplateCatalogEnum.INVELIM.getTemplatetype().equals(templateType)) && kd.bos.util.StringUtils.isNotEmpty((String)number)) {
            if (number.length() >= 45) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc745\u4e2a\u5b57\u7b26\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"PaperTemplatePlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
            if (!BCMNumberRule.checkNumber((String)number)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6a21\u677f\u7f16\u7801\u4e0d\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u4ee5\u5916\u7684\u5b57\u7b26\uff0c\u4e0d\u53ef\u4ee5\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u5f00\u5934\uff0c\u5c0f\u6570\u70b9\u4e4b\u95f4\u5fc5\u987b\u6709\u5176\u4ed6\u5b57\u7b26\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"AdjustPaperTemplatePlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
        if (Objects.equals(operateKey, OPERATION_CONFIRM) && Objects.equals(this.getPageCache().get("explain"), "isexplain") && Objects.nonNull(rap = (RichTextEditor)this.getControl(CTL_RICH_TEXTEDITOR_AP)) && StringUtils.isNotEmpty((CharSequence)rap.getText())) {
            this.setValueOnModel("description", rap.getText());
        }
    }

    private boolean checkTemplateHaveMultiVersion(long groupId) {
        QFilter filter = new QFilter("group", "=", (Object)groupId);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"paper_template_count", (String)"bcm_papertemplate", (String)"id,group", (QFilter[])filter.toArray(), null);){
            boolean bl = dataSet.count("group", false) > 1;
            return bl;
        }
    }

    private void initProcessCombo(List<String> processScope) {
        IDNumberTreeNode processNode;
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(10);
        for (String process : processScope) {
            processNode = MemberReader.findProcessMemberByNum((String)this.getCurModelNumber(), (String)process);
            if (!processNode.isLeaf()) continue;
            items.add(new ComboItem(new LocaleString(processNode.getNumber() + " " + processNode.getName()), InvCaseProcessEnum.getIndex((String)processNode.getNumber())));
        }
        ((ComboEdit)this.getControl(CB_PROCESS)).setComboItems(items);
        if (CollectionUtils.isNotEmpty(items)) {
            processNode = MemberReader.findProcessMemberByNum((String)this.getCurModelNumber(), (String)processScope.get(0));
            this.getModel().setValue(CB_PROCESS, (Object)InvCaseProcessEnum.getIndex((String)processNode.getNumber()));
            this.getModel().setValue(PROCESS, (Object)processNode.getId());
        }
    }

    public DynamicObject getProcess(Long modelId, String ... processNumber) {
        QFBuilder qfBuilder = new QFBuilder(ctl_model, "=", (Object)modelId);
        qfBuilder.add("number", "in", (Object)processNumber);
        qfBuilder.add("isleaf", "=", (Object)true);
        return QueryServiceHelper.queryOne((String)"bcm_processmembertree", (String)"id,number", (QFilter[])qfBuilder.toArray());
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        Object newValue;
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (kd.bos.util.StringUtils.isEmpty((String)key)) {
            return;
        }
        ChangeData changeData = e.getChangeSet()[0];
        if (CB_PROCESS.equals(key)) {
            String newvalue = changeData.getNewValue().toString();
            if (newvalue == null || newvalue.length() <= 0) {
                this.getModel().setValue(CB_PROCESS, changeData.getOldValue());
                return;
            }
            DynamicObject process = this.getProcess(this.getModelId(), InvCaseProcessEnum.getNumber((String)changeData.getNewValue().toString()));
            if (process != null) {
                this.getModel().setValue(PROCESS, (Object)process.getLong("id"));
            }
        } else if (ctr_effectivetext.equals(key)) {
            if (changeData.getNewValue() == null || kd.bos.util.StringUtils.isEmpty((String)changeData.getNewValue().toString())) {
                this.getPageCache().remove(ctr_effectivecache);
            }
        } else if (SCENARIOSET.equals(key) && ((newValue = e.getChangeSet()[0].getNewValue()) == null || kd.bos.util.StringUtils.isBlank((String)newValue.toString()))) {
            this.getPageCache().remove(TMPL_SCENE_CACHE);
            this.getPageCache().remove(TMPL_SCENE_ITEMS);
        }
    }

    private void initShowEffective() {
        String effectivedata = (String)this.getFormCustomParam(ctr_effectivedata);
        if (StringUtils.isNotEmpty((CharSequence)effectivedata)) {
            this.getPageCache().put(ctr_effectivecache, effectivedata);
            String effectiveStr = this.getFormCustomParam(ctr_effectivetext, "");
            this.getModel().setValue(ctr_effectivetext, (Object)effectiveStr);
        }
    }

    private void openExpiredDateF7(String key) {
        long modelIdl = this.getModelId();
        if (0L == modelIdl) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"ConvertSettingPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bcm_expire_date_f7");
        formShowParameter.setParentPageId(this.getView().getPageId());
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u6709\u6548\u671f\u95f4", (String)"ConvertSettingPlugin_28", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)modelIdl);
        formShowParameter.setCustomParam("entryId", (Object)key);
        String data = this.getPageCache().get(ctr_effectivecache);
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)data)) {
            formShowParameter.setCustomParam("effective", (Object)data);
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "ExpiredDate");
        formShowParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getReturnData() == null) {
            return;
        }
        String actionId = closedCallBackEvent.getActionId();
        if ("ExpiredDate".equals(actionId)) {
            String data = (String)this.deSerializedBytes(String.valueOf(closedCallBackEvent.getReturnData()));
            JSONObject obj = JSON.parseObject((String)data);
            this.getModel().setValue(ctr_effectivetext, obj.get((Object)"text"));
            if (kd.bos.util.StringUtils.isNotEmpty((String)obj.getString("effective"))) {
                Map effective = (Map)JSON.parseObject((String)obj.getString("effective"), (TypeReference)new TypeReference<Map<String, Set<Long>>>(){}, (Feature[])new Feature[0]);
                if (effective == null || effective.size() == 0) {
                    this.getPageCache().remove(ctr_effectivecache);
                } else {
                    this.getPageCache().put(ctr_effectivecache, JSON.toJSONString((Object)effective));
                }
            }
        } else if (SCENARIOSET.equals(actionId)) {
            String serialStr = closedCallBackEvent.getReturnData().toString();
            Map tmplScene = (Map)this.deSerializedBytes(serialStr);
            this.getModel().setValue(SCENARIOSET, tmplScene.get("name"));
            this.getPageCache().put(TMPL_SCENE_CACHE, serialStr);
            this.getPageCache().put(TMPL_SCENE_ITEMS, this.toByteSerialized(tmplScene.get("items")));
        }
    }
}

