/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.papertemplate;

import com.google.common.collect.Maps;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.events.CreateListDataProviderListener;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.fi.bcm.common.util.LongUtil;

public class PaperTemplateVersionListPlugin
extends AbstractListPlugin
implements CreateListDataProviderListener {
    private static final String ctl_billlistap = "billlistap";
    private static final String btn_newversion = "newversion";
    private static final String btn_delversion = "delversion";
    private static final String action_modify = "action_modify";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getBillList();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        this.getBillList();
    }

    public void createListDataProvider(BeforeCreateListDataProviderArgs arg0) {
        arg0.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int arg0, int arg1) {
                DynamicObjectCollection superData = super.getData(arg0, arg1);
                return superData;
            }
        });
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (btn_newversion.equals(actionId)) {
            Object returnData = closedCallBackEvent.getReturnData();
            if (returnData != null) {
                IFormView view = this.getView();
                IFormView parentView = view.getParentView();
                if (parentView != null) {
                    view.returnDataToParent(returnData);
                }
                view.close();
            } else {
                BillList billList = this.getBillList();
                billList.refresh();
            }
        } else if (action_modify.equals(actionId)) {
            BillList billList = this.getBillList();
            billList.refresh();
        }
    }

    public BillList getBillList() {
        BillList billList = (BillList)this.getControl(ctl_billlistap);
        billList.addCreateListDataProviderListener(this::createListDataProvider);
        return billList;
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long group = (Long)formShowParameter.getCustomParam("group");
        Long model = (Long)formShowParameter.getCustomParam("model");
        HashMap cus = Maps.newHashMap();
        cus.put("group", group);
        cus.put("model", model);
        if (btn_newversion.equals(itemKey)) {
            if (group != null) {
                cus.put("style", "new");
                String caption = ResManager.loadKDString((String)"\u751f\u6210\u65b0\u7248\u672c", (String)"TplVersionListPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                this.openNewVersionPage(btn_newversion, cus, caption);
            }
        } else if (!btn_delversion.equals(itemKey)) {
            if ("btn_modifyinfo".equals(itemKey)) {
                BillList billList = this.getBillList();
                ListSelectedRowCollection selectedRows = billList.getSelectedRows();
                if (selectedRows.size() <= 0) {
                    String tip = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u4fee\u6539\u7684\u6a21\u677f\u3002", (String)"TplVersionListPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                    this.getView().showTipNotification(tip);
                    return;
                }
                cus.put("pkId", selectedRows.get(0).getPrimaryKeyValue());
                cus.put("style", "modify");
                String caption = ResManager.loadKDString((String)"\u4fee\u6539\u7248\u672c", (String)"TplVersionListPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                this.openNewVersionPage(action_modify, cus, caption);
            } else if ("btn_opentpl".equals(itemKey)) {
                BillList billList = this.getBillList();
                ListSelectedRowCollection selectedRows = billList.getSelectedRows();
                IFormView view = this.getView();
                if (selectedRows.size() <= 0) {
                    String tip = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u6253\u5f00\u7684\u6a21\u677f\u3002", (String)"TplVersionListPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                    view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u6253\u5f00\u7684\u6a21\u677f\u3002", (String)"TplVersionListPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                IFormView parentView = view.getParentView();
                if (parentView != null) {
                    view.returnDataToParent(selectedRows.get(0).getPrimaryKeyValue());
                }
                view.close();
            }
        }
    }

    private void openNewVersionPage(String actionId, Map<String, Object> cus, String caption) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(this.getVersionEditForm());
        formShowParameter.setCustomParams(cus);
        formShowParameter.setCaption(caption);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionId));
        this.getView().showForm(formShowParameter);
    }

    public void setFilter(SetFilterEvent e) {
        if (LongUtil.isvalidLong((Object)this.getView().getFormShowParameter().getCustomParam("group"))) {
            Long group = Long.valueOf(this.getView().getFormShowParameter().getCustomParam("group").toString());
            e.addCustomQFilter(new QFilter("group", "=", (Object)group));
        }
        if (LongUtil.isvalidLong((Object)this.getView().getFormShowParameter().getCustomParam("model"))) {
            Long model = Long.valueOf(this.getView().getFormShowParameter().getCustomParam("model").toString());
            e.addCustomQFilter(new QFilter("model", "=", (Object)model));
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        IFormView view = this.getView();
        IFormView parentView = view.getParentView();
        BillList billList = this.getBillList();
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (parentView != null) {
            view.returnDataToParent(selectedRows.get(0).getPrimaryKeyValue());
        }
        view.close();
    }

    public String getVersionEditForm() {
        return "bcm_papertplversionedit";
    }
}

