/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.papertemplate;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.fi.bcm.business.innertrade.report.IntrTmplImportExportHelper;
import kd.fi.bcm.business.invest.helper.InvTmplImportExportHelper;
import kd.fi.bcm.business.papertemplate.PaperTemplateService;
import kd.fi.bcm.business.papertemplate.PaperTmplImportInfo;
import kd.fi.bcm.business.papertemplate.PaperTmplImportResult;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.enums.TemplateCatalogEnum;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.enums.status.ResultStatusEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.MapInitHelper;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import org.apache.commons.io.IOUtils;

public class PaperTmplImportPlugin
extends AbstractBaseFormPlugin
implements UploadListener {
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, PaperTmplImportPlugin.class);
    private static final String BTNOK = "btnok";
    private static final String CHANGENUM = "changenum";
    private static final String ATTACHMENTPANELAP = "attachmentpanelap";
    private static final String CACHEKEY_FILE_TYPE = "file_type";
    private static final String CACHEKEY_FILE_URL = "file_url";
    private static final String JSON_FILETYPE = "json";
    public static final String TMP_LIST_KEY = "tmpList";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(BTNOK, CHANGENUM);
        AttachmentPanel attach = (AttachmentPanel)this.getControl(ATTACHMENTPANELAP);
        attach.addUploadListener((UploadListener)this);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long modelId = LongUtil.toLong((Object)this.getFormCustomParam("KEY_MODEL_ID"));
        Long catalog = LongUtil.toLong((Object)this.getFormCustomParam("templatecatalog"));
        Long sceneid = LongUtil.toLong((Object)this.getFormCustomParam("KEY_SCENARIO_ID"));
        if (modelId == 0L || catalog == 0L || sceneid == 0L) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u53c2\u6570\u6709\u95ee\u9898\uff0c\u8bf7\u68c0\u67e5\u4f53\u7cfb\u3001\u60c5\u666f\u548c\u6a21\u677f\u5206\u7c7b\u3002", (String)"PaperTmplImportPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            this.getView().setEnable(Boolean.valueOf(false), new String[]{BTNOK});
            return;
        }
        this.getPageCache().put("KEY_MODEL_ID", modelId.toString());
        String templateType = (String)this.getFormCustomParam("templateType");
        this.getView().setVisible(Boolean.valueOf(TemplateCatalogEnum.INVELIM.getTemplatetype().equals(templateType)), new String[]{CHANGENUM});
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Button)evt.getSource()).getKey();
        if (BTNOK.equals(key)) {
            try {
                String jsonString = this.getImportDate();
                Long catalog = LongUtil.toLong((Object)this.getFormCustomParam("templatecatalog"));
                Long sceneid = LongUtil.toLong((Object)this.getFormCustomParam("KEY_SCENARIO_ID"));
                String templateType = PaperTemplateService.getTemplateType((String)catalog.toString());
                if (StringUtils.isBlank((CharSequence)templateType)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5177\u4f53\u7684\u6a21\u677f\u5206\u7c7b\u3002", (String)"PaperTmplImportPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                Map<Object, Object> numberMap = new HashMap(16);
                String tmpListStr = this.getPageCache().get(TMP_LIST_KEY);
                if (StringUtils.isNotEmpty((CharSequence)tmpListStr)) {
                    List tmpList = (List)ObjectSerialUtil.deSerializedBytes((String)tmpListStr);
                    numberMap = tmpList.stream().collect(Collectors.toMap(k -> String.format("%s_%s", k.get("oldtmpnum"), k.get("version")), v -> (String)v.get("importnum"), (e1, e2) -> e1));
                }
                PaperTmplImportResult result = new PaperTmplImportResult();
                if (TemplateCatalogEnum.INNERTRADE.getTemplatetype().equals(templateType)) {
                    result = IntrTmplImportExportHelper.importTmpls((long)this.getModelId(), (Long)sceneid, (Long)catalog, (String)jsonString, numberMap);
                } else if (TemplateCatalogEnum.INVELIM.getTemplatetype().equals(templateType)) {
                    result = InvTmplImportExportHelper.importTmpls((Long)this.getModelId(), (Long)sceneid, (Long)catalog, (String)jsonString, numberMap);
                }
                String title = "";
                StringBuilder message = new StringBuilder();
                if (!CollectionUtils.isEmpty((Collection)result.getSuccessTmpls()) && !CollectionUtils.isEmpty((Collection)result.getFailTmpls())) {
                    title = ResManager.loadKDString((String)"\u90e8\u5206\u6a21\u677f\u5bfc\u5165\u6210\u529f\u3002", (String)"PaperTmplImportPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                    message.append(String.format(ResManager.loadKDString((String)"\u6210\u529f\u4e2a\u6570\uff1a%1$s \u5931\u8d25\u4e2a\u6570\uff1a%2$s", (String)"PaperTmplImportPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), result.getSuccessTmpls().size(), result.getFailTmpls().size()));
                    message.append("\r\n");
                    message.append("\r\n");
                } else if (!CollectionUtils.isEmpty((Collection)result.getFailTmpls())) {
                    title = ResManager.loadKDString((String)"\u6a21\u677f\u5bfc\u5165\u5931\u8d25\u3002", (String)"PaperTmplImportPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                } else if (!CollectionUtils.isEmpty((Collection)result.getSuccessTmpls())) {
                    title = ResManager.loadKDString((String)"\u5168\u90e8\u6a21\u677f\u5bfc\u5165\u6210\u529f\u3002", (String)"PaperTmplImportPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                }
                if (!CollectionUtils.isEmpty((Collection)result.getNeedUpdateTmpls())) {
                    message.append(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a[%s]\u7684\u6a21\u677f\u5bfc\u5165\u6210\u529f\uff0c\u4f46\u9700\u8981\u7ef4\u62a4\u7248\u672c\u7684\u751f\u6548\u65e5\u671f\uff0c\u8bf7\u70b9\u51fb\u7248\u672c\u5316\u6309\u94ae\u8fdb\u884c\u7ef4\u62a4\u3002", (String)"PaperTmplImportPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", result.getNeedUpdateTmpls().stream().map(PaperTmplImportInfo::getNumber).collect(Collectors.toSet()))));
                    message.append("\r\n");
                }
                if (!CollectionUtils.isEmpty((Collection)result.getFailTmpls())) {
                    message.append(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\u7684\u539f\u56e0\u5982\u4e0b\uff1a", (String)"PaperTmplImportPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    message.append("\r\n");
                    for (PaperTmplImportInfo failTmpl : result.getFailTmpls()) {
                        message.append(String.format("%s-V%s\uff1a%s", failTmpl.getNumber(), failTmpl.getVersion(), failTmpl.getFailMsg()));
                        message.append("\r\n");
                    }
                }
                this.writeImportLog(result);
                this.getView().showMessage(title, message.toString(), null);
                this.getView().close();
            }
            catch (Exception e) {
                log.error("invest template import error", (Throwable)e);
                throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\u3002", (String)"PaperTmplImportPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        } else if (CHANGENUM.equals(key)) {
            FormShowParameter showParameter = new FormShowParameter();
            String tmpListStr = this.getPageCache().get(TMP_LIST_KEY);
            if (StringUtils.isNotEmpty((CharSequence)tmpListStr)) {
                showParameter.setCustomParam(TMP_LIST_KEY, (Object)tmpListStr);
            } else {
                String jsonString = this.getImportDate();
                String templateType = (String)this.getFormCustomParam("templateType");
                showParameter.setCustomParam(TMP_LIST_KEY, (Object)ObjectSerialUtil.toByteSerialized(this.deSerializedTmpl(jsonString, templateType)));
            }
            showParameter.setFormId("bcm_invimpnumsetting");
            showParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CHANGENUM));
            this.getView().showForm(showParameter);
        }
    }

    private List<Map<String, String>> deSerializedTmpl(String jsonString, String templateType) {
        List<Map<String, String>> tmpList = new ArrayList<Map<String, String>>(16);
        try {
            if (TemplateCatalogEnum.INNERTRADE.getTemplatetype().equals(templateType)) {
                List tmpls = (List)ObjectSerialUtil.deSerializedBytes((String)jsonString);
                tmpList = tmpls.stream().map(e -> MapInitHelper.ofMap((Object)"oldtmpnum", (Object)e.getNumber(), (Object)"version", (Object)e.getVersionNumber(), (Object)"importnum", (Object)e.getNumber())).collect(Collectors.toList());
            } else if (TemplateCatalogEnum.INVELIM.getTemplatetype().equals(templateType)) {
                List tmpls = (List)ObjectSerialUtil.deSerializedBytes((String)jsonString);
                tmpList = tmpls.stream().map(e -> MapInitHelper.ofMap((Object)"oldtmpnum", (Object)e.getNumber(), (Object)"version", (Object)e.getVersionNumber(), (Object)"importnum", (Object)e.getNumber())).collect(Collectors.toList());
            }
            return tmpList;
        }
        catch (Exception e2) {
            log.error("intr template import error.", (Throwable)e2);
            throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\u6216\u5df2\u635f\u574f\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PaperTmplImportPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private String getImportDate() {
        TempFileCacheDownloadable fileCache = (TempFileCacheDownloadable)CacheFactory.getCommonCacheFactory().getTempFileCache();
        String fileUrl = this.getPageCache().get(CACHEKEY_FILE_URL);
        if (fileUrl == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u4e0a\u4f20\u5bfc\u5165\u6570\u636e\u3002", (String)"PaperTmplImportPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        this.checkFileType();
        String[] reqParams = new String[]{};
        try {
            reqParams = new URL(fileUrl).getQuery().split("&");
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\u3002", (String)"PaperTmplImportPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0])), new Object[0]);
        }
        HashMap<String, String> map = new HashMap<String, String>(reqParams.length);
        for (String param : reqParams) {
            String[] p = param.split("=");
            map.put(p[0], p[1]);
        }
        TempFileCacheDownloadable.Content content = fileCache.get((String)map.get("configKey"), (String)map.get("id"));
        InputStream inputStream = content.getInputStream();
        return this.getStringFromInputStream(inputStream);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Object returnData;
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if (CHANGENUM.equals(actionId) && (returnData = event.getReturnData()) != null) {
            this.getPageCache().put(TMP_LIST_KEY, ObjectSerialUtil.toByteSerialized((Object)returnData));
        }
    }

    private void writeImportLog(PaperTmplImportResult result) {
        if (!CollectionUtils.isEmpty((Collection)result.getSuccessTmpls())) {
            String successLog = result.getSuccessTmpls().stream().map(e -> String.format("%s_%s", e.getNumber(), e.getName())).collect(Collectors.joining(" "));
            OperationLogUtil.writeOperationLog((String)OpItemEnum.IMPORT.getName(), (String)(successLog + " " + OpItemEnum.IMPORT.getName() + ResultStatusEnum.SUCCESS.getName()), (Long)this.getModelId(), (String)"bcm_invtmplimport");
        }
        if (!CollectionUtils.isEmpty((Collection)result.getFailTmpls())) {
            String failLog = result.getFailTmpls().stream().map(e -> String.format("%s_%s", e.getNumber(), e.getName())).collect(Collectors.joining(" "));
            OperationLogUtil.writeOperationLog((String)OpItemEnum.IMPORT.getName(), (String)(failLog + " " + OpItemEnum.IMPORT.getName() + ResultStatusEnum.FAIL.getName()), (Long)this.getModelId(), (String)"bcm_invtmplimport");
        }
    }

    private String getStringFromInputStream(InputStream inputStream) {
        StringWriter writer = new StringWriter();
        try {
            IOUtils.copy((InputStream)inputStream, (Writer)writer, (String)StandardCharsets.UTF_8.name());
        }
        catch (IOException e) {
            log.error("invest template import io error", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"IO\u5f02\u5e38", (String)"PaperTmplImportPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        return writer.toString();
    }

    private void checkFileType() {
        String type = this.getPageCache().get(CACHEKEY_FILE_TYPE);
        if (type != null && !JSON_FILETYPE.equals(type)) {
            this.writeLog(false);
            throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\u6216\u5df2\u635f\u574f\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PaperTmplImportPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private void writeLog(boolean isSuccess) {
        OperationLogUtil.writeOperationLog((String)OpItemEnum.IMPORT.getName(), (String)String.format(ResManager.loadKDString((String)"\u6743\u76ca\u62b5\u9500\u6a21\u677f\u5bfc\u5165%s", (String)"PaperTmplImportPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]), isSuccess ? ResultStatusEnum.SUCCESS.getName() : ResultStatusEnum.FAIL.getName()), (Long)this.getModelId(), (String)"bcm_templateimport");
    }

    public void afterUpload(UploadEvent evt) {
        for (Object url : evt.getUrls()) {
            this.getPageCache().put(CACHEKEY_FILE_URL, (String)((Map)url).get("url"));
            this.getPageCache().put(CACHEKEY_FILE_TYPE, (String)((Map)url).get("type"));
        }
    }

    public void afterRemove(UploadEvent evt) {
        this.getPageCache().remove(CACHEKEY_FILE_URL);
        this.getPageCache().remove(CACHEKEY_FILE_TYPE);
        this.getPageCache().remove(TMP_LIST_KEY);
    }
}

