/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.papertemplate;

import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.papertemplate.PaperTemplateService;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.common.constant.invest.invsheet.InvSheetDistributeConstant;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.TemplateCatalogEnum;
import kd.fi.bcm.common.util.BCMTreeUtils;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ThrowableHelper;

public class TemplateAssignPlugin
extends AbstractFormPlugin {
    public static final String CTL_ENTITY = "dentity";
    public static final String CTL_MODEL = "model";
    public static final String RANGEVALUE = "rangevalue";
    public static final String TEMPLATEIDS = "templeteids";
    public static final String CTL_CATALOGTREE = "temcatalogtree";
    public static final String CTL_BILLLISTAP = "billlistap";

    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getView().getControl(CTL_BILLLISTAP);
        billList.setBillFormId(this.getBillForm());
        this.addListeners();
    }

    private void addListeners() {
        this.addClickListeners(new String[]{"btn_selectentity", "btn_deleteentity", "btn_unassign", "btn_detail"});
        this.addItemClickListeners(new String[]{"toolbarap"});
        TreeView tree = (TreeView)this.getControl(CTL_CATALOGTREE);
        tree.addTreeNodeCheckListener(this::treeNodeCheck);
        EntryGrid orgEntry = (EntryGrid)this.getControl(CTL_ENTITY);
        orgEntry.addRowClickListener(new RowClickEventListener(){

            public void entryRowClick(RowClickEvent evt) {
                super.entryRowClick(evt);
                TemplateAssignPlugin.this.refreshBillList();
            }
        });
        BillList billList = (BillList)this.getView().getControl(CTL_BILLLISTAP);
        billList.addSetFilterListener(evt -> {
            List filters = evt.getQFilters();
            QFilter filter1 = this.getTemQueryFilter(CTL_CATALOGTREE, "template");
            QFilter filter2 = this.getOrgQueryFilter(CTL_ENTITY, "oid", "entity");
            String longnumber = PaperTemplateService.getTemplateLongnumber((String)this.getPageCache().get("focusnodeid"));
            QFilter filter3 = new QFilter("template.templatecatalog.longnumber", "like", (Object)(longnumber + "%"));
            if (filter1 == null && filter2 == null) {
                filters.add(new QFilter("1", "!=", (Object)1));
            } else if (filter1 == null) {
                filters.add(filter2);
            } else if (filter2 == null) {
                filters.add(filter1);
            } else {
                filters.add(filter1.and(filter2));
            }
            filters.add(filter3);
        });
        billList.addCreateListColumnsListener(listener -> {
            List listCol = listener.getListColumns();
            String viewid = (String)this.getModel().getValue("viewcombo");
            if (!viewid.equals("10") && viewid.equals("20")) {
                Collections.swap(listCol, 0, 3);
                Collections.swap(listCol, 2, 4);
            }
        });
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (c.getKey().toLowerCase(Locale.ENGLISH)) {
            case "btn_selectentity": {
                this.actionSelectOrg();
                break;
            }
            case "btn_deleteentity": {
                this.actionDeleteOrg();
                break;
            }
            case "btn_unassign": {
                this.actionUnAssign();
                break;
            }
            case "btn_detail": {
                this.actionViewDetail();
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("btn_assign".equals(key)) {
            this.actionAssign();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if ("viewcombo".equals(key)) {
            BillList billlist = (BillList)this.getControl(CTL_BILLLISTAP);
            List listCol = billlist.getShowListColumns();
            Collections.swap(listCol, 0, 3);
            Collections.swap(listCol, 2, 4);
            billlist.refresh();
            billlist.clearSelection();
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String modelid = (String)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        this.getPageCache().put("KEY_MODEL_ID", modelid);
        String foucusId = (String)this.getView().getFormShowParameter().getCustomParam("focusnodeid");
        this.getPageCache().put("focusnodeid", foucusId);
        if (!StringUtils.isEmpty((CharSequence)modelid)) {
            this.setTemplateDate2View(Long.valueOf(modelid));
        }
        this.setRangeAndExcept();
        FilterParameter fp = new FilterParameter();
        QFilter filter = new QFilter(CTL_MODEL, "=", (Object)LongUtil.toLong((Object)modelid));
        fp.setFilter(filter);
        BillList billList = (BillList)this.getControl(CTL_BILLLISTAP);
        billList.setFilterParameter(fp);
        this.refreshBillList();
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        DynamicObjectCollection olddoc = this.getModel().getEntryEntity(CTL_ENTITY);
        if ("ccb_selectmember".equals(actionId) && e.getReturnData() != null) {
            DynamicObjectCollection newdoc = (DynamicObjectCollection)e.getReturnData();
            this.selectOrgMember(olddoc, newdoc);
            this.refreshBillList();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        BillList billlist;
        ListSelectedRowCollection listrows;
        Object[] rows;
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        if ("delete_confirm".equals(callBackId) && e.getResult().equals((Object)MessageBoxResult.Yes) && Objects.nonNull(rows = (listrows = (billlist = (BillList)this.getControl(CTL_BILLLISTAP)).getSelectedRows()).getPrimaryKeyValues()) && rows.length != 0) {
            PaperTemplateService.deleteDistRecord((Object[])rows, (long)this.getModelId());
            this.refreshBillList();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53cd\u5206\u914d\u5b8c\u6210\u3002", (String)"DistributionPlugin_19", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private void selectOrgMember(DynamicObjectCollection oldDoc, DynamicObjectCollection newDoc) {
        IDataModel model = this.getModel();
        HashSet<Integer> list = new HashSet<Integer>(10);
        EntryGrid eg = (EntryGrid)this.getControl(CTL_ENTITY);
        int[] rows = eg.getSelectRows();
        for (DynamicObject newOne : newDoc) {
            boolean isexist = false;
            for (DynamicObject oldOne : oldDoc) {
                if (!newOne.get("mid1").equals(oldOne.get("oid")) || !newOne.get("filltypevalue1").equals(oldOne.get(RANGEVALUE))) continue;
                isexist = true;
                break;
            }
            if (isexist) continue;
            int index = model.createNewEntryRow(CTL_ENTITY);
            model.setValue("entity", newOne.get(3), index);
            model.setValue(RANGEVALUE, newOne.get(5), index);
            model.setValue("oid", newOne.get(4), index);
            model.setValue("pid", newOne.get(6), index);
            list.add(index);
        }
        for (Object t : (Object)rows) {
            list.add((int)t);
        }
        if (list.isEmpty()) {
            return;
        }
        rows = new int[list.size()];
        int index = 0;
        for (Integer row : list) {
            rows[index++] = row;
        }
        eg.selectRows(rows, rows[0]);
    }

    private void refreshBillList() {
        BillList billlist = (BillList)this.getControl(CTL_BILLLISTAP);
        billlist.refresh();
        billlist.clearSelection();
    }

    private QFilter getTemQueryFilter(String entityId, String columnName) {
        List<String> rows = this.getTemSelectedAndResultList(entityId);
        QFilter filter = null;
        if (!rows.isEmpty()) {
            filter = new QFilter(columnName, "in", (Object)LongUtil.toLongList(rows));
        }
        return filter;
    }

    private List<String> getTemSelectedAndResultList(String entityId) {
        TreeView tree = (TreeView)this.getControl(entityId);
        List<String> tids = tree.getTreeState().getSelectedNodeId();
        if (tids.isEmpty()) {
            String cache = this.getPageCache().get(TEMPLATEIDS);
            tids = StringUtils.isNotEmpty((CharSequence)cache) ? (List)SerializationUtils.fromJsonString((String)cache, List.class) : new ArrayList(10);
        } else {
            this.getPageCache().put(TEMPLATEIDS, SerializationUtils.toJsonString((Object)tids));
        }
        List noPermCatalogIds = (List)this.getView().getFormShowParameter().getCustomParam("noPermCatalogIds");
        DynamicObjectCollection doc = PaperTemplateService.getTemplatecatalogList((long)this.getModelId(), (List)noPermCatalogIds);
        LinkedList<String> clist = new LinkedList<String>();
        for (DynamicObject dd : doc) {
            clist.add(dd.getString("id"));
        }
        tids.removeAll(clist);
        return tids;
    }

    private QFilter getOrgQueryFilter(String entityId, String idName, String columnName) {
        List<DynamicObject> orglist = this.getOrgSelectedAndResultList(entityId);
        Set orgids = orglist.stream().map(e -> e.getLong("oid")).collect(Collectors.toSet());
        QFBuilder qf = new QFBuilder();
        qf.add(CTL_MODEL, "=", (Object)this.getModelId());
        qf.add("id", "in", orgids);
        HashMap idMap = new HashMap(orgids.size());
        QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id, copyfrom.id", (QFilter[])qf.toArray()).forEach(e -> {
            long baseId = e.getLong("copyfrom.id");
            Long id = e.getLong("id");
            if (baseId != 0L) {
                idMap.put(id, baseId);
            } else {
                idMap.put(id, id);
            }
        });
        LinkedList mrows = new LinkedList();
        LinkedList<Long> lrows = new LinkedList<Long>();
        for (DynamicObject org : orglist) {
            if (StringUtils.isEmpty((CharSequence)org.getString("pid").trim())) {
                mrows.add(idMap.get(Long.valueOf(org.get(idName).toString())));
                continue;
            }
            lrows.add(org.getLong(idName));
        }
        QFilter filter = null;
        if (!mrows.isEmpty()) {
            filter = new QFilter(columnName, "in", (Object)mrows.toArray());
        }
        if (!lrows.isEmpty()) {
            QFilter filter2 = new QFilter("propertyvalue", "in", (Object)lrows.toArray());
            filter = filter == null ? filter2 : filter.or(filter2);
        }
        return filter;
    }

    private List<DynamicObject> getOrgSelectedAndResultList(String entityId) {
        EntryGrid eg = (EntryGrid)this.getControl(entityId);
        int[] rows = eg.getEntryState().getSelectedRows();
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(10);
        for (int row : rows) {
            DynamicObject dd = this.getModel().getEntryRowEntity(entityId, row);
            if (dd == null) continue;
            list.add(dd);
        }
        return list;
    }

    private void actionSelectOrg() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bcm_mulmemberf7base_dis");
        formShowParameter.setCustomParam("dimension", (Object)"1");
        formShowParameter.setCustomParam("templatetype", (Object)PaperTemplateService.getTemplateType((String)this.getPageCache().get("focusnodeid")));
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u6210\u5458\u9009\u62e9 - \u7ec4\u7ec7", (String)"DistributionPlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "ccb_selectmember");
        formShowParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(formShowParameter);
    }

    private void actionDeleteOrg() {
        EntryGrid eg = (EntryGrid)this.getControl(CTL_ENTITY);
        int[] row = eg.getEntryState().getSelectedRows();
        if (row.length < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u64cd\u4f5c\u6570\u636e\u884c\u3002", (String)"DistributionPlugin_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().deleteEntryRows(CTL_ENTITY, row);
        this.refreshBillList();
    }

    private void actionUnAssign() {
        BillList billlist = (BillList)this.getControl(CTL_BILLLISTAP);
        ListSelectedRowCollection list = billlist.getSelectedRows();
        if (list.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u53cd\u5206\u914d\u8bb0\u5f55\u7684\u6570\u636e\u884c\u3002", (String)"DistributionPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u662f\u5426\u53cd\u5206\u914d\u3002", (String)"DistributionPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("delete_confirm", (IFormPlugin)this));
    }

    private void actionAssign() {
        List<String> tplList = this.getTemSelectedAndResultList(CTL_CATALOGTREE);
        List<DynamicObject> orgList = this.getOrgSelectedAndResultList(CTL_ENTITY);
        if (tplList.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5206\u914d\u7684\u6a21\u677f\u3002", (String)"DistributionPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (orgList.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5206\u914d\u7684\u7ec4\u7ec7\u3002", (String)"DistributionPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        String msg = this.removeOrgMemberTemplate(tplList);
        List tplIds = PaperTemplateService.isTemplateType((String)this.getPageCache().get("focusnodeid"), (String)TemplateCatalogEnum.PRTADJUST.getNumber()) ? LongUtil.toLongList(tplList) : PaperTemplateService.getSameGroup(tplList, (Long)this.getModelId());
        PaperTemplateService.saveDistributeRecord(orgList, (List)tplIds, (long)this.getModelId(), (String)msg);
        this.refreshBillList();
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5206\u914d\u6210\u529f\u3002", (String)"DistributionPlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }

    private String removeOrgMemberTemplate(List<String> tplList) {
        List tplIds;
        String orgIds = this.getPageCache().get("orgids");
        if (StringUtils.isNotEmpty((CharSequence)orgIds) && tplList.removeAll(tplIds = (List)SerializationUtils.fromJsonString((String)orgIds, List.class))) {
            return String.format(ResManager.loadKDString((String)"\u5df2\u8df3\u8fc7\u7ec4\u7ec7\u7ef4\u5ea6\u540d\u79f0\u201c%s\u201d\u5728\u89c6\u70b9\u7ef4\u7684\u62a5\u8868\u6a21\u677f\u3002", (String)"DistributionPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]), this.getEntityByNumber().getString("name"));
        }
        return "";
    }

    private DynamicObject getEntityByNumber() {
        QFilter filter1 = new QFilter(CTL_MODEL, "=", (Object)this.getModelId());
        QFilter filter2 = new QFilter("number", "=", (Object)"Entity");
        QFilter[] filters = new QFilter[]{filter1, filter2};
        return QueryServiceHelper.queryOne((String)"bcm_dimension", (String)"name", (QFilter[])filters);
    }

    private void actionViewDetail() {
        BillList billlist = (BillList)this.getControl(CTL_BILLLISTAP);
        FormShowParameter param = new FormShowParameter();
        param.setFormId(this.getTemplateAssignDetailEntityName());
        param.setCaption(ResManager.loadKDString((String)"\u6a21\u677f\u5206\u914d\u8be6\u60c5", (String)"DistributionPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        Object[] ids = billlist.getSelectedRows().getPrimaryKeyValues().length < 1 ? billlist.getCurrentListAllRowCollection().getPrimaryKeyValues() : billlist.getSelectedRows().getPrimaryKeyValues();
        param.setCustomParam("ids", (Object)SerializationUtils.toJsonString((Object)ids));
        param.setCustomParam("modelid", (Object)this.getPageCache().get("KEY_MODEL_ID"));
        param.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(param);
    }

    private void setTemplateDate2View(Long modelId) {
        DynamicObjectCollection tplList = this.getTemplateColl(modelId);
        Object[] dynamicObjects = new DynamicObject[]{};
        if (PaperTemplateService.isTemplateType((String)this.getPageCache().get("focusnodeid"), (String)TemplateCatalogEnum.PRTADJUST.getNumber())) {
            dynamicObjects = (DynamicObject[])tplList.toArray(dynamicObjects);
        } else {
            Map filterdlist = tplList.stream().collect(Collectors.toMap(s -> s.getString("group"), s -> s, (a, b) -> a.getBigDecimal("versionnumber").compareTo(b.getBigDecimal("versionnumber")) > 0 ? a : b, LinkedHashMap::new));
            dynamicObjects = (DynamicObject[])filterdlist.values().toArray(dynamicObjects);
        }
        Long catalogId = LongUtil.toLong((Object)this.getPageCache().get("focusnodeid"));
        DynamicObject catalogObj = BusinessDataServiceHelper.loadSingle((Object)catalogId, (String)this.getTemplateCatalogEntityName(), (String)"id,number,name,longnumber");
        List noPermCatalogIds = (List)this.getView().getFormShowParameter().getCustomParam("noPermCatalogIds");
        TreeNode rootview = PaperTemplateService.getTemplateTree((DynamicObject)catalogObj, (long)this.getModelId(), (DynamicObject[])dynamicObjects, new ArrayList(10), (String)"0", (TreeNode)new TreeNode(), (List)noPermCatalogIds);
        TreeView tree = (TreeView)this.getControl(CTL_CATALOGTREE);
        BCMTreeUtils.spreadAllNode((TreeNode)rootview);
        List rows = (List)this.getView().getFormShowParameter().getCustomParam("rows");
        ArrayList orgIds = new ArrayList(10);
        ArrayList<TreeNode> selNodes = new ArrayList<TreeNode>(10);
        for (Object dd : dynamicObjects) {
            if (rows == null || !rows.contains(dd.getLong("group")) && !rows.contains(dd.getLong("id"))) continue;
            TreeNode node = rootview.getTreeNode(dd.getString("id"), 10);
            selNodes.add(node);
        }
        tree.addNode(rootview);
        if (!selNodes.isEmpty()) {
            tree.checkNodes(selNodes);
            this.getPageCache().put(TEMPLATEIDS, SerializationUtils.toJsonString(selNodes.stream().map(selNode -> selNode.getId()).collect(Collectors.toList())));
        }
        this.getPageCache().put("orgids", SerializationUtils.toJsonString(orgIds));
    }

    private DynamicObjectCollection getTemplateColl(Long modelId) {
        ArrayListMultimap map;
        List noPermIds;
        QFilter filter = new QFilter(CTL_MODEL, "=", (Object)modelId);
        Object pks = this.getView().getFormShowParameter().getCustomParam("tpks");
        if (pks != null) {
            filter.and("id", "in", pks);
        }
        boolean modelManager = MemberPermHelper.isModelManager((Long)modelId);
        QFilter fpermfilter = new QFilter("1", "=", (Object)1);
        if (!modelManager && !CollectionUtils.isEmpty((Collection)(noPermIds = (map = PermClassEntityHelper.getPermissionMap((String)"bcm_papertemplate", (String)String.valueOf(this.getModelId()), (String)String.valueOf(RequestContext.get().getUserId()))).get((Object)"1")))) {
            fpermfilter = new QFilter("id", "not in", (Object)noPermIds);
        }
        QFilter[] filters = new QFilter[]{filter, fpermfilter};
        String selectFields = "id, name, number,templatecatalog,templatecatalog.longnumber,versionnumber,group";
        return QueryServiceHelper.query((String)this.getTemplateEntityName(), (String)selectFields, (QFilter[])filters, (String)"number asc,sequence asc");
    }

    private void setRangeAndExcept() {
        try {
            ComboEdit rangeEntity = (ComboEdit)this.getControl(RANGEVALUE).clone();
            ArrayList<ComboItem> items = new ArrayList<ComboItem>(6);
            if (PaperTemplateService.isTemplateType((String)this.getPageCache().get("focusnodeid"), (String)TemplateCatalogEnum.INVELIM.getNumber())) {
                InvSheetDistributeConstant.MemRangeComboEnum[] comboEnums;
                for (InvSheetDistributeConstant.MemRangeComboEnum comboEnum : comboEnums = InvSheetDistributeConstant.MemRangeComboEnum.values()) {
                    RangeEnum rangeByNumberOrName = RangeEnum.getRangeByNumberOrName((String)comboEnum.getCode());
                    items.add(new ComboItem(new LocaleString(rangeByNumberOrName.getName()), comboEnum.getCode()));
                }
                rangeEntity.setComboItems(items);
            } else if (PaperTemplateService.isTemplateType((String)this.getPageCache().get("focusnodeid"), (String)TemplateCatalogEnum.INNERTRADE.getNumber())) {
                items.add(new ComboItem(new LocaleString(RangeEnum.VALUE_10.getName()), RangeEnum.VALUE_10.getValue() + ""));
                items.add(new ComboItem(new LocaleString(RangeEnum.VALUE_110.getName()), RangeEnum.VALUE_110.getValue() + ""));
                rangeEntity.setComboItems(items);
            }
        }
        catch (Exception e) {
            throw new KDBizException(ThrowableHelper.toString((Exception)e));
        }
    }

    public void treeNodeCheck(TreeNodeCheckEvent evt) {
        TreeView source = (TreeView)evt.getSource();
        List tids = source.getTreeState().getSelectedNodeId();
        if (tids.isEmpty()) {
            this.getPageCache().remove(TEMPLATEIDS);
        } else {
            this.getPageCache().put(TEMPLATEIDS, SerializationUtils.toJsonString((Object)tids));
        }
        this.refreshBillList();
    }

    private Long getModelId() {
        return ConvertUtil.convertStrToLong((String)this.getPageCache().get("KEY_MODEL_ID"));
    }

    public String getBillForm() {
        return "bcm_templateassignrecord";
    }

    public String getTemplateCatalogEntityName() {
        return "bcm_papertemplatecatalog";
    }

    public String getTemplateEntityName() {
        return "bcm_papertemplate";
    }

    public String getTemplateAssignDetailEntityName() {
        return "bcm_templateassigndetail";
    }

    public String getBizEntityNumber() {
        return this.getModel().getDataEntityType().getName();
    }
}

