/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.papertemplate;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.fi.bcm.business.papertemplate.PaperTemplateHelper;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.papertemplate.PaperTemplateSceneSettingHelper;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.MapInitHelper;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import org.apache.commons.lang3.StringUtils;

public class TemplateMutiScenceSetPlugin
extends AbstractBaseFormPlugin {
    private static final String SCENARIO = "scenario";
    private static final String SCOPE = "scope";
    public static final String ENTRYENTITY = "entryentity";
    private static Set<String> dimKeys = Sets.newHashSet((Object[])new String[]{"scenario"});

    @Override
    public void initialize() {
        super.initialize();
        HashMap map = new HashMap();
        this.asMapF7toType(new ArrayList<String>(dimKeys), SingleF7TypeEnum.LEAF, map);
        this.initSingleMemberF7(map);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("btn_cancel", "btn_confirm");
        BasedataEdit scenario = (BasedataEdit)this.getControl(SCENARIO);
        scenario.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        String name = beforeF7SelectEvent.getProperty().getName();
        if (SCENARIO.equals(name)) {
            QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId());
            if (beforeF7SelectEvent.getFormShowParameter() instanceof ListShowParameter) {
                ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
                qFilters.add(qFilter);
                formShowParameter.setFormId("bos_listf7");
                formShowParameter.getListFilterParameter().getQFilters().addAll(qFilters);
            } else {
                FormShowParameter formShowParameter = beforeF7SelectEvent.getFormShowParameter();
                formShowParameter.setFormId("bos_listf7");
                formShowParameter.setCustomParam("customFilter", (Object)qFilter.toSerializedString());
            }
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btn_confirm".equals(key)) {
            DynamicObjectCollection settings = this.getModel().getEntryEntity(ENTRYENTITY);
            HashMap<String, Object> result = new HashMap<String, Object>(16);
            ArrayList<Map> items = new ArrayList<Map>(16);
            StringJoiner stringJoiner = new StringJoiner(";");
            HashSet<String> configSet = new HashSet<String>(16);
            for (DynamicObject dyn : settings) {
                Long scenarioId = dyn.getLong("scenario.id");
                String scope = dyn.getString(SCOPE);
                String isexcept = dyn.getString("isexcept");
                if (!LongUtil.isvalidLong((Object)scenarioId)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60c5\u666f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TemplateMutiScenceSetPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                String configStr = scope + "_" + isexcept + "_" + scenarioId;
                if (!configSet.add(configStr)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u591a\u60c5\u666f\u914d\u7f6e\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u3002", (String)"TemplateMutiScenceSetPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                items.add(MapInitHelper.ofMap((Object)"id", (Object)scenarioId, (Object)SCOPE, (Object)scope, (Object)"isexcept", (Object)isexcept));
                stringJoiner.add(PaperTemplateSceneSettingHelper.formateDisplay((String)dyn.getString("scenario.number"), (String)dyn.getString("scenario.name"), (String)scope, (String)isexcept));
            }
            List sceneList = settings.stream().map(d -> {
                HashMap<String, Object> item = new HashMap<String, Object>();
                item.put("id", d.getLong("scenario.id"));
                item.put("number", d.getString("scenario.number"));
                item.put(SCOPE, d.getString(SCOPE));
                item.put("isleaf", d.getBoolean("scenario.isleaf"));
                item.put("isexcept", d.getString("isexcept"));
                return item;
            }).collect(Collectors.toList());
            if (!PaperTemplateHelper.checkEffectiveScenario((long)this.getModelId(), sceneList)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u60c5\u666f\u89e3\u6790\u540e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u3002", (String)"TemplateMutiScenceSetPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            result.put("name", stringJoiner.toString());
            result.put("items", items);
            this.returnDataToParent(result);
            this.getView().close();
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String selecteditems = (String)formShowParameter.getCustomParam("selecteditems");
        Long model = (Long)formShowParameter.getCustomParam("model");
        this.getPageCache().put("KEY_MODEL_ID", String.valueOf(model));
        if (StringUtils.isNotBlank((CharSequence)selecteditems)) {
            this.getModel().deleteEntryData(ENTRYENTITY);
            List sceneList = (List)this.deSerializedBytes(selecteditems);
            if (!CollectionUtils.isEmpty((Collection)sceneList)) {
                this.getModel().batchCreateNewEntryRow(ENTRYENTITY, sceneList.size());
                for (int i = 0; i < sceneList.size(); ++i) {
                    Map scene = (Map)sceneList.get(i);
                    this.getModel().setValue(SCENARIO, scene.get("id"), i);
                    this.getModel().setValue(SCOPE, scene.get(SCOPE), i);
                    this.getModel().setValue("isexcept", scene.get("isexcept"), i);
                }
            }
        }
    }
}

