/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.papertemplate.adjust;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.ReflectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.innertrade.model.IntrField;
import kd.fi.bcm.business.innertrade.model.IntrTplDimScope;
import kd.fi.bcm.business.innertrade.report.IntrTemplateHelper;
import kd.fi.bcm.business.innertrade.report.QueryIntrDataHelper;
import kd.fi.bcm.business.permission.perm.PermissionService;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.util.BCMNumberRule;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportHelper;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportOperateType;
import kd.fi.bcm.formplugin.impexport.BillResult;
import kd.fi.bcm.formplugin.util.AdjustCatalogUtil;

public class AdjSettingBatchImportPlugin
extends BatchImportPlugin {
    private static final Log log = LogFactory.getLog(AdjSettingBatchImportPlugin.class);
    public static final String M_CUR = "$Cur";
    public static final String M_BTN = "Bn()";
    private Long modelId = 0L;
    private String modelShowNum = "";
    private Long templateId = 0L;
    private DynamicObject template;
    private Map<String, String> fieldMap = new HashMap<String, String>(16);
    private List<String> businessTypeList = new ArrayList<String>(16);
    private List<String> processNumList = Arrays.asList("ADJ", "CADJ", "CCADJ", "EJE", "EICA", "EOE", "EOther", "EIT", "ECF");
    private Map<String, String> userDefineDimNumMap = new HashMap<String, String>(16);
    private Map<String, IDNumberTreeNode> memberReaderCache = new HashMap<String, IDNumberTreeNode>(16);
    private Set<String> existNumberSet = new HashSet<String>(16);
    private Map<String, Long> adjustCatalogMap = new HashMap<String, Long>(16);
    private Map<String, Map<String, Long>> extFieldLinkDimMap = new HashMap<String, Map<String, Long>>(16);

    protected int getBatchImportSize() {
        return 1000;
    }

    protected boolean isForceBatch() {
        return true;
    }

    public String getDefaultImportType() {
        return super.getDefaultImportType();
    }

    public String getDefaultKeyFields() {
        return "number";
    }

    public List<String> getDefaultLockUIs() {
        ArrayList<String> lockUIs = new ArrayList<String>(2);
        lockUIs.add("keyfields");
        return lockUIs;
    }

    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        super.beforeSave(billdatas, logger);
        this.initParam();
    }

    private void initParam() {
        try {
            IFormView parentView;
            Class<?> aClass = this.ctx.getClass();
            Field view = aClass.getDeclaredField("view");
            ReflectionUtils.makeAccessible((Field)view);
            IFormView formView = (IFormView)view.get(this.ctx);
            if (formView != null && (parentView = formView.getParentView()) != null) {
                List eunmList;
                this.modelId = LongUtil.toLong((Object)parentView.getPageCache().get("KEY_MODEL_ID"));
                this.modelShowNum = MemberReader.findModelSNumberById((Object)this.modelId);
                DynamicObjectCollection dimDyns = QueryServiceHelper.query((String)"bcm_dimension", (String)"id,number,name,membermodel,issysdimension,fieldmapped,shortnumber,dseq", (QFilter[])new QFilter("model", "=", (Object)this.modelId).toArray(), (String)"dseq");
                dimDyns.forEach(e -> {
                    if (!e.getBoolean("issysdimension")) {
                        this.userDefineDimNumMap.put(e.getString("fieldmapped"), e.getString("number"));
                    }
                });
                this.templateId = LongUtil.toLong((Object)parentView.getPageCache().get("templateid"));
                this.template = QueryServiceHelper.queryOne((String)"bcm_papertemplate", (String)"id,number,versionnumber", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)this.templateId)});
                QueryServiceHelper.query((String)"bcm_papertemplate", (String)"id,papertemplatefield.extmodelfield.extfield.id,papertemplatefield.extmodelfield.extfield.name,papertemplatefield.extmodelfield.extfield.number,papertemplatefield.extmodelfield.extfield.datatype", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)LongUtil.toLong((Object)this.modelId)), new QFilter("id", "=", (Object)LongUtil.toLong((Object)this.templateId))}).stream().filter(e -> {
                    String dataType = e.getString("papertemplatefield.extmodelfield.extfield.datatype");
                    return DataTypeEnum.DEFAULT.index.equals(dataType) || DataTypeEnum.UNCURRENCY.index.equals(dataType) || DataTypeEnum.CURRENCY.index.equals(dataType);
                }).forEach(e -> this.fieldMap.put(e.getString("papertemplatefield.extmodelfield.extfield.number"), e.getString("papertemplatefield.extmodelfield.extfield.id")));
                this.fieldMap.put(M_BTN, M_BTN);
                QFilter qFilter = new QFilter("model", "=", (Object)this.modelId);
                qFilter.and("id", "=", (Object)LongUtil.toLong((Object)this.templateId));
                DynamicObjectCollection extfields = QueryServiceHelper.query((String)"bcm_papertemplate", (String)"id,papertemplatefield.extmodelfield.extfield.id,papertemplatefield.extmodelfield.extfield.number,papertemplatefield.extmodelfield.extfield.entryentityasso.assodim.number", (QFilter[])new QFilter[]{qFilter});
                if (extfields != null) {
                    Map<String, List<DynamicObject>> dimLinkMap = extfields.stream().filter(e -> e.getString("papertemplatefield.extmodelfield.extfield.entryentityasso.assodim.number") != null).collect(Collectors.groupingBy(e -> e.getString("papertemplatefield.extmodelfield.extfield.entryentityasso.assodim.number")));
                    for (Map.Entry<String, List<DynamicObject>> entry : dimLinkMap.entrySet()) {
                        String dimNumber = entry.getKey();
                        Map<String, Long> fieldNumberIdMap = entry.getValue().stream().collect(Collectors.toMap(k -> k.getString("papertemplatefield.extmodelfield.extfield.number"), v -> v.getLong("papertemplatefield.extmodelfield.extfield.id"), (v1, v2) -> v1));
                        this.extFieldLinkDimMap.put(dimNumber.toLowerCase(Locale.ENGLISH), fieldNumberIdMap);
                    }
                }
                List enumScopList = IntrTemplateHelper.getDimScope((Long)this.templateId).getOrDefault("INTR_001", new IntrTplDimScope()).getEnumList();
                List intrFields = QueryIntrDataHelper.queryExtFieldByNumbers((Long)this.modelId, (Set)Sets.newHashSet((Object[])new String[]{"INTR_001"}));
                if (!intrFields.isEmpty() && (eunmList = ((IntrField)intrFields.get(0)).getEunmList()) != null && !eunmList.isEmpty()) {
                    eunmList.forEach(e -> {
                        if (enumScopList != null && !enumScopList.isEmpty()) {
                            if (enumScopList.contains(e)) {
                                this.businessTypeList.add(e.toString());
                            }
                        } else {
                            this.businessTypeList.add(e.toString());
                        }
                    });
                }
                DynamicObjectCollection adjustCatalogs = QueryServiceHelper.query((String)"bcm_templatecatalog", (String)"id,number", (QFilter[])new QFilter[]{AdjustCatalogUtil.getAdjustCatalogFilterWithPerm(this.modelId)});
                adjustCatalogs.forEach(d -> this.adjustCatalogMap.put(d.getString("number"), d.getLong("id")));
            }
        }
        catch (Exception e2) {
            log.error((Throwable)e2);
        }
    }

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        ImportOperateType importType = ImportHelper.getImportType(this.ctx);
        ArrayList<Map<String, Object>> datas = new ArrayList<Map<String, Object>>(16);
        Boolean b = Boolean.TRUE;
        ArrayList<DynamicObject> needSaveData = new ArrayList<DynamicObject>(16);
        BillResult item = new BillResult();
        int dataIndex = 0;
        for (ImportBillData importBillData : rowdatas) {
            Pair<Boolean, String> res = this.validateBillData(importBillData, importType, needSaveData);
            b = b != false && (Boolean)res.p1 != false;
            item.setData((Map<String, Object>)importBillData.getData());
            item.setIndex(dataIndex++);
            item.setSucess((Boolean)res.p1);
            item.setMessage((String)res.p2);
            datas.add(item.toMap());
        }
        if (!needSaveData.isEmpty()) {
            Throwable throwable = null;
            try (TXHandle tx = TX.required();){
                try {
                    SaveServiceHelper.save((DynamicObject[])needSaveData.toArray(new DynamicObject[0]));
                }
                catch (Exception e2) {
                    tx.markRollback();
                    throw e2;
                }
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
            String versionNum = String.format("V%.1f", Float.valueOf(this.template.getBigDecimal("versionnumber").floatValue()));
            String string = this.template.getString("number");
            needSaveData.forEach(e -> {
                String des = String.format(ResManager.loadKDString((String)"\u4f53\u7cfb[%1$s]\u5185\u90e8\u4ea4\u6613\u6a21\u677f[%2$s]\u7248\u672c\u53f7[%3$s]\u5206\u5f55\u8bbe\u7f6e[%4$s]\u5bfc\u5165\u6210\u529f\u3002", (String)"CheckTmplBatchImportPlugin_64", (String)"fi-bcm-formplugin", (Object[])new Object[0]), this.modelShowNum, templateNum, versionNum, e.getString("number"));
                OperationLogUtil.writeOperationLog((String)ResManager.loadKDString((String)"\u5bfc\u5165", (String)"DimMemberOperateTypeEnum_88", (String)"fi-bcm-common", (Object[])new Object[0]), (String)des, (Long)0L, (String)"bcm_adjsetting");
            });
        }
        ApiResult result = new ApiResult();
        result.setSuccess(b.booleanValue());
        result.setData(datas);
        return result;
    }

    private Pair<Boolean, String> validateBillData(ImportBillData rowdata, ImportOperateType importType, List<DynamicObject> needSaveData) {
        Pair buildRes;
        JSONObject data = rowdata.getData();
        if (StringUtils.isEmpty((CharSequence)data.getString("number"))) {
            String msg = ResManager.loadKDString((String)"\u6a21\u677f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CheckTmplBatchImportPlugin_27", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return Pair.onePair((Object)Boolean.FALSE, (Object)msg);
        }
        if (data.getString("number").length() > 30) {
            String msg = ResManager.loadKDString((String)"\u5b57\u6bb5\u201c\u7f16\u7801\u201d\u8f93\u5165\u957f\u5ea6\u8d85\u51fa\u9650\u5b9a\u8303\u56f4[0,30]", (String)"CheckTmplBatchImportPlugin_33", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return Pair.onePair((Object)Boolean.FALSE, (Object)msg);
        }
        if (!BCMNumberRule.checkNumber((String)data.getString("number"))) {
            String msg = ResManager.loadKDString((String)"\u6a21\u677f\u7f16\u7801\u4e0d\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u4ee5\u5916\u7684\u5b57\u7b26\uff0c\u4e0d\u53ef\u4ee5\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u5f00\u5934\uff0c\u5c0f\u6570\u70b9\u4e4b\u95f4\u5fc5\u987b\u6709\u5176\u4ed6\u5b57\u7b26\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"AdjustPaperTemplatePlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return Pair.onePair((Object)Boolean.FALSE, (Object)msg);
        }
        DynamicObject sameNumTmpl = QueryServiceHelper.queryOne((String)"bcm_adjsetting", (String)"id", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)this.modelId), new QFilter("templateid", "=", (Object)this.templateId), new QFilter("number", "=", data.get((Object)"number"))});
        DynamicObject newTmpl = BusinessDataServiceHelper.newDynamicObject((String)"bcm_adjsetting");
        newTmpl.set("creator", (Object)LongUtil.toLong((Object)RequestContext.get().getUserId()));
        newTmpl.set("createtime", (Object)TimeServiceHelper.now());
        if (ImportOperateType.NEW == importType) {
            if (sameNumTmpl != null) {
                String msg = ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u6a21\u677f\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u65b0\u589e\u6570\u636e\u5931\u8d25\u3002", (String)"CheckTmplBatchImportPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                return Pair.onePair((Object)Boolean.FALSE, (Object)msg);
            }
        } else if (ImportOperateType.OVERRIDE == importType) {
            if (sameNumTmpl == null) {
                String msg = ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u6a21\u677f\u7f16\u7801\u4e0d\u5b58\u5728\uff0c\u66f4\u65b0\u6570\u636e\u5931\u8d25\u3002", (String)"CheckTmplBatchImportPlugin_48", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                return Pair.onePair((Object)Boolean.FALSE, (Object)msg);
            }
            newTmpl = BusinessDataServiceHelper.loadSingle((Object)sameNumTmpl.getLong("id"), (String)"bcm_adjsetting");
        } else if (ImportOperateType.OVERRIDENEW == importType && sameNumTmpl != null) {
            newTmpl = BusinessDataServiceHelper.loadSingle((Object)sameNumTmpl.getLong("id"), (String)"bcm_adjsetting");
        }
        try {
            buildRes = this.buildDynInfo(data, newTmpl);
        }
        catch (KDBizException e) {
            buildRes = Pair.onePair((Object)Boolean.FALSE, (Object)e.getMessage());
        }
        catch (Exception e) {
            buildRes = Pair.onePair((Object)Boolean.FALSE, (Object)String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff1a%s", (String)"CheckTmplBatchImportPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]), e));
            log.error(e.getCause());
        }
        if (((Boolean)buildRes.p1).booleanValue()) {
            needSaveData.add(newTmpl);
        }
        return buildRes;
    }

    private Pair<Boolean, String> buildDynInfo(JSONObject data, DynamicObject dyn) {
        String description;
        String msg;
        String modelNumber = MemberReader.findModelNumberById((Object)this.modelId);
        dyn.set("model", (Object)this.modelId);
        dyn.set("templateid", (Object)this.templateId);
        Object name = data.get((Object)"name");
        String nameStr = "";
        if (name == null) {
            String msg2 = ResManager.loadKDString((String)"\u6a21\u677f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CheckTmplBatchImportPlugin_28", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return Pair.onePair((Object)Boolean.FALSE, (Object)msg2);
        }
        nameStr = name instanceof Map ? LocaleString.fromMap((Map)((Map)name)).toString().trim() : name.toString().trim();
        if (nameStr.length() > 50) {
            String msg3 = ResManager.loadKDString((String)"\u5b57\u6bb5\u201c\u540d\u79f0\u201d\u8f93\u5165\u957f\u5ea6\u8d85\u51fa\u9650\u5b9a\u8303\u56f4[0,50]", (String)"CheckTmplBatchImportPlugin_34", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return Pair.onePair((Object)Boolean.FALSE, (Object)msg3);
        }
        if (nameStr.isEmpty()) {
            String msg4 = ResManager.loadKDString((String)"\u6a21\u677f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CheckTmplBatchImportPlugin_28", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return Pair.onePair((Object)Boolean.FALSE, (Object)msg4);
        }
        if (this.existNumberSet.contains(data.getString("number"))) {
            String msg5 = String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u6587\u4ef6\u91cc\u6a21\u677f\u7f16\u7801 %S \u91cd\u590d\u3002", (String)"CheckTmplBatchImportPlugin_43", (String)"fi-bcm-formplugin", (Object[])new Object[0]), data.getString("number"));
            return Pair.onePair((Object)Boolean.FALSE, (Object)msg5);
        }
        dyn.set("name", (Object)nameStr);
        dyn.set("number", data.get((Object)"number"));
        this.existNumberSet.add(data.getString("number"));
        String status = data.getString("status");
        if (StringUtils.isEmpty((CharSequence)status)) {
            String msg6 = ResManager.loadKDString((String)"\u72b6\u6001\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AdjSettingBatchImportPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return Pair.onePair((Object)Boolean.FALSE, (Object)msg6);
        }
        if (!"1".equals(status) && !"0".equals(status)) {
            String msg7 = ResManager.loadKDString((String)"\u72b6\u6001\u5b57\u6bb5\u586b\u5199\u9519\u8bef\u3002", (String)"AdjSettingBatchImportPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return Pair.onePair((Object)Boolean.FALSE, (Object)msg7);
        }
        dyn.set("status", (Object)status);
        if (!this.businessTypeList.contains(data.getString("businesstypenum"))) {
            String msg8 = ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u5b57\u6bb5\u586b\u5199\u9519\u8bef\u3002", (String)"AdjSettingBatchImportPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return Pair.onePair((Object)Boolean.FALSE, (Object)msg8);
        }
        dyn.set("businesstype", (Object)data.getString("businesstypenum"));
        Object process = data.get((Object)"process");
        if (process == null) {
            String msg9 = ResManager.loadKDString((String)"\u62b5\u9500\u8fc7\u7a0b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AdjSettingBatchImportPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return Pair.onePair((Object)Boolean.FALSE, (Object)msg9);
        }
        String processNum = (String)((Map)process).get("number");
        if (StringUtils.isEmpty((CharSequence)processNum)) {
            String msg10 = ResManager.loadKDString((String)"\u62b5\u9500\u8fc7\u7a0b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AdjSettingBatchImportPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return Pair.onePair((Object)Boolean.FALSE, (Object)msg10);
        }
        if (!this.processNumList.contains(processNum)) {
            String msg11 = ResManager.loadKDString((String)"\u62b5\u9500\u8fc7\u7a0b\u7f16\u7801\u586b\u5199\u4e0d\u6b63\u786e\u3002", (String)"AdjSettingBatchImportPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return Pair.onePair((Object)Boolean.FALSE, (Object)msg11);
        }
        IDNumberTreeNode processNode = MemberReader.findProcessMemberByNum((String)modelNumber, (String)processNum);
        if (processNode != IDNumberTreeNode.NotFoundTreeNode && processNode.isLeaf()) {
            if (!this.hasPerm("Process", processNode.getId())) {
                String msg12 = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u5bf9\u8fc7\u7a0b%s\u65e0\u6743\u3002", (String)"AdjSettingBatchImportPlugin_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]), processNum);
                return Pair.onePair((Object)Boolean.FALSE, (Object)msg12);
            }
        } else {
            String msg13 = ResManager.loadKDString((String)"\u62b5\u9500\u8fc7\u7a0b\u7f16\u7801\u586b\u5199\u4e0d\u6b63\u786e\u3002", (String)"AdjSettingBatchImportPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return Pair.onePair((Object)Boolean.FALSE, (Object)msg13);
        }
        dyn.set("process", (Object)processNode.getId());
        JSONObject adjustcatalogJson = (JSONObject)data.get((Object)"adjustcatalog");
        if (adjustcatalogJson != null && adjustcatalogJson.containsKey((Object)"number") && StringUtils.isNotEmpty((CharSequence)adjustcatalogJson.getString("number"))) {
            Long adjustCatalogId = this.adjustCatalogMap.get(adjustcatalogJson.getString("number"));
            if (adjustCatalogId == null) {
                String msg14 = ResManager.loadKDString((String)"\u5206\u5f55\u5206\u7c7b\u7f16\u7801\u65e0\u6743\u6216\u4e0d\u5b58\u5728\u3002", (String)"CheckTmplBatchImportPlugin_63", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                return Pair.onePair((Object)Boolean.FALSE, (Object)msg14);
            }
            dyn.set("adjustcatalog", (Object)adjustCatalogId);
        }
        if (StringUtils.isEmpty((CharSequence)data.getString("islinkage"))) {
            msg = ResManager.loadKDString((String)"\u662f\u5426\u8054\u52a8\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CheckTmplBatchImportPlugin_31", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return Pair.onePair((Object)Boolean.FALSE, (Object)msg);
        }
        if (!("0".equals(data.getString("islinkage")) || "1".equals(data.getString("islinkage")) || "2".equals(data.getString("islinkage")))) {
            msg = ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u5bfc\u5165\u7684\u8054\u52a8\u65b9\u5f0f\u3002", (String)"CheckTmplBatchImportPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return Pair.onePair((Object)Boolean.FALSE, (Object)msg);
        }
        dyn.set("islinkage", data.get((Object)"islinkage"));
        if (StringUtils.isEmpty((CharSequence)data.getString("journaltype"))) {
            msg = ResManager.loadKDString((String)"\u5206\u5f55\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CheckTmplBatchImportPlugin_54", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return Pair.onePair((Object)Boolean.FALSE, (Object)msg);
        }
        dyn.set("journaltype", data.get((Object)"journaltype"));
        String string = description = null == data.get((Object)"description") ? "" : LocaleString.fromMap((Map)((Map)data.get((Object)"description"))).toString().trim();
        if (description.length() > 255) {
            String msg15 = ResManager.loadKDString((String)"\u5b57\u6bb5\u201c\u8bf4\u660e\u201d\u8f93\u5165\u957f\u5ea6\u8d85\u51fa\u9650\u5b9a\u8303\u56f4[0,255]", (String)"CheckTmplBatchImportPlugin_38", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return Pair.onePair((Object)Boolean.FALSE, (Object)msg15);
        }
        dyn.set("description", (Object)description);
        dyn.set("modifier", (Object)LongUtil.toLong((Object)RequestContext.get().getUserId()));
        dyn.set("modifytime", (Object)TimeServiceHelper.now());
        return this.buildDynEntry(data, dyn);
    }

    private boolean hasPerm(String dimNumber, Long memberId) {
        Long dimId;
        PermissionService instance = PermissionServiceImpl.getInstance((Long)this.modelId);
        return !instance.hasNoPerm(dimId = MemberReader.getDimensionIdByNum((long)this.modelId, (String)dimNumber), memberId);
    }

    private Pair<Boolean, String> buildDynEntry(JSONObject data, DynamicObject dyn) {
        DynamicObjectCollection entryentity = dyn.getDynamicObjectCollection("entryentity");
        entryentity.clear();
        if (!data.containsKey((Object)"entryentity") || ((JSONArray)data.get((Object)"entryentity")).isEmpty()) {
            String msg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5b8c\u6574\u5355\u636e\u4f53\u4fe1\u606f\u3002", (String)"CheckTmplBatchImportPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return Pair.onePair((Object)Boolean.FALSE, (Object)msg);
        }
        JSONArray entryentityJsonArr = (JSONArray)data.get((Object)"entryentity");
        int seq = 0;
        int bnEntryCount = 0;
        for (Object rowObject : entryentityJsonArr) {
            String msg;
            JSONObject rowJSONObject = (JSONObject)rowObject;
            DynamicObject newEntryObj = entryentity.addNew();
            newEntryObj.set("seq", (Object)(++seq));
            Pair<Boolean, String> accountRes = this.setDimEntryValue(rowJSONObject, newEntryObj, DimTypesEnum.ACCOUNT);
            if (!((Boolean)accountRes.p1).booleanValue()) {
                return accountRes;
            }
            if (this.isExistDimension(DimTypesEnum.AUDITTRIAL.getNumber())) {
                Pair<Boolean, String> auditTrailRes = this.setDimEntryValue(rowJSONObject, newEntryObj, DimTypesEnum.AUDITTRIAL);
                if (!((Boolean)auditTrailRes.p1).booleanValue()) {
                    return auditTrailRes;
                }
            }
            if (this.isExistDimension(DimTypesEnum.CHANGETYPE.getNumber())) {
                Pair<Boolean, String> changeTypeRes = this.setDimEntryValue(rowJSONObject, newEntryObj, DimTypesEnum.CHANGETYPE);
                if (!((Boolean)changeTypeRes.p1).booleanValue()) {
                    return changeTypeRes;
                }
            }
            if (this.isExistDimension(DimTypesEnum.DATASORT.getNumber())) {
                Pair<Boolean, String> dsRes = this.setDimEntryValue(rowJSONObject, newEntryObj, DimTypesEnum.DATASORT);
                if (!((Boolean)dsRes.p1).booleanValue()) {
                    return dsRes;
                }
            }
            if (this.isExistDimension(DimTypesEnum.MULTIGAAP.getNumber())) {
                Iterator<Map.Entry<String, String>> muRes = this.setDimEntryValue(rowJSONObject, newEntryObj, DimTypesEnum.MULTIGAAP);
                if (!((Boolean)((Pair)muRes).p1).booleanValue()) {
                    return muRes;
                }
            }
            for (Map.Entry<String, String> entry : this.userDefineDimNumMap.entrySet()) {
                String msg2;
                String d = entry.getKey();
                String dimNumber = entry.getValue();
                String classType = rowJSONObject.getString(d + "classtype");
                if (StringUtils.isEmpty((CharSequence)classType)) {
                    String msg3 = String.format(ResManager.loadKDString((String)"%s\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AdjSettingBatchImportPlugin_19", (String)"fi-bcm-formplugin", (Object[])new Object[0]), d);
                    return Pair.onePair((Object)Boolean.FALSE, (Object)msg3);
                }
                newEntryObj.set(d + "classtype", (Object)classType);
                boolean isExtendField = "bcm_structofextend".equals(classType);
                JSONObject dimJson = rowJSONObject.getJSONObject(d + "dyn");
                if (dimJson == null) {
                    String msg4 = String.format(ResManager.loadKDString((String)"%s\u57fa\u7840\u8d44\u6599\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AdjSettingBatchImportPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), d);
                    return Pair.onePair((Object)Boolean.FALSE, (Object)msg4);
                }
                String memNum = dimJson.getString("number");
                if (StringUtils.isEmpty((CharSequence)memNum)) {
                    String msg5 = String.format(ResManager.loadKDString((String)"%s\u57fa\u7840\u8d44\u6599\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AdjSettingBatchImportPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), d);
                    return Pair.onePair((Object)Boolean.FALSE, (Object)msg5);
                }
                if (isExtendField) {
                    Map<String, Long> numIdMap = this.extFieldLinkDimMap.get(dimNumber.toLowerCase(Locale.ENGLISH));
                    if (numIdMap == null) {
                        msg2 = String.format(ResManager.loadKDString((String)"\u62d3\u5c55\u6210\u5458\u7f16\u7801%1$s\u672a\u5173\u8054%2$s\u7ef4\u5ea6\u3002", (String)"AdjSettingBatchImportPlugin_20", (String)"fi-bcm-formplugin", (Object[])new Object[0]), memNum, d);
                        return Pair.onePair((Object)Boolean.FALSE, (Object)msg2);
                    }
                    Long extFieldId = numIdMap.get(memNum);
                    if (extFieldId != null && extFieldId != 0L) {
                        newEntryObj.set(d + "dyn", (Object)extFieldId);
                        continue;
                    }
                    String msg6 = String.format(ResManager.loadKDString((String)"\u62d3\u5c55\u6210\u5458\u7f16\u7801%1$s\u672a\u5173\u8054%2$s\u7ef4\u5ea6\u3002", (String)"AdjSettingBatchImportPlugin_20", (String)"fi-bcm-formplugin", (Object[])new Object[0]), memNum, d);
                    return Pair.onePair((Object)Boolean.FALSE, (Object)msg6);
                }
                IDNumberTreeNode memberNode = this.getMemberByNumCache(this.modelId, dimNumber, memNum);
                if (memberNode.getId() == -1L) {
                    msg2 = String.format(ResManager.loadKDString((String)"%1$s\u7ef4\u5ea6\u6210\u5458\u7f16\u7801%2$s\u4e0d\u5b58\u5728\u3002", (String)"AdjSettingBatchImportPlugin_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]), d, memNum);
                    return Pair.onePair((Object)Boolean.FALSE, (Object)msg2);
                }
                if (M_CUR.equals(memberNode.getNumber())) {
                    newEntryObj.set(d + "dyn", (Object)memberNode.getId());
                    continue;
                }
                if (memberNode.isLeaf()) {
                    if (this.hasPerm(dimNumber, memberNode.getId())) {
                        newEntryObj.set(d + "dyn", (Object)memberNode.getId());
                        continue;
                    }
                    msg2 = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u5bf9%1$s\u7ef4\u5ea6\u6210\u5458\u7f16\u7801%2$s\u65e0\u6743\u3002", (String)"AdjSettingBatchImportPlugin_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]), d, memNum);
                    return Pair.onePair((Object)Boolean.FALSE, (Object)msg2);
                }
                msg2 = String.format(ResManager.loadKDString((String)"%s\u6210\u5458\u9700\u4e3a\u660e\u7ec6\u6210\u5458\u3002", (String)"AdjSettingBatchImportPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]), d);
                return Pair.onePair((Object)Boolean.FALSE, (Object)msg2);
            }
            if (!"1".equals(rowJSONObject.getString("entity")) && !"2".equals(rowJSONObject.getString("entity"))) {
                msg = ResManager.loadKDString((String)"\u7ec4\u7ec7\u586b\u5199\u4e0d\u6b63\u786e\u3002", (String)"AdjSettingBatchImportPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                return Pair.onePair((Object)Boolean.FALSE, (Object)msg);
            }
            newEntryObj.set("entity", (Object)rowJSONObject.getString("entity"));
            if (this.isExistDimension(DimTypesEnum.MYCOMPANY.getNumber())) {
                if ("1".equals(rowJSONObject.getString("mycompany")) || "2".equals(rowJSONObject.getString("mycompany")) || "3".equals(rowJSONObject.getString("mycompany"))) {
                    newEntryObj.set("mycompany", (Object)rowJSONObject.getString("mycompany"));
                } else {
                    msg = ResManager.loadKDString((String)"\u6211\u65b9\u7ec4\u7ec7\u586b\u5199\u4e0d\u6b63\u786e\u3002", (String)"AdjSettingBatchImportPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                    return Pair.onePair((Object)Boolean.FALSE, (Object)msg);
                }
            }
            if (!("1".equals(rowJSONObject.getString("opcompany")) || "2".equals(rowJSONObject.getString("opcompany")) || "0".equals(rowJSONObject.getString("opcompany")))) {
                msg = ResManager.loadKDString((String)"\u5f80\u6765\u7ec4\u7ec7\u586b\u5199\u4e0d\u6b63\u786e\u3002", (String)"AdjSettingBatchImportPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                return Pair.onePair((Object)Boolean.FALSE, (Object)msg);
            }
            newEntryObj.set("opcompany", (Object)rowJSONObject.getString("opcompany"));
            if (StringUtils.isEmpty((CharSequence)rowJSONObject.getString("debitnumber")) && StringUtils.isEmpty((CharSequence)rowJSONObject.getString("creditnumber"))) {
                msg = ResManager.loadKDString((String)"\u501f\u65b9\u6210\u5458\u7f16\u7801\u548c\u8d37\u65b9\u6210\u5458\u7f16\u7801\u4e0d\u80fd\u5168\u4e3a\u7a7a\u3002", (String)"AdjSettingBatchImportPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                return Pair.onePair((Object)Boolean.FALSE, (Object)msg);
            }
            if (StringUtils.isNotEmpty((CharSequence)rowJSONObject.getString("debitnumber")) && StringUtils.isNotEmpty((CharSequence)rowJSONObject.getString("creditnumber"))) {
                msg = ResManager.loadKDString((String)"\u501f\u65b9\u6210\u5458\u7f16\u7801\u548c\u8d37\u65b9\u6210\u5458\u7f16\u7801\u4e0d\u80fd\u540c\u65f6\u586b\u5199\u503c\u3002", (String)"AdjSettingBatchImportPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                return Pair.onePair((Object)Boolean.FALSE, (Object)msg);
            }
            if (StringUtils.isNotEmpty((CharSequence)rowJSONObject.getString("debitnumber"))) {
                if (this.fieldMap.containsKey(rowJSONObject.getString("debitnumber"))) {
                    newEntryObj.set("debit", (Object)this.fieldMap.get(rowJSONObject.getString("debitnumber")));
                    if (!M_BTN.equals(rowJSONObject.getString("debitnumber"))) continue;
                    ++bnEntryCount;
                    continue;
                }
                msg = ResManager.loadKDString((String)"\u501f\u65b9\u6210\u5458\u53ea\u80fd\u586b\u5199\u9ed8\u8ba4\u3001\u8d27\u5e01\u548c\u6570\u503c\u7c7b\u578b\u7684\u62d3\u5c55\u6210\u5458\u6216\u5e73\u8861\u6570Bn()\u3002", (String)"AdjSettingBatchImportPlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                return Pair.onePair((Object)Boolean.FALSE, (Object)msg);
            }
            if (!StringUtils.isNotEmpty((CharSequence)rowJSONObject.getString("creditnumber"))) continue;
            if (this.fieldMap.containsKey(rowJSONObject.getString("creditnumber"))) {
                newEntryObj.set("credit", (Object)this.fieldMap.get(rowJSONObject.getString("creditnumber")));
                if (!M_BTN.equals(rowJSONObject.getString("creditnumber"))) continue;
                ++bnEntryCount;
                continue;
            }
            msg = ResManager.loadKDString((String)"\u8d37\u65b9\u6210\u5458\u53ea\u80fd\u586b\u5199\u9ed8\u8ba4\u3001\u8d27\u5e01\u548c\u6570\u503c\u7c7b\u578b\u7684\u62d3\u5c55\u6210\u5458\u6216\u5e73\u8861\u6570Bn()\u3002", (String)"AdjSettingBatchImportPlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return Pair.onePair((Object)Boolean.FALSE, (Object)msg);
        }
        if (bnEntryCount != 1) {
            String msg = ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u4e00\u884c\u5e73\u8861\u6570\u5206\u5f55\u660e\u7ec6\u3002", (String)"AdjSettingBatchImportPlugin_21", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return Pair.onePair((Object)Boolean.FALSE, (Object)msg);
        }
        return Pair.onePair((Object)Boolean.TRUE, (Object)"");
    }

    /*
     * Enabled aggressive block sorting
     */
    private Pair<Boolean, String> setDimEntryValue(JSONObject rowJSONObject, DynamicObject newEntryObj, DimTypesEnum dimTypesEnum) {
        String dimSign = dimTypesEnum.getNumber().toLowerCase(Locale.ENGLISH);
        JSONObject dimJson = rowJSONObject.getJSONObject(dimSign + "dyn");
        String classType = rowJSONObject.getString(dimSign + "classtype");
        if (StringUtils.isEmpty((CharSequence)classType)) {
            String msg = String.format(ResManager.loadKDString((String)"%s\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AdjSettingBatchImportPlugin_19", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dimTypesEnum.getName());
            return Pair.onePair((Object)Boolean.FALSE, (Object)msg);
        }
        newEntryObj.set(dimSign + "classtype", (Object)classType);
        boolean isExtendField = "bcm_structofextend".equals(classType);
        if (dimJson == null) {
            String msg = String.format(ResManager.loadKDString((String)"%s\u57fa\u7840\u8d44\u6599\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AdjSettingBatchImportPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dimTypesEnum.getName());
            return Pair.onePair((Object)Boolean.FALSE, (Object)msg);
        }
        String memNum = dimJson.getString("number");
        if (StringUtils.isEmpty((CharSequence)memNum)) {
            String msg = String.format(ResManager.loadKDString((String)"%s\u57fa\u7840\u8d44\u6599\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AdjSettingBatchImportPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dimTypesEnum.getName());
            return Pair.onePair((Object)Boolean.FALSE, (Object)msg);
        }
        if (isExtendField) {
            Map<String, Long> numIdMap = this.extFieldLinkDimMap.get(dimSign);
            if (numIdMap == null) {
                String msg = String.format(ResManager.loadKDString((String)"\u62d3\u5c55\u6210\u5458\u7f16\u7801%1$s\u672a\u5173\u8054%2$s\u7ef4\u5ea6\u3002", (String)"AdjSettingBatchImportPlugin_20", (String)"fi-bcm-formplugin", (Object[])new Object[0]), memNum, dimTypesEnum.getName());
                return Pair.onePair((Object)Boolean.FALSE, (Object)msg);
            }
            Long extFieldId = numIdMap.get(memNum);
            if (extFieldId != null && extFieldId != 0L) {
                newEntryObj.set(dimSign + "dyn", (Object)extFieldId);
                return Pair.onePair((Object)Boolean.TRUE, (Object)"");
            }
            String msg = String.format(ResManager.loadKDString((String)"\u62d3\u5c55\u6210\u5458\u7f16\u7801%1$s\u672a\u5173\u8054%2$s\u7ef4\u5ea6\u3002", (String)"AdjSettingBatchImportPlugin_20", (String)"fi-bcm-formplugin", (Object[])new Object[0]), memNum, dimTypesEnum.getName());
            return Pair.onePair((Object)Boolean.FALSE, (Object)msg);
        }
        IDNumberTreeNode memberNode = this.getMemberByNumCache(this.modelId, dimTypesEnum.getNumber(), memNum);
        if (memberNode.getId() == -1L) {
            String msg = String.format(ResManager.loadKDString((String)"%1$s\u7ef4\u5ea6\u6210\u5458\u7f16\u7801%2$s\u4e0d\u5b58\u5728\u3002", (String)"AdjSettingBatchImportPlugin_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dimTypesEnum.getName(), memNum);
            return Pair.onePair((Object)Boolean.FALSE, (Object)msg);
        }
        if (M_CUR.equals(memberNode.getNumber())) {
            newEntryObj.set(dimSign + "dyn", (Object)memberNode.getId());
            return Pair.onePair((Object)Boolean.TRUE, (Object)"");
        }
        if (DimTypesEnum.ACCOUNT == dimTypesEnum) {
            boolean isAccountOffset;
            boolean bl = isAccountOffset = memberNode.getProperty("accountpart.isaccountoffset") == null || (Boolean)memberNode.getProperty("accountpart.isaccountoffset") != false;
            if (memberNode.isLeaf() && StorageTypeEnum.getRealStorageEnumIndexs().contains(memberNode.getStorageType().getOIndex()) && isAccountOffset) {
                if (!this.hasPerm(dimTypesEnum.getNumber(), memberNode.getId())) {
                    String msg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u5bf9%1$s\u7ef4\u5ea6\u6210\u5458\u7f16\u7801%2$s\u65e0\u6743\u3002", (String)"AdjSettingBatchImportPlugin_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dimTypesEnum.getName(), memNum);
                    return Pair.onePair((Object)Boolean.FALSE, (Object)msg);
                }
                newEntryObj.set(dimSign + "dyn", (Object)memberNode.getId());
            } else {
                String msg = ResManager.loadKDString((String)"\u79d1\u76ee\u6210\u5458\u9700\u4e3a\u6253\u5f00\u4e86\u62b5\u9500\u5c5e\u6027\u7684\u5b58\u50a8\u6216\u4e0d\u5171\u4eab\u7684\u660e\u7ec6\u6210\u5458\u3002", (String)"AdjSettingBatchImportPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                return Pair.onePair((Object)Boolean.FALSE, (Object)msg);
            }
        }
        if (DimTypesEnum.AUDITTRIAL == dimTypesEnum) {
            if ("3".equals(memberNode.getProperty("datasource")) && memberNode.isLeaf()) {
                if (!this.hasPerm(dimTypesEnum.getNumber(), memberNode.getId())) {
                    String msg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u5bf9%1$s\u7ef4\u5ea6\u6210\u5458\u7f16\u7801%2$s\u65e0\u6743\u3002", (String)"AdjSettingBatchImportPlugin_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dimTypesEnum.getName(), memNum);
                    return Pair.onePair((Object)Boolean.FALSE, (Object)msg);
                }
                newEntryObj.set(dimSign + "dyn", (Object)memberNode.getId());
            } else {
                String msg = ResManager.loadKDString((String)"\u5ba1\u8ba1\u7ebf\u7d22\u6210\u5458\u9700\u4e3a\u6570\u636e\u6765\u6e90\u5c5e\u6027\u662f\u5206\u5f55\u8c03\u6574\u7684\u660e\u7ec6\u6210\u5458\u3002", (String)"AdjSettingBatchImportPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                return Pair.onePair((Object)Boolean.FALSE, (Object)msg);
            }
        }
        if (DimTypesEnum.CHANGETYPE != dimTypesEnum && DimTypesEnum.DATASORT != dimTypesEnum) {
            if (DimTypesEnum.MULTIGAAP != dimTypesEnum) return Pair.onePair((Object)Boolean.TRUE, (Object)"");
        }
        if (!memberNode.isLeaf()) {
            String msg = String.format(ResManager.loadKDString((String)"%s\u6210\u5458\u9700\u4e3a\u660e\u7ec6\u6210\u5458\u3002", (String)"AdjSettingBatchImportPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dimTypesEnum.getName());
            return Pair.onePair((Object)Boolean.FALSE, (Object)msg);
        }
        if (this.hasPerm(dimTypesEnum.getNumber(), memberNode.getId())) {
            newEntryObj.set(dimSign + "dyn", (Object)memberNode.getId());
            return Pair.onePair((Object)Boolean.TRUE, (Object)"");
        }
        String msg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u5bf9%1$s\u7ef4\u5ea6\u6210\u5458\u7f16\u7801%2$s\u65e0\u6743\u3002", (String)"AdjSettingBatchImportPlugin_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dimTypesEnum.getName(), memNum);
        return Pair.onePair((Object)Boolean.FALSE, (Object)msg);
    }

    private IDNumberTreeNode getMemberByNumCache(Long modelId, String dimNum, String memberNum) {
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        String cacheKey = String.join((CharSequence)"#", modelNum, dimNum, memberNum);
        IDNumberTreeNode node = this.memberReaderCache.get(cacheKey);
        if (node == null) {
            node = MemberReader.findMemberByNumber((String)modelNum, (String)dimNum, (String)memberNum);
            this.memberReaderCache.put(cacheKey, node);
        }
        return node;
    }

    private boolean isExistDimension(String dimNum) {
        return MemberReader.isExistDimension((String)MemberReader.findModelNumberById((Object)this.modelId), (String)dimNum);
    }
}

