/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.papertemplate.adjust;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.container.Container;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.innertrade.model.IntrField;
import kd.fi.bcm.business.innertrade.model.IntrTplDimScope;
import kd.fi.bcm.business.innertrade.report.IntrTemplateHelper;
import kd.fi.bcm.business.innertrade.report.QueryIntrDataHelper;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.util.BCMNumberRule;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.MessageConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DataSourceEnum;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.dimension.SystemVarsEnum;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.database.BasedataEditSingleMemberF7;
import kd.fi.bcm.formplugin.pageinteraction.CommandParam;
import kd.fi.bcm.formplugin.pageinteraction.DynamicPage;
import kd.fi.bcm.formplugin.pageinteraction.SubPage;
import kd.fi.bcm.formplugin.util.AdjustCatalogUtil;
import kd.fi.bcm.formplugin.util.SingleMemberF7Util;
import kd.fi.bcm.formplugin.util.UserSelectUtil;

public class AdjSettingEditPlugin
extends AbstractBaseFormPlugin
implements SubPage,
DynamicPage {
    private static final String ctl_model = "model";
    private static final String ctl_account = "accounttext";
    private static final String ctl_changetype = "changetypetext";
    private static final String ctl_datasort = "datasorttext";
    private static final String ctl_multigaap = "multigaaptext";
    private static final String ctl_entryentity = "entryentity";
    private static final String ctl_mycompany = "mycompany";
    private static final String ctl_audittrail = "audittrailtext";
    private static final String ctl_entity = "entity";
    private static final String ctl_debit = "debit";
    private static final String ctl_credit = "credit";
    private static final String CTL_ENTRYENTITY = "entryentity";
    private static final String CACHE_DIM = "cache_dim";
    private static final String ctl_process = "process";
    private static final String templateid = "templateid";
    private static final String templatenumber = "templatenumber";
    private static final List<String> multiSelectDims = Arrays.asList("accounttext", "audittrailtext", "changetypetext", "datasorttext", "multigaaptext", "dim1text", "dim2text", "dim3text", "dim4text", "dim5text", "dim6text");
    public static final List<String> hideColums = Arrays.asList("accountclasstype", "accountdyn", "audittrailclasstype", "audittraildyn", "dim1classtype", "dim1dyn", "dim2classtype", "dim2dyn", "dim3classtype", "dim3dyn", "dim4classtype", "dim4dyn", "dim5classtype", "dim5dyn", "dim6classtype", "dim6dyn", "datasortclasstype", "datasortdyn", "multigaapclasstype", "multigaapdyn", "changetypeclasstype", "changetypedyn");
    List<String> dynFields = Arrays.asList("accountdyn", "audittraildyn", "dim1dyn", "dim2dyn", "dim3dyn", "dim4dyn", "dim5dyn", "dim6dyn", "datasortdyn", "multigaapdyn", "changetypedyn");
    private final Map<String, String> dimKeys = new HashMap<String, String>();

    public AdjSettingEditPlugin() {
        this.dimKeys.put(ctl_process, ctl_process);
    }

    @Override
    public void initialize() {
        super.initialize();
        HashMap map = new HashMap(16);
        this.asMapF7toType(new ArrayList<String>(this.dimKeys.keySet()), SingleF7TypeEnum.LEAF, map);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        String f7Key = beforeF7SelectEvent.getProperty().getName();
        if (ctl_process.equals(f7Key) && beforeF7SelectEvent.getFormShowParameter() instanceof ListShowParameter) {
            IDNumberTreeNode ejeMember = MemberReader.findProcessMemberByNum((String)MemberReader.findModelNumberById((Object)this.getModelId()), (String)"EJE");
            QFilter processNumberQfilter = new QFilter("number", "in", (Object)new String[]{"ADJ", "CADJ", "CCADJ"});
            if (ejeMember.isLeaf()) {
                processNumberQfilter.or(new QFilter("number", "=", (Object)"EJE"));
            } else {
                processNumberQfilter.or(new QFilter("longnumber", "like", (Object)"%!EJE!%"));
            }
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            qFilters.add(new QFilter(ctl_model, "=", (Object)this.getModelId()));
            qFilters.add(processNumberQfilter);
            QFilter processPermQfilter = PermissionServiceImpl.getInstance((Long)this.getModelId()).getReadOrWritePermFilter(MemberReader.getDimensionIdByNum((long)this.getModelId(), (String)DimTypesEnum.PROCESS.getNumber()), "bcm_processmembertree", "id");
            qFilters.add(processPermQfilter);
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            formShowParameter.setFormId("bos_listf7");
            ListFilterParameter listFilterParameter = formShowParameter.getListFilterParameter();
            listFilterParameter.setOrderBy("longnumber");
            listFilterParameter.getQFilters().addAll(qFilters);
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit pro = (BasedataEdit)this.getControl(ctl_process);
        pro.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        AdjustCatalogUtil.setAdjustCatalogFilter((BasedataEdit)this.getControl("adjustcatalog"), this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID"));
    }

    public Map<String, String> getDimKeyCache() {
        HashMap<String, String> dimKeyMap = new HashMap<String, String>(16);
        String cacheDim = this.getPageCache().get(CACHE_DIM);
        if (kd.bos.util.StringUtils.isEmpty((String)cacheDim)) {
            String selectFields = "id,name,number,issysdimension,fieldmapped,membermodel";
            QFilter[] qfilter = new QFilter[]{new QFilter(ctl_model, "=", (Object)this.getModelId())};
            DynamicObjectCollection dimDyns = QueryServiceHelper.query((String)"bcm_dimension", (String)selectFields, (QFilter[])qfilter, (String)"dseq");
            Map<String, DynamicObject> dynamicObjectMap = dimDyns.stream().collect(Collectors.toMap(e -> e.getString("number"), e -> e));
            List userDefineds = DimensionServiceHelper.getUserDefineDimensionNumListByModel((Object)this.getModelId());
            Map numMapped = DimensionServiceHelper.getDimensionNumMapped((Object)this.getModelId());
            Map userName = DimensionServiceHelper.getUserDefineDimensionNumAndNameByModel((Object)this.getModelId(), (boolean)false);
            for (int i = 1; i <= userDefineds.size(); ++i) {
                String userDefinedNumber = (String)userDefineds.get(i - 1);
                dimKeyMap.put((String)numMapped.get(userDefinedNumber), userDefinedNumber);
                dimKeyMap.put((String)numMapped.get(userDefinedNumber) + "name", (String)userName.get(userDefinedNumber));
                dimKeyMap.put((String)numMapped.get(userDefinedNumber) + "id", dynamicObjectMap.get(userDefinedNumber).getString("id"));
                dimKeyMap.put((String)numMapped.get(userDefinedNumber) + "sign", dynamicObjectMap.get(userDefinedNumber).getString("membermodel"));
            }
            dimDyns.stream().filter(e -> e.getBoolean("issysdimension")).forEach(d -> {
                String dimSign = d.getString("number").toLowerCase();
                dimKeyMap.put(dimSign, d.getString("number"));
                dimKeyMap.put(dimSign + "name", d.getString("name"));
                dimKeyMap.put(dimSign + "id", d.getString("id"));
                dimKeyMap.put(dimSign + "sign", d.getString("membermodel"));
            });
            DynamicObject extendDim = QueryServiceHelper.queryOne((String)"bcm_dimension_ext", (String)"id,name,number", (QFilter[])qfilter);
            if (extendDim != null) {
                dimKeyMap.put("extdimnumber", extendDim.getString("number"));
                dimKeyMap.put("extdimname", extendDim.getString("name"));
                dimKeyMap.put("extdimid", extendDim.getString("id"));
            }
            this.getPageCache().put(CACHE_DIM, ObjectSerialUtil.toByteSerialized(dimKeyMap));
        } else {
            dimKeyMap.putAll((Map)ObjectSerialUtil.deSerializedBytes((String)cacheDim));
        }
        return dimKeyMap;
    }

    @Override
    public void dealMsg(CommandParam com) {
        if ("saveData".equals(com.getOperation())) {
            this.actionSave();
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if ("btn_confirm".equals(evt.getItemKey())) {
            this.actionSave();
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (this.getModelId() == 0L) {
            return;
        }
        Map map = this.getView().getFormShowParameter().getCustomParams();
        String modelId = (String)map.get("KEY_MODEL_ID");
        if (StringUtils.isEmpty((CharSequence)modelId) || modelId.equals("0")) {
            modelId = UserSelectUtil.getModelIdAfterCreateNewData(this.getView(), ctl_model);
        }
        if (StringUtils.isEmpty((CharSequence)modelId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4f53\u7cfbid\u4e3a\u7a7a\u3002", (String)"AdjSettingEditPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        this.getPageCache().put("KEY_MODEL_ID", modelId);
        this.getModel().setValue(ctl_model, (Object)modelId);
        Container flexpanelap11 = (Container)this.getControl("flexpanelap11");
        flexpanelap11.setCollapse(false);
        this.initEntryEntity();
        this.initBusinessType();
        this.initFiledNameCombos();
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        String tempid = (String)this.getView().getFormShowParameter().getCustomParam(templateid);
        String tempnumber = (String)this.getView().getFormShowParameter().getCustomParam(templatenumber);
        if (StringUtils.isEmpty((CharSequence)tempid) || StringUtils.isEmpty((CharSequence)tempnumber)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6a21\u677fid\u6216\u8005\u6a21\u677f\u7f16\u7801\u4e3a\u7a7a\u3002", (String)"AdjSettingEditPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        this.getPageCache().put(templateid, tempid);
        this.getModel().setValue(templateid, (Object)tempid);
        this.getPageCache().put(templatenumber, tempnumber);
        if (this.getModel().getValue(ctl_process) == null) {
            IDNumberTreeNode eje = MemberReader.findProcessMemberByNum((String)MemberReader.findModelNumberById((Object)modelId), (String)"EJE");
            if (eje.isLeaf()) {
                this.getModel().setValue(ctl_process, (Object)eje.getId());
            } else {
                IDNumberTreeNode eit = MemberReader.findProcessMemberByNum((String)MemberReader.findModelNumberById((Object)modelId), (String)"EIT");
                this.getModel().setValue(ctl_process, (Object)eit.getId());
            }
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.getModelId() == 0L) {
            return;
        }
        Map map = this.getView().getFormShowParameter().getCustomParams();
        String modelId = (String)map.get("KEY_MODEL_ID");
        if (StringUtils.isEmpty((CharSequence)modelId) || modelId.equals("0")) {
            modelId = UserSelectUtil.getModelIdAfterCreateNewData(this.getView(), ctl_model);
        }
        if (StringUtils.isEmpty((CharSequence)modelId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4f53\u7cfbid\u4e3a\u7a7a\u3002", (String)"AdjSettingEditPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        this.getPageCache().put("KEY_MODEL_ID", modelId);
        this.getModel().setValue(ctl_model, (Object)modelId);
        Container flexpanelap11 = (Container)this.getControl("flexpanelap11");
        flexpanelap11.setCollapse(false);
        this.initEntryEntity();
        this.initBusinessType();
        this.initFiledNameCombos();
        String tempid = (String)this.getView().getFormShowParameter().getCustomParam(templateid);
        String tempnumber = (String)this.getView().getFormShowParameter().getCustomParam(templatenumber);
        if (StringUtils.isEmpty((CharSequence)tempid) || StringUtils.isEmpty((CharSequence)tempnumber)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4f53\u7cfbid\u4e3a\u7a7a\u3002", (String)"AdjSettingEditPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (this.getModel().getValue(ctl_process) == null) {
            IDNumberTreeNode eje = MemberReader.findProcessMemberByNum((String)MemberReader.findModelNumberById((Object)modelId), (String)"EJE");
            this.getModel().setValue(ctl_process, (Object)eje.getId());
        }
        this.getPageCache().put(templateid, tempid);
        this.getModel().setValue(templateid, (Object)tempid);
        this.getPageCache().put(templatenumber, tempnumber);
        this.initMemberFieldNameDisplay();
        this.getModel().setDataChanged(false);
    }

    private void initMemberFieldNameDisplay() {
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity("entryentity");
        if (dynamicObjects != null) {
            for (int i = 0; i < dynamicObjects.size(); ++i) {
                DynamicObject rowDyn = (DynamicObject)dynamicObjects.get(i);
                for (String fieldKey : this.dynFields) {
                    String dimSign = fieldKey.replace("dyn", "");
                    String textFieldKey = dimSign + "text";
                    DynamicObject member = rowDyn.getDynamicObject(fieldKey);
                    if (member == null) continue;
                    this.rebuildComboEdit(dimSign, member.getLong("id"), member.getString("name"));
                    this.getModel().setValue(textFieldKey, (Object)member.getString("id"), i);
                }
            }
        }
    }

    private void initBusinessType() {
        List eunmList;
        String tempid = this.getFormCustomParam(templateid, "0");
        Map dimScope = IntrTemplateHelper.getDimScope((Long)LongUtil.toLong((Object)tempid));
        List enumScopList = dimScope.getOrDefault("INTR_001", new IntrTplDimScope()).getEnumList();
        List intrFields = QueryIntrDataHelper.queryExtFieldByNumbers((Long)this.getModelId(), (Set)Sets.newHashSet((Object[])new String[]{"INTR_001"}));
        if (intrFields != null && intrFields.size() > 0 && (eunmList = ((IntrField)intrFields.get(0)).getEunmList()) != null && eunmList.size() > 0) {
            ComboEdit comboEdit = (ComboEdit)this.getControl("businesstype");
            ArrayList comboItems = new ArrayList(10);
            eunmList.forEach(e -> {
                if (enumScopList != null && enumScopList.size() > 0) {
                    if (enumScopList.contains(e)) {
                        comboItems.add(new ComboItem(new LocaleString(e.toString()), e.toString()));
                    }
                } else {
                    comboItems.add(new ComboItem(new LocaleString(e.toString()), e.toString()));
                }
            });
            comboEdit.setComboItems(comboItems);
        }
    }

    @Override
    public void getEntityType(GetEntityTypeEventArgs e) {
        try {
            e.setNewEntityType((MainEntityType)e.getOriginalEntityType().clone());
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public long getModelId() {
        String modelId = this.getPageCache().get("KEY_MODEL_ID");
        if (kd.bos.util.StringUtils.isEmpty((String)modelId)) {
            String string = modelId = this.getFormCustomParam("KEY_MODEL_ID") == null ? "" : this.getFormCustomParam("KEY_MODEL_ID").toString();
        }
        if (kd.bos.util.StringUtils.isEmpty((String)modelId)) {
            this.getView().showTipNotification(MessageConstant.getMODEL_NOTEXISTS());
            return 0L;
        }
        return Long.parseLong(modelId);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId = e.getActionId();
        if ((ctl_debit.equals(actionId) || ctl_credit.equals(actionId)) && e.getReturnData() != null) {
            int[] selectRows = ((EntryGrid)this.getView().getControl("entryentity")).getSelectRows();
            if (selectRows.length < 1) {
                return;
            }
            int selectRow = selectRows[0];
            HashMap returnData = (HashMap)e.getReturnData();
            this.getModel().setValue("dcformula", returnData.get("formula"), selectRow);
            this.getModel().setValue(actionId, returnData.get("name"), selectRow);
            if (ctl_debit.equals(actionId)) {
                this.getModel().setValue(ctl_credit, (Object)"", selectRow);
            } else {
                this.getModel().setValue(ctl_debit, (Object)"", selectRow);
            }
        } else if (multiSelectDims.contains(actionId)) {
            String dimSign = actionId.replace("text", "");
            String classType = this.getDimKeyCache().get(dimSign + "sign");
            DynamicObject res = (DynamicObject)e.getReturnData();
            this.afterF7Close(res, dimSign, classType);
        } else if (actionId.startsWith("extdim")) {
            DynamicObject res = (DynamicObject)e.getReturnData();
            String dimSign = actionId.replace("extdim", "");
            String classType = "bcm_structofextend";
            this.afterF7Close(res, dimSign, classType);
        }
    }

    private void afterF7Close(DynamicObject res, String dimSign, String classType) {
        int[] selectRows = ((EntryGrid)this.getView().getControl("entryentity")).getSelectRows();
        if (selectRows.length < 1) {
            return;
        }
        int selectRow = selectRows[0];
        if (res != null) {
            this.getModel().setValue(dimSign + "classtype", (Object)classType, selectRow);
            this.getModel().setValue(dimSign + "dyn", (Object)res.getLong("id"), selectRow);
            this.rebuildComboEdit(dimSign, res.getLong("id"), res.getString("name"));
            this.getModel().setValue(dimSign + "text", (Object)res.getLong("id"), selectRow);
        } else {
            String oldValue = null;
            Object value = this.getModel().getValue(dimSign + "dyn");
            if (value instanceof DynamicObject) {
                oldValue = ((DynamicObject)value).getString("id");
            } else if (value instanceof Long) {
                oldValue = value.toString();
            }
            this.getModel().setValue(dimSign + "text", (Object)oldValue, selectRow);
        }
    }

    private void rebuildComboEdit(String dimSign, Long id, String name) {
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl(dimSign + "text");
        String comboItemCacheStr = this.getPageCache().get("comboitems" + dimSign);
        List<ComboItem> comboItems = Lists.newArrayList();
        if (kd.bos.util.StringUtils.isNotEmpty((String)comboItemCacheStr)) {
            comboItems = (List)ObjectSerialUtil.deSerializedBytes((String)comboItemCacheStr);
            if (comboItems.stream().noneMatch(e -> e.getValue().equals(id.toString()))) {
                comboItems.add(new ComboItem(null, new LocaleString(name), id.toString(), false));
            }
        } else {
            ComboProp prop = (ComboProp)comboEdit.getProperty();
            List oldComboItems = prop.getComboItems();
            for (ValueMapItem m : oldComboItems) {
                comboItems.add(new ComboItem(null, m.getName(), m.getValue(), m.isItemVisible()));
            }
            comboItems.add(new ComboItem(null, new LocaleString(name), id.toString(), false));
        }
        comboEdit.setComboItems(comboItems);
        this.getPageCache().put("comboitems" + dimSign, ObjectSerialUtil.toByteSerialized(comboItems));
    }

    private void initFiledNameCombos() {
        String templateId = (String)this.getFormCustomParam(templateid);
        String modelId = (String)this.getFormCustomParam("KEY_MODEL_ID");
        if (kd.bos.util.StringUtils.isNotEmpty((String)templateId) && kd.bos.util.StringUtils.isNotEmpty((String)modelId)) {
            QFilter qFilter = new QFilter(ctl_model, "=", (Object)LongUtil.toLong((Object)modelId));
            qFilter.and("id", "=", (Object)LongUtil.toLong((Object)templateId));
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bcm_papertemplate", (String)"id,papertemplatefield.extmodelfield.extfield.id,papertemplatefield.extmodelfield.extfield.name,papertemplatefield.extmodelfield.extfield.number,papertemplatefield.extmodelfield.extfield.datatype", (QFilter[])new QFilter[]{qFilter});
            if (dynamicObjects != null && dynamicObjects.size() > 0) {
                ComboEdit debitComboEdit = (ComboEdit)this.getControl(ctl_debit);
                ComboEdit creditComboEdit = (ComboEdit)this.getControl(ctl_credit);
                ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(10);
                comboItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5e73\u8861\u6570", (String)"AdjSettingEditPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0])), "Bn()"));
                HashMap map = new HashMap(16);
                dynamicObjects.forEach(e -> {
                    String name = e.getString("papertemplatefield.extmodelfield.extfield.name");
                    String id = e.getString("papertemplatefield.extmodelfield.extfield.id");
                    String dataType = e.getString("papertemplatefield.extmodelfield.extfield.datatype");
                    if (DataTypeEnum.DEFAULT.index.equals(dataType) || DataTypeEnum.UNCURRENCY.index.equals(dataType) || DataTypeEnum.CURRENCY.index.equals(dataType)) {
                        comboItems.add(new ComboItem(new LocaleString(name), id));
                        map.put(id, name);
                    }
                });
                debitComboEdit.setComboItems(comboItems);
                creditComboEdit.setComboItems(comboItems);
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String dimSign;
        Map<String, String> dimKeyCache;
        String dimNum;
        Object value;
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (kd.bos.util.StringUtils.isEmpty((String)key)) {
            return;
        }
        ChangeData changeData = e.getChangeSet()[0];
        int rowIndex = changeData.getRowIndex();
        if (ctl_debit.equals(key) && (value = this.getModel().getValue(ctl_debit, rowIndex)) != null && !"".equals(value)) {
            this.getModel().setValue(ctl_credit, (Object)"", rowIndex);
        }
        if (ctl_credit.equals(key) && (value = this.getModel().getValue(ctl_credit, rowIndex)) != null && !"".equals(value)) {
            this.getModel().setValue(ctl_debit, (Object)"", rowIndex);
        }
        if (multiSelectDims.contains(key) && kd.bos.util.StringUtils.isNotEmpty((String)(dimNum = (dimKeyCache = this.getDimKeyCache()).get(dimSign = key.replace("text", ""))))) {
            Long dimId = LongUtil.toLong((Object)dimKeyCache.get(dimSign + "id"));
            if ("1".equals(changeData.getNewValue())) {
                BasedataEditSingleMemberF7 sf7 = SingleMemberF7Util.createBasedataEditSingleMemberF7(this.getView(), this.getModel(), this.getModelId(), dimId, key, this, Boolean.FALSE, SingleF7TypeEnum.LEAF);
                sf7.setF7title(ResManager.loadKDString((String)"\u6210\u5458\u9009\u62e9", (String)"AdjSettingEditPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                sf7.setCallBackClassName(this.getClass().getName());
                sf7.setCustomFilter(this.getDimFilter(key));
                sf7.setSystemVariables(SystemVarsEnum.getAdjustVars());
                sf7.click();
            } else if ("0".equals(changeData.getNewValue())) {
                Long extDimId = LongUtil.toLong((Object)dimKeyCache.get("extdimid"));
                if (extDimId != 0L) {
                    QFilter qFilter = this.getExtFieldFilterByDimId(dimId);
                    if (qFilter != null) {
                        BasedataEditSingleMemberF7 extf7 = SingleMemberF7Util.createBaseDataEditSingleMemberF7(this.getView(), this.getModel(), this.getModelId(), extDimId, "extdim" + dimSign, null, Boolean.FALSE, SingleF7TypeEnum.EXT_DIM, Boolean.TRUE);
                        extf7.setCallBackClassName(this.getClass().getName());
                        extf7.setCustomFilter(qFilter);
                        extf7.click();
                    } else {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u5173\u8054\u8be5\u7ef4\u5ea6\u7684\u62d3\u5c55\u6210\u5458\u3002", (String)"AdjSettingEditPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                        String oldValue = null;
                        Object value2 = this.getModel().getValue(dimSign + "dyn");
                        if (value2 instanceof DynamicObject) {
                            oldValue = ((DynamicObject)value2).getString("id");
                        } else if (value2 instanceof Long) {
                            oldValue = value2.toString();
                        }
                        this.getModel().setValue(dimSign + "text", (Object)oldValue, rowIndex);
                    }
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u672a\u5f00\u542f\u62d3\u5c55\u7ef4\u3002", (String)"AdjSettingEditPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
            }
        }
    }

    private QFilter getExtFieldFilterByDimId(Long dimId) {
        String templateId = (String)this.getFormCustomParam(templateid);
        if (kd.bos.util.StringUtils.isNotEmpty((String)templateId)) {
            QFilter qFilter = new QFilter(ctl_model, "=", (Object)this.getModelId());
            qFilter.and("id", "=", (Object)LongUtil.toLong((Object)templateId));
            qFilter.and("papertemplatefield.extmodelfield.extfield.entryentityasso.assodim.id", "=", (Object)dimId);
            DynamicObjectCollection extfields = QueryServiceHelper.query((String)"bcm_papertemplate", (String)"id,papertemplatefield.extmodelfield.extfield.id,papertemplatefield.extmodelfield.extfield.entryentityasso.assodim.id", (QFilter[])new QFilter[]{qFilter});
            if (extfields != null) {
                HashSet extfieldIds = new HashSet(16);
                extfields.forEach(e -> extfieldIds.add(e.getLong("papertemplatefield.extmodelfield.extfield.id")));
                if (!extfieldIds.isEmpty()) {
                    return new QFilter("id", "in", extfieldIds);
                }
            }
        }
        return null;
    }

    private QFilter getDimFilter(String key) {
        QFilter qFilter = new QFilter(ctl_model, "=", (Object)this.getModelId());
        if (ctl_account.equals(key)) {
            qFilter.and(new QFilter("isleaf", "=", (Object)Boolean.TRUE));
            qFilter.and(new QFilter("accountpart.isaccountoffset", "=", (Object)true));
            qFilter.and("storagetype", "in", (Object)StorageTypeEnum.getRealStorageEnumIndexs());
        } else if (ctl_audittrail.equals(key)) {
            qFilter.and(new QFilter("isleaf", "=", (Object)Boolean.TRUE));
            qFilter.and(new QFilter("datasource", "=", (Object)DataSourceEnum.ENTRYADJUSTMENT.getOIndex()));
            qFilter.and("storagetype", "in", (Object)StorageTypeEnum.getRealStorageEnumIndexs());
        } else if (key.startsWith("dim") || key.equals(ctl_datasort) || key.equals(ctl_multigaap) || key.equals(ctl_changetype)) {
            qFilter.and(new QFilter("isleaf", "=", (Object)Boolean.TRUE));
            qFilter.and("storagetype", "in", (Object)StorageTypeEnum.getRealStorageEnumIndexs());
        }
        return qFilter;
    }

    private void initEntryEntity() {
        this.getView().setVisible(Boolean.valueOf(false), hideColums.toArray(hideColums.toArray(new String[0])));
        DynamicObject modelDyn = (DynamicObject)this.getModel().getValue(ctl_model);
        EntryGrid grid = (EntryGrid)this.getControl("entryentity");
        Map<String, String> dimKeyCache = this.getDimKeyCache();
        for (int i = 1; i <= 6; ++i) {
            String userDefinedIndex = "dim" + i;
            String columSign = userDefinedIndex + "text";
            String userDefinedNumber = dimKeyCache.get(userDefinedIndex);
            if (kd.bos.util.StringUtils.isNotEmpty((String)userDefinedNumber)) {
                String userDefinedName = dimKeyCache.get(userDefinedIndex + "name");
                grid.setColumnProperty(columSign, "header", (Object)new LocaleString(userDefinedName));
                grid.setMustInput(columSign, true);
                this.getView().setVisible(Boolean.valueOf(true), new String[]{columSign});
                continue;
            }
            this.getView().setVisible(Boolean.valueOf(false), new String[]{columSign});
        }
        boolean existAuditTrail = MemberReader.isExistAuditTrailDimension((long)modelDyn.getLong("id"));
        this.getView().setVisible(Boolean.valueOf(existAuditTrail), new String[]{ctl_audittrail});
        grid.setMustInput(ctl_audittrail, existAuditTrail);
        boolean existChangeType = MemberReader.isExistChangeTypeDimension((long)modelDyn.getLong("id"));
        this.getView().setVisible(Boolean.valueOf(existChangeType), new String[]{ctl_changetype});
        grid.setMustInput(ctl_changetype, existChangeType);
        boolean isspptdatasort = modelDyn.getBoolean("isspptdatasort");
        this.getView().setVisible(Boolean.valueOf(isspptdatasort), new String[]{ctl_datasort});
        grid.setMustInput(ctl_datasort, isspptdatasort);
        boolean isspptmultrule = modelDyn.getBoolean("isspptmultrule");
        this.getView().setVisible(Boolean.valueOf(isspptmultrule), new String[]{ctl_multigaap});
        grid.setMustInput(ctl_multigaap, isspptmultrule);
        boolean existsMyCompanyDim = DimensionServiceHelper.existsMyCompanyDim((long)modelDyn.getLong("id"));
        this.getView().setVisible(Boolean.valueOf(existsMyCompanyDim), new String[]{ctl_mycompany});
        grid.setMustInput(ctl_mycompany, existsMyCompanyDim);
        this.getView().updateView("entryentity");
    }

    private void actionSave() {
        if (this.checkDataBeforeSave()) {
            if (!QueryServiceHelper.exists((String)"bcm_papertemplate", (Object)LongUtil.toLong((Object)this.getFormCustomParam(templateid)))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6a21\u677f\u672a\u4fdd\u5b58\u6216\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5148\u68c0\u67e5\u5185\u90e8\u4ea4\u6613\u62b5\u9500\u6a21\u677f\u3002", (String)"AdjSettingEditPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject dynamicObject = this.getView().getModel().getDataEntity(true);
            dynamicObject.set("modifier", (Object)this.getUserId());
            dynamicObject.set("modifytime", (Object)TimeServiceHelper.now());
            DynamicObject[] ids = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
            SaveServiceHelper.clearDataEntityCache((String)"bcm_adjsetting");
            this.getPageCache(this.getView().getParentView()).put("focusnodeid", ids[0].getString("id"));
            CommandParam com = new CommandParam("bcm_adjsetting", "bcm_adjsettinglist", "refreshPage", new Object[0]);
            this.sendMsg(this.getView(), com);
            QFilter qf = new QFilter("id", "=", (Object)LongUtil.toLong((Object)this.getFormCustomParam(templateid)));
            DynamicObject template = BusinessDataServiceHelper.loadSingle((String)"bcm_papertemplate", (String)"id,modifier,modifytime", (QFilter[])new QFilter[]{qf});
            template.set("modifier", (Object)this.getUserId());
            template.set("modifytime", (Object)TimeServiceHelper.now());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{template});
            this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"AdjSettingEditPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            OperationLogUtil.writeOperationLog((String)OpItemEnum.SAVE.getName(), (String)String.format(ResManager.loadKDString((String)"%1$s %2$s\uff0c\u4fdd\u5b58\u6210\u529f", (String)"AdjSettingEditPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dynamicObject.getString("number"), dynamicObject.getString("name")), (Long)this.getModelId(), (String)"bcm_adjsetting");
        }
    }

    private boolean checkDataBeforeSave() {
        DynamicObject dyObj = this.getModel().getDataEntity(true);
        String name = dyObj.getString("name");
        String number = dyObj.getString("number");
        String businesstype = dyObj.getString("businesstype");
        if (kd.bos.util.StringUtils.isEmpty((String)number)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u7f16\u7801\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AdjSettingEditPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (number.length() > 30) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u7f16\u7801\u201d\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc730\u4e2a\u5b57\u7b26\u3002", (String)"AdjSettingEditPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (!BCMNumberRule.checkNumber((String)number)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6a21\u677f\u7f16\u7801\u4e0d\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u4ee5\u5916\u7684\u5b57\u7b26\uff0c\u4e0d\u53ef\u4ee5\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u5f00\u5934\uff0c\u5c0f\u6570\u70b9\u4e4b\u95f4\u5fc5\u987b\u6709\u5176\u4ed6\u5b57\u7b26\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"AdjSettingEditPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        long id = dyObj.getLong("id");
        boolean isEdit = QueryServiceHelper.exists((String)"bcm_adjsetting", (Object)id);
        QFilter filter1 = new QFilter("number", "=", (Object)number);
        QFilter filter3 = new QFilter(templateid, "=", (Object)LongUtil.toLong((Object)this.getFormCustomParam(templateid)));
        QFilter filter4 = new QFilter("id", "!=", (Object)id);
        if (!isEdit) {
            QFilter[] qFilters1 = new QFilter[]{filter1, filter3};
            boolean numberFlag = QueryServiceHelper.exists((String)"bcm_adjsetting", (QFilter[])qFilters1);
            if (numberFlag) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u7f16\u7801\u201d\u91cd\u590d\u3002", (String)"AdjSettingEditPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return false;
            }
        } else {
            QFilter[] qFiltersEdit = new QFilter[]{filter1, filter3, filter4};
            DynamicObjectCollection collection = QueryServiceHelper.query((String)"bcm_adjsetting", (String)"id", (QFilter[])qFiltersEdit);
            if (!collection.isEmpty()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u7f16\u7801\u201d\u91cd\u590d\u3002", (String)"AdjSettingEditPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        if (kd.bos.util.StringUtils.isEmpty((String)name)) {
            this.getView().getParentView().showErrorNotification(ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AdjSettingEditPlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (kd.bos.util.StringUtils.isEmpty((String)businesstype)) {
            this.getView().getParentView().showErrorNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AdjSettingEditPlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObject model = dyObj.getDynamicObject(ctl_model);
        if (model != null) {
            Map<String, String> dimKeyCache = this.getDimKeyCache();
            boolean existAuditTrail = MemberReader.isExistAuditTrailDimension((long)model.getLong("id"));
            boolean existChangeType = MemberReader.isExistChangeTypeDimension((long)model.getLong("id"));
            Map numMapped = DimensionServiceHelper.getDimensionNumMapped((Object)model.getLong("id"));
            boolean isspptdatasort = model.getBoolean("isspptdatasort");
            boolean isspptmultrule = model.getBoolean("isspptmultrule");
            boolean existsMyCompanyDim = DimensionServiceHelper.existsMyCompanyDim((long)model.getLong("id"));
            List userDefineds = DimensionServiceHelper.getUserDefineDimensionNumListByModel((Object)model.getLong("id"));
            DynamicObjectCollection entryCollection = dyObj.getDynamicObjectCollection("entryentity");
            if (entryCollection != null && entryCollection.size() > 0) {
                int index = 1;
                boolean isContainsBn = false;
                int bnEntryCount = 0;
                for (DynamicObject row : entryCollection) {
                    String msg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5206\u5f55\u660e\u7ec6\u7b2c%d\u884c\u201c%s\u201d\u5b57\u6bb5\u3002", (String)"AdjSettingEditPlugin_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                    if (row.get("accountdyn") == null) {
                        this.getView().getParentView().showErrorNotification(String.format(msg, index, ResManager.loadKDString((String)"\u79d1\u76ee", (String)"AdjSettingEditPlugin_17", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
                        return false;
                    }
                    if (kd.bos.util.StringUtils.isEmpty((String)row.getString(ctl_credit)) && kd.bos.util.StringUtils.isEmpty((String)row.getString(ctl_debit))) {
                        this.getView().getParentView().showErrorNotification(String.format(msg, index, ResManager.loadKDString((String)"\u501f\u65b9\u6216\u8d37\u65b9", (String)"AdjSettingEditPlugin_18", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
                        return false;
                    }
                    if ("Bn()".equals(row.getString(ctl_credit)) || "Bn()".equals(row.getString(ctl_debit))) {
                        isContainsBn = true;
                        ++bnEntryCount;
                    }
                    if (existChangeType && row.get("changetypedyn") == null) {
                        this.getView().getParentView().showErrorNotification(String.format(msg, index, ResManager.loadKDString((String)"\u53d8\u52a8\u7c7b\u578b", (String)"AdjSettingEditPlugin_19", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
                        return false;
                    }
                    if (existAuditTrail && row.get("audittraildyn") == null) {
                        this.getView().getParentView().showErrorNotification(String.format(msg, index, ResManager.loadKDString((String)"\u5ba1\u8ba1\u7ebf\u7d22", (String)"AdjSettingEditPlugin_20", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
                        return false;
                    }
                    if (isspptdatasort && row.get("datasortdyn") == null) {
                        this.getView().getParentView().showErrorNotification(String.format(msg, index, ResManager.loadKDString((String)"\u6570\u636e\u5206\u7c7b", (String)"AdjSettingEditPlugin_21", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
                        return false;
                    }
                    if (isspptmultrule && row.get("multigaapdyn") == null) {
                        this.getView().getParentView().showErrorNotification(String.format(msg, index, ResManager.loadKDString((String)"\u51c6\u5219", (String)"AdjSettingEditPlugin_22", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
                        return false;
                    }
                    if (existsMyCompanyDim && row.get(ctl_mycompany) == null) {
                        this.getView().getParentView().showErrorNotification(String.format(msg, index, ResManager.loadKDString((String)"\u6211\u65b9\u7ec4\u7ec7", (String)"AdjSettingEditPlugin_23", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
                        return false;
                    }
                    if (row.get(ctl_entity) == null) {
                        this.getView().getParentView().showErrorNotification(String.format(msg, index, ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"AdjSettingEditPlugin_24", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
                        return false;
                    }
                    if (row.get("opcompany") == null) {
                        this.getView().getParentView().showErrorNotification(String.format(msg, index, ResManager.loadKDString((String)"\u5f80\u6765\u7ec4\u7ec7", (String)"AdjSettingEditPlugin_25", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
                        return false;
                    }
                    for (int i = 1; i <= userDefineds.size(); ++i) {
                        if (row.get((String)numMapped.get(userDefineds.get(i - 1)) + "dyn") != null) continue;
                        this.getView().getParentView().showErrorNotification(String.format(msg, index, dimKeyCache.get((String)numMapped.get(userDefineds.get(i - 1)) + "name")));
                        return false;
                    }
                    ++index;
                }
                if (!isContainsBn || bnEntryCount != 1) {
                    this.getView().getParentView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u4e00\u884c\u5e73\u8861\u6570\u5206\u5f55\u660e\u7ec6\u3002", (String)"AdjSettingEditPlugin_26", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return false;
                }
            } else {
                this.getView().getParentView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u586b\u5199\u4e00\u884c\u5206\u5f55\u660e\u7ec6\u3002", (String)"AdjSettingEditPlugin_27", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }
}

