/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.papertemplate.adjust;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.enums.status.ResultStatusEnum;
import kd.fi.bcm.common.util.BCMTreeUtils;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.pageinteraction.CommandParam;
import kd.fi.bcm.formplugin.pageinteraction.MainPage;
import kd.fi.bcm.formplugin.papertemplate.adjust.AdjSettingEditPlugin;
import kd.fi.bcm.formplugin.papertemplate.adjust.AdjSettingExportHelper;
import kd.fi.bcm.formplugin.util.UserSelectUtil;

public class AdjSettingListPlugin
extends AbstractBaseListPlugin
implements MainPage {
    private static final Log logger = LogFactory.getLog(AdjSettingListPlugin.class);
    private static final String templateid = "templateid";
    private static final String templatenumber = "templatenumber";
    private static final String ctl_adjsettingtree = "adjsettingtree";
    private static final String btn_addgroup = "btn_addgroup";
    private static final String btn_editgroup = "btn_editgroup";
    private static final String btn_delgroup = "btn_delgroup";
    private static final String callbackid_del_confirm = "callbackid_del_confirm";

    @Override
    public void initialize() {
        super.initialize();
        HashMap<String, SingleF7TypeEnum> map = new HashMap<String, SingleF7TypeEnum>(16);
        map.put("scenario", SingleF7TypeEnum.LEAF);
        super.initSingleMemberF7(map);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(btn_addgroup, btn_editgroup, btn_delgroup);
        TreeView treeView = (TreeView)this.getControl(ctl_adjsettingtree);
        treeView.addTreeNodeClickListener(new TreeNodeClickListener(){

            public void treeNodeClick(TreeNodeEvent evt) {
                super.treeNodeClick(evt);
                AdjSettingListPlugin.this.getPageCache().put("focusnodeid", evt.getNodeId().toString());
                if (AdjSettingListPlugin.this.checkSubPageDataChange("treeNodeClick")) {
                    AdjSettingListPlugin.this.openAdjSettingInfoPage(evt.getNodeId().toString());
                }
            }
        });
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String modelId = (String)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        if (StringUtils.isEmpty((CharSequence)modelId) || modelId.equals("0")) {
            modelId = UserSelectUtil.getModelIdAfterCreateNewData(this.getView(), "model");
        }
        if (StringUtils.isEmpty((CharSequence)modelId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4f53\u7cfbID\u4e3a\u7a7a\u3002", (String)"AdjSettingListPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        String tempid = (String)this.getView().getFormShowParameter().getCustomParam(templateid);
        String tempnumber = (String)this.getView().getFormShowParameter().getCustomParam(templatenumber);
        if (StringUtils.isEmpty((CharSequence)tempid) || StringUtils.isEmpty((CharSequence)tempnumber)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6a21\u677fID\u6216\u6a21\u677f\u7f16\u7801\u4e3a\u7a7a\u3002", (String)"AdjSettingListPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        this.getPageCache().put("KEY_MODEL_ID", modelId);
        this.getPageCache().put(templateid, tempid);
        this.getPageCache().put(templatenumber, tempnumber);
        this.refreshTree();
        if (this.getFormCustomParam("noModify") != null) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"btn_addnew", "btn_save", "btn_del", "btn_copy", "btn_enable", "btn_disable", "btn_import"});
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "btn_addnew": {
                super.doCheckPermission("bcm_papertemplatelist", "4715a0df000000ac");
                this.openNewAdjSettingInfoPage();
                break;
            }
            case "btn_copy": {
                super.doCheckPermission("bcm_papertemplatelist", "4715a0df000000ac");
                if (!this.checkSubPageDataChange(key)) break;
                this.openCopyAdjSettingInfoPage();
                break;
            }
            case "btn_save": {
                super.doCheckPermission("bcm_papertemplatelist", "4715a0df000000ac");
                this.saveAdjSettingInfo();
                break;
            }
            case "btn_del": {
                super.doCheckPermission("bcm_papertemplatelist", "4715a0df000000ac");
                this.actionDelete();
                break;
            }
            case "btn_refresh": {
                if (!this.checkSubPageDataChange(key)) break;
                this.refreshTree();
                break;
            }
            case "btn_enable": {
                super.doCheckPermission("bcm_papertemplatelist", "4715a0df000000ac");
                this.updateAdjsettingEnable(true);
                break;
            }
            case "btn_disable": {
                super.doCheckPermission("bcm_papertemplatelist", "4715a0df000000ac");
                this.updateAdjsettingEnable(false);
                break;
            }
            case "btn_export": {
                super.doCheckPermission("bcm_papertemplatelist", "47150e89000000ac");
                this.exportAdjSettingPage();
                break;
            }
            case "btn_import": {
                super.doCheckPermission("bcm_papertemplatelist", "4715a0df000000ac");
                this.importAdjSettingPage();
                break;
            }
        }
    }

    private boolean checkSubPageDataChange(String key) {
        String adjinfoPageId = this.getPageCache().get("adjinfo_pageId");
        try {
            if (StringUtils.isNotEmpty((CharSequence)adjinfoPageId) && this.getView().getView(adjinfoPageId) != null) {
                if (this.getView().getView(adjinfoPageId).getModel().getDataChanged()) {
                    this.beforeSubViewClosed(this.getView().getView(adjinfoPageId));
                }
                if (this.getView().getView(adjinfoPageId).getModel().getDataChanged() && this.getFormCustomParam("noModify") == null) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4fdd\u5b58\uff1f", (String)"AdjSettingListPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]), this.getView().getView(adjinfoPageId).getModel().getChangeDesc(), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("callback_" + key, (IFormPlugin)this));
                    return false;
                }
            }
        }
        catch (Exception e) {
            log.error("checkSubPageDataChange error !");
        }
        return true;
    }

    private void beforeSubViewClosed(IFormView subView) {
        DynamicObject dataEntity = subView.getModel().getDataEntity(true);
        DynamicObjectCollection entryentity = dataEntity.getDynamicObjectCollection("entryentity");
        for (DynamicObject item : entryentity) {
            DataEntityPropertyCollection properties = item.getDataEntityType().getProperties();
            DataEntityState dataEntityState = item.getDataEntityState();
            for (String proKey : AdjSettingEditPlugin.hideColums) {
                IDataEntityProperty baseProperty;
                IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)proKey);
                if (property == null) continue;
                dataEntityState.setBizChanged(property.getOrdinal(), false);
                if (!(property instanceof BasedataProp) || (baseProperty = (IDataEntityProperty)properties.get((Object)(proKey + "_id"))) == null) continue;
                dataEntityState.setBizChanged(baseProperty.getOrdinal(), false);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent mbc) {
        super.confirmCallBack(mbc);
        if (callbackid_del_confirm.equals(mbc.getCallBackId())) {
            String focusnodeid = this.getPageCache().get("focusnodeid");
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)focusnodeid, (String)"bcm_adjsetting");
            if (MessageBoxResult.Yes.equals((Object)mbc.getResult()) && dynamicObject != null) {
                DeleteServiceHelper.delete((String)"bcm_adjsetting", (QFilter[])new QFBuilder("id", "=", (Object)LongUtil.toLong((Object)focusnodeid)).toArray());
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"AdjSettingListPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                this.refreshTree();
                OperationLogUtil.writeOperationLog((String)OpItemEnum.DELETE.getName(), (String)String.format(ResManager.loadKDString((String)"%1$s %2$s\uff0c\u5220\u9664\u6210\u529f", (String)"CheckTmplListPlugin_43", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dynamicObject.getString("number"), dynamicObject.getString("name")), (Long)this.getModelId(), (String)"bcm_adjsetting");
            }
        } else if ("callback_btn_refresh".equals(mbc.getCallBackId())) {
            if (MessageBoxResult.Yes.equals((Object)mbc.getResult())) {
                this.saveAdjSettingInfo();
            } else {
                this.refreshTree();
            }
        } else if ("callback_btn_copy".equals(mbc.getCallBackId())) {
            if (MessageBoxResult.Yes.equals((Object)mbc.getResult())) {
                this.saveAdjSettingInfo();
            } else {
                this.openCopyAdjSettingInfoPage();
            }
        } else if ("callback_btn_close".equals(mbc.getCallBackId())) {
            if (MessageBoxResult.Yes.equals((Object)mbc.getResult())) {
                this.saveAdjSettingInfo();
            } else {
                this.getPageCache().put("forceClose", "true");
                this.getView().close();
            }
        }
        if ("callback_treeNodeClick".equals(mbc.getCallBackId())) {
            if (MessageBoxResult.Yes.equals((Object)mbc.getResult())) {
                this.saveAdjSettingInfo();
            } else {
                this.openAdjSettingInfoPage(this.getPageCache().get("focusnodeid"));
            }
        }
    }

    @Override
    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (this.getPageCache().get("forceClose") == null && !this.checkSubPageDataChange("btn_close")) {
            e.setCancel(true);
        }
    }

    private void saveAdjSettingInfo() {
        CommandParam com = new CommandParam("bcm_adjsettinglist", "bcm_adjsetting", "saveData", new Object[0]);
        com.setParam(Collections.singletonList(new String[]{this.getPageCache().get(templateid)}));
        this.sendMsg(this.getView(), com);
    }

    private void updateAdjsettingEnable(boolean isEnable) {
        String focusnodeid = this.getPageCache().get("focusnodeid");
        if (StringUtils.isEmpty((CharSequence)focusnodeid) || "0".equals(focusnodeid) || "-1".equals(focusnodeid)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u6570\u636e\u3002", (String)"AdjSettingListPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        } else {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)focusnodeid, (String)"bcm_adjsetting");
            dynamicObject.set("status", (Object)(isEnable ? "1" : "0"));
            dynamicObject.set("modifier", (Object)this.getUserId());
            dynamicObject.set("modifytime", (Object)TimeServiceHelper.now());
            SaveServiceHelper.update((DynamicObject)dynamicObject);
            SaveServiceHelper.clearDataEntityCache((String)"bcm_adjsetting");
            String msg = isEnable ? ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f\u3002", (String)"AdjSettingListPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\u3002", (String)"AdjSettingListPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            this.getView().showSuccessNotification(msg);
            String opName = isEnable ? OpItemEnum.ENABLE.getName() : OpItemEnum.DISABLE.getName();
            this.writeOperationLog(opName, dynamicObject.getString("model.name") + " " + dynamicObject.getString("number") + dynamicObject.getString("name") + msg);
            this.refreshTree();
        }
    }

    private void actionDelete() {
        String focusnodeid = this.getPageCache().get("focusnodeid");
        if (StringUtils.isEmpty((CharSequence)focusnodeid) || "0".equals(focusnodeid) || "-1".equals(focusnodeid)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8981\u5220\u9664\u7684\u6570\u636e\u3002", (String)"AdjSettingListPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        } else {
            if (this.isExistAdjust(this.getModelId(), LongUtil.toLong((Object)focusnodeid))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff0c\u5f53\u524d\u5206\u5f55\u8bbe\u7f6e\u5df2\u751f\u6210\u5206\u5f55\uff0c\u8bf7\u6253\u56de\u5e95\u7a3f\u540e\u518d\u5220\u9664\u3002", (String)"AdjSettingListPlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u662f\u5426\u5220\u9664\uff1f", (String)"CheckTmplListPlugin_22", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(callbackid_del_confirm, (IFormPlugin)this));
        }
    }

    private boolean isExistAdjust(long modelId, Long settingId) {
        return QueryServiceHelper.exists((String)"bcm_linkadjust_mapping", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId), new QFilter("linkid", "=", (Object)settingId)});
    }

    private void openNewAdjSettingInfoPage() {
        TreeView tree = (TreeView)this.getControl(ctl_adjsettingtree);
        tree.focusNode(new TreeNode("", "0", ResManager.loadKDString((String)"\u5185\u90e8\u4ea4\u6613\u62b5\u9500", (String)"AdjSettingListPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
        this.getPageCache().remove("focusnodeid");
        this.openAdjSettingInfoPage("-1");
    }

    private void openCopyAdjSettingInfoPage() {
        String focusnodeid = this.getPageCache().get("focusnodeid");
        if (StringUtils.isEmpty((CharSequence)focusnodeid) || "0".equals(focusnodeid) || "-1".equals(focusnodeid)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8981\u590d\u5236\u7684\u6570\u636e\u3002", (String)"AdjSettingListPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        } else {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)focusnodeid, (String)"bcm_adjsetting");
            if (dynamicObject != null) {
                DynamicObject clone = (DynamicObject)OrmUtils.clone((IDataEntityBase)dynamicObject, (boolean)false, (boolean)true);
                clone.set("number", (Object)(dynamicObject.getString("number") + "_copy"));
                clone.set("name", (Object)(dynamicObject.getString("name") + "-copy"));
                DynamicObject[] ids = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{clone});
                this.getPageCache().put("focusnodeid", ids[0].getString("id"));
                this.refreshTree();
                this.writeLog(OpItemEnum.COPY.getName(), clone.getString("number") + OpItemEnum.COPY.getName() + ResultStatusEnum.SUCCESS.getName());
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u6570\u636e\u5df2\u7ecf\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u540e\u518d\u64cd\u4f5c\u3002", (String)"AdjSettingListPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void openAdjSettingInfoPage(String pkid) {
        String adjinfoPageId = this.getPageCache().get("adjinfo_pageId");
        if (StringUtils.isNotEmpty((CharSequence)adjinfoPageId) && this.getView().getView(adjinfoPageId) != null) {
            this.getView().getView(adjinfoPageId).close();
        }
        FormShowParameter lsp = new FormShowParameter();
        lsp.setFormId("bcm_adjsetting");
        lsp.setStatus(OperationStatus.ADDNEW);
        if (!(StringUtils.isEmpty((CharSequence)pkid) || "0".equals(pkid) || "-1".equals(pkid))) {
            HashMap<String, String> openParameter = new HashMap<String, String>(16);
            openParameter.put("formId", "bcm_adjsetting");
            openParameter.put("pkId", pkid);
            lsp = FormShowParameter.createFormShowParameter(openParameter);
            lsp.setStatus(OperationStatus.EDIT);
        }
        String pageId = this.getPageIdAndCache(this.getPageCache(), "bcm_adjsetting");
        this.getPageCache().put("adjinfo_pageId", pageId);
        lsp.setPageId(pageId);
        lsp.setCustomParam("KEY_MODEL_ID", (Object)(this.getModelId() + ""));
        lsp.setCustomParam(templateid, (Object)this.getPageCache().get(templateid));
        lsp.setCustomParam(templatenumber, (Object)this.getPageCache().get(templatenumber));
        lsp.getOpenStyle().setTargetKey("adjinfo");
        lsp.getOpenStyle().setShowType(ShowType.InContainer);
        lsp.setParentPageId(this.getView().getPageId());
        this.getView().showForm(lsp);
    }

    private void refreshTree() {
        TreeView tree = (TreeView)this.getControl(ctl_adjsettingtree);
        tree.deleteAllNodes();
        this.initTree();
    }

    private void initTree() {
        String oldSelectNodeId = this.getPageCache().get("focusnodeid");
        TreeNode root = new TreeNode("", "0", ResManager.loadKDString((String)"\u5185\u90e8\u4ea4\u6613\u62b5\u9500", (String)"AdjSettingListPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        String modelID = this.getPageCache().get("KEY_MODEL_ID");
        String templateId = this.getPageCache().get(templateid);
        String selectFields = "id,name,number,businesstype,status";
        QFilter fmodelid = new QFilter("model", "=", (Object)ConvertUtil.convertObjToLong((Object)modelID));
        QFilter ftemplateid = new QFilter(templateid, "=", (Object)ConvertUtil.convertObjToLong((Object)templateId));
        QFilter[] filters = new QFilter[]{fmodelid, ftemplateid};
        String orderBys = "id";
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"bcm_adjsetting", (String)selectFields, (QFilter[])filters, (String)orderBys);
        ArrayList treeList = new ArrayList(10);
        if (dcs != null && dcs.size() > 0) {
            for (DynamicObject task : dcs) {
                HashMap<String, String> memberMap = new HashMap<String, String>(16);
                memberMap.put("id", task.get("id").toString());
                memberMap.put("number", (String)task.get("number"));
                memberMap.put("name", ("0".equals(task.getString("status")) ? ResManager.loadKDString((String)"\uff08\u7981\u7528\uff09", (String)"AdjSettingListPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]) : "") + task.getString("businesstype") + "_" + (String)task.get("name"));
                memberMap.put("parentid", "0");
                treeList.add(memberMap);
            }
        }
        BCMTreeUtils.setEntryNode((TreeNode)root, treeList, (String)"0");
        BCMTreeUtils.spreadAllNode((TreeNode)root);
        TreeView tree = (TreeView)this.getControl(ctl_adjsettingtree);
        tree.addNode(root);
        if (CollectionUtils.isEmpty((Collection)root.getChildren())) {
            tree.focusNode(root);
            this.getPageCache().put("focusnodeid", "0");
        } else {
            TreeNode oldSelectNode = null;
            if (StringUtils.isNotEmpty((CharSequence)oldSelectNodeId) && (oldSelectNode = root.getTreeNode(oldSelectNodeId, 1)) != null) {
                tree.focusNode(oldSelectNode);
                this.getPageCache().put("focusnodeid", oldSelectNodeId);
            } else {
                tree.focusNode((TreeNode)root.getChildren().get(0));
                this.getPageCache().put("focusnodeid", ((TreeNode)root.getChildren().get(0)).getId());
            }
        }
        this.openAdjSettingInfoPage(this.getPageCache().get("focusnodeid"));
    }

    @Override
    public long getModelId() {
        String modelId = this.getPageCache().get("KEY_MODEL_ID");
        if (StringUtils.isEmpty((CharSequence)modelId)) {
            String string = modelId = this.getFormCustomParam("KEY_MODEL_ID") == null ? "" : this.getFormCustomParam("KEY_MODEL_ID").toString();
        }
        if (StringUtils.isEmpty((CharSequence)modelId)) {
            return 0L;
        }
        return Long.parseLong(modelId);
    }

    @Override
    public void dealMsg(CommandParam com) {
        if ("refreshPage".equals(com.getOperation())) {
            this.refreshTree();
        }
    }

    private void exportAdjSettingPage() {
        ListShowParameter listParams = new ListShowParameter();
        listParams.setBillFormId("bcm_adjsetting");
        listParams.setFormId("bos_listf7");
        StyleCss css = new StyleCss();
        css.setWidth("960px");
        css.setHeight("580px");
        listParams.getOpenStyle().setInlineStyleCss(css);
        listParams.setLookUp(true);
        listParams.setShowFilter(false);
        listParams.setShowQuickFilter(false);
        listParams.setMultiSelect(true);
        listParams.setMustInput(true);
        listParams.setCaption(ResManager.loadKDString((String)"\u5206\u5f55\u8bbe\u7f6e", (String)"AdjSettingListPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        listParams.getOpenStyle().setShowType(ShowType.Modal);
        listParams.setCustomParam("modelId", (Object)this.getModelId());
        ListFilterParameter listFilterParameter = listParams.getListFilterParameter();
        QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId());
        qFilter.and(new QFilter(templateid, "=", (Object)LongUtil.toLong((Object)this.getPageCache().get(templateid))));
        listFilterParameter.setFilter(qFilter);
        listParams.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "btn_export_closecallback"));
        this.getView().showForm((FormShowParameter)listParams);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String key = evt.getActionId();
        if ("btn_export_closecallback".equals(key)) {
            ListSelectedRowCollection rowCollection;
            Set<Long> ids;
            if (evt.getReturnData() != null && !(ids = (rowCollection = (ListSelectedRowCollection)evt.getReturnData()).stream().map(e -> LongUtil.toLong((Object)e.getPrimaryKeyValue())).collect(Collectors.toSet())).isEmpty()) {
                try {
                    Pair<String, DynamicObject[]> res = AdjSettingExportHelper.exportAdjSetting(this.getBizAppId(), this.getModelId(), LongUtil.toLong((Object)this.getPageCache().get(templateid)), ids);
                    if (StringUtils.isNotEmpty((CharSequence)((CharSequence)res.p1))) {
                        DynamicObject template;
                        this.downloadFile((String)res.p1, "bcm_papertemplatelist", "47150e89000000ac");
                        if (((DynamicObject[])res.p2).length != 0 && (template = QueryServiceHelper.queryOne((String)"bcm_papertemplate", (String)"id,number,versionnumber", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)LongUtil.toLong((Object)this.getPageCache().get(templateid)))})) != null) {
                            String modelShowNumber = MemberReader.findModelSNumberById((Object)this.getModelId());
                            String versionNum = String.format("V%.1f", Float.valueOf(template.getBigDecimal("versionnumber").floatValue()));
                            String templateNum = template.getString("number");
                            Arrays.asList((Object[])res.p2).forEach(e -> {
                                String des = String.format(ResManager.loadKDString((String)"\u4f53\u7cfb[%1$s]\u5185\u90e8\u4ea4\u6613\u6a21\u677f[%2$s]\u7248\u672c\u53f7[%3$s]\u5206\u5f55\u8bbe\u7f6e[%4$s]\u5bfc\u51fa\u6210\u529f\u3002", (String)"CheckTmplBatchImportPlugin_65", (String)"fi-bcm-formplugin", (Object[])new Object[0]), modelShowNumber, templateNum, versionNum, e.getString("number"));
                                OperationLogUtil.writeOperationLog((String)ResManager.loadKDString((String)"\u5bfc\u51fa", (String)"RptAdjustdListPlugin_21", (String)"fi-bcm-formplugin", (Object[])new Object[0]), (String)des, (Long)0L, (String)"bcm_adjsetting");
                            });
                        }
                    }
                }
                catch (IOException e2) {
                    logger.error((Throwable)e2);
                }
            }
        } else if ("btn_import_closecallback".equals(key)) {
            this.refreshTree();
        }
    }

    private void importAdjSettingPage() {
        this.invokeOperation("bcm_adjsetting_import", "kd.fi.bcm.formplugin.papertemplate.adjust.AdjSettingBatchImportPlugin", ResManager.loadKDString((String)"\u5185\u90e8\u4ea4\u6613\u62b5\u9500\u6a21\u677f\u5206\u5f55\u8bbe\u7f6e", (String)"AdjSettingExportHelper_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), "btn_import_closecallback");
        SaveServiceHelper.clearDataEntityCache((String)"bcm_adjsetting");
    }
}

