/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.papertemplate.innertrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.innertrade.model.IntrField;
import kd.fi.bcm.business.innertrade.report.IntrTemplateHelper;
import kd.fi.bcm.business.papertemplate.CommonPaperTemplateModel;
import kd.fi.bcm.business.papertemplate.InnerTradeTemplateModel;
import kd.fi.bcm.common.enums.papertemplate.PaperTemplateSpreadKeyEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.formplugin.spread.SpreadBasePlugin;
import kd.fi.bcm.formplugin.spread.SpreadClientInvoker;
import kd.fi.bcm.formplugin.template.model.ISpreadModelSupplier;
import kd.fi.bcm.formplugin.template.model.ISupportPageCacheProxy;
import kd.fi.bcm.spread.domain.view.JsonSerializerUtil;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.js.SpreadProperties;

public abstract class AbstractPaperTemplate
extends SpreadBasePlugin
implements ISpreadModelSupplier,
ISupportPageCacheProxy {
    protected final String KEY_TEMPLATE_MODEL = "paper_template_model";
    protected final String KEY_SPREAD_MODEL = "KEY_SPREAD_MODEL";
    protected final String SPREAD_KEY = PaperTemplateSpreadKeyEnum.INTERNAL_TRANSACTION.getKey();
    protected static WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, AbstractPaperTemplate.class);
    protected CommonPaperTemplateModel template;
    protected SpreadManager spread;

    @Override
    public String getSpreadKey() {
        return this.SPREAD_KEY;
    }

    @Override
    public SpreadManager getSpreadModel() {
        if (this.spread != null) {
            return this.spread;
        }
        String spreadModelSerial = this.getPageCache().get("KEY_SPREAD_MODEL");
        Predicate<String> p = StringUtils::isEmpty;
        boolean hasCache = true;
        if (p.test(spreadModelSerial)) {
            if (this.isTemplatePlugin()) {
                spreadModelSerial = this.getTemplateModel().getData();
            }
            hasCache = false;
        }
        this.spread = !p.test(spreadModelSerial) ? JsonSerializerUtil.toSpreadManager((String)spreadModelSerial) : this.buildSpreadManager();
        if (!hasCache) {
            this.cacheSpreadModel(this.spread);
        }
        return this.spread;
    }

    protected SpreadManager buildSpreadManager() {
        SpreadManager spread = new SpreadManager(this.getTemplateModel().getName(), null);
        IntrTemplateHelper.repairTableRow((SpreadManager)spread);
        this.spread = spread;
        this.getPageCache().put("KEY_SPREAD_MODEL", this.toSerialSpreadModel(spread));
        return spread;
    }

    public void cacheSpreadModel() {
        this.cacheSpreadModel(this.getSpreadModel());
    }

    @Override
    public void cacheSpreadModel(SpreadManager spread) {
        this.getPageCache().put("KEY_SPREAD_MODEL", JsonSerializerUtil.toJson((SpreadManager)spread));
    }

    public CommonPaperTemplateModel getTemplateModel() {
        if (this.template != null) {
            return this.template;
        }
        Predicate<String> p = StringUtils::isEmpty;
        String serial = this.getPageCache().get("paper_template_model");
        if (p.test(serial)) {
            serial = (String)this.getFormCustomParam("paper_template_model");
            this.template = !p.test(serial) ? this.getTemplateModelFromSerial(serial) : this.newInstancePaperTemplate();
            this.getPageCache().put("paper_template_model", this.toSerialTemplateModel(this.template));
        } else {
            this.template = this.getTemplateModelFromSerial(serial);
        }
        return this.template;
    }

    private CommonPaperTemplateModel newInstancePaperTemplate() {
        PaperTemplateSpreadKeyEnum paperTemplateSpreadKeyEnum = PaperTemplateSpreadKeyEnum.getSpreadKeyEnumByKey((String)this.getSpreadKey());
        switch (paperTemplateSpreadKeyEnum) {
            case INTERNAL_TRANSACTION: {
                return new InnerTradeTemplateModel();
            }
            case INV: {
                return new InnerTradeTemplateModel();
            }
        }
        return new CommonPaperTemplateModel();
    }

    protected Sheet getEffectiveSheet() {
        return this.getSpreadModel().getBook().getSheet(0);
    }

    protected CommonPaperTemplateModel getTemplateModelFromSerial(String serial) {
        return (CommonPaperTemplateModel)this.deSerializedBytes(serial);
    }

    protected String getTemplateModelSerial() {
        return this.toSerialTemplateModel(this.getTemplateModel());
    }

    protected String getSpreadModelSerial() {
        return this.toSerialSpreadModel(this.getSpreadModel());
    }

    protected SpreadManager getSpreadModelFromSerial(String serial) {
        return JsonSerializerUtil.toSpreadManager((String)serial);
    }

    protected String toSerialTemplateModel(CommonPaperTemplateModel model) {
        return this.toByteSerialized(model);
    }

    public String toSerialSpreadModel(SpreadManager spread) {
        return JsonSerializerUtil.toJson((SpreadManager)spread);
    }

    protected void cacheTemplateModel() {
        this.getPageCache().put("paper_template_model", this.getTemplateModelSerial());
    }

    public void cacheTemplateModel(CommonPaperTemplateModel model) {
        this.getPageCache().put("paper_template_model", this.toSerialTemplateModel(model));
    }

    protected boolean isTemplatePlugin() {
        return true;
    }

    protected void invokeJsUpdateCellValues(int r, int c, IntrField field) {
        String msg = field == null ? null : field.getName();
        this.getEffectiveSheet().getCell(r, c).setValue((Object)msg);
        ArrayList<Map<String, Object>> cellValues = new ArrayList<Map<String, Object>>();
        cellValues.add(this.packedUpdateCellMap(r, c, msg));
        this.invokeSpreadUpdateValueMethod(cellValues);
    }

    protected void invokeSpreadUpdateValueMethod(List<Map<String, Object>> cellValues) {
        SpreadClientInvoker.invokeUpdataValueMethod(this.getClientViewProxy(), this.SPREAD_KEY, cellValues);
    }

    public Map<String, Object> packedUpdateCellMap(int r, int c, Object value) {
        HashMap<String, Object> valMap = new HashMap<String, Object>();
        valMap.put(SpreadProperties.UpdataValueMethod.R.k(), r);
        valMap.put(SpreadProperties.UpdataValueMethod.C.k(), c);
        valMap.put(SpreadProperties.UpdataValueMethod.V.k(), value);
        return valMap;
    }

    @Override
    public boolean isOpenPageCacheProxy() {
        return true;
    }

    public abstract boolean checkIsExistReport();
}

