/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.papertemplate.innertrade;

import com.google.common.collect.Maps;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.formula.express.ExpressParser;
import kd.fi.bcm.business.formula.model.FormulaEnum;
import kd.fi.bcm.business.formula.model.IFormula;
import kd.fi.bcm.business.formula.param.ParamItem;
import kd.fi.bcm.business.formula.param.ParamList;
import kd.fi.bcm.business.innertrade.model.IntrField;
import kd.fi.bcm.business.papertemplate.ExtDimHelper;
import kd.fi.bcm.common.IntrConstant;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.papertemplate.innertrade.IFunctionSettingPlugin;
import kd.fi.bcm.spread.formula.EncoderService;

public class DvbFunctionSettingPlugin
extends AbstractBaseFormPlugin
implements IFunctionSettingPlugin {
    public static final String KEY_MODEL = "extendmodel";
    public static final String KEY_FILED = "fieldid";
    public static final String KEY_BYMODEL = "byextendmodel";
    public static final String KEY_BYFILED = "byfieldid";
    public static final String BTN_CONFIRM = "confirm";
    public static final String KEY_TEXT = "modeltext";
    public static final String KEY_BYTEXT = "bymodeltext";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(BTN_CONFIRM, KEY_TEXT, KEY_BYTEXT);
        BasedataEdit extendModelF7 = (BasedataEdit)this.getControl(KEY_MODEL);
        extendModelF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit byExtendModelF7 = (BasedataEdit)this.getControl(KEY_BYMODEL);
        byExtendModelF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (this.getFormCustomParam("formula") != null) {
            String formulaText = (String)this.getFormCustomParam("formula");
            ExpressParser parser = new ExpressParser();
            EncoderService encoder = new EncoderService();
            try {
                Pair pair = parser.parse(formulaText, encoder);
                ParamList paramList = ((IFormula)((List)pair.p2).get(0)).getParamList();
                String[] params = ((ParamItem)paramList.get(0)).toString().split("@");
                QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
                DynamicObject modelDyn = QueryServiceHelper.queryOne((String)"bcm_extendsmodel", (String)"id,number,name", (QFilter[])new QFilter[]{filter, new QFilter("number", "=", (Object)params[0])});
                IntrField field = ExtDimHelper.getTmpFieldByNum((Long)modelDyn.getLong("id"), (String)params[1]);
                this.getModel().setValue(KEY_MODEL, (Object)modelDyn.getLong("id"));
                if (field != null) {
                    this.getModel().setValue(KEY_FILED, (Object)field.getId());
                    this.getModel().setValue(KEY_TEXT, (Object)(modelDyn.getString("name") + "@" + field.getName()));
                }
            }
            catch (Exception e1) {
                log.error("error", (Throwable)e1);
            }
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_MODEL, KEY_FILED, KEY_BYMODEL, KEY_BYFILED, KEY_BYTEXT});
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (Objects.equals(BTN_CONFIRM, key) && this.validate()) {
            String modelNumber = ((DynamicObject)this.getValue(KEY_MODEL)).getString("number");
            String modelName = ((DynamicObject)this.getValue(KEY_MODEL)).getString("name");
            String fieldNumber = "";
            String fieldName = "";
            Long fieldId = (Long)this.getValue(KEY_FILED);
            IntrField field = ExtDimHelper.getTmpFieldById((Long)fieldId);
            if (field != null) {
                fieldNumber = field.getNumber();
                fieldName = field.getName();
            }
            String formula = FormulaEnum.Dvb.getCode() + "(\"" + modelNumber + "@" + fieldNumber + "\")";
            HashMap map = Maps.newHashMap();
            map.put("formula", formula);
            map.put("name", String.format("%s(%s@%s)", FormulaEnum.Dvb.getText(), modelName, fieldName));
            this.getView().returnDataToParent((Object)map);
            this.getView().close();
        } else if (Objects.equals(KEY_TEXT, key)) {
            FormShowParameter formShowParameter = new FormShowParameter();
            this.setFormShowParameter(this.getModel(), formShowParameter, KEY_MODEL, null, KEY_MODEL, KEY_FILED, KEY_TEXT);
            formShowParameter.setCustomParam("filterDatatype", (Object)String.join((CharSequence)",", IntrConstant.DIGITAL_DATA_TYPE));
            formShowParameter.setCustomParam("filterModelId", this.getFormCustomParam("seller"));
            this.getView().showForm(formShowParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        this.setExtendValue(this.getModel(), actionId, e.getReturnData());
    }

    private boolean validate() {
        if (StringUtils.isEmpty((String)((String)this.getValue(KEY_TEXT)))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u201c\u9700\u5206\u914d\u7684\u62d3\u5c55\u7ef4\u6210\u5458\u201d\u3002", (String)"DvbFunctionSettingPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }
}

