/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.papertemplate.innertrade;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.fi.bcm.business.innertrade.model.IntrField;
import kd.fi.bcm.business.papertemplate.ExtDimHelper;
import kd.fi.bcm.business.papertemplate.PaperTemplateFieldEntry;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.pageinteraction.DynamicPage;
import kd.fi.bcm.formplugin.pageinteraction.SubPage;
import kd.fi.bcm.formplugin.papertemplate.innertrade.IntrFromulaExportHelper;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;

public class FormulaListEditPlugin
extends AbstractBaseFormPlugin
implements SubPage,
DynamicPage {
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String KEY_FORMULA = "formula";
    private static final String KEY_FORMULANAME = "formula_name";
    private static final String KEY_FORMULA_DES = "formulades";
    private static final String KEY_NAME = "name";
    private static final String KEY_IS_MERGE = "ismerge";
    private static final String BTN_CONFIRM = "confirm";
    private static final String IS_MODIFY = "is_modify";
    public static final String DIM_INDEX_SET = "DIM_INDEX_SET";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
        entryEntity.clear();
        List fieldList = (List)ObjectSerialUtil.deSerializedBytes((String)((String)this.getFormCustomParam("paperTemplateField")));
        this.packageData(fieldList);
        this.setModified(false);
        this.getView().updateView(ENTRY_ENTITY);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(KEY_FORMULANAME, BTN_CONFIRM);
        this.addItemClickListeners("toolbarap", "btn_export", "btn_import");
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (Objects.equals(key, KEY_FORMULANAME)) {
            int[] selectRows = ((EntryGrid)this.getView().getControl(ENTRY_ENTITY)).getSelectRows();
            if (ArrayUtils.isEmpty((int[])selectRows)) {
                return;
            }
            int selectRow = selectRows[0];
            String formula = (String)this.getModel().getValue(KEY_FORMULA, selectRow);
            Long fieldId = (Long)this.getModel().getValue("id", selectRow);
            String formulaName = (String)this.getModel().getValue(KEY_FORMULANAME, selectRow);
            String fieldName = (String)this.getModel().getValue("fieldname", selectRow);
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setCaption(String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u62b5\u9500\u516c\u5f0f\u7f16\u8f91-%s", (String)"FormulaListEditPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), fieldName));
            formShowParameter.setFormId("bcm_intrformula");
            formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelIdFromParam());
            formShowParameter.setCustomParam(KEY_FORMULA, (Object)formula);
            formShowParameter.setCustomParam(KEY_FORMULANAME, (Object)formulaName);
            formShowParameter.setCustomParam("templateid", this.getFormCustomParam("templateid"));
            formShowParameter.setCustomParam("fieldId", (Object)fieldId);
            formShowParameter.setCustomParam("seller", this.getFormCustomParam("seller"));
            formShowParameter.setCustomParam("purchaser", this.getFormCustomParam("purchaser"));
            formShowParameter.setCustomParam("mergenode", this.getFormCustomParam("mergenode"));
            formShowParameter.setCustomParam("usage", this.getFormCustomParam("usage"));
            formShowParameter.setParentPageId(this.getView().getPageId());
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
            this.getView().showForm(formShowParameter);
        } else if (Objects.equals(key, BTN_CONFIRM)) {
            HashMap<String, Object> returnData = new HashMap<String, Object>(16);
            List<PaperTemplateFieldEntry> fieldList = this.getPaperTemplateFieldEntries();
            returnData.put(KEY_FORMULA, fieldList);
            returnData.put(IS_MODIFY, this.isModified());
            this.getView().returnDataToParent((Object)ObjectSerialUtil.toByteSerialized(returnData));
            this.getView().close();
        }
    }

    private List<PaperTemplateFieldEntry> getPaperTemplateFieldEntries() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
        List fieldList = (List)ObjectSerialUtil.deSerializedBytes((String)((String)this.getFormCustomParam("paperTemplateField")));
        Map entityMap = entryEntity.stream().collect(Collectors.toMap(o -> o.getLong("id"), Function.identity(), (o1, o2) -> o2));
        for (PaperTemplateFieldEntry field : fieldList) {
            Long id = field.getFieldId();
            DynamicObject entity = (DynamicObject)entityMap.get(id);
            field.setExecuteSeq(entity.getInt("executeseq"));
            field.setFormula(entity.getString(KEY_FORMULA));
            field.setFormulaName(entity.getString(KEY_FORMULANAME));
            field.setFormulaDes(entity.getString(KEY_FORMULA_DES));
            field.setIsMerge(entity.getBoolean(KEY_IS_MERGE));
        }
        return fieldList;
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        int[] selectRows = ((EntryGrid)this.getView().getControl(ENTRY_ENTITY)).getSelectRows();
        if (ArrayUtils.isEmpty((int[])selectRows)) {
            return;
        }
        int selectRow = selectRows[0];
        if (Objects.equals(propName, KEY_FORMULANAME)) {
            String newValue = (String)e.getChangeSet()[0].getNewValue();
            if (StringUtils.isBlank((String)newValue)) {
                this.getModel().setValue(KEY_FORMULA, null, selectRow);
                this.setModified(true);
            }
        } else if (Objects.equals(propName, KEY_IS_MERGE)) {
            boolean isMerge = (Boolean)e.getChangeSet()[0].getNewValue();
            if (isMerge) {
                Object value = this.getModel().getValue(KEY_FORMULA, selectRow);
                if (!"".equals(value)) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u8bbe\u7f6e\u5408\u5e76\u6210\u5458\u5c06\u6e05\u9664\u5df2\u8bbe\u7f6e\u7684\u516c\u5f0f\u3002", (String)"FormulaListEditPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("clear_formula", (IFormPlugin)this));
                } else {
                    this.lockCurrentRowFormulaEdit(true);
                }
            } else {
                this.lockCurrentRowFormulaEdit(false);
            }
        } else {
            this.setModified(true);
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String key = messageBoxClosedEvent.getCallBackId();
        if ("clear_formula".equals(key)) {
            if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                this.clearCurrentRowFormula();
                this.lockCurrentRowFormulaEdit(true);
                this.setModified(true);
            } else {
                this.setCurrentRowMerge(false);
            }
        }
    }

    private void clearCurrentRowFormula() {
        int[] selectRows = ((EntryGrid)this.getView().getControl(ENTRY_ENTITY)).getSelectRows();
        if (ArrayUtils.isEmpty((int[])selectRows)) {
            return;
        }
        int selectRow = selectRows[0];
        this.getModel().setValue(KEY_FORMULA, null, selectRow);
        this.getModel().setValue(KEY_FORMULANAME, null, selectRow);
    }

    private void setCurrentRowMerge(boolean isMerge) {
        int[] selectRows = ((EntryGrid)this.getView().getControl(ENTRY_ENTITY)).getSelectRows();
        if (ArrayUtils.isEmpty((int[])selectRows)) {
            return;
        }
        int selectRow = selectRows[0];
        this.getModel().setValue(KEY_IS_MERGE, (Object)isMerge, selectRow);
    }

    private void lockCurrentRowFormulaEdit(boolean isLock) {
        int[] selectRows = ((EntryGrid)this.getView().getControl(ENTRY_ENTITY)).getSelectRows();
        if (ArrayUtils.isEmpty((int[])selectRows)) {
            return;
        }
        int selectRow = selectRows[0];
        this.getView().setEnable(Boolean.valueOf(!isLock), selectRow, new String[]{KEY_FORMULANAME});
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        List result;
        String actionId = evt.getActionId();
        if (Objects.equals(actionId, KEY_FORMULANAME)) {
            int[] selectRows = ((EntryGrid)this.getView().getControl(ENTRY_ENTITY)).getSelectRows();
            if (selectRows.length < 1) {
                return;
            }
            int selectRow = selectRows[0];
            HashMap returnData = (HashMap)evt.getReturnData();
            if (Objects.nonNull(returnData)) {
                this.getModel().setValue(actionId, returnData.get(KEY_NAME), selectRow);
                this.getModel().setValue(KEY_FORMULA, returnData.get(KEY_FORMULA), selectRow);
                this.setModified(true);
            }
        } else if (Objects.equals(actionId, "intrformulaimport_close") && (result = (List)evt.getReturnData()) != null && result.size() > 0) {
            List<PaperTemplateFieldEntry> fieldList = this.updateFieldListByImportData(result);
            this.packageData(fieldList);
        }
    }

    private List<PaperTemplateFieldEntry> updateFieldListByImportData(List<Map<String, Object>> result) {
        List<PaperTemplateFieldEntry> fieldList = this.getPaperTemplateFieldEntries();
        List extFieldInfo = ExtDimHelper.getTmpFieldByExtModelId((Long)((Long)this.getFormCustomParam("mergenode")));
        Map<String, IntrField> extFieldMap = extFieldInfo.stream().collect(Collectors.toMap(k -> k.getNumber(), v -> v, (v1, v2) -> v1));
        Map<String, Map> importDataMap = result.stream().collect(Collectors.toMap(k -> (String)k.get("modelfield.number"), v -> v, (v1, v2) -> v1));
        importDataMap.forEach((fieldNum, v) -> {
            IntrField intrField = (IntrField)extFieldMap.get(fieldNum);
            if (intrField != null) {
                Optional<PaperTemplateFieldEntry> fieldEntry = fieldList.stream().filter(e -> e.getFieldId().equals(intrField.getExtFieldRefId())).findAny();
                fieldEntry.ifPresent(field -> {
                    int seq = 1;
                    String executeseq = v.getOrDefault("executeseq", "1") + "";
                    if (!StringUtils.isEmpty((String)executeseq) && NumberUtils.isNumber((String)executeseq)) {
                        seq = new BigDecimal(executeseq).intValue();
                    }
                    field.setExecuteSeq(seq);
                    field.setFormula(this.getStringValue(v.get(KEY_FORMULA)));
                    field.setFormulaName(this.getStringValue(v.get("formulaname")));
                    field.setFormulaDes(this.getStringValue(v.get("formuladesc")));
                });
            }
        });
        return fieldList;
    }

    private String getStringValue(Object o) {
        if (o == null) {
            return "";
        }
        if (o instanceof String) {
            return (String)o;
        }
        return o.toString();
    }

    public long getModelIdFromParam() {
        return (Long)this.getFormCustomParam("KEY_MODEL_ID");
    }

    private void packageData(List<PaperTemplateFieldEntry> fieldList) {
        this.getModel().deleteEntryData(ENTRY_ENTITY);
        boolean isMergeUsage = "0".equals(this.getFormCustomParam("usage"));
        List extFieldInfo = ExtDimHelper.getTmpFieldByExtModelId((Long)((Long)this.getFormCustomParam("mergenode")));
        HashMap<Long, IntrField> fieldMap = new HashMap<Long, IntrField>(extFieldInfo.size());
        HashSet<Long> lockFieldId = new HashSet<Long>(2);
        long bizTypeMemberId = 0L;
        for (IntrField field : extFieldInfo) {
            fieldMap.put(field.getExtFieldRefId(), field);
            if ("INTR_001".equals(field.getNumber()) || "INTR_000".equals(field.getNumber())) {
                lockFieldId.add(field.getExtFieldRefId());
            }
            if (!"INTR_001".equals(field.getNumber())) continue;
            bizTypeMemberId = field.getExtFieldRefId();
        }
        Set<Long> commonFieldId = this.getCommonFieldId();
        ArrayList<Integer> lockIndex = new ArrayList<Integer>(10);
        int[] rows = this.getModel().batchCreateNewEntryRow(ENTRY_ENTITY, fieldList.size());
        this.getModel().beginInit();
        for (int i2 = 0; i2 < fieldList.size(); ++i2) {
            IntrField extModelField;
            PaperTemplateFieldEntry templateField = fieldList.get(i2);
            long extModelFieldId = templateField.getFieldId();
            if (extModelFieldId == bizTypeMemberId) {
                templateField.setIsMerge(true);
            }
            if ((extModelField = (IntrField)fieldMap.get(extModelFieldId)) == null) continue;
            String fieldName = extModelField.getName();
            this.getModel().setValue("id", (Object)extModelFieldId, rows[i2]);
            if (lockFieldId.contains(extModelFieldId)) {
                this.getModel().setValue("executeseq", (Object)1, rows[i2]);
            } else {
                this.getModel().setValue("executeseq", (Object)templateField.getExecuteSeq(), rows[i2]);
            }
            this.getModel().setValue("fieldnumber", (Object)extModelField.getNumber(), rows[i2]);
            this.getModel().setValue("fieldname", (Object)fieldName, rows[i2]);
            if (lockFieldId.contains(extModelFieldId)) {
                lockIndex.add(i2);
            } else {
                this.getModel().setValue(KEY_FORMULA, (Object)templateField.getFormula(), rows[i2]);
                this.getModel().setValue(KEY_FORMULANAME, (Object)templateField.getFormulaName(), rows[i2]);
            }
            this.getModel().setValue(KEY_FORMULA_DES, (Object)templateField.getFormulaDes(), rows[i2]);
            if (commonFieldId.contains(extModelFieldId)) {
                this.getModel().setValue(KEY_IS_MERGE, (Object)templateField.isMerge(), rows[i2]);
                this.getView().setEnable(Boolean.valueOf(!lockFieldId.contains(extModelFieldId)), i2, new String[]{KEY_IS_MERGE});
                if (!templateField.isMerge()) continue;
                this.getView().setEnable(Boolean.valueOf(false), i2, new String[]{KEY_FORMULANAME});
                this.getModel().setValue(KEY_FORMULA, (Object)"", rows[i2]);
                this.getModel().setValue(KEY_FORMULANAME, (Object)"", rows[i2]);
                continue;
            }
            this.getView().setEnable(Boolean.valueOf(false), i2, new String[]{KEY_IS_MERGE});
        }
        lockIndex.forEach(i -> this.getView().setEnable(Boolean.valueOf(false), i.intValue(), new String[]{KEY_IS_MERGE, KEY_FORMULANAME, "executeseq"}));
        this.getView().setVisible(Boolean.valueOf(isMergeUsage), new String[]{KEY_IS_MERGE});
        this.getModel().endInit();
        this.getView().updateView(ENTRY_ENTITY);
    }

    private void setModified(boolean isModified) {
        this.cacheTrueOrFalseFlag(IS_MODIFY, isModified);
    }

    private boolean isModified() {
        return this.isTrueFlagInCache(IS_MODIFY);
    }

    private Set<Long> getCommonFieldId() {
        Object purchaser = this.getFormCustomParam("purchaser");
        Object mergeNode = this.getFormCustomParam("mergenode");
        if (purchaser == null || mergeNode == null || purchaser instanceof Integer && Objects.equals(0, purchaser) || mergeNode instanceof Integer && Objects.equals(0, mergeNode)) {
            return new HashSet<Long>(1);
        }
        List purchaserFileds = ExtDimHelper.getTmpFieldByExtModelId((Long)((Long)purchaser));
        List mergeFileds = ExtDimHelper.getTmpFieldByExtModelId((Long)((Long)mergeNode));
        Set purchaserFiledIds = purchaserFileds.stream().map(IntrField::getNumber).collect(Collectors.toSet());
        return mergeFileds.stream().filter(e -> purchaserFiledIds.contains(e.getNumber())).map(IntrField::getExtFieldRefId).collect(Collectors.toSet());
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        if ("btn_export".equals(evt.getItemKey())) {
            List<PaperTemplateFieldEntry> fieldEntries = this.getPaperTemplateFieldEntries();
            List extFieldInfo = ExtDimHelper.getTmpFieldByExtModelId((Long)((Long)this.getFormCustomParam("mergenode")));
            try {
                String url = IntrFromulaExportHelper.export(fieldEntries, extFieldInfo);
                if (StringUtils.isNotEmpty((String)url)) {
                    this.downloadFile(url, "bcm_papertemplatelist", "4715a0df000000ac");
                }
            }
            catch (IOException e) {
                log.error("export error" + evt);
            }
        } else if ("btn_import".equals(evt.getItemKey())) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("bcm_intrformulaimport");
            showParameter.setCustomParam("seller", this.getFormCustomParam("seller"));
            showParameter.setCustomParam("purchaser", this.getFormCustomParam("purchaser"));
            showParameter.setCustomParam("mergenode", this.getFormCustomParam("mergenode"));
            showParameter.setCustomParam("usage", this.getFormCustomParam("usage"));
            showParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "intrformulaimport_close"));
            this.getView().showForm(showParameter);
        }
    }
}

