/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.papertemplate.innertrade;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.formula.express.ExpressParser;
import kd.fi.bcm.business.formula.model.FormulaEnum;
import kd.fi.bcm.business.innertrade.model.IntrField;
import kd.fi.bcm.business.papertemplate.ExtDimHelper;
import kd.fi.bcm.business.serviceHelper.FormulaServiceHelper;
import kd.fi.bcm.common.IntrConstant;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.pageinteraction.SubPage;
import kd.fi.bcm.spread.common.util.StringUtil;
import kd.fi.bcm.spread.formula.EncoderService;
import kd.fi.bcm.spread.formula.expr.NameExpr;
import org.apache.commons.lang.StringUtils;

public class InnerTradeFormulaPlugin
extends AbstractBaseFormPlugin
implements SubPage {
    private static final String ENABLE = "enable";
    public static final String FORMULA = "formula";
    public static final String FORMULA_NAME = "formula_name";
    public static final String NAME = "name";
    private static final String FORMULA_TEXT = "formulatext";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("mf", "gev", "esp", "lyv", "dvb", "pn", "confirm", "cancel");
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.valueOf(!"1".equals(this.getFormCustomParam("usage"))), new String[]{"dvb"});
        String hideFunctions = "f(x)";
        CustomControl custom = (CustomControl)this.getView().getControl(FORMULA_TEXT);
        String formulaText = (String)this.getFormCustomParam(FORMULA);
        if (StringUtils.isNotBlank((String)formulaText)) {
            String fullFormula = this.buildFormulaDisplay(formulaText);
            custom.setData(FormulaServiceHelper.packUpdateTextWithHide((String)fullFormula, (String)hideFunctions));
        } else {
            custom.setData(FormulaServiceHelper.packUpdateTextWithHide((JSONObject)new JSONObject(), (String)hideFunctions));
        }
        this.hideFormula();
    }

    private void hideFormula() {
        Long fieldId = (Long)this.getFormCustomParam("fieldId");
        IntrField field = ExtDimHelper.getTmpFieldByRefId((Long)fieldId);
        if (field == null) {
            return;
        }
        if ("dim".equals(field.getExtFieldRefType()) || field.isLinkDim()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"esp", "lyv", "dvb", "pn"});
        }
        if (IntrConstant.DB_TEXT_DATA_TYPE.contains(field.getDataType())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"lyv"});
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("KEY_MODEL_ID", this.getModelId());
        params.put("templateid", this.getFormCustomParam("templateid"));
        params.put("seller", this.getFormCustomParam("seller"));
        params.put("purchaser", this.getFormCustomParam("purchaser"));
        params.put("mergenode", this.getFormCustomParam("mergenode"));
        params.put("fieldId", this.getFormCustomParam("fieldId"));
        switch (key) {
            case "mf": {
                String formId = "bcm_mffunctionset";
                String actionId = "mfformulacb";
                this.showFormulaPanel(formId, params, actionId);
                break;
            }
            case "gev": {
                String formId = "bcm_gevfunctionset";
                String actionId = "gevformulacb";
                this.showFormulaPanel(formId, params, actionId);
                break;
            }
            case "esp": {
                params.put("is_draft", true);
                params.put("sharescaletype", this.getSharescaletype());
                String formId = "bcm_espfunctionset";
                String actionId = "espformulacb";
                this.showFormulaPanel(formId, params, actionId);
                break;
            }
            case "lyv": {
                String formId = "bcm_lyvfunctionset";
                String actionId = "lyvformulacb";
                params.put("fieldId", this.getFormCustomParam("fieldId"));
                this.showFormulaPanel(formId, params, actionId);
                break;
            }
            case "dvb": {
                String formId = "bcm_dvbfunctionset";
                String actionId = "dvbformulacb";
                this.showFormulaPanel(formId, params, actionId);
                break;
            }
            case "pn": {
                String formId = "bcm_pnfunctionset";
                String actionId = "pnformulacb";
                this.showFormulaPanel(formId, params, actionId);
                break;
            }
            case "confirm": {
                CustomControl formulaControl = (CustomControl)this.getView().getControl(FORMULA_TEXT);
                formulaControl.setData(FormulaServiceHelper.packGetText());
            }
        }
    }

    public void customEvent(CustomEventArgs evt) {
        String eventText = evt.getEventArgs();
        switch (evt.getEventName()) {
            case "f(x)": {
                if (StringUtils.isEmpty((String)eventText)) break;
                String param = this.getPageCache().get(eventText);
                if (eventText.startsWith("mfformulacb")) {
                    this.showVPanel("mfformulacb", eventText, param);
                    break;
                }
                if (eventText.startsWith("gevformulacb")) {
                    this.showVPanel("gevformulacb", eventText, param);
                    break;
                }
                if (eventText.startsWith("espformulacb")) {
                    this.showVPanel("espformulacb", eventText, param);
                    break;
                }
                if (eventText.startsWith("lyvformulacb")) {
                    this.showVPanel("lyvformulacb", eventText, param);
                    break;
                }
                if (eventText.startsWith("dvbformulacb")) {
                    this.showVPanel("dvbformulacb", eventText, param);
                    break;
                }
                if (!eventText.startsWith("pnformulacb")) break;
                this.showVPanel("pnformulacb", eventText, param);
                break;
            }
            case "getText": {
                if (StringUtil.isEmptyString((String)eventText)) {
                    HashMap map = Maps.newHashMap();
                    map.put(FORMULA, "");
                    map.put(NAME, "");
                    this.getView().returnDataToParent((Object)map);
                    this.getView().close();
                    break;
                }
                eventText = eventText.replaceAll("\n", "");
                eventText = eventText.replaceAll("\\p{C}", "");
                if (this.getPageCache().get("ismodifer") != null) {
                    String data = FormulaServiceHelper.rebuildFormula((String)eventText, (IPageCache)this.getPageCache());
                    this.getPageCache().remove("ismodifer");
                    CustomControl control = (CustomControl)this.getView().getControl(FORMULA_TEXT);
                    control.setData(FormulaServiceHelper.packUpdateText((String)data));
                    break;
                }
                String transFormula = FormulaServiceHelper.transFormula((String)eventText, (IPageCache)this.getPageCache());
                String formulaText = "";
                String formulaName = "";
                if (!"@@@".equalsIgnoreCase(transFormula)) {
                    String[] fs = transFormula.split("@@@");
                    formulaText = fs[0];
                    formulaName = fs[1];
                }
                this.validateFormula(formulaText);
                HashMap map = Maps.newHashMap();
                map.put(FORMULA, formulaText);
                map.put(NAME, formulaName);
                this.getView().returnDataToParent((Object)map);
                this.getView().close();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        CustomControl control = (CustomControl)this.getView().getControl(FORMULA_TEXT);
        Object returnData = evt.getReturnData();
        if (returnData != null) {
            HashMap returnMap = (HashMap)returnData;
            String formulaText = returnMap.get(FORMULA).toString();
            String formulaName = returnMap.get(NAME).toString();
            String sign = actionId;
            HashMap dataCache = Maps.newHashMap();
            if (this.getPageCache().get(actionId) == null) {
                sign = FormulaServiceHelper.getComboSign((String)actionId);
                control.setData(FormulaServiceHelper.packAddText((String)sign, (String)formulaName));
            } else {
                dataCache.put("ismodifer", "1");
                control.setData(FormulaServiceHelper.packGetText());
            }
            dataCache.put(sign, formulaText);
            dataCache.put(sign + NAME, formulaName);
            this.getPageCache().put((Map)dataCache);
        }
    }

    private void showFormulaPanel(String formId, Map<String, Object> params, String actionId) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(formId);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParams(params);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, actionId);
        formShowParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(formShowParameter);
    }

    private void showVPanel(String type, String key, Object param) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        String enable = (String)this.getView().getFormShowParameter().getCustomParam(ENABLE);
        formShowParameter.setCustomParam(ENABLE, (Object)enable);
        formShowParameter.setCustomParam(FORMULA, param);
        formShowParameter.setCustomParam("fieldId", this.getFormCustomParam("fieldId"));
        formShowParameter.setCustomParam("templateid", this.getFormCustomParam("templateid"));
        formShowParameter.setCustomParam("seller", this.getFormCustomParam("seller"));
        formShowParameter.setCustomParam("purchaser", this.getFormCustomParam("purchaser"));
        formShowParameter.setCustomParam("mergenode", this.getFormCustomParam("mergenode"));
        if ("mfformulacb".equals(type)) {
            formShowParameter.setFormId("bcm_mffunctionset");
        }
        if ("gevformulacb".equals(type)) {
            formShowParameter.setFormId("bcm_gevfunctionset");
        }
        if ("espformulacb".equals(type)) {
            formShowParameter.setFormId("bcm_espfunctionset");
            formShowParameter.setCustomParam("is_draft", (Object)true);
            formShowParameter.setCustomParam("sharescaletype", (Object)this.getSharescaletype());
        }
        if ("lyvformulacb".equals(type)) {
            formShowParameter.setFormId("bcm_lyvfunctionset");
        }
        if ("dvbformulacb".equals(type)) {
            formShowParameter.setFormId("bcm_dvbfunctionset");
        }
        if ("pnformulacb".equals(type)) {
            formShowParameter.setFormId("bcm_pnfunctionset");
        }
        CloseCallBack closeCallBack = key != null ? new CloseCallBack((IFormPlugin)this, key) : new CloseCallBack((IFormPlugin)this, type);
        formShowParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(formShowParameter);
    }

    private String getDisplayName(Object obj) {
        String formulaParam = (String)obj;
        if ("currentYear".contains(formulaParam)) {
            return ResManager.loadKDString((String)"\u5f53\u524d\u8d22\u5e74", (String)"PnFunctionSettingPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        if ("currentPeriod".contains(formulaParam)) {
            return ResManager.loadKDString((String)"\u5f53\u524d\u671f\u95f4", (String)"PnFunctionSettingPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        if ("startYear".contains(formulaParam)) {
            return ResManager.loadKDString((String)"\u5f53\u524d\u8d22\u5e74", (String)"PnFunctionSettingPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        if ("startPeriod".contains(formulaParam)) {
            return ResManager.loadKDString((String)"\u5e74\u521d\u671f\u95f4", (String)"PnFunctionSettingPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        long modelId = this.getModelId();
        if (StringUtils.isEmpty((String)formulaParam)) {
            return formulaParam;
        }
        StringBuilder displayName = new StringBuilder();
        String[] params = formulaParam.split("@");
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        filter.and("number", "=", (Object)params[0]);
        DynamicObjectCollection extendsModelList = QueryServiceHelper.query((String)"bcm_extendsmodel", (String)"id,number,name", (QFilter[])new QFilter[]{filter});
        if (CollectionUtils.isEmpty((Collection)extendsModelList)) {
            displayName.append(params[0]);
        } else {
            displayName.append(((DynamicObject)extendsModelList.get(0)).getString(NAME));
        }
        displayName.append("@");
        IntrField field = ExtDimHelper.getTmpFieldByNum((Long)((DynamicObject)extendsModelList.get(0)).getLong("id"), (String)params[1]);
        if (CollectionUtils.isEmpty((Collection)extendsModelList)) {
            displayName.append(params[1]);
        } else if (field != null) {
            displayName.append(field.getName());
        }
        return displayName.toString();
    }

    private void validateFormula(String invFormula) {
        try {
            ExpressParser parser = new ExpressParser();
            EncoderService encoder = new EncoderService();
            boolean hasStr = parser.parse2(invFormula, encoder).stream().anyMatch(p -> p instanceof NameExpr);
            if (hasStr) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u516c\u5f0f\u3002", (String)"InnerTradeFormulaPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        }
        catch (Exception e1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u516c\u5f0f\u3002", (String)"InnerTradeFormulaPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private String getSharescaletype() {
        String sharescaletype = (String)this.getFormCustomParam("sharescaletype");
        sharescaletype = StringUtils.isNotEmpty((String)sharescaletype) ? sharescaletype : "1";
        return sharescaletype;
    }

    private String buildFormulaDisplay(String formula) {
        StringBuffer sb = new StringBuffer();
        String tempData = this.buildFormulaDisplayByChild(formula, sb);
        while (tempData.length() > 0) {
            tempData = this.buildFormulaDisplayByChild(tempData, sb);
        }
        return sb.toString();
    }

    private String buildFormulaDisplayByChild(String data, StringBuffer sb) {
        List<Object> indexList = new ArrayList<Integer>();
        indexList.add(data.indexOf(FormulaEnum.Esp.name()));
        indexList.add(data.indexOf(FormulaEnum.Gev.name()));
        indexList.add(data.indexOf(FormulaEnum.Lyv.name()));
        indexList.add(data.indexOf(FormulaEnum.Dvb.name()));
        indexList.add(data.indexOf(FormulaEnum.Mf.name()));
        indexList.add(data.indexOf(FormulaEnum.Pn.name()));
        indexList = indexList.stream().filter(e -> e > -1).collect(Collectors.toList());
        Collections.sort(indexList);
        int beginPosition = -1;
        if (indexList.size() > 0) {
            beginPosition = (Integer)indexList.get(0);
        }
        if (beginPosition > 0) {
            sb.append(data.substring(0, beginPosition));
            return data.substring(beginPosition);
        }
        if (beginPosition == -1) {
            sb.append(data);
            return "";
        }
        try {
            String item = data.substring(beginPosition, data.indexOf(41) + 1);
            sb.append(FormulaServiceHelper.analyFullFormula((String)item, (IPageCache)this.getPageCache(), (long)this.getModelId(), this::getDisplayName));
            return data.substring(data.indexOf(41) + 1);
        }
        catch (Exception e2) {
            return "";
        }
    }
}

