/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.papertemplate.innertrade;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.AppMetadataCache;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.spread.F7ItemFillBackArgs;
import kd.bos.form.spread.LookUpDataArgs;
import kd.bos.form.spread.SpreadPostDataInfo;
import kd.bos.metadata.form.container.TabAp;
import kd.bos.metadata.form.container.TabPageAp;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.formula.register.FormulaConfig;
import kd.fi.bcm.business.innertrade.model.ExtTemplateDto;
import kd.fi.bcm.business.innertrade.model.IntrField;
import kd.fi.bcm.business.innertrade.report.IntrTemplateHelper;
import kd.fi.bcm.business.model.formula.Formula;
import kd.fi.bcm.business.papertemplate.CommonPaperTemplateModel;
import kd.fi.bcm.business.papertemplate.ExtDimHelper;
import kd.fi.bcm.business.papertemplate.InnerTradeTemplateModel;
import kd.fi.bcm.business.papertemplate.PaperTemplateCatalog;
import kd.fi.bcm.business.papertemplate.PaperTemplateDimFieldScopeEntry;
import kd.fi.bcm.business.papertemplate.PaperTemplateFieldEntry;
import kd.fi.bcm.business.papertemplate.PaperTemplateHelper;
import kd.fi.bcm.business.papertemplate.PaperTemplateService;
import kd.fi.bcm.business.permission.cache.BcmPermSingleModel;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.serviceHelper.MutexServiceHelper;
import kd.fi.bcm.business.serviceHelper.UserServiceHelper;
import kd.fi.bcm.business.template.model.DynaEntryObject;
import kd.fi.bcm.business.util.ResourcesLoaderUtil;
import kd.fi.bcm.common.IntrConstant;
import kd.fi.bcm.common.PairList;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.enums.papertemplate.PaperTemplateTypeEnum;
import kd.fi.bcm.common.enums.status.ResultStatusEnum;
import kd.fi.bcm.common.json.JSONObjectUtil;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.ExcelUtils;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.MapInitHelper;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.BcmBasePluginUtil;
import kd.fi.bcm.formplugin.intergration.util.ShowFormulaUtil;
import kd.fi.bcm.formplugin.papertemplate.innertrade.AbstractPaperTemplate;
import kd.fi.bcm.formplugin.papertemplate.innertrade.handle.PaperViewSwitchers;
import kd.fi.bcm.formplugin.spread.SpreadClientInvoker;
import kd.fi.bcm.formplugin.spread.SpreadEasyInvoker;
import kd.fi.bcm.formplugin.template.model.AskExcuteInfo;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.JsonSerializerUtil;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.event.EventConstant;
import kd.fi.bcm.spread.domain.view.event.NotifyEvent;
import kd.fi.bcm.spread.domain.view.js.SpreadProperties;
import kd.fi.bcm.spread.formula.ExcelFormulaPaserHelper;
import kd.fi.bcm.spread.formula.expr.BinaryOperationExpr;
import kd.fi.bcm.spread.formula.expr.Expression;
import kd.fi.bcm.spread.formula.expr.FunctionExpr;
import org.apache.commons.collections.CollectionUtils;
import org.apache.poi.util.StringUtil;

public class InnerTradeTemplatePlugin
extends AbstractPaperTemplate {
    private static final String TAB_VIEW = "tabview";
    private static final String TAB_VIEW_STYLE = "tab_style";
    private static final String TAB_VIEW_FIELD = "tab_field";
    private static final String PAGE_CACHE_OLD_MUTEX_KEY = "page_cache_oldMutexKey";
    private static final String PAGE_CACHE_LOCKED = "page_cache_locked";
    private static final String IS_MODIFY = "is_modify";
    private static final String IS_SHOW_TIP_MODIFY = "is_show_tip_modify";
    private static final String[] formulaNumbers = new String[]{"newrptinfo"};
    private static final String NEW_RPT_INFO = "newrptinfo";
    public static final String TMPL_SCENE_CACHE = "tmpl_scene_cache";
    public static final String INTR_TEMPLATE_REPORT = "intr_template_report";

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners("toolbarap");
        Tab topTab = (Tab)this.getControl(TAB_VIEW);
        topTab.addTabSelectListener(this::topTabSelected);
        this.initSpreadListener();
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.registerFormula();
        this.loadData();
        this.buildTabView();
        new PaperViewSwitchers().switchView(TAB_VIEW_STYLE, this, this.SPREAD_KEY, false);
        this.mutexControl();
        this.setModified(false);
        this.hanldMenuItem();
        if (this.getFormCustomParam("read") != null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6a21\u677f\u53ea\u6709\u67e5\u8be2\u6743\u9650\uff0c\u65e0\u6cd5\u7f16\u8f91\u4fdd\u5b58\u3002", (String)"InnerTradeTemplatePlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            this.getView().setEnable(Boolean.FALSE, new String[]{"btn_save"});
        }
        this.registSpreadShortcutKey();
    }

    private void registSpreadShortcutKey() {
        SpreadClientInvoker.invokeRegistShortcutKey(this.getClientViewProxy(), this.getSpreadKey(), "openStageLock", "F8", true, true, true);
    }

    public void openStageLock() {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setParentPageId(this.getView().getPageId());
        fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        fsp.setFormId("bcm_datalockcompare");
        fsp.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        this.getView().showForm(fsp);
    }

    protected void hanldMenuItem() {
        boolean isHaveReport = this.checkIsExistReportRecordByTemplateId(this.getTemplateModel().getId());
        SpreadClientInvoker.invokeHideContextMenuItems(this.getClientViewProxy(), this.SPREAD_KEY, MapInitHelper.ofMap((Object)"isHide", (Object)false));
        ArrayList<Map> MenuItems = new ArrayList<Map>(10);
        MenuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.deleteColumns, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)isHaveReport));
        MenuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.deleteRows, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
        MenuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.insertColumns, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)isHaveReport));
        MenuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.insertRows, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
        MenuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.insertColMany, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)isHaveReport));
        MenuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.insertRowMany, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
        MenuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.insertRowOrColumns, (Object)SpreadProperties.HideContextMenuItemsMethod.SUBMENU.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.insertRowsTop, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
        MenuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.insertRowOrColumns, (Object)SpreadProperties.HideContextMenuItemsMethod.SUBMENU.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.insertRowsBottom, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
        MenuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.rows_insertRowsTop, (Object)SpreadProperties.HideContextMenuItemsMethod.WORKAREA.k(), (Object)SpreadProperties.WorkAreaEnum.rowHeader, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
        MenuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.rows_insertRowsBottom, (Object)SpreadProperties.HideContextMenuItemsMethod.WORKAREA.k(), (Object)SpreadProperties.WorkAreaEnum.rowHeader, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
        SpreadClientInvoker.invokeHideContextMenuItems(this.getClientViewProxy(), this.getSpreadKey(), MenuItems);
        SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.getClientViewProxy(), this.getSpreadKey());
        invoker.lockAllToolbarItems(true, SpreadProperties.ToolbarItemNamesEnum.DeleteRowAndCol, SpreadProperties.ToolbarItemNamesEnum.InsertRowAndCol, SpreadProperties.ToolbarItemNamesEnum.LockCells, SpreadProperties.ToolbarItemNamesEnum.DataValidation);
        invoker.startToInvoke();
    }

    private void showTmplReportView(Set<Long> tmplIds) {
        FormShowParameter param = new FormShowParameter();
        param.setFormId("bcm_intrreportrecord");
        param.setParentPageId(this.getView().getParentView().getPageId());
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.getOpenStyle().setTargetKey("_submaintab_");
        param.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        param.setCustomParam("tmplIds", tmplIds);
        param.setCaption(ResManager.loadKDString((String)"\u5185\u90e8\u4ea4\u6613\u6a21\u677f\u7f16\u5236\u8bb0\u5f55", (String)"InnerTradeTemplatePlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        this.getView().showForm(param);
    }

    private void loadData() {
        this.spread = null;
        this.template = null;
        if (LongUtil.isvalidLong((Object)this.getFormCustomParam("template_id")) || LongUtil.isvalidLong((Object)this.getFormCustomParam("id"))) {
            Long templateId = Objects.nonNull(this.getFormCustomParam("template_id")) ? (Long)this.getFormCustomParam("template_id") : (Long)this.getFormCustomParam("id");
            DynamicObject template = BusinessDataServiceHelper.loadSingle((Object)templateId, (String)"bcm_papertemplate");
            InnerTradeTemplateModel templateModel = this.constructTemplateModel(template);
            this.cacheTemplateModel((CommonPaperTemplateModel)templateModel);
        } else {
            this.buildFromCusParameter();
        }
        this.getPageCache().remove("KEY_SPREAD_MODEL");
    }

    private InnerTradeTemplateModel constructTemplateModel(DynamicObject dyna) {
        InnerTradeTemplateModel template = new InnerTradeTemplateModel();
        template.loadDynaObj2Model(dyna);
        return template;
    }

    private void buildTabView() {
        TabAp tabap = new TabAp();
        tabap.setKey(TAB_VIEW);
        tabap.setGrow(0);
        PairList tabs = new PairList();
        tabs.addPair((Object)TAB_VIEW_STYLE, (Object)ResManager.loadKDString((String)"\u5e95\u7a3f\u8868\u6837", (String)"InnerTradeTemplatePlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        tabs.addPair((Object)TAB_VIEW_FIELD, (Object)ResManager.loadKDString((String)"\u7ef4\u5ea6\u53ca\u6210\u5458", (String)"InnerTradeTemplatePlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        tabs.forEach(p -> {
            TabPageAp page = new TabPageAp();
            page.setKey((String)p.p1);
            page.setName(new LocaleString((String)p.p2));
            tabap.getItems().add(page);
        });
        Map features = tabap.createControl();
        this.getView().updateControlMetadata(TAB_VIEW, features);
    }

    private void mutexControl() {
        if (!ConfigServiceHelper.getGlobalBoolParam((String)"P001")) {
            this.getPageCache().put(PAGE_CACHE_OLD_MUTEX_KEY, "P001");
        }
        String locked = this.getPageCache().get(PAGE_CACHE_LOCKED);
        String mutexKey = this.getPageCache().get(PAGE_CACHE_OLD_MUTEX_KEY);
        boolean success = locked != null || mutexKey != null ? mutexKey != null : this.requestMutex();
        if (!success) {
            this.lockToolbar(false);
            SpreadClientInvoker.invokeLockOrUnlockWholeToolbar(this.getClientViewProxy(), this.SPREAD_KEY, true);
            this.lockSheet();
        }
    }

    private boolean requestMutex() {
        String opDesc = ResManager.loadKDString((String)"\u4fee\u6539", (String)"InnerTradeTemplatePlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        String mutexKey = "MutexLock_PaperTemplate_" + this.getTemplateModel().getId();
        boolean mutex = MutexServiceHelper.request((String)mutexKey, (String)"bcm_templateentity", (String)opDesc);
        if (!mutex) {
            this.getPageCache().put(PAGE_CACHE_LOCKED, "true");
            Map lockInfo = MutexServiceHelper.getLockInfo((String)mutexKey, (String)"bcm_templateentity", (String)opDesc);
            if (lockInfo != null) {
                String tips = String.format(ResManager.loadKDString((String)"\u5df2\u88ab %s \u9501\u5b9a\uff0c\u53ea\u80fd\u67e5\u770b", (String)"InnerTradeTemplatePlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]), UserServiceHelper.getUsernameByUserid(lockInfo.get("userid")));
                this.getView().showTipNotification(tips, Integer.valueOf(3000));
            }
        } else {
            this.getPageCache().put(PAGE_CACHE_OLD_MUTEX_KEY, this.getView().getPageId());
        }
        return mutex;
    }

    public void pageRelease(EventObject e) {
        this.releaseOldMutexLock();
    }

    private void releaseOldMutexLock() {
        String mutexHolder = this.getPageCache().get(PAGE_CACHE_OLD_MUTEX_KEY);
        if (mutexHolder != null) {
            String opDesc = ResManager.loadKDString((String)"\u4fee\u6539", (String)"InnerTradeTemplatePlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            String mutexKey = "MutexLock_PaperTemplate_" + this.getTemplateModel().getId();
            MutexServiceHelper.release((String)mutexKey, (String)"bcm_templateentity", (String)opDesc);
        }
    }

    private void lockSheet() {
        Sheet sheet = this.getEffectiveSheet();
        new SpreadEasyInvoker(this.getClientViewProxy(), this.SPREAD_KEY).lockCell(0, 0, sheet.getMaxRowCount(), sheet.getMaxColumnCount());
    }

    private void lockToolbar(boolean isLock) {
        this.getView().setEnable(Boolean.valueOf(isLock), new String[]{"btn_save", "btn_baseinfo", "btn_explain", "btn_filed_area", "btn_formula_setting", "btn_entryset", "btn_check_setting", "btn_dim_scope"});
    }

    @Override
    public void pushCache() {
        this.forcePushCache();
    }

    private void topTabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey = tabSelectEvent.getTabKey();
        if (TAB_VIEW_STYLE.equals(this.getCurrentViewTabKey())) {
            this.getSpreadModel();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("callback", "invokeAction");
            params.put("invokemethod", "syncStyle2Model");
            SpreadClientInvoker.invokeGetSpreadJsonMethod(this.getClientViewProxy(), this.SPREAD_KEY, params);
        } else {
            new PaperViewSwitchers().switchView(tabKey, this, this.SPREAD_KEY, false);
            if (this.isTrueFlagInCache("dosave")) {
                this.invokeSaveEvent();
            }
            this.getPageCache().remove("dosave");
        }
    }

    public void syncStyle2Model(String spreadJson) {
        this.getTemplateModel().setSpreadJson(spreadJson);
        this.cacheTemplateModel();
        Tab reportTab = (Tab)this.getControl(TAB_VIEW);
        new PaperViewSwitchers().switchView(reportTab.getCurrentTab(), this, this.SPREAD_KEY, false);
    }

    private void initSpreadListener() {
        this.registerAfterEvent(EventConstant.ActionName.UPDATE_VALUE, e -> {
            Cell cell = (Cell)e.getSource();
            if (this.isIncludeViewsOnCurrView(TAB_VIEW_STYLE)) {
                if (cell.getValue() == null || StringUtils.isEmpty((CharSequence)cell.getValue().toString())) {
                    cell.setFormula(null);
                }
                this.setModified(true);
                this.setShowTipModified(true);
            }
        });
        this.registerBeforeEvent(EventConstant.ActionName.UPDATE_MULVALUE, e -> {
            if (this.isIncludeViewsOnCurrView(TAB_VIEW_FIELD)) {
                SpreadPostDataInfo data = (SpreadPostDataInfo)e.getParam();
                List values = data.getValues();
                Map<String, IntrField> fieldNameMap = ExtDimHelper.getTmpFieldInludeBuySelll((Long)this.getTemplateModel().getMergeNode()).stream().collect(Collectors.toMap(IntrField::getName, v -> v, (e1, e2) -> e2));
                for (LinkedHashMap map : values) {
                    Object v2 = map.get("v");
                    Cell cell = this.getEffectiveSheet().getCell(((Integer)map.get("r")).intValue(), ((Integer)map.get("c")).intValue());
                    if (v2 != null) {
                        IntrField fieldDy = fieldNameMap.get(v2.toString());
                        if (fieldDy == null) continue;
                        cell.clearAllUserObject();
                        cell.setValue((Object)fieldDy.getName());
                        cell.setUserObject("fieldId", (Object)fieldDy.getExtFieldRefId());
                        cell.setUserObject("fieldType", (Object)fieldDy.getExtFieldRefType());
                        cell.setUserObject("number", (Object)fieldDy.getNumber());
                        cell.setUserObject("name", (Object)fieldDy.getName());
                        continue;
                    }
                    cell.setValue(null);
                    cell.clearAllUserObject();
                }
                this.setModified(true);
                this.updateTemplateModelField();
            }
        });
        this.registerBeforeEvent(EventConstant.ActionName.ADD_ROW, this::operationCheck);
        this.registerBeforeEvent(EventConstant.ActionName.REMOVE_ROW, this::operationCheck);
        this.registerBeforeEvent(EventConstant.ActionName.ADD_COL, this::operationCheck);
        this.registerBeforeEvent(EventConstant.ActionName.REMOVE_COL, this::operationCheck);
        this.registerAfterEvent(EventConstant.ActionName.ADD_ROW, this::invokeAddOrRemove);
        this.registerAfterEvent(EventConstant.ActionName.REMOVE_ROW, this::invokeAddOrRemove);
        this.registerAfterEvent(EventConstant.ActionName.ADD_COL, this::invokeAddOrRemove);
        this.registerAfterEvent(EventConstant.ActionName.REMOVE_COL, this::invokeAddOrRemove);
        this.registerAfterEvent(EventConstant.ActionName.INSERT_COPIED_CELL, this::invokeAddOrRemove);
    }

    private void reSetValue(NotifyEvent e) {
        List values = ((SpreadPostDataInfo)e.getParam()).getValues();
        if (CollectionUtils.isEmpty((Collection)values)) {
            return;
        }
        Sheet oldSheet = this.getEffectiveSheet();
        SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.getClientViewProxy(), this.getSpreadKey());
        invoker.setBatch(true);
        for (LinkedHashMap value : values) {
            int row = Integer.parseInt(value.get("r").toString());
            int col = Integer.parseInt(value.get("c").toString());
            invoker.updataValue(row, col, oldSheet.getCell(row, col).getValue());
        }
        invoker.startToInvoke();
    }

    private boolean isIncludeViewsOnCurrView(String ... views) {
        Tab tab = (Tab)this.getControl(TAB_VIEW);
        String currView = tab.getCurrentTab();
        for (String view : views) {
            if (!currView.equals(view)) continue;
            return true;
        }
        return false;
    }

    private String getCurrentViewTabKey() {
        return this.getPageCache().get("tab_current_key");
    }

    private void buildFromCusParameter() {
        InnerTradeTemplateModel templateModel = (InnerTradeTemplateModel)this.getTemplateModel();
        Object name = this.getView().getFormShowParameter().getCustomParam("mutiname");
        String number = (String)this.getView().getFormShowParameter().getCustomParam("number");
        String usage = (String)this.getView().getFormShowParameter().getCustomParam("usage");
        String tmplScene = (String)this.getView().getFormShowParameter().getCustomParam(TMPL_SCENE_CACHE);
        String effectiveText = (String)this.getView().getFormShowParameter().getCustomParam("effectivetext");
        String effectiveDataStr = (String)this.getView().getFormShowParameter().getCustomParam("effectivedata");
        if (LongUtil.isvalidLong((Object)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID"))) {
            Long modelId = (Long)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
            templateModel.setModelId(modelId.longValue());
            this.getPageCache().put("KEY_MODEL_ID", String.valueOf(modelId));
        }
        if (LongUtil.isvalidLong((Object)this.getView().getFormShowParameter().getCustomParam("templatecatalog"))) {
            Long catalogId = (Long)this.getView().getFormShowParameter().getCustomParam("templatecatalog");
            PaperTemplateCatalog catalog = new PaperTemplateCatalog();
            DynamicObject dyna = QueryServiceHelper.queryOne((String)catalog.getDataEntityNumber(), (String)"id,name,longnumber", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)catalogId)});
            catalog.setId(catalogId.longValue());
            catalog.setName(dyna.getString("name"));
            String longnumber = dyna.getString("longnumber");
            templateModel.setTemplateType(PaperTemplateService.getTemplateTypeByLongnumber((String)longnumber));
            templateModel.setTemplateCatalog(catalog);
        }
        if (LongUtil.isvalidLong((Object)this.getView().getFormShowParameter().getCustomParam("permclass"))) {
            Long permClassId = (Long)this.getView().getFormShowParameter().getCustomParam("permclass");
            templateModel.setPermClass((Object)permClassId);
        }
        if (Objects.nonNull(name)) {
            templateModel.setName(name);
        }
        if (Objects.nonNull(number)) {
            templateModel.setNumber(number);
        }
        if (Objects.nonNull(usage)) {
            templateModel.setUsage(usage);
        }
        if (Objects.nonNull(tmplScene)) {
            templateModel.setTmplScene((Map)this.deSerializedBytes(tmplScene));
        }
        if (Objects.nonNull(effectiveText)) {
            templateModel.setEffectivetext(effectiveText);
        }
        if (!StringUtils.isBlank((CharSequence)effectiveDataStr)) {
            templateModel.setEffectivedata((Map)ObjectSerialUtil.deSerializedBytes((String)effectiveDataStr));
        }
        this.cacheTemplateModel((CommonPaperTemplateModel)templateModel);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (itemKey.equals("btn_save") && !TAB_VIEW_STYLE.equals(this.getCurrentViewTabKey())) {
            Tab tab = (Tab)this.getControl(TAB_VIEW);
            tab.activeTab(TAB_VIEW_STYLE);
            this.cacheTrueOrFalseFlag("dosave", true);
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "btn_filed_area": {
                if (!this.checkIsExistExtDimension(this.getModelId(), true)) break;
                this.openFormPage("bcm_papertpl_datamodel");
                break;
            }
            case "btn_formula_setting": {
                this.openFormPage("bcm_papertpl_fieldlist");
                break;
            }
            case "btn_check_setting": {
                this.openFormPage("bcm_mffunctionset");
                break;
            }
            case "btn_dim_scope": {
                this.openFormPage("bcm_intrdimfieldscope");
                break;
            }
            case "btn_explain": {
                this.openFormPage("explain_setting");
                break;
            }
            case "btn_baseinfo": {
                this.openFormPage("baseinfo_setting");
                break;
            }
            case "btn_save": {
                this.checkPerm("btn_modify", "bcm_papertemplatelist");
                this.handleSaveEvent();
                break;
            }
            case "btn_entryset": {
                this.openAdjSettingListPage();
                break;
            }
            case "btn_refresh": {
                this.checkIsModified(key);
                break;
            }
            case "btn_close": {
                if (this.checkIsModified(key)) break;
                this.getView().close();
                break;
            }
        }
    }

    public boolean checkPermModify() {
        int is;
        String opkey = "btn_modify";
        String entityId = "bcm_papertemplatelist";
        Map permitem = BcmPermSingleModel.getInstance().getPermitem();
        Map map = (Map)permitem.get(entityId);
        if (map == null || map.get(opkey) == null) {
            return true;
        }
        String[] perm = ((String)map.get(opkey)).split("@");
        if (perm.length < 2) {
            return true;
        }
        String bizAppId = this.getBizAppId();
        if (ApplicationTypeEnum.BGMD.appnum.equalsIgnoreCase(bizAppId)) {
            bizAppId = ApplicationTypeEnum.EB.appnum;
        }
        if ((is = BcmBasePluginUtil.checkPermission(this.getUserId(), this.getModelId(), AppMetadataCache.getAppInfo((String)bizAppId).getId(), perm[0], perm[1])) == 0) {
            return MemberPermHelper.ifUserHasRootPermByModel((long)this.getUserId(), (String)String.valueOf(this.getModelId()));
        }
        return true;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            if ("reset_filed_area".equals(callBackId)) {
                String areaPoint = this.getTemplateModel().getAreaPoint();
                String[] point = areaPoint.split(":");
                this.getSpreadModel().getAreaManager().removeArea(new PositionInfo(point[0], point[1]));
                this.getTemplateModel().setAreaPoint(null);
                this.cacheTemplateModel();
                this.cacheSpreadModel();
                new PaperViewSwitchers().switchView(this.getCurrentViewTabKey(), this, this.SPREAD_KEY, true);
                this.openFormPage("bcm_papertpl_datamodel");
            } else if ("btn_refresh".equals(callBackId)) {
                this.loadData();
                new PaperViewSwitchers().switchView(this.getCurrentViewTabKey(), this, this.SPREAD_KEY, true);
                this.setModified(false);
            } else if ("btn_close".equals(callBackId)) {
                this.getView().close();
            }
        }
    }

    private String getCurrentSelectAreaPointStart() {
        String selectorRect = this.getSelectorRect();
        return selectorRect.split(":")[0];
    }

    private void openAdjSettingListPage() {
        if (this.isModified()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6a21\u677f\u5df2\u4fee\u6539\uff0c\u8bf7\u5148\u4fdd\u5b58\u540e\u518d\u6253\u5f00\u5206\u5f55\u8bbe\u7f6e\u3002", (String)"InnerTradeTemplatePlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        InnerTradeTemplateModel templateModel = (InnerTradeTemplateModel)this.getTemplateModel();
        if (!QueryServiceHelper.exists((String)"bcm_papertemplate", (Object)templateModel.getId())) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6a21\u677f\u672a\u4fdd\u5b58\u6216\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5148\u68c0\u67e5\u5185\u90e8\u4ea4\u6613\u62b5\u9500\u6a21\u677f\u3002", (String)"InnerTradeTemplatePlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        IFormView mainPageView = this.getView().getMainView();
        IFormView parentView = this.getView().getParentView();
        String pageId = this.getView().getPageId() + templateModel.getId();
        if (mainPageView == null || mainPageView.getView(pageId) == null || parentView == null) {
            mainPageView = mainPageView == null ? this.getView() : mainPageView;
            FormShowParameter param = new FormShowParameter();
            param.setFormId("bcm_adjsettinglist");
            param.setPageId(pageId);
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            param.getOpenStyle().setTargetKey("_submaintab_");
            param.setCustomParam("KEY_MODEL_ID", (Object)(this.getModelId() + ""));
            param.setCustomParam("templateid", (Object)(templateModel.getId() + ""));
            param.setCustomParam("templatenumber", (Object)templateModel.getNumber());
            if (!this.checkPermModify() || this.getFormCustomParam("read") != null) {
                param.setCustomParam("noModify", (Object)"true");
            }
            param.setCaption(ResManager.loadKDString((String)"\u5206\u5f55\u8bbe\u7f6e", (String)"InnerTradeTemplatePlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            if (parentView == null) {
                this.getView().showForm(param);
                this.getView().sendFormAction(mainPageView);
            } else {
                parentView.showForm(param);
                this.getView().sendFormAction(parentView);
            }
        } else {
            IFormView childFormView = mainPageView.getView(pageId);
            childFormView.activate();
            this.getView().sendFormAction(childFormView);
        }
    }

    private void openFormPage(String formName) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bcm_papertemplate");
        formShowParameter.setParentPageId(this.getView().getPageId());
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        InnerTradeTemplateModel templateModel = (InnerTradeTemplateModel)this.getTemplateModel();
        switch (formName) {
            case "bcm_papertpl_fieldlist": {
                if (Objects.isNull(templateModel.getMergeNode()) || templateModel.getMergeNode() == 0L) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u201c\u62d3\u5c55\u6570\u636e\u533a\u57df\u201d\u3002", (String)"InnerTradeTemplatePlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                formShowParameter.setFormId(formName);
                formShowParameter.setRootPageId(this.getView().getPageId());
                formShowParameter.setStatus(OperationStatus.ADDNEW);
                formShowParameter.getOpenStyle().setTargetKey("_submaintab_");
                formShowParameter.setCaption(ResManager.loadKDString((String)"\u62d3\u5c55\u6570\u636e\u516c\u5f0f\u8bbe\u7f6e", (String)"InnerTradeTemplatePlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                formShowParameter.setCustomParam("templateid", (Object)templateModel.getId());
                templateModel.removeSellerAndBueyerField();
                List paperTemplateField = templateModel.getPaperTemplateField();
                formShowParameter.setCustomParam("paperTemplateField", (Object)ObjectSerialUtil.toByteSerialized((Object)paperTemplateField));
                formShowParameter.setCustomParam("seller", (Object)templateModel.getSeller());
                formShowParameter.setCustomParam("purchaser", (Object)templateModel.getPurchaser());
                formShowParameter.setCustomParam("mergenode", (Object)templateModel.getMergeNode());
                formShowParameter.setCustomParam("usage", (Object)templateModel.getUsage());
                formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bcm_papertpl_fieldlist"));
                break;
            }
            case "explain_setting": {
                Map<String, Object> params = this.buildBaseParams((CommonPaperTemplateModel)templateModel);
                if (Objects.nonNull(templateModel.getDescription())) {
                    params.put("description", ObjectSerialUtil.toByteSerialized((Object)templateModel.getDescription()));
                }
                params.put("explain", "isexplain");
                formShowParameter.setCustomParams(params);
                formShowParameter.setStatus(OperationStatus.EDIT);
                formShowParameter.setCaption(ResManager.loadKDString((String)"\u7f16\u5236\u8bf4\u660e", (String)"InnerTradeTemplatePlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "baseinfo_setting": {
                Map<String, Object> params = this.buildBaseParams((CommonPaperTemplateModel)templateModel);
                if (templateModel.getEffectivedata() != null) {
                    params.put("effectivedata", JSON.toJSONString((Object)templateModel.getEffectivedata()));
                    params.put("effectivetext", templateModel.getEffectivetext());
                }
                formShowParameter.setCustomParams(params);
                QFilter filter2 = new QFilter("id", "!=", (Object)templateModel.getId());
                QFilter filter = new QFilter("group", "=", (Object)templateModel.getGroup());
                QFilter[] filters = new QFilter[]{filter2, filter};
                boolean flag = QueryServiceHelper.exists((String)"bcm_papertemplate", (QFilter[])filters);
                formShowParameter.setCaption(ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f", (String)"InnerTradeTemplatePlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                formShowParameter.setStatus(OperationStatus.ADDNEW);
                formShowParameter.setCustomParam("exist", (Object)(!flag ? 1 : 0));
                formShowParameter.setCustomParam("tmplscene", (Object)this.toByteSerialized(templateModel.getTmplScene()));
                break;
            }
            case "bcm_papertpl_datamodel": {
                HashMap<String, Object> dataModelInfo = new HashMap<String, Object>();
                dataModelInfo.put("usage", templateModel.getUsage());
                dataModelInfo.put("group", templateModel.getGroup());
                dataModelInfo.put("mergenode", templateModel.getMergeNode());
                dataModelInfo.put("seller", templateModel.getSeller());
                dataModelInfo.put("purchaser", templateModel.getPurchaser());
                dataModelInfo.put("newAreaPointStart", this.getCurrentSelectAreaPointStart());
                dataModelInfo.put("oldAreaPointStart", templateModel.getAreaPoint() == null ? "" : templateModel.getAreaPoint().split(":")[0]);
                dataModelInfo.put("KEY_MODEL_ID", this.getModelId());
                formShowParameter.setCustomParams(dataModelInfo);
                formShowParameter.setFormId(formName);
                formShowParameter.setCaption(ResManager.loadKDString((String)"\u6570\u636e\u6a21\u578b\u8bbe\u7f6e", (String)"InnerTradeTemplatePlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "bcm_mffunctionset": {
                if (Objects.isNull(templateModel.getSeller()) || Objects.isNull(templateModel.getPurchaser()) || templateModel.getSeller() == 0L || templateModel.getPurchaser() == 0L) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u201c\u62d3\u5c55\u6570\u636e\u533a\u57df\u201d\u3002", (String)"InnerTradeTemplatePlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (StringUtils.isNotEmpty((CharSequence)templateModel.getMfFormula())) {
                    formShowParameter.setCustomParam("formula", (Object)templateModel.getMfFormula());
                }
                formShowParameter.setCustomParam("seller", (Object)templateModel.getSeller());
                formShowParameter.setCustomParam("purchaser", (Object)templateModel.getPurchaser());
                formShowParameter.setCustomParam("templateid", (Object)templateModel.getId());
                formShowParameter.setFormId(formName);
                formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bcm_mffunctionset"));
                break;
            }
            case "bcm_intrdimfieldscope": {
                if (Objects.isNull(templateModel.getMergeNode()) || templateModel.getMergeNode() == 0L) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u201c\u62d3\u5c55\u6570\u636e\u533a\u57df\u201d\u3002", (String)"InnerTradeTemplatePlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                formShowParameter.setCustomParam("mergenode", (Object)templateModel.getMergeNode());
                formShowParameter.setCustomParam("templateid", (Object)templateModel.getId());
                formShowParameter.setCustomParam("model", (Object)this.getModelId());
                List fields = templateModel.getPaperTemplateField();
                if (CollectionUtils.isNotEmpty((Collection)fields)) {
                    formShowParameter.setCustomParam("fieldRefIds", (Object)ObjectSerialUtil.toByteSerialized(fields.stream().map(PaperTemplateFieldEntry::getDimModelField).filter(id -> LongUtil.toLong((Object)id) != 0L).collect(Collectors.toSet())));
                    formShowParameter.setCustomParam("extfieldIds", (Object)ObjectSerialUtil.toByteSerialized(fields.stream().map(PaperTemplateFieldEntry::getExtModelField).filter(id -> LongUtil.toLong((Object)id) != 0L).collect(Collectors.toSet())));
                }
                formShowParameter.setCustomParam("joinFieldDimensionIds", (Object)ObjectSerialUtil.toByteSerialized(this.getJoinFieldDimensionIds(templateModel)));
                if (CollectionUtils.isNotEmpty((Collection)templateModel.getPaperTemplateDimFieldScopeEntry())) {
                    formShowParameter.setCustomParam("paperTemplateDimFieldScope", (Object)ObjectSerialUtil.toByteSerialized((Object)templateModel.getPaperTemplateDimFieldScopeEntry()));
                }
                formShowParameter.setFormId(formName);
                formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bcm_intrdimfieldscope"));
                break;
            }
        }
        if (!this.checkPermModify() || this.checkIsExistReportRecordByTemplateId(templateModel.getId()) || this.getFormCustomParam("read") != null) {
            formShowParameter.setCustomParam("noModify", (Object)"true");
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, formName);
        formShowParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(formShowParameter);
    }

    private Map<String, Object> buildBaseParams(CommonPaperTemplateModel templateModel) {
        HashMap<String, Object> params = new HashMap<String, Object>(6);
        params.put("name", templateModel.getMultilingualName());
        params.put("number", templateModel.getNumber());
        params.put("KEY_MODEL_ID", templateModel.getModelId());
        params.put("permclass", templateModel.getPermClass());
        params.put("templatecatalog", templateModel.getTemplateCatalog().getId());
        params.put("usage", templateModel.getUsage());
        if (LongUtil.isvalidLong((Object)templateModel.getId())) {
            params.put("id", templateModel.getId());
        }
        if (LongUtil.isvalidLong((Object)templateModel.getGroup())) {
            params.put("group", templateModel.getGroup());
        }
        if (StringUtils.isNotEmpty((CharSequence)templateModel.getDescription())) {
            params.put("description", templateModel.getDescription());
        }
        return params;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String action = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        InnerTradeTemplateModel templateModel = (InnerTradeTemplateModel)this.getTemplateModel();
        boolean isModify = false;
        boolean isShowTipModify = false;
        switch (action) {
            case "bcm_papertpl_fieldlist": {
                Map data = (Map)ObjectSerialUtil.deSerializedBytes((String)returnData.toString());
                List fieldList = (List)data.get("formula");
                isModify = isShowTipModify = !ObjectSerialUtil.toByteSerialized((Object)fieldList).equalsIgnoreCase(ObjectSerialUtil.toByteSerialized((Object)templateModel.getPaperTemplateField()));
                templateModel.setPaperTemplateField(fieldList);
                this.cacheTemplateModel((CommonPaperTemplateModel)templateModel);
                break;
            }
            case "explain_setting": {
                this.fillBackDescInfo((Map)ObjectSerialUtil.deSerializedBytes((String)returnData.toString()));
                isModify = true;
                break;
            }
            case "baseinfo_setting": {
                this.fillBackBaseInfo((Map)ObjectSerialUtil.deSerializedBytes((String)returnData.toString()));
                isModify = true;
                break;
            }
            case "bcm_papertpl_datamodel": {
                Map dataModelInfo = (Map)ObjectSerialUtil.deSerializedBytes((String)returnData.toString());
                Long newSeller = (Long)dataModelInfo.get("seller");
                Long newPurchaser = (Long)dataModelInfo.get("purchaser");
                Long newMergeNode = (Long)dataModelInfo.get("mergenode");
                String newAreaPointStart = (String)dataModelInfo.get("newAreaPointStart");
                this.checkGroup(templateModel, newMergeNode);
                this.clearMfFormula(templateModel, newSeller, newPurchaser);
                templateModel.setSeller(newSeller);
                templateModel.setPurchaser(newPurchaser);
                templateModel.setMergeNode(newMergeNode);
                this.setFiledArea((CommonPaperTemplateModel)templateModel, newAreaPointStart);
                new PaperViewSwitchers().switchView(TAB_VIEW_FIELD, this, this.SPREAD_KEY, true);
                isModify = true;
                break;
            }
            case "spread_field_f7": {
                this.handleReturnF7DataToCell(returnData);
                isModify = true;
                break;
            }
            case "bcm_mffunctionset": {
                isModify = isShowTipModify = this.handleReturnMfFormula(returnData, templateModel);
                break;
            }
            case "selectFormula": 
            case "setFormula": {
                String formulaStr = returnData.toString();
                if (formulaStr.contains("template.data")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u91d1\u989d\u5355\u4f4d\u8bbe\u7f6e\u3002", (String)"InnerTradeTemplatePlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                int row = this.getSpreadSelector().getStartRow();
                int col = this.getSpreadSelector().getStartCol();
                Cell formulaCell = this.getEffectiveSheet().getCell(row, col);
                formulaCell.setFormula(formulaStr);
                this.cacheSpreadModel();
                this.handleCallBackFormula(formulaStr);
                isShowTipModify = true;
                isModify = true;
                break;
            }
            case "bcm_intrdimfieldscope": {
                Map fieldScopeMap = (Map)ObjectSerialUtil.deSerializedBytes((String)returnData.toString());
                isModify = (Boolean)fieldScopeMap.get(IS_MODIFY);
                List fieldScope = (List)fieldScopeMap.get("dimFieldScope");
                for (PaperTemplateDimFieldScopeEntry entry : fieldScope) {
                    entry.setTemplate((CommonPaperTemplateModel)templateModel);
                }
                templateModel.setPaperTemplateDimFieldScopeEntry(fieldScope);
                this.cacheTemplateModel((CommonPaperTemplateModel)templateModel);
                break;
            }
        }
        this.setModified(isModify || this.isModified());
        this.setShowTipModified(isShowTipModify || this.isShowTipModified());
        this.forcePushCache();
    }

    private void updateDimScope(InnerTradeTemplateModel template) {
        Set<Long> joinFieldDimensionIds = this.getJoinFieldDimensionIds(template);
        Long sellerDimId = MemberReader.getDimensionIdByNum((long)template.getModelId(), (String)PresetConstant.ENTITY_DIM);
        Long buyerDimId = MemberReader.getDimensionIdByNum((long)template.getModelId(), (String)PresetConstant.INTERNALCOMPANY_DIM);
        List dimFieldScopeEntrys = template.getPaperTemplateDimFieldScopeEntry();
        dimFieldScopeEntrys.removeIf(e -> joinFieldDimensionIds.contains(e.getDimension()) || joinFieldDimensionIds.contains(e.getExtendFieldId()));
        Set dimRefIds = template.getPaperTemplateField().stream().filter(e -> e.getDimModelField() != null && e.getDimModelField() != 0L).map(PaperTemplateFieldEntry::getDimModelField).collect(Collectors.toSet());
        List dimFields = ExtDimHelper.getDimFieldByRefIds(dimRefIds);
        Set dimIds = dimFields.stream().map(IntrField::getId).collect(Collectors.toSet());
        dimIds.add(sellerDimId);
        dimIds.add(buyerDimId);
        Set extFieldIds = template.getPaperTemplateField().stream().map(PaperTemplateFieldEntry::getExtModelField).filter(extModelField -> LongUtil.toLong((Object)extModelField) != 0L).collect(Collectors.toSet());
        Set extFieldEnumId = ExtDimHelper.getExtendFieldsByRefIds((long)template.getModelId(), extFieldIds).stream().filter(e -> DataTypeEnum.ENUMTP.getOIndex().equals(e.getDataType()) && !"INTR_000".equals(e.getNumber()) || e.isLinkDim()).map(IntrField::getId).collect(Collectors.toSet());
        dimIds.addAll(extFieldEnumId);
        dimFieldScopeEntrys.removeIf(e -> !dimIds.contains(LongUtil.toLong((Object)e.getDimension()) != 0L ? e.getDimension() : e.getExtendFieldId()));
        dimFieldScopeEntrys.sort(Comparator.comparingInt(DynaEntryObject::getSeq));
        for (int i = 0; i < dimFieldScopeEntrys.size(); ++i) {
            ((PaperTemplateDimFieldScopeEntry)dimFieldScopeEntrys.get(i)).setSeq(i + 1);
        }
    }

    private Set<Long> getJoinFieldDimensionIds(InnerTradeTemplateModel template) {
        boolean isMergeUsage = "0".equals(template.getUsage());
        List mergeField = template.getPaperTemplateField().stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getFormula()) || e.isMerge() || isMergeUsage && "INTR_001".equals(e.getExtModelFieldNumber())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(mergeField)) {
            return mergeField.stream().map(e -> {
                IntrField dimField = ExtDimHelper.getTmpFieldByRefId((Long)(LongUtil.toLong((Object)e.getDimModelField()) != 0L ? e.getDimModelField() : e.getExtModelField()));
                if (dimField != null) {
                    return dimField.getId();
                }
                return 0L;
            }).collect(Collectors.toSet());
        }
        return new HashSet<Long>(16);
    }

    private void setFiledArea(CommonPaperTemplateModel templateModel, String start) {
        List fields = ExtDimHelper.getTmpFieldByExtModelId((Long)templateModel.getMergeNode());
        String end = ExcelUtils.offsetAxisByCol((String)start, (int)(fields.size() + 1));
        String areaPoint = start + ":" + end;
        templateModel.setAreaPoint(areaPoint);
        this.cacheTemplateModel(templateModel);
        this.getPageCache().put("initField", "true");
    }

    private void fillBackDescInfo(Map<String, Object> param) {
        InnerTradeTemplateModel templateModel = (InnerTradeTemplateModel)this.getTemplateModel();
        if (Objects.nonNull(param.get("description"))) {
            String desc = (String)param.get("description");
            templateModel.setDescription(desc);
        }
        this.getPageCache().put("paper_template_model", this.toSerialTemplateModel((CommonPaperTemplateModel)templateModel));
        this.cacheTemplateModel((CommonPaperTemplateModel)templateModel);
    }

    private void fillBackBaseInfo(Map<String, Object> param) {
        Object text;
        if (Objects.isNull(param) || param.size() == 0) {
            return;
        }
        InnerTradeTemplateModel templateModel = (InnerTradeTemplateModel)this.getTemplateModel();
        if (Objects.nonNull(param.get("templatecatalog"))) {
            Long catalogId = (Long)param.get("templatecatalog");
            PaperTemplateCatalog catalog = new PaperTemplateCatalog();
            DynamicObject dyna = QueryServiceHelper.queryOne((String)catalog.getDataEntityNumber(), (String)"id,name,longnumber", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)catalogId)});
            catalog.setId(catalogId.longValue());
            catalog.setName(dyna.getString("name"));
            String longnumber = dyna.getString("longnumber");
            templateModel.setTemplateType(PaperTemplateService.getTemplateTypeByLongnumber((String)longnumber));
            templateModel.setTemplateCatalog(catalog);
        }
        if (Objects.nonNull(param.get("model"))) {
            Long modelId = (Long)param.get("model");
            templateModel.setModelId(modelId.longValue());
        }
        if (Objects.nonNull(param.get("scenario"))) {
            Long scenarioId = (Long)param.get("scenario");
            templateModel.setScenario(scenarioId);
        }
        if (Objects.nonNull(param.get("permclass"))) {
            Long permClassId = (Long)param.get("permclass");
            templateModel.setPermClass((Object)permClassId);
        } else {
            templateModel.setPermClass(null);
        }
        if (Objects.nonNull(param.get("mutiname"))) {
            templateModel.setName(param.get("mutiname"));
        }
        if (Objects.nonNull(param.get("number"))) {
            String number = (String)param.get("number");
            templateModel.setNumber(number);
        }
        if (Objects.nonNull(param.get("description"))) {
            String desc = (String)param.get("description");
            templateModel.setDescription(desc);
        }
        if (Objects.nonNull(param.get(TMPL_SCENE_CACHE))) {
            templateModel.setTmplScene((Map)this.deSerializedBytes(param.get(TMPL_SCENE_CACHE).toString()));
        }
        templateModel.setEffectivetext((text = param.get("effectivetext")) == null ? null : text.toString());
        templateModel.setEffectivedata((Map)param.get("effectivedata"));
        this.getPageCache().put("paper_template_model", this.toSerialTemplateModel((CommonPaperTemplateModel)templateModel));
        this.cacheTemplateModel((CommonPaperTemplateModel)templateModel);
    }

    protected void handleSaveEvent() {
        if (TAB_VIEW_STYLE.equals(this.getPageCache().get("tab_current_key"))) {
            this.invokeSaveEvent();
        }
    }

    private void invokeSaveEvent() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("callback", "invokeAction");
        params.put("invokemethod", "actionSave");
        SpreadClientInvoker.invokeGetSpreadJsonMethod(this.getClientViewProxy(), this.SPREAD_KEY, params);
    }

    public void actionSave(String spreadJson) {
        InnerTradeTemplateModel template = (InnerTradeTemplateModel)this.getTemplateModel();
        long templateId = template.getId();
        boolean isNew = !QueryServiceHelper.exists((String)"bcm_papertemplate", (Object)templateId);
        template.setSpreadJson(spreadJson);
        this.syncFrontFormulasToSpreadModel(spreadJson);
        if (this.isShowTipModified()) {
            this.getEffectiveSheet().putUserObject("intr_show_tip_date", (Object)new Date());
        }
        template.setData(this.getSpreadModelSerial());
        this.updateDimScope(template);
        LinkedHashMap<String, String> templateFieldInfo = this.getTemplateFieldInfo();
        if (!this.checkFieldCanToSave(templateFieldInfo, template)) {
            return;
        }
        if (template.getSequence() == null) {
            DynamicObject count = QueryServiceHelper.queryOne((String)"bcm_papertemplate", (String)"count(*) as num", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)template.getModelId())});
            template.setSequence(count.getInt("num") + 1);
        }
        try (TXHandle th = TX.requiresNew();){
            try {
                if (QueryServiceHelper.exists((String)"bcm_papertemplate", (Object)template.getId())) {
                    template.setModifierId(this.getUserId());
                    template.setModifyTime(TimeServiceHelper.now());
                } else {
                    template.setVersionNumber(new BigDecimal(1));
                    template.setCreatorId(Long.parseLong(RequestContext.get().getUserId()));
                    template.setCreateTime(TimeServiceHelper.now());
                    template.setStatus("1");
                    template.setGroup(GlobalIdUtil.genGlobalLongId());
                    template.setEffectiveDate(EntityVersioningUtil.getModelBeginDate((Object)template.getModelId()));
                }
                PaperTemplateHelper.saveTmplScene((long)template.getModelId(), (PaperTemplateTypeEnum)PaperTemplateTypeEnum.INNERTRADE, (long)template.getGroup(), (List)((List)template.getTmplScene().get("items")));
                template.removeSellerAndBueyerField();
                DynamicObject t = template.genDynamicObject();
                BusinessDataWriter.delete((IDataEntityType)t.getDataEntityType(), (Object[])new Object[]{t.getPkValue()});
                BusinessDataWriter.save((IDataEntityType)t.getDataEntityType(), (Object[])new Object[]{t});
                PaperTemplateService.moveAllVersion2Catalog((Collection)Lists.newArrayList((Object[])new Object[]{t.getLong("id")}), (long)this.getModelId(), (long)t.getLong("templatecatalog"), Collections.singleton(t.getLong("group")), SaveServiceHelper::save);
                PermClassEntityHelper.savePermClass((DynamicObject)t, (Long)ConvertUtil.convertObjToLong((Object)this.getModelId()));
                this.cacheTemplateModel((CommonPaperTemplateModel)template);
                this.addOperationLog(isNew, true);
            }
            catch (Exception e) {
                th.markRollback();
                this.addOperationLog(isNew, false);
                throw new KDBizException((Throwable)e, new ErrorCode("inner_tpl_0000", "Paper Template Save Error."), new Object[0]);
            }
        }
        this.setModified(false);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"InnerTradeTemplatePlugin_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }

    private LinkedHashMap<String, String> getTemplateFieldInfo() {
        LinkedHashMap<String, String> fieldLocationMap = new LinkedHashMap<String, String>(16);
        String areaPoint = this.getTemplateModel().getAreaPoint();
        if (kd.fi.bcm.spread.common.util.StringUtil.isEmptyString((String)areaPoint)) {
            return fieldLocationMap;
        }
        String start = areaPoint.split(":")[0];
        String end = areaPoint.split(":")[1];
        int row = ExcelUtils.pos2Y((String)start);
        int startCol = ExcelUtils.pos2X((String)start);
        int endCol = ExcelUtils.pos2X((String)end);
        Sheet sheet = this.getEffectiveSheet();
        for (int i = startCol; i <= endCol; ++i) {
            Cell cell = sheet.getCell(row, i);
            String extMemberNumber = (String)cell.getUserObject("number");
            if (extMemberNumber == null) continue;
            fieldLocationMap.put(cell.getExcelAxis(), extMemberNumber);
        }
        Cell sellCell = sheet.getCell(row, startCol);
        Cell buyCell = sheet.getCell(row, startCol + 1);
        Collection<String> fileNumbers = fieldLocationMap.values();
        if (!fileNumbers.contains(IntrConstant.FIELD_ORG_NUMBER) && IntrConstant.getSellerName().equals(sellCell.getValue())) {
            fieldLocationMap.put(sellCell.getExcelAxis(), IntrConstant.FIELD_ORG_NUMBER);
        }
        if (!fileNumbers.contains(IntrConstant.FIELD_IC_NUMBER) && IntrConstant.getBuyerName().equals(buyCell.getValue())) {
            fieldLocationMap.put(buyCell.getExcelAxis(), IntrConstant.FIELD_IC_NUMBER);
        }
        return fieldLocationMap;
    }

    private boolean checkFieldCanToSave(LinkedHashMap<String, String> fieldLocationMap, InnerTradeTemplateModel templateModel) {
        boolean isMergeUsage = "0".equals(templateModel.getUsage());
        Long extModelId = templateModel.getMergeNode();
        if (fieldLocationMap.isEmpty() || extModelId == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u201c\u62d3\u5c55\u6570\u636e\u533a\u57df\u201d\u3002", (String)"InnerTradeTemplatePlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        this.checkGroup(templateModel, extModelId);
        Map usedExtDataModels = IntrTemplateHelper.queryUsedExtDataModelIds((Long)templateModel.getModelId(), (Long)templateModel.getGroup());
        if (usedExtDataModels.containsKey(extModelId)) {
            ExtTemplateDto tmpl = (ExtTemplateDto)usedExtDataModels.get(extModelId);
            if (tmpl.isIntr()) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5408\u5e76\u65b9\u6570\u636e\u6a21\u578b\u5df2\u88ab\u5185\u90e8\u4ea4\u6613\u62b5\u9500\u6a21\u677f %1$s(%2$s) \u4f7f\u7528\u3002", (String)"InnerTradeTemplatePlugin_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]), tmpl.getName(), tmpl.getNumber()));
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5408\u5e76\u65b9\u6570\u636e\u6a21\u578b\u5df2\u88ab\u62a5\u8868\u6a21\u677f %1$s(%2$s) \u4f7f\u7528\u3002", (String)"InnerTradeTemplatePlugin_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]), tmpl.getName(), tmpl.getNumber()));
        }
        if (isMergeUsage && !kd.fi.bcm.spread.common.util.StringUtil.isEmptyString((String)templateModel.getMfFormula()) && !this.checkDiffFieldInTmplFields(templateModel)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u201c\u5bf9\u8d26\u8bbe\u7f6e\u201d\u5df2\u8bbe\u7f6e\uff0c\u6a21\u677f\u5b57\u6bb5\u5fc5\u987b\u5305\u542b\u201cINTR_000 \u4ea4\u6613\u5dee\u989d\u9879\u201d\u6210\u5458\u3002", (String)"InnerTradeTemplatePlugin_19", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (!fieldLocationMap.containsValue("INTR_001")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u9009\u62e9\u4e1a\u52a1\u7c7b\u578b\u5b57\u6bb5\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"InnerTradeTemplatePlugin_20", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (!fieldLocationMap.containsValue(IntrConstant.FIELD_ORG_NUMBER)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u9009\u62e9\u9500\u552e\u65b9\u5b57\u6bb5\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"InnerTradeTemplatePlugin_21", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (!fieldLocationMap.containsValue(IntrConstant.FIELD_IC_NUMBER)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u9009\u62e9\u91c7\u8d2d\u65b9\u5b57\u6bb5\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"InnerTradeTemplatePlugin_22", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (templateModel.getTmplScene() == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f\u4e2d\u6ca1\u6709\u8bbe\u7f6e\u9002\u7528\u60c5\u666f\u3002", (String)"InnerTradeTemplatePlugin_23", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        List items = (List)templateModel.getTmplScene().get("items");
        if (CollectionUtils.isEmpty((Collection)items)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f\u4e2d\u6ca1\u6709\u8bbe\u7f6e\u9002\u7528\u60c5\u666f\u3002", (String)"InnerTradeTemplatePlugin_23", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        HashMap<String, ArrayList<String>> fieldMap = new HashMap<String, ArrayList<String>>();
        for (Map.Entry<String, String> entry : fieldLocationMap.entrySet()) {
            ArrayList<String> locationList = (ArrayList<String>)fieldMap.get(entry.getValue());
            if (locationList != null) {
                locationList.add(entry.getKey());
                continue;
            }
            locationList = new ArrayList<String>(10);
            locationList.add(entry.getKey());
            fieldMap.put(entry.getValue(), locationList);
        }
        ArrayList<String> msg = new ArrayList<String>(10);
        for (Map.Entry entry : fieldMap.entrySet()) {
            if (((List)entry.getValue()).size() <= 1) continue;
            msg.add(String.format(ResManager.loadKDString((String)"%s\u5b58\u5728\u76f8\u540c\u6210\u5458\u3002", (String)"InnerTradeTemplatePlugin_24", (String)"fi-bcm-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", (Iterable)entry.getValue())));
        }
        if (!msg.isEmpty()) {
            throw new KDBizException(String.join((CharSequence)";", msg));
        }
        return true;
    }

    private void checkGroup(InnerTradeTemplateModel templateModel, Long newExtModnewelId) {
        if (templateModel.getVersionNumber() != null && BigDecimal.valueOf(1.0).compareTo(templateModel.getVersionNumber()) < 0) {
            Long oldGroupId;
            Long newGroupId = IntrTemplateHelper.getGroupIdByExtModelId((Long)newExtModnewelId);
            DynamicObjectCollection tempGroups = IntrTemplateHelper.getTemplateByGroup((Long)templateModel.getModelId(), (Long)templateModel.getGroup());
            if (CollectionUtils.isNotEmpty((Collection)tempGroups) && (oldGroupId = IntrTemplateHelper.getGroupIdByExtModelId((Long)((DynamicObject)tempGroups.get(0)).getLong("mergenode.id"))) != null && !oldGroupId.equals(newGroupId)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u540c\u4e00\u4e2a\u6a21\u677f\u7684\u201c\u5408\u5e76\u65b9\u6a21\u578b\u201d\u53ea\u80fd\u9009\u62e9\u540c\u4e00\u4e2a\u62d3\u5c55\u7ef4\u5b57\u6bb5\u5206\u7ec4\u7684\u6a21\u578b\u3002", (String)"InnerTradeTemplatePlugin_25", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private boolean checkDiffFieldInTmplFields(InnerTradeTemplateModel templateModel) {
        if (CollectionUtils.isEmpty((Collection)templateModel.getPaperTemplateField())) {
            return false;
        }
        return templateModel.getPaperTemplateField().stream().anyMatch(e -> "INTR_000".equals(e.getExtModelFieldNumber()));
    }

    @Override
    public void spreadF7Click(int row, int col) {
        super.spreadF7Click(row, col);
        Long mergeNode = this.getTemplateModel().getMergeNode();
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bcm_structofextend_f7");
        formShowParameter.setParentPageId(this.getView().getPageId());
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u5b57\u6bb5\u6210\u5458\u5217\u8868", (String)"InnerTradeTemplatePlugin_26", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "spread_field_f7"));
        formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        formShowParameter.setCustomParam("filterModelId", (Object)mergeNode);
        formShowParameter.setCustomParam("isShowBuySellField", (Object)true);
        this.getView().showForm(formShowParameter);
    }

    private void handleReturnF7DataToCell(Object returnData) {
        if (returnData instanceof Tuple) {
            Tuple data = (Tuple)returnData;
            Tuple fieldTuple = (Tuple)data.p2;
            IntrField field = ExtDimHelper.getTmpFieldInfoById((Long)LongUtil.toLong((Object)data.p1), (Long)((Long)fieldTuple.p1));
            this.setFiledIdToCell(field, this.getF7SelectRow(), this.getF7SelectCol());
        }
    }

    private void setFiledIdToCell(IntrField field, int row, int col) {
        Cell cell = this.getEffectiveSheet().getCell(row, col);
        if (field != null) {
            cell.setValue((Object)field.getName());
            cell.setUserObject("fieldId", (Object)field.getExtFieldRefId());
            cell.setUserObject("fieldType", (Object)field.getExtFieldRefType());
            cell.setUserObject("number", (Object)field.getNumber());
            cell.setUserObject("name", (Object)field.getName());
        } else {
            cell.setValue(null);
            cell.getUserObject().clear();
        }
        this.invokeJsUpdateCellValues(row, col, field);
        this.updateTemplateModelField();
    }

    public void setSpreadF7Item(F7ItemFillBackArgs arg) {
        long filedId = arg.getId();
        IntrField field = ExtDimHelper.getTmpFieldByRefId((Long)filedId);
        this.setFiledIdToCell(field, arg.getR(), arg.getC());
    }

    @Override
    public void spreadF7LookUpData(LookUpDataArgs args) {
        Long mergeNode = this.getTemplateModel().getMergeNode();
        ORM orm = ORM.create();
        QFilter filterName = new QFilter("extfield.name", "like", (Object)(args.getLeft() + args.getValue().trim() + args.getRight()));
        QFilter filterNumber = new QFilter("extfield.number", "like", (Object)(args.getLeft() + args.getValue().trim() + args.getRight()));
        QFilter filterExtModel = new QFilter("extmodelid", "=", (Object)mergeNode);
        int top = args.getCountEnd() > 0 ? args.getCountEnd() : 20;
        DataSet ds = orm.queryDataSet(this.getClass().getName(), "bcm_extmodelfield", "id,extfield.number,extfield.name", new QFilter[]{filterName.or(filterNumber), filterExtModel}, "extfield.number", top);
        DynamicObjectCollection queryCollection = orm.toPlainDynamicObjectCollection(ds, args.getCountStart() - 1, top);
        HashMap<String, Serializable> data = new HashMap<String, Serializable>();
        ArrayList arrayList = new ArrayList();
        for (DynamicObject object : queryCollection) {
            ArrayList<String> arr = new ArrayList<String>();
            arr.add(object.getString("id"));
            arr.add(object.getString("extfield.number"));
            arr.add(object.getString("extfield.name"));
            arrayList.add(arr);
        }
        data.put("data", arrayList);
        data.put("r", Integer.valueOf(args.getR()));
        data.put("c", Integer.valueOf(args.getC()));
        this.getClientViewProxy().invokeControlMethod(this.SPREAD_KEY, "setLookupData", new Object[]{data});
    }

    private void operationCheck(NotifyEvent notifyEvent) {
        AskExcuteInfo info = (AskExcuteInfo)notifyEvent.getSource();
        String areaPoint = this.getTemplateModel().getAreaPoint();
        if (kd.fi.bcm.spread.common.util.StringUtil.isEmptyString((String)areaPoint)) {
            return;
        }
        EventConstant.ActionName actionname = info.getActionname();
        if (EventConstant.ActionName.REMOVE_COL == actionname && info.getOperationdata().size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5220\u9664\u5217\u5931\u8d25\uff0c\u6bcf\u6b21\u53ea\u80fd\u5220\u96641\u5217\u3002", (String)"InnerTradeTemplatePlugin_27", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            notifyEvent.setCancel(true);
        }
    }

    private void invokeAddOrRemove(NotifyEvent notifyEvent) {
        AskExcuteInfo info = (AskExcuteInfo)notifyEvent.getSource();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("status", true);
        map.put("data", info.getOperationdata());
        map.put("isUndo", info.isUndo());
        if (EventConstant.ActionName.INSERT_COPIED_CELL == info.getActionname()) {
            map.put("copyStyle", false);
        }
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).invokeControlMethod(this.SPREAD_KEY, info.getMethod().getMethod(), new Object[]{map});
        this.syncFieldArea(info);
    }

    private void syncFieldArea(AskExcuteInfo info) {
        String areaPoint = this.getTemplateModel().getAreaPoint();
        if (kd.fi.bcm.spread.common.util.StringUtil.isEmptyString((String)areaPoint)) {
            return;
        }
        String start = areaPoint.split(":")[0];
        String end = areaPoint.split(":")[1];
        int row = ExcelUtils.pos2Y((String)start);
        int startCol = ExcelUtils.pos2X((String)start);
        int endCol = ExcelUtils.pos2X((String)end);
        EventConstant.ActionName actionname = info.getActionname();
        Integer index = info.getOperationdata().get(0);
        int insertCount = info.getOperationdata().size();
        if (EventConstant.ActionName.ADD_COL == actionname || EventConstant.ActionName.REMOVE_COL == actionname) {
            if (index < startCol) {
                if (EventConstant.ActionName.ADD_COL == actionname) {
                    startCol += insertCount;
                    endCol += insertCount;
                } else {
                    --startCol;
                    --endCol;
                }
            } else if (index <= endCol) {
                endCol = EventConstant.ActionName.ADD_COL == actionname ? (endCol += insertCount) : --endCol;
            }
        } else if ((EventConstant.ActionName.ADD_ROW == actionname || EventConstant.ActionName.REMOVE_ROW == actionname) && index <= row) {
            row = EventConstant.ActionName.ADD_ROW == actionname ? (row += insertCount) : --row;
        }
        start = ExcelUtils.xy2Pos((int)startCol, (int)row);
        end = ExcelUtils.xy2Pos((int)endCol, (int)row);
        this.getTemplateModel().setAreaPoint(start + ":" + end);
        this.cacheTemplateModel();
        if (EventConstant.ActionName.ADD_COL == actionname || EventConstant.ActionName.REMOVE_COL == actionname) {
            this.updateTemplateModelField();
        }
    }

    private void updateTemplateModelField() {
        InnerTradeTemplateModel templateModel = (InnerTradeTemplateModel)this.getTemplateModel();
        String areaPoint = this.getTemplateModel().getAreaPoint();
        if (kd.fi.bcm.spread.common.util.StringUtil.isEmptyString((String)areaPoint)) {
            return;
        }
        String start = areaPoint.split(":")[0];
        String end = areaPoint.split(":")[1];
        int row = ExcelUtils.pos2Y((String)start);
        int startCol = ExcelUtils.pos2X((String)start);
        int endCol = ExcelUtils.pos2X((String)end);
        Sheet sheet = this.getEffectiveSheet();
        List paperTemplateField = templateModel.getPaperTemplateField();
        Map<String, PaperTemplateFieldEntry> fieldFormulaInfoMap = this.getFieldFormulaInfoMap(templateModel);
        paperTemplateField.clear();
        int seq = 1;
        for (int i = startCol; i <= endCol; ++i) {
            Cell cell = sheet.getCell(row, i);
            String number = (String)cell.getUserObject("number");
            if (number == null) continue;
            PaperTemplateFieldEntry fieldEntry = fieldFormulaInfoMap.get(number);
            if (fieldEntry == null) {
                fieldEntry = new PaperTemplateFieldEntry((CommonPaperTemplateModel)templateModel);
                fieldEntry.setFieldId((String)cell.getUserObject("fieldType"), (Long)cell.getUserObject("fieldId"));
                fieldEntry.setExtModelFieldNumber(number);
                fieldEntry.setExtModelId(templateModel.getMergeNode());
                fieldEntry.setExecuteSeq(1);
            }
            fieldEntry.setSeq(seq);
            ++seq;
            paperTemplateField.add(fieldEntry);
        }
        templateModel.setPaperTemplateField(paperTemplateField);
        this.cacheTemplateModel((CommonPaperTemplateModel)templateModel);
        this.cacheSpreadModel();
        this.forcePushCache();
    }

    private Map<String, PaperTemplateFieldEntry> getFieldFormulaInfoMap(InnerTradeTemplateModel templateModel) {
        List fieldFormulaInfo = templateModel.getPaperTemplateField();
        HashMap<String, PaperTemplateFieldEntry> fieldFormulaInfoMap = new HashMap<String, PaperTemplateFieldEntry>(16);
        for (PaperTemplateFieldEntry fieldEntry : fieldFormulaInfo) {
            fieldFormulaInfoMap.put(fieldEntry.getExtModelFieldNumber(), fieldEntry);
        }
        return fieldFormulaInfoMap;
    }

    private void setModified(boolean isModified) {
        this.cacheTrueOrFalseFlag(IS_MODIFY, isModified);
    }

    private boolean isModified() {
        return this.isTrueFlagInCache(IS_MODIFY);
    }

    private void setShowTipModified(boolean isShowTipModified) {
        this.cacheTrueOrFalseFlag(IS_SHOW_TIP_MODIFY, isShowTipModified);
    }

    private boolean isShowTipModified() {
        return this.isTrueFlagInCache(IS_SHOW_TIP_MODIFY);
    }

    private boolean checkIsModified(String key) {
        if (this.isModified()) {
            if ("btn_refresh".equals(key)) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u6a21\u677f\u5df2\u4fee\u6539\uff0c\u5237\u65b0\u4f1a\u4e22\u5931\u4fee\u6539\u7684\u5185\u5bb9\uff0c\u662f\u5426\u786e\u8ba4\u5237\u65b0\uff1f", (String)"InnerTradeTemplatePlugin_28", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(key, (IFormPlugin)this));
            } else if ("btn_close".equals(key)) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u6a21\u677f\u5df2\u4fee\u6539\uff0c\u9000\u51fa\u4f1a\u4e22\u5931\u4fee\u6539\u7684\u5185\u5bb9\uff0c\u662f\u5426\u786e\u8ba4\u9000\u51fa\uff1f", (String)"InnerTradeTemplatePlugin_29", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(key, (IFormPlugin)this));
            }
            return true;
        }
        return false;
    }

    private boolean handleReturnMfFormula(Object returnData, InnerTradeTemplateModel templateModel) {
        if (Objects.isNull(returnData)) {
            return false;
        }
        HashMap returnMap = (HashMap)returnData;
        String formulaText = returnMap.get("formula").toString();
        String oldFormula = templateModel.getMfFormula();
        if (!Objects.equals(oldFormula, formulaText)) {
            templateModel.setMfFormula(formulaText);
            this.getPageCache().put("paper_template_model", this.toSerialTemplateModel((CommonPaperTemplateModel)templateModel));
            this.cacheTemplateModel((CommonPaperTemplateModel)templateModel);
            return true;
        }
        return false;
    }

    private void clearMfFormula(InnerTradeTemplateModel templateModel, Long newSeller, Long newPurchaser) {
        if (!Objects.equals(templateModel.getSeller(), newSeller) || !Objects.equals(templateModel.getPurchaser(), newPurchaser)) {
            templateModel.setMfFormula("");
        }
    }

    private void addOperationLog(boolean isNew, boolean success) {
        OpNameMultiLangEnumBridge operation = isNew ? this.getOperationNew() : this.getOperationEdit();
        String status = success ? ResultStatusEnum.SUCCESS.getName() : ResultStatusEnum.FAIL.getName();
        this.writeOperationLog(operation, this.template.getNumber(), this.template.getName(), status);
    }

    private OpNameMultiLangEnumBridge getOperationNew() {
        return new OpNameMultiLangEnumBridge("\u65b0\u589e\u6a21\u677f", "InnerTradeTemplatePlugin_30", "fi-bcm-formplugin", "Add template");
    }

    private OpNameMultiLangEnumBridge getOperationEdit() {
        return new OpNameMultiLangEnumBridge("\u4fee\u6539\u6a21\u677f", "InnerTradeTemplatePlugin_31", "fi-bcm-formplugin", "Update template");
    }

    @Override
    public boolean checkIsExistReport() {
        return this.checkIsExistReportRecordByTemplateId(this.getTemplateModel().getId());
    }

    private boolean checkIsExistReportRecordByTemplateId(long templateId) {
        String hasReportStr = this.getPageCache().get(INTR_TEMPLATE_REPORT);
        if (StringUtils.isBlank((CharSequence)hasReportStr)) {
            boolean hasReport = QueryServiceHelper.exists((String)"bcm_intrreportentity", (QFilter[])new QFilter[]{new QFilter("papertemplate", "=", (Object)templateId)});
            this.getPageCache().put(INTR_TEMPLATE_REPORT, String.valueOf(hasReport));
            return hasReport;
        }
        return Boolean.parseBoolean(hasReportStr);
    }

    @Override
    public void showFormulaPanel(int row, int col) {
        String tab = this.getCurrentViewTabKey();
        if (!TAB_VIEW_STYLE.equals(tab)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9875\u7b7e\u4e0d\u652f\u6301\u516c\u5f0f\u7f16\u8f91\uff0c\u8bf7\u5728\u5e95\u7a3f\u8868\u6837\u9875\u7b7e\u8fdb\u884c\u516c\u5f0f\u7f16\u8f91\u3002", (String)"InnerTradeTemplatePlugin_32", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (this.getEffectiveSheet() != null && row >= 0 && col >= 0) {
            Cell cell = this.getEffectiveSheet().getCell(row, col);
            String formula = cell.getFormula();
            if (StringUtils.isEmpty((CharSequence)formula)) {
                this.showFormulaList(formula);
            } else {
                try {
                    formula = formula.replaceAll("\\p{C}", "");
                    Expression e = ExcelFormulaPaserHelper.parse((String)formula);
                    this.openFormulaEdit(e, formula);
                }
                catch (Exception ee) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u516c\u5f0f\u89e3\u6790\u9519\u8bef\u3002", (String)"InnerTradeTemplatePlugin_33", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
            }
        }
    }

    private void registerFormula() {
        Formula f = ResourcesLoaderUtil.getFormulaByNumber((String)NEW_RPT_INFO);
        if (null != f) {
            HashMap<String, Object> formula = new HashMap<String, Object>();
            formula.put(SpreadProperties.RegisterCustomFormulaMethod.FORMULANAME.k(), f.getNumber());
            formula.put(SpreadProperties.RegisterCustomFormulaMethod.ARGSNUM.k(), f.getParam().size());
            formula.put(SpreadProperties.RegisterCustomFormulaMethod.RETURENTYPE.k(), 1);
            if (f.getMinArgs() != null) {
                formula.put("minArgs", f.getMinArgs());
            }
            HashMap<String, Object> description = new HashMap<String, Object>();
            description.put(SpreadProperties.RegisterCustomFormulaMethod.DESCRIPTION.k(), f.getName());
            description.put(SpreadProperties.RegisterCustomFormulaMethod.PARAMETERS.k(), f.getParam());
            formula.put(SpreadProperties.RegisterCustomFormulaMethod.DESCRIPTIONIFNO.k(), description);
            SpreadClientInvoker.invokeRegisterCustomFormulaMethod(this.getClientViewProxy(), this.SPREAD_KEY, Lists.newArrayList((Object[])new Map[]{formula}));
        }
    }

    public void showFormulaList(String formula) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bcm_formulapicker");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setStatus(OperationStatus.EDIT);
        parameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        parameter.setCustomParam("filter", (Object)StringUtil.join((Object[])formulaNumbers, (String)","));
        parameter.setCustomParam("txtadvance", (Object)formula);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "selectFormula");
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(parameter);
    }

    private void openFormulaEdit(Expression e, String formula) {
        if (e instanceof BinaryOperationExpr) {
            this.showFormulaList(formula);
        } else if (e instanceof FunctionExpr) {
            String selectedNodeNumber = ((FunctionExpr)e).getFuncionName().toLowerCase(Locale.ENGLISH);
            boolean exitformula = FormulaConfig.getInstance().getFormulaList().stream().anyMatch(f -> selectedNodeNumber.equals(((String)f.get("number")).toLowerCase(Locale.ENGLISH)));
            if (exitformula) {
                FormShowParameter parameter = new FormShowParameter();
                ShowFormulaUtil.selectGuidePage(ResourcesLoaderUtil.getFormulaByNumber((String)selectedNodeNumber), parameter, this.getModelId());
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.setStatus(OperationStatus.EDIT);
                parameter.setCustomParam("accttype", (Object)selectedNodeNumber);
                parameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
                if (formula != null) {
                    parameter.setCustomParam("formula", (Object)ShowFormulaUtil.formula2LowerCase(formula));
                }
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "setFormula");
                parameter.setCloseCallBack(closeCallBack);
                this.getView().showForm(parameter);
            } else {
                this.showFormulaList(formula);
            }
        } else {
            this.showFormulaList(formula);
        }
    }

    private void handleCallBackFormula(String returnData) {
        Cell cell = this.getEffectiveSheet().getCell(this.getSelectorStartRow(), this.getSelectorStartCol());
        cell.setFormula(returnData);
        HashMap<String, Object> formula = new HashMap<String, Object>();
        formula.put(SpreadProperties.SetFormulaMethod.R.k(), cell.getRow());
        formula.put(SpreadProperties.SetFormulaMethod.C.k(), cell.getCol());
        formula.put(SpreadProperties.SetFormulaMethod.F.k(), returnData);
        formula.put(SpreadProperties.SetFormulaMethod.isUndo.k(), true);
        SpreadClientInvoker.invokeSetFormulaMethod(this.getClientViewProxy(), this.SPREAD_KEY, Lists.newArrayList((Object[])new Map[]{formula}));
    }

    private void syncFrontFormulasToSpreadModel(String spreadJson) {
        String frontJson = JsonSerializerUtil.uncompress((String)spreadJson);
        JSONObject obj = JSONObjectUtil.parseObjectOrder((String)frontJson);
        JSONObject sheets = (JSONObject)obj.get((Object)"sheets");
        for (Map.Entry entry : sheets.entrySet()) {
            Object datatable;
            Object data;
            Object value = entry.getValue();
            if (value == null || (data = ((JSONObject)value).get((Object)"data")) == null || (datatable = ((JSONObject)data).get((Object)"dataTable")) == null) continue;
            for (Map.Entry row : ((JSONObject)datatable).entrySet()) {
                if (row == null) continue;
                for (Map.Entry cell : ((JSONObject)row.getValue()).entrySet()) {
                    Object formulaObj;
                    if (cell == null || !(cell.getValue() instanceof JSONObject) || !((JSONObject)cell.getValue()).containsKey((Object)"formula") || (formulaObj = ((JSONObject)cell.getValue()).get((Object)"formula")) == null) continue;
                    this.getEffectiveSheet().getCell(Integer.parseInt((String)row.getKey()), Integer.parseInt((String)cell.getKey())).setFormula(formulaObj.toString());
                }
            }
        }
        this.cacheSpreadModel();
    }
}

