/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.papertemplate.innertrade;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.innertrade.model.IntrField;
import kd.fi.bcm.business.papertemplate.ExtDimHelper;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import org.apache.commons.collections4.CollectionUtils;

public class IntrFieldF7Plugin
extends AbstractBaseFormPlugin {
    private static final String CONTROL_MODEL = "extendmodel";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String BTN_OK = "btnok";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(BTN_OK);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.loadExtendmodel();
        this.refreshList();
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String keyName;
        super.propertyChanged(e);
        switch (keyName = e.getProperty().getName()) {
            case "extendmodel": {
                this.refreshList();
                break;
            }
        }
    }

    @Override
    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btnok": {
                if (!this.validate()) break;
                this.btnOk();
                break;
            }
        }
    }

    private void refreshList() {
        String dimFieldQfStr;
        this.getModel().deleteEntryData(ENTRY_ENTITY);
        this.getModel().beginInit();
        Long selectedFieldId = (Long)this.getFormCustomParam("field");
        Long extModelId = LongUtil.toLong((Object)this.getModel().getValue(CONTROL_MODEL));
        if (extModelId == 0L) {
            return;
        }
        QFilter extFieldFilter = new QFilter("extmodelid", "=", (Object)extModelId);
        QFilter dimFieldFilter = new QFilter("extmodelid", "=", (Object)extModelId);
        String extFieldQfStr = (String)this.getFormCustomParam("extFieldQfStr");
        if (StringUtils.isNotEmpty((String)extFieldQfStr)) {
            QFilter extFieldQFilter = (QFilter)ObjectSerialUtil.deSerializedBytes((String)extFieldQfStr);
            extFieldFilter.and(extFieldQFilter);
        }
        if (StringUtils.isNotEmpty((String)(dimFieldQfStr = (String)this.getFormCustomParam("dimFieldQfStr")))) {
            QFilter dimFieldQFilter = (QFilter)ObjectSerialUtil.deSerializedBytes((String)dimFieldQfStr);
            dimFieldFilter.and(dimFieldQFilter);
        }
        Integer selectedRowIndex = null;
        Integer rowIndex = 0;
        List tmpFields = ExtDimHelper.getTmpFields((QFilter[])new QFilter[]{extFieldFilter}, (QFilter[])new QFilter[]{dimFieldFilter});
        this.getModel().batchCreateNewEntryRow(ENTRY_ENTITY, tmpFields.size());
        for (IntrField field : tmpFields) {
            DynamicObject dyn = this.getModel().getEntryRowEntity(ENTRY_ENTITY, rowIndex.intValue());
            dyn.set("id", (Object)field.getExtFieldRefId());
            dyn.set("number", (Object)field.getNumber());
            dyn.set("name", (Object)field.getName());
            if (field.getId().equals(selectedFieldId)) {
                selectedRowIndex = rowIndex;
            }
            Integer n = rowIndex;
            Integer n2 = rowIndex = Integer.valueOf(rowIndex + 1);
        }
        this.getModel().endInit();
        this.getView().updateView(ENTRY_ENTITY);
        if (selectedRowIndex != null) {
            EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
            grid.selectRows(selectedRowIndex.intValue(), true);
        }
    }

    private void loadExtendmodel() {
        Long modelId = (Long)this.getFormCustomParam("KEY_MODEL_ID");
        Long extendModelId = (Long)this.getFormCustomParam("model");
        HashSet<Long> modelIds = new HashSet<Long>();
        Object filterModelId = this.getFormCustomParam("filterModelId");
        if (filterModelId != null) {
            modelIds.add(Long.valueOf(filterModelId.toString()));
        } else {
            Object seller = this.getFormCustomParam("seller");
            Object purchaser = this.getFormCustomParam("purchaser");
            Object mergenode = this.getFormCustomParam("mergenode");
            if (Objects.nonNull(seller) && seller instanceof Long) {
                modelIds.add((Long)seller);
            }
            if (Objects.nonNull(purchaser) && purchaser instanceof Long) {
                modelIds.add((Long)purchaser);
            }
            if (Objects.nonNull(mergenode) && mergenode instanceof Long) {
                modelIds.add((Long)mergenode);
            }
        }
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        filter.and("status", "=", (Object)"C");
        filter.and("id", "in", modelIds);
        DynamicObjectCollection extendsModelList = QueryServiceHelper.query((String)"bcm_extendsmodel", (String)"id,number,name", (QFilter[])new QFilter[]{filter}, (String)"number");
        ComboEdit comboEdit = (ComboEdit)this.getControl(CONTROL_MODEL);
        ArrayList<ComboItem> data = new ArrayList<ComboItem>(extendsModelList.size());
        for (DynamicObject obj : extendsModelList) {
            data.add(new ComboItem(new LocaleString(obj.getString("name")), obj.getString("id")));
        }
        comboEdit.setComboItems(data);
        if (Objects.isNull(extendModelId) && CollectionUtils.isNotEmpty((Collection)extendsModelList)) {
            extendModelId = ((DynamicObject)extendsModelList.get(0)).getLong("id");
        }
        this.getModel().setValue(CONTROL_MODEL, (Object)extendModelId);
    }

    private void btnOk() {
        Long extendModelId = null;
        String extendModelIdStr = (String)this.getModel().getValue(CONTROL_MODEL);
        if (StringUtils.isNotEmpty((String)extendModelIdStr)) {
            extendModelId = Long.valueOf(extendModelIdStr);
        }
        Long extendFieldId = null;
        EntryGrid grid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        if (grid.getSelectRows().length > 0) {
            extendFieldId = (Long)this.getModel().getValue("id", grid.getSelectRows()[0]);
        }
        Tuple returnData = new Tuple((Object)extendModelId, extendFieldId, this.getFormCustomParam("controlKey"));
        this.getView().returnDataToParent((Object)returnData);
        this.getView().close();
    }

    private boolean validate() {
        String extendModelId = (String)this.getModel().getValue(CONTROL_MODEL);
        if (StringUtils.isEmpty((String)extendModelId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u4e1a\u52a1\u6a21\u578b\u201d\u3002", (String)"ExtDimMemberF7Plugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        EntryGrid grid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        if (grid.getSelectRows().length <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u62d3\u5c55\u7ef4\u5ea6\u6210\u5458\u201d\u3002", (String)"ExtDimMemberF7Plugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }
}

