/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.papertemplate.innertrade;

import com.google.common.collect.HashMultimap;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bcm.business.export.ExportUtil;
import kd.fi.bcm.business.formula.express.ExpressParser;
import kd.fi.bcm.business.formula.model.FormulaEnum;
import kd.fi.bcm.business.innertrade.model.IntrField;
import kd.fi.bcm.business.innertrade.report.IntrCalculateFormulaHelper;
import kd.fi.bcm.business.papertemplate.ExtDimHelper;
import kd.fi.bcm.common.IntrConstant;
import kd.fi.bcm.common.enums.MultiLangEnumBridge;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.papertemplate.innertrade.IntrFromulaExportHelper;
import kd.fi.bcm.spread.formula.EncoderService;
import kd.fi.bcm.spread.formula.ExcelFormulaPaserHelper;
import kd.fi.bcm.spread.formula.expr.Expression;
import kd.fi.bcm.spread.formula.expr.FunctionExpr;
import kd.fi.bcm.spread.formula.expr.NameExpr;
import kd.fi.bcm.spread.formula.expr.StringExpr;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public class IntrFormulaImportPlugin
extends AbstractBaseFormPlugin
implements UploadListener {
    private static Map<String, MultiLangEnumBridge> errorHeaderMap = new LinkedHashMap<String, MultiLangEnumBridge>(16);
    private static final WatchLogger log;
    private static final String BTNOK = "btnok";
    private static final String ATTACHMENTPANELAP = "attachmentpanelap";
    private static final String CACHEKEY_FILE_TYPE = "file_type";
    private static final String CACHEKEY_FILE_URL = "file_url";
    private static final String XLS_FILETYPE = "xls";
    private static String executeSeqReg;
    private static List<String> pnConst;

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(BTNOK);
        AttachmentPanel attach = (AttachmentPanel)this.getControl(ATTACHMENTPANELAP);
        attach.addUploadListener((UploadListener)this);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long modelId = LongUtil.toLong((Object)this.getFormCustomParam("KEY_MODEL_ID"));
        this.getPageCache().put("KEY_MODEL_ID", modelId.toString());
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Button)evt.getSource()).getKey();
        if (BTNOK.equals(key)) {
            TempFileCacheDownloadable fileCache = (TempFileCacheDownloadable)CacheFactory.getCommonCacheFactory().getTempFileCache();
            try {
                String fileUrl = this.getPageCache().get(CACHEKEY_FILE_URL);
                if (fileUrl == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u4e0a\u4f20\u5bfc\u5165\u6570\u636e\u3002", (String)"IntrFormulaImportPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
                this.checkFileType();
                String[] reqParams = new URL(fileUrl).getQuery().split("&");
                HashMap<String, String> map = new HashMap<String, String>(reqParams.length);
                for (String param : reqParams) {
                    String[] p = param.split("=");
                    map.put(p[0], p[1]);
                }
                TempFileCacheDownloadable.Content content = fileCache.get((String)map.get("configKey"), (String)map.get("id"));
                InputStream inputStream = content.getInputStream();
                List<Map<String, Object>> data = this.getMapFromInputStream(inputStream);
                if (this.validData(data)) {
                    if (this.getView().getParentView() != null) {
                        this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\u3002", (String)"IntrFormulaImportPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    }
                    this.getView().returnDataToParent(data);
                    this.getView().close();
                } else {
                    String url = this.export(data);
                    if (StringUtils.isNotEmpty((String)url)) {
                        this.downloadFile(url, "bcm_papertemplatelist", "4715a0df000000ac");
                    }
                    if (this.getView().getParentView() != null) {
                        this.getView().getParentView().showErrorNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u5b8c\u6210\uff0c\u5b58\u5728\u5bfc\u5165\u5931\u8d25\u60c5\u51b5\uff0c\u8be6\u60c5\u8bf7\u67e5\u770b\u9644\u4ef6\u3002", (String)"IntrFormulaImportPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    }
                    this.getView().close();
                }
            }
            catch (Exception e) {
                log.error("file import error", (Throwable)e);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25:%s", (String)"IntrFormulaImportPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]), e.getMessage()));
            }
        }
    }

    private String export(List<Map<String, Object>> data) throws IOException {
        String fileName = String.format("%1$s_%2$s.xls", ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25", (String)"IntrFormulaImportPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u62d3\u5c55\u6570\u636e\u516c\u5f0f\u8bbe\u7f6e", (String)"IntrFormulaImportPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet("sheet1");
        int rowNum = IntrFromulaExportHelper.buildTableHeader(errorHeaderMap, (Sheet)sheet, IntrFromulaExportHelper.getCellStyle(wb));
        CellStyle cellCenterStyle = IntrFromulaExportHelper.getCellStyle(wb);
        CellStyle errorCenterStyle = IntrFromulaExportHelper.getCellStyle(wb);
        HSSFFont font = wb.createFont();
        font.setColor(IndexedColors.RED.getIndex());
        errorCenterStyle.setFont((Font)font);
        errorCenterStyle.setAlignment(HorizontalAlignment.LEFT);
        String[] keys = errorHeaderMap.keySet().toArray(new String[0]);
        for (Map<String, Object> entry : data) {
            Row tempRow = sheet.createRow(rowNum++);
            tempRow.setHeight((short)300);
            for (int i = 0; i < keys.length; ++i) {
                String cellValue;
                Cell tempCell = tempRow.createCell(i);
                tempCell.setCellStyle("errorInfo".equals(keys[i]) ? errorCenterStyle : cellCenterStyle);
                String string = cellValue = entry.get(keys[i]) == null ? "" : entry.get(keys[i]).toString();
                if ("executeseq".equals(keys[i]) && NumberUtils.isNumber((String)cellValue)) {
                    BigDecimal seq = new BigDecimal(cellValue);
                    cellValue = seq.stripTrailingZeros().toPlainString();
                }
                tempCell.setCellValue(cellValue);
            }
        }
        return ExportUtil.writeFile((HSSFWorkbook)wb, (String)fileName);
    }

    private boolean validData(List<Map<String, Object>> data) {
        AtomicBoolean isPass = new AtomicBoolean(true);
        if (!data.isEmpty()) {
            boolean isMergeUsage;
            HashMultimap numMapForGev = HashMultimap.create();
            HashMultimap numMapForLyv = HashMultimap.create();
            HashMultimap numMapForDvb = HashMultimap.create();
            HashMultimap numMapForPn = HashMultimap.create();
            DynamicObject mergeExtendsmodel = BusinessDataServiceHelper.loadSingle((Object)LongUtil.toLong((Object)this.getFormCustomParam("mergenode")), (String)"bcm_extendsmodel");
            List mergeFieldInfo = ExtDimHelper.getTmpFieldByExtModelId((Long)LongUtil.toLong((Object)this.getFormCustomParam("mergenode")));
            if (mergeExtendsmodel != null && !mergeFieldInfo.isEmpty()) {
                numMapForPn.put((Object)mergeExtendsmodel.getString("number"), (Object)"startyear");
                numMapForPn.put((Object)mergeExtendsmodel.getString("number"), (Object)"startmonth");
                numMapForPn.put((Object)mergeExtendsmodel.getString("number"), (Object)"endyear");
                numMapForPn.put((Object)mergeExtendsmodel.getString("number"), (Object)"endmonth");
                mergeFieldInfo.forEach(f -> {
                    numMapForGev.put((Object)mergeExtendsmodel.getString("number"), (Object)f.getNumber());
                    numMapForPn.put((Object)mergeExtendsmodel.getString("number"), (Object)f.getNumber());
                    if (IntrConstant.DB_DIGITAL_DATA_TYPE.contains(f.getDataType())) {
                        numMapForLyv.put((Object)mergeExtendsmodel.getString("number"), (Object)f.getNumber());
                    }
                });
            }
            if (isMergeUsage = "0".equals(this.getFormCustomParam("usage"))) {
                DynamicObject sellerExtendsmodel = BusinessDataServiceHelper.loadSingle((Object)LongUtil.toLong((Object)this.getFormCustomParam("seller")), (String)"bcm_extendsmodel");
                List sellerFieldInfo = ExtDimHelper.getTmpFieldByExtModelId((Long)LongUtil.toLong((Object)this.getFormCustomParam("seller")));
                if (sellerExtendsmodel != null && !sellerFieldInfo.isEmpty()) {
                    sellerFieldInfo.forEach(f -> {
                        numMapForGev.put((Object)sellerExtendsmodel.getString("number"), (Object)f.getNumber());
                        if (IntrConstant.DB_DIGITAL_DATA_TYPE.contains(f.getDataType())) {
                            numMapForDvb.put((Object)sellerExtendsmodel.getString("number"), (Object)f.getNumber());
                        }
                    });
                }
                DynamicObject purchaserExtendsmodel = BusinessDataServiceHelper.loadSingle((Object)LongUtil.toLong((Object)this.getFormCustomParam("purchaser")), (String)"bcm_extendsmodel");
                List purchaserFieldInfo = ExtDimHelper.getTmpFieldByExtModelId((Long)LongUtil.toLong((Object)this.getFormCustomParam("purchaser")));
                if (purchaserExtendsmodel != null && !purchaserFieldInfo.isEmpty()) {
                    purchaserFieldInfo.forEach(f -> numMapForGev.put((Object)purchaserExtendsmodel.getString("number"), (Object)f.getNumber()));
                }
            }
            HashSet fieldNumberSet = new HashSet(16);
            data.forEach(map -> {
                IntrField curIntrField = null;
                StringBuilder msg = new StringBuilder(16);
                try {
                    Object executeseq = map.get("executeseq");
                    Object modelfieldNumber = map.get("modelfield.number");
                    Object formula = map.get("formula");
                    Object formuladesc = map.get("formuladesc");
                    if (formuladesc != null && formuladesc.toString().length() > 50) {
                        msg.append(ResManager.loadKDString((String)"\u8bf4\u660e\u7684\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e50\u3002", (String)"IntrFormulaImportPlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                        msg.append("\n");
                    }
                    if (executeseq == null || "".equals(executeseq) || !NumberUtils.isNumber((String)executeseq.toString())) {
                        msg.append(ResManager.loadKDString((String)"\u6267\u884c\u987a\u5e8f\u7684\u6709\u6548\u8303\u56f4\u4e3a[1,100000]\u7684\u6574\u6570\u3002", (String)"IntrFormulaImportPlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                        msg.append("\n");
                    } else {
                        BigDecimal seq = new BigDecimal(executeseq.toString());
                        if (!Pattern.matches(executeSeqReg, seq.stripTrailingZeros().toPlainString())) {
                            msg.append(ResManager.loadKDString((String)"\u6267\u884c\u987a\u5e8f\u7684\u6709\u6548\u8303\u56f4\u4e3a[1,100000]\u7684\u6574\u6570\u3002", (String)"IntrFormulaImportPlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                            msg.append("\n");
                        }
                    }
                    if (modelfieldNumber == null) {
                        msg.append(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6210\u5458\u7f16\u7801\u3002", (String)"IntrFormulaImportPlugin_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]), modelfieldNumber));
                        msg.append("\n");
                    } else if (mergeFieldInfo.stream().noneMatch(e -> Objects.equals(e.getNumber(), modelfieldNumber))) {
                        msg.append(String.format(ResManager.loadKDString((String)"\u586b\u5199\u7684\u6210\u5458\u7f16\u7801%s\u5728\u5408\u5e76\u6a21\u578b\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"IntrFormulaImportPlugin_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]), modelfieldNumber));
                        msg.append("\n");
                    } else if (!fieldNumberSet.add(modelfieldNumber.toString())) {
                        msg.append(String.format(ResManager.loadKDString((String)"\u6210\u5458\u7f16\u7801\u91cd\u590d\u3002", (String)"IntrFormulaImportPlugin_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]), modelfieldNumber));
                        msg.append("\n");
                    }
                    Optional<IntrField> optionalIntrField = mergeFieldInfo.stream().filter(e -> Objects.equals(e.getNumber(), modelfieldNumber)).findAny();
                    if (optionalIntrField.isPresent()) {
                        curIntrField = optionalIntrField.get();
                    }
                    if (formula != null && StringUtils.isNotEmpty((String)formula.toString().trim())) {
                        ExpressParser parser = new ExpressParser();
                        EncoderService encoder = new EncoderService();
                        List expressions = parser.parse2(formula.toString(), encoder);
                        if (expressions.stream().anyMatch(p -> p instanceof NameExpr)) {
                            msg.append(ResManager.loadKDString((String)"\u8ba1\u7b97\u516c\u5f0f\u8f93\u5165\u4e0d\u6b63\u786e\u3002", (String)"IntrFormulaImportPlugin_19", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                            msg.append("\n");
                        } else {
                            IntrField finalCurIntrField = curIntrField;
                            IntrCalculateFormulaHelper.walkExpress((Expression)ExcelFormulaPaserHelper.parse((String)formula.toString().trim()), fun -> {
                                if (fun instanceof FunctionExpr) {
                                    String funcName = ((FunctionExpr)fun).getFuncionName();
                                    if (FormulaEnum.Esp.getCode().equalsIgnoreCase(funcName)) {
                                        List paramList = ((FunctionExpr)fun).getParameters();
                                        if (paramList == null || paramList.isEmpty()) {
                                            msg.append(String.format(ResManager.loadKDString((String)"\u8ba1\u7b97\u516c\u5f0f%s\u516c\u5f0f\u53c2\u6570\u4e0d\u6b63\u786e\u3002", (String)"IntrFormulaImportPlugin_20", (String)"fi-bcm-formplugin", (Object[])new Object[0]), funcName));
                                            msg.append("\n");
                                        }
                                    } else if (FormulaEnum.Gev.getCode().equalsIgnoreCase(funcName)) {
                                        this.handleFormula((FunctionExpr)fun, msg, funcName, (HashMultimap<String, String>)numMapForGev);
                                    } else if (FormulaEnum.Lyv.getCode().equalsIgnoreCase(funcName)) {
                                        if (finalCurIntrField != null && ("dim".equals(finalCurIntrField.getExtFieldRefType()) || IntrConstant.DB_TEXT_DATA_TYPE.contains(finalCurIntrField.getDataType()))) {
                                            msg.append(String.format(ResManager.loadKDString((String)"\u591a\u7ef4\u6210\u5458\u3001\u6587\u672c\u3001\u65e5\u671f\u548c\u679a\u4e3e\u6570\u636e\u7c7b\u578b\u7684\u62d3\u5c55\u6210\u5458\u4e0d\u5141\u8bb8\u8bbe\u7f6e%s\u516c\u5f0f\u3002", (String)"IntrFormulaImportPlugin_21", (String)"fi-bcm-formplugin", (Object[])new Object[0]), funcName));
                                            msg.append("\n");
                                        } else {
                                            this.handleFormula((FunctionExpr)fun, msg, funcName, (HashMultimap<String, String>)numMapForLyv);
                                        }
                                    } else if (FormulaEnum.Dvb.getCode().equalsIgnoreCase(funcName)) {
                                        if (isMergeUsage) {
                                            this.handleFormula((FunctionExpr)fun, msg, funcName, (HashMultimap<String, String>)numMapForDvb);
                                        } else {
                                            msg.append(String.format(ResManager.loadKDString((String)"\u5f55\u5165\u7248\u6a21\u677f\u4e0d\u5141\u8bb8\u914d\u7f6e%s\u516c\u5f0f\u3002", (String)"IntrFormulaImportPlugin_22", (String)"fi-bcm-formplugin", (Object[])new Object[0]), funcName));
                                            msg.append("\n");
                                        }
                                    } else if (FormulaEnum.Pn.getCode().equalsIgnoreCase(funcName)) {
                                        this.handleFormula((FunctionExpr)fun, msg, funcName, (HashMultimap<String, String>)numMapForPn);
                                    }
                                }
                                return fun;
                            });
                        }
                    }
                }
                catch (Exception e2) {
                    msg.append(ResManager.loadKDString((String)"\u5f53\u524d\u884c\u6570\u636e\u89e3\u6790\u5f02\u5e38\u3002", (String)"IntrFormulaImportPlugin_23", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
                map.put("errorInfo", msg.toString());
                isPass.set(isPass.get() && msg.length() == 0);
            });
        }
        return isPass.get();
    }

    private void handleFormula(FunctionExpr fun, StringBuilder msg, String funcName, HashMultimap<String, String> numMap) {
        List paramList = fun.getParameters();
        if (paramList == null) {
            msg.append(String.format(ResManager.loadKDString((String)"\u8ba1\u7b97\u516c\u5f0f%s\u516c\u5f0f\u53c2\u6570\u4e0d\u6b63\u786e\u3002", (String)"IntrFormulaImportPlugin_20", (String)"fi-bcm-formplugin", (Object[])new Object[0]), funcName));
            msg.append("\n");
        } else {
            boolean isDvb = FormulaEnum.Dvb.getCode().equalsIgnoreCase(funcName);
            for (int i = 0; !(i >= paramList.size() || isDvb && i > 0); ++i) {
                String p = ((StringExpr)paramList.get(i)).getValue();
                String[] split = p.split("@");
                if (split.length == 1) {
                    if (pnConst.contains(split[0])) continue;
                    msg.append(String.format(ResManager.loadKDString((String)"\u8ba1\u7b97\u516c\u5f0f%1$s\u516c\u5f0f\u7684\u53c2\u6570%2$s\u683c\u5f0f\u9700\u4e3a:dataModelNum@fieldNum\u3002", (String)"IntrFormulaImportPlugin_24", (String)"fi-bcm-formplugin", (Object[])new Object[0]), funcName, p));
                    msg.append("\n");
                    continue;
                }
                if (split.length == 2) {
                    if (!numMap.containsKey((Object)split[0])) {
                        msg.append(String.format(ResManager.loadKDString((String)"\u8ba1\u7b97\u516c\u5f0f%1$s\u516c\u5f0f\u7684%2$s\u7684\u6570\u636e\u6a21\u578b\u7f16\u7801\u4e0d\u6b63\u786e\u3002", (String)"IntrFormulaImportPlugin_25", (String)"fi-bcm-formplugin", (Object[])new Object[0]), funcName, p));
                        msg.append("\n");
                        continue;
                    }
                    if (numMap.get((Object)split[0]).contains(split[1])) continue;
                    msg.append(String.format(ResManager.loadKDString((String)"\u8ba1\u7b97\u516c\u5f0f%1$s\u516c\u5f0f\u7684%2$s\u7684\u6210\u5458\u7f16\u7801\u4e0d\u6b63\u786e\u3002", (String)"IntrFormulaImportPlugin_26", (String)"fi-bcm-formplugin", (Object[])new Object[0]), funcName, p));
                    msg.append("\n");
                    continue;
                }
                msg.append(String.format(ResManager.loadKDString((String)"\u8ba1\u7b97\u516c\u5f0f%1$s\u516c\u5f0f\u7684\u53c2\u6570%2$s\u683c\u5f0f\u9700\u4e3a:dataModelNum@fieldNum\u3002", (String)"IntrFormulaImportPlugin_24", (String)"fi-bcm-formplugin", (Object[])new Object[0]), funcName, p));
                msg.append("\n");
            }
        }
    }

    private List<Map<String, Object>> getMapFromInputStream(InputStream inputStream) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(16);
        HSSFWorkbook hssfWorkbook = null;
        try {
            hssfWorkbook = new HSSFWorkbook(inputStream);
            HSSFSheet sheetAt = hssfWorkbook.getSheetAt(0);
            if (sheetAt.getLastRowNum() < 2) {
                return result;
            }
            HashMap header = new HashMap(16);
            sheetAt.getRow(0).forEach(c -> header.put(c.getColumnIndex(), c.getStringCellValue()));
            for (int i = 2; i <= sheetAt.getLastRowNum(); ++i) {
                HashMap rowData = new HashMap(16);
                HSSFRow row = sheetAt.getRow(i);
                for (Map.Entry entry : header.entrySet()) {
                    HSSFCell cell = row.getCell(((Integer)entry.getKey()).intValue());
                    rowData.put(entry.getValue(), CellType.NUMERIC.equals((Object)cell.getCellType()) ? Double.valueOf(cell.getNumericCellValue()) : cell.getStringCellValue());
                }
                result.add(rowData);
            }
        }
        catch (IOException e) {
            log.error("getMapFromInputStream error:" + e);
            throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\u3002", (String)"IntrFormulaImportPlugin_27", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        return result;
    }

    private void checkFileType() {
        String type = this.getPageCache().get(CACHEKEY_FILE_TYPE);
        if (type != null && !XLS_FILETYPE.equals(type)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\u6216\u5df2\u635f\u574f\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"IntrFormulaImportPlugin_28", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterUpload(UploadEvent evt) {
        for (Object url : evt.getUrls()) {
            this.getPageCache().put(CACHEKEY_FILE_URL, (String)((Map)url).get("url"));
            this.getPageCache().put(CACHEKEY_FILE_TYPE, (String)((Map)url).get("type"));
        }
    }

    public void afterRemove(UploadEvent evt) {
        this.getPageCache().remove(CACHEKEY_FILE_URL);
        this.getPageCache().remove(CACHEKEY_FILE_TYPE);
    }

    static {
        errorHeaderMap.put("errorInfo", new MultiLangEnumBridge("\u9519\u8bef\u4fe1\u606f", "IntrFormulaImportPlugin_1", "fi-bcm-formplugin"));
        errorHeaderMap.put("executeseq", new MultiLangEnumBridge("\u6267\u884c\u987a\u5e8f", "IntrFormulaImportPlugin_2", "fi-bcm-formplugin"));
        errorHeaderMap.put("modelfield.number", new MultiLangEnumBridge("\u6210\u5458\u7f16\u7801", "IntrFormulaImportPlugin_3", "fi-bcm-formplugin"));
        errorHeaderMap.put("modelfield.name", new MultiLangEnumBridge("\u6210\u5458\u540d\u79f0", "IntrFormulaImportPlugin_4", "fi-bcm-formplugin"));
        errorHeaderMap.put("formula", new MultiLangEnumBridge("\u8ba1\u7b97\u516c\u5f0f", "IntrFormulaImportPlugin_5", "fi-bcm-formplugin"));
        errorHeaderMap.put("formulaname", new MultiLangEnumBridge("\u8ba1\u7b97\u516c\u5f0f\u540d\u79f0", "IntrFormulaImportPlugin_6", "fi-bcm-formplugin"));
        errorHeaderMap.put("formuladesc", new MultiLangEnumBridge("\u8bf4\u660e", "IntrFormulaImportPlugin_7", "fi-bcm-formplugin"));
        log = BcmLogFactory.getWatchLogInstance((boolean)true, IntrFormulaImportPlugin.class);
        executeSeqReg = "^[1-9]\\d{0,4}$|^100000";
        pnConst = Arrays.asList("startYear", "startPeriod", "currentYear", "currentPeriod");
    }
}

