/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.papertemplate.innertrade;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.bcm.business.export.ExportUtil;
import kd.fi.bcm.business.innertrade.model.IntrField;
import kd.fi.bcm.business.papertemplate.PaperTemplateFieldEntry;
import kd.fi.bcm.common.enums.MultiLangEnumBridge;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;

public class IntrFromulaExportHelper {
    private static Map<String, MultiLangEnumBridge> headerMap = new LinkedHashMap<String, MultiLangEnumBridge>(16);

    public static String export(List<PaperTemplateFieldEntry> fieldEntries, List<IntrField> extFieldInfo) throws IOException {
        Map<Long, IntrField> intrFieldMap = extFieldInfo.stream().collect(Collectors.toMap(k -> k.getExtFieldRefId(), v -> v, (v1, v2) -> v1));
        String fileName = String.format("%s.xls", ResManager.loadKDString((String)"\u62d3\u5c55\u6570\u636e\u516c\u5f0f\u8bbe\u7f6e", (String)"IntrFromulaExportHelper_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet("sheet1");
        int rowNum = IntrFromulaExportHelper.buildTableHeader(headerMap, (Sheet)sheet, IntrFromulaExportHelper.getCellStyle(wb));
        CellStyle cellCenterStyle = IntrFromulaExportHelper.getCellStyle(wb);
        for (PaperTemplateFieldEntry entry : fieldEntries) {
            Row tempRow = sheet.createRow(rowNum++);
            tempRow.setHeight((short)300);
            String[] keys = headerMap.keySet().toArray(new String[0]);
            for (int i = 0; i < keys.length; ++i) {
                Cell tempCell = tempRow.createCell(i);
                tempCell.setCellStyle(cellCenterStyle);
                tempCell.setCellValue(IntrFromulaExportHelper.getCellValue(keys[i], entry, intrFieldMap));
            }
        }
        return ExportUtil.writeFile((HSSFWorkbook)wb, (String)fileName);
    }

    private static String getCellValue(String key, PaperTemplateFieldEntry entry, Map<Long, IntrField> intrFieldMap) {
        IntrField intrField = intrFieldMap.get(entry.getFieldId());
        if ("executeseq".equals(key)) {
            return entry.getExecuteSeq() + "";
        }
        if (intrField != null && "modelfield.number".equals(key)) {
            return intrField.getNumber();
        }
        if (intrField != null && "modelfield.name".equals(key)) {
            return intrField.getName();
        }
        if ("formula".equals(key)) {
            return entry.getFormula();
        }
        if ("formulaname".equals(key)) {
            return entry.getFormulaName();
        }
        if ("formuladesc".equals(key)) {
            return entry.getFormulaDes();
        }
        return "";
    }

    public static int buildTableHeader(Map<String, MultiLangEnumBridge> headerNameMap, Sheet sheet, CellStyle cellCenterStyle) {
        int rowNum = 0;
        cellCenterStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cellCenterStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        for (int i = 0; i < headerNameMap.size(); ++i) {
            sheet.setColumnWidth(i, 6000);
        }
        Row r1 = sheet.createRow(rowNum++);
        r1.setHeight((short)500);
        String[] keys = headerNameMap.keySet().toArray(new String[0]);
        for (int i = 0; i < keys.length; ++i) {
            Cell tempCell = r1.createCell(i);
            tempCell.setCellStyle(cellCenterStyle);
            tempCell.setCellValue(keys[i]);
        }
        Row r2 = sheet.createRow(rowNum++);
        r2.setHeight((short)400);
        MultiLangEnumBridge[] names = headerNameMap.values().toArray(new MultiLangEnumBridge[0]);
        for (int i = 0; i < names.length; ++i) {
            Cell tempCell = r2.createCell(i);
            tempCell.setCellStyle(cellCenterStyle);
            tempCell.setCellValue(names[i].loadKDString());
        }
        return rowNum;
    }

    public static CellStyle getCellStyle(HSSFWorkbook wb) {
        HSSFCellStyle cellCenterStyle = wb.createCellStyle();
        cellCenterStyle.setAlignment(HorizontalAlignment.CENTER);
        cellCenterStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellCenterStyle.setLocked(true);
        cellCenterStyle.setWrapText(false);
        cellCenterStyle.setBorderBottom(BorderStyle.THIN);
        cellCenterStyle.setBorderLeft(BorderStyle.THIN);
        cellCenterStyle.setBorderTop(BorderStyle.THIN);
        cellCenterStyle.setBorderRight(BorderStyle.THIN);
        return cellCenterStyle;
    }

    static {
        headerMap.put("executeseq", new MultiLangEnumBridge("\u6267\u884c\u987a\u5e8f", "IntrFromulaExportHelper_1", "fi-bcm-formplugin"));
        headerMap.put("modelfield.number", new MultiLangEnumBridge("\u6210\u5458\u7f16\u7801", "IntrFromulaExportHelper_2", "fi-bcm-formplugin"));
        headerMap.put("modelfield.name", new MultiLangEnumBridge("\u6210\u5458\u540d\u79f0", "IntrFromulaExportHelper_3", "fi-bcm-formplugin"));
        headerMap.put("formula", new MultiLangEnumBridge("\u8ba1\u7b97\u516c\u5f0f", "IntrFromulaExportHelper_4", "fi-bcm-formplugin"));
        headerMap.put("formulaname", new MultiLangEnumBridge("\u8ba1\u7b97\u516c\u5f0f\u540d\u79f0", "IntrFromulaExportHelper_5", "fi-bcm-formplugin"));
        headerMap.put("formuladesc", new MultiLangEnumBridge("\u8bf4\u660e", "IntrFromulaExportHelper_6", "fi-bcm-formplugin"));
    }
}

